/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TabOutScopesTracker;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.Key;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TabOutScopesTrackerImpl
implements TabOutScopesTracker {
    private static final Key<Integer> CARET_SHIFT = Key.create((String)"tab.out.caret.shift");

    public void registerEmptyScope(@NotNull Editor editor, int offset, int tabOutOffset) {
        if (editor == null) {
            TabOutScopesTrackerImpl.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (editor.isDisposed()) {
            throw new IllegalArgumentException("Editor is already disposed");
        }
        if (tabOutOffset <= offset) {
            throw new IllegalArgumentException("tabOutOffset should be larger than offset");
        }
        if (!CodeInsightSettings.getInstance().TAB_EXITS_BRACKETS_AND_QUOTES) {
            return;
        }
        if (editor instanceof EditorWindow) {
            DocumentWindow documentWindow = ((EditorWindow)editor).getDocument();
            offset = documentWindow.injectedToHost(offset);
            editor = ((EditorWindow)editor).getDelegate();
        }
        if (!(editor instanceof EditorImpl)) {
            return;
        }
        Tracker tracker = Tracker.forEditor((EditorImpl)editor, true);
        tracker.registerScope(offset, tabOutOffset - offset);
    }

    public boolean hasScopeEndingAt(@NotNull Editor editor, int offset) {
        if (editor == null) {
            TabOutScopesTrackerImpl.$$$reportNull$$$0(1);
        }
        return TabOutScopesTrackerImpl.checkOrRemoveScopeEndingAt(editor, offset, false) > 0;
    }

    public int removeScopeEndingAt(@NotNull Editor editor, int offset) {
        int caretShift;
        if (editor == null) {
            TabOutScopesTrackerImpl.$$$reportNull$$$0(2);
        }
        return (caretShift = TabOutScopesTrackerImpl.checkOrRemoveScopeEndingAt(editor, offset, true)) > 0 ? offset + caretShift : -1;
    }

    private static int checkOrRemoveScopeEndingAt(@NotNull Editor editor, int offset, boolean removeScope) {
        if (editor == null) {
            TabOutScopesTrackerImpl.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!CodeInsightSettings.getInstance().TAB_EXITS_BRACKETS_AND_QUOTES) {
            return 0;
        }
        if (editor instanceof EditorWindow) {
            DocumentWindow documentWindow = ((EditorWindow)editor).getDocument();
            offset = documentWindow.injectedToHost(offset);
            editor = ((EditorWindow)editor).getDelegate();
        }
        if (!(editor instanceof EditorImpl)) {
            return 0;
        }
        Tracker tracker = Tracker.forEditor((EditorImpl)editor, false);
        if (tracker == null) {
            return 0;
        }
        return tracker.getCaretShiftForScopeEndingAt(offset, removeScope);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "editor";
        objectArray2[1] = "com/intellij/codeInsight/editorActions/TabOutScopesTrackerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerEmptyScope";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "hasScopeEndingAt";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "removeScopeEndingAt";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkOrRemoveScopeEndingAt";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Tracker
    implements DocumentListener {
        private static final Key<Tracker> TRACKER = Key.create((String)"tab.out.scope.tracker");
        private static final Key<List<RangeMarker>> TRACKED_SCOPES = Key.create((String)"tab.out.scopes");
        private final Editor myEditor;

        private static Tracker forEditor(@NotNull EditorImpl editor, boolean createIfAbsent) {
            Tracker tracker;
            if (editor == null) {
                Tracker.$$$reportNull$$$0(0);
            }
            if ((tracker = (Tracker)editor.getUserData(TRACKER)) == null && createIfAbsent) {
                tracker = new Tracker(editor);
                editor.putUserData(TRACKER, tracker);
            }
            return tracker;
        }

        private Tracker(@NotNull EditorImpl editor) {
            if (editor == null) {
                Tracker.$$$reportNull$$$0(1);
            }
            this.myEditor = editor;
            Disposable editorDisposable = editor.getDisposable();
            this.myEditor.getDocument().addDocumentListener((DocumentListener)this, editorDisposable);
        }

        private List<RangeMarker> getCurrentScopes(boolean create2) {
            Caret currentCaret = this.myEditor.getCaretModel().getCurrentCaret();
            ArrayList result2 = (ArrayList)currentCaret.getUserData(TRACKED_SCOPES);
            if (result2 == null && create2) {
                result2 = new ArrayList();
                currentCaret.putUserData(TRACKED_SCOPES, result2);
            }
            return result2;
        }

        private void registerScope(int offset, int caretShift) {
            RangeMarker marker = this.myEditor.getDocument().createRangeMarker(offset, offset);
            marker.setGreedyToLeft(true);
            marker.setGreedyToRight(true);
            if (caretShift > 1) {
                marker.putUserData(CARET_SHIFT, (Object)caretShift);
            }
            this.getCurrentScopes(true).add(marker);
        }

        private int getCaretShiftForScopeEndingAt(int offset, boolean remove2) {
            List<RangeMarker> scopes = this.getCurrentScopes(false);
            if (scopes == null) {
                return 0;
            }
            Iterator<RangeMarker> it = scopes.iterator();
            while (it.hasNext()) {
                Integer caretShift;
                RangeMarker scope = it.next();
                if (offset != scope.getEndOffset()) continue;
                if (remove2) {
                    it.remove();
                }
                return (caretShift = (Integer)scope.getUserData(CARET_SHIFT)) == null ? 1 : caretShift;
            }
            return 0;
        }

        public void beforeDocumentChange(@NotNull DocumentEvent event) {
            List<RangeMarker> scopes;
            if (event == null) {
                Tracker.$$$reportNull$$$0(2);
            }
            if ((scopes = this.getCurrentScopes(false)) == null) {
                return;
            }
            int caretOffset = this.myEditor.getCaretModel().getOffset();
            int changeStart = event.getOffset();
            int changeEnd = event.getOffset() + event.getOldLength();
            Iterator<RangeMarker> it = scopes.iterator();
            while (it.hasNext()) {
                RangeMarker scope = it.next();
                if (changeStart >= scope.getStartOffset() && changeEnd <= scope.getEndOffset() || caretOffset >= scope.getStartOffset() && caretOffset <= scope.getEndOffset() && (changeEnd < scope.getStartOffset() || changeStart > scope.getEndOffset())) continue;
                it.remove();
            }
        }

        public void bulkUpdateStarting(@NotNull Document document) {
            if (document == null) {
                Tracker.$$$reportNull$$$0(3);
            }
            for (Caret caret : this.myEditor.getCaretModel().getAllCarets()) {
                caret.putUserData(TRACKED_SCOPES, null);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/editorActions/TabOutScopesTrackerImpl$Tracker";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "forEditor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeDocumentChange";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "bulkUpdateStarting";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

