/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.template.impl.TemplateTextLexer;
import com.intellij.codeInsight.template.impl.TemplateTokenType;
import com.intellij.codeInsight.template.impl.Variable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.hash.LinkedHashMap;
import java.util.LinkedHashSet;

public class TemplateImplUtil {
    public static LinkedHashSet<String> parseVariableNames(CharSequence text2) {
        IElementType tokenType;
        LinkedHashSet<String> variableNames = new LinkedHashSet<String>();
        TemplateTextLexer lexer = new TemplateTextLexer();
        lexer.start(text2);
        while ((tokenType = lexer.getTokenType()) != null) {
            if (tokenType == TemplateTokenType.VARIABLE) {
                int start2 = lexer.getTokenStart();
                int end = lexer.getTokenEnd();
                String name = text2.subSequence(start2 + 1, end - 1).toString();
                variableNames.add(name);
            }
            lexer.advance();
        }
        return variableNames;
    }

    public static LinkedHashMap<String, Variable> parseVariables(CharSequence text2) {
        LinkedHashMap variables = new LinkedHashMap();
        for (String name : TemplateImplUtil.parseVariableNames(text2)) {
            variables.put((Object)name, (Object)new Variable(name, "", "", true));
        }
        return variables;
    }

    public static boolean isValidVariableName(String varName) {
        return TemplateImplUtil.parseVariableNames("$" + varName + "$").contains(varName);
    }

    public static TextRange findVariableAtOffset(CharSequence text2, int offset) {
        TemplateTextLexer lexer = new TemplateTextLexer();
        lexer.start(text2);
        IElementType tokenType;
        while ((tokenType = lexer.getTokenType()) != null) {
            int end;
            int start2 = lexer.getTokenStart();
            if (start2 < offset && (end = lexer.getTokenEnd()) >= offset) {
                return tokenType == TemplateTokenType.VARIABLE ? new TextRange(start2 + 1, end - 1) : null;
            }
            lexer.advance();
        }
        return null;
    }
}

