/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.impl.Divider;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.concurrency.JobLauncher;
import com.intellij.lang.Language;
import com.intellij.lang.MetaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveVisitor;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionEngine {
    private static final Logger LOG = Logger.getInstance(InspectionEngine.class);
    private static final Set<Class<? extends LocalInspectionTool>> RECURSIVE_VISITOR_TOOL_CLASSES = ContainerUtil.newConcurrentSet();

    @NotNull
    public static PsiElementVisitor createVisitorAndAcceptElements(@NotNull LocalInspectionTool tool, @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session2, @NotNull List<? extends PsiElement> elements2) {
        PsiElementVisitor visitor;
        if (tool == null) {
            InspectionEngine.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            InspectionEngine.$$$reportNull$$$0(1);
        }
        if (session2 == null) {
            InspectionEngine.$$$reportNull$$$0(2);
        }
        if (elements2 == null) {
            InspectionEngine.$$$reportNull$$$0(3);
        }
        if ((visitor = tool.buildVisitor(holder, isOnTheFly, session2)) == null) {
            LOG.error("Tool " + tool + " (" + tool.getClass() + ") must not return null from the buildVisitor() method");
        } else if (visitor instanceof PsiRecursiveVisitor && RECURSIVE_VISITOR_TOOL_CLASSES.add(tool.getClass())) {
            LOG.error("The visitor returned from LocalInspectionTool.buildVisitor() must not be recursive: " + tool);
        }
        if (visitor != PsiElementVisitor.EMPTY_VISITOR) {
            tool.inspectionStarted(session2, isOnTheFly);
            InspectionEngine.acceptElements(elements2, visitor);
        }
        PsiElementVisitor psiElementVisitor = visitor;
        if (psiElementVisitor == null) {
            InspectionEngine.$$$reportNull$$$0(4);
        }
        return psiElementVisitor;
    }

    public static void acceptElements(@NotNull List<? extends PsiElement> elements2, @NotNull PsiElementVisitor elementVisitor) {
        if (elements2 == null) {
            InspectionEngine.$$$reportNull$$$0(5);
        }
        if (elementVisitor == null) {
            InspectionEngine.$$$reportNull$$$0(6);
        }
        int elementsSize = elements2.size();
        for (int i = 0; i < elementsSize; ++i) {
            PsiElement element2 = elements2.get(i);
            element2.accept(elementVisitor);
            ProgressManager.checkCanceled();
        }
    }

    private static boolean intersect(@NotNull Set<String> ids1, @NotNull Set<String> ids2) {
        if (ids1 == null) {
            InspectionEngine.$$$reportNull$$$0(7);
        }
        if (ids2 == null) {
            InspectionEngine.$$$reportNull$$$0(8);
        }
        if (ids1.size() > ids2.size()) {
            Set<String> tmp = ids1;
            ids1 = ids2;
            ids2 = tmp;
        }
        for (String id2 : ids1) {
            if (!ids2.contains(id2)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static List<ProblemDescriptor> inspect(@NotNull List<? extends LocalInspectionToolWrapper> toolWrappers, @NotNull PsiFile file2, @NotNull InspectionManager iManager, @NotNull ProgressIndicator indicator) {
        if (toolWrappers == null) {
            InspectionEngine.$$$reportNull$$$0(9);
        }
        if (file2 == null) {
            InspectionEngine.$$$reportNull$$$0(10);
        }
        if (iManager == null) {
            InspectionEngine.$$$reportNull$$$0(11);
        }
        if (indicator == null) {
            InspectionEngine.$$$reportNull$$$0(12);
        }
        Map<String, List<ProblemDescriptor>> problemDescriptors = InspectionEngine.inspectEx(toolWrappers, file2, iManager, false, indicator);
        ArrayList<ProblemDescriptor> result2 = new ArrayList<ProblemDescriptor>();
        for (List<ProblemDescriptor> group : problemDescriptors.values()) {
            result2.addAll(group);
        }
        ArrayList<ProblemDescriptor> arrayList = result2;
        if (arrayList == null) {
            InspectionEngine.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @NotNull
    public static Map<String, List<ProblemDescriptor>> inspectEx(@NotNull List<? extends LocalInspectionToolWrapper> toolWrappers, @NotNull PsiFile file2, @NotNull InspectionManager iManager, boolean isOnTheFly, @NotNull ProgressIndicator indicator) {
        if (toolWrappers == null) {
            InspectionEngine.$$$reportNull$$$0(14);
        }
        if (file2 == null) {
            InspectionEngine.$$$reportNull$$$0(15);
        }
        if (iManager == null) {
            InspectionEngine.$$$reportNull$$$0(16);
        }
        if (indicator == null) {
            InspectionEngine.$$$reportNull$$$0(17);
        }
        if (toolWrappers.isEmpty()) {
            Map<String, List<ProblemDescriptor>> map2 = Collections.emptyMap();
            if (map2 == null) {
                InspectionEngine.$$$reportNull$$$0(18);
            }
            return map2;
        }
        TextRange range2 = file2.getTextRange();
        ArrayList allDivided = new ArrayList();
        Divider.divideInsideAndOutsideAllRoots(file2, range2, range2, (Condition<? super PsiFile>)Conditions.alwaysTrue(), (Processor<? super Divider.DividedElements>)new CommonProcessors.CollectProcessor(allDivided));
        List elements2 = ContainerUtil.concat((Iterable)ContainerUtil.map(allDivided, d -> ContainerUtil.concat((List[])new List[]{d.inside, d.outside, d.parents})));
        return InspectionEngine.inspectElements(toolWrappers, file2, iManager, isOnTheFly, indicator, elements2, InspectionEngine.calcElementDialectIds(elements2));
    }

    @NotNull
    static Map<String, List<ProblemDescriptor>> inspectElements(@NotNull List<? extends LocalInspectionToolWrapper> toolWrappers, @NotNull PsiFile file2, @NotNull InspectionManager iManager, boolean isOnTheFly, @NotNull ProgressIndicator indicator, @NotNull List<? extends PsiElement> elements2, @NotNull Set<String> elementDialectIds) {
        if (toolWrappers == null) {
            InspectionEngine.$$$reportNull$$$0(19);
        }
        if (file2 == null) {
            InspectionEngine.$$$reportNull$$$0(20);
        }
        if (iManager == null) {
            InspectionEngine.$$$reportNull$$$0(21);
        }
        if (indicator == null) {
            InspectionEngine.$$$reportNull$$$0(22);
        }
        if (elements2 == null) {
            InspectionEngine.$$$reportNull$$$0(23);
        }
        if (elementDialectIds == null) {
            InspectionEngine.$$$reportNull$$$0(24);
        }
        TextRange range2 = file2.getTextRange();
        LocalInspectionToolSession session2 = new LocalInspectionToolSession(file2, range2.getStartOffset(), range2.getEndOffset());
        toolWrappers = InspectionEngine.filterToolsApplicableByLanguage(toolWrappers, elementDialectIds);
        ConcurrentHashMap<String, List<ProblemDescriptor>> resultDescriptors = new ConcurrentHashMap<String, List<ProblemDescriptor>>();
        Processor processor2 = wrapper2 -> {
            ProblemsHolder holder = new ProblemsHolder(iManager, file2, isOnTheFly);
            LocalInspectionTool tool = (LocalInspectionTool)wrapper2.getTool();
            InspectionEngine.createVisitorAndAcceptElements(tool, holder, isOnTheFly, session2, elements2);
            tool.inspectionFinished(session2, holder);
            if (holder.hasResults()) {
                resultDescriptors.put(tool.getShortName(), ContainerUtil.filter((Collection)holder.getResults(), descriptor2 -> {
                    PsiElement element2 = descriptor2.getPsiElement();
                    return element2 == null || !SuppressionUtil.inspectionResultSuppressed(element2, tool);
                }));
            }
            return true;
        };
        JobLauncher.getInstance().invokeConcurrentlyUnderProgress(toolWrappers, indicator, processor2);
        ConcurrentHashMap<String, List<ProblemDescriptor>> concurrentHashMap = resultDescriptors;
        if (concurrentHashMap == null) {
            InspectionEngine.$$$reportNull$$$0(25);
        }
        return concurrentHashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static List<ProblemDescriptor> runInspectionOnFile(final @NotNull PsiFile file2, @NotNull InspectionToolWrapper<?, ?> toolWrapper, final @NotNull GlobalInspectionContext inspectionContext) {
        block15: {
            if (file2 == null) {
                InspectionEngine.$$$reportNull$$$0(26);
            }
            if (toolWrapper == null) {
                InspectionEngine.$$$reportNull$$$0(27);
            }
            if (inspectionContext == null) {
                InspectionEngine.$$$reportNull$$$0(28);
            }
            final InspectionManager inspectionManager = InspectionManager.getInstance((Project)file2.getProject());
            toolWrapper.initialize(inspectionContext);
            RefManagerImpl refManager = (RefManagerImpl)inspectionContext.getRefManager();
            refManager.inspectionReadActionStarted();
            if (toolWrapper instanceof LocalInspectionToolWrapper) {
                List<ProblemDescriptor> list2 = InspectionEngine.inspect(Collections.singletonList((LocalInspectionToolWrapper)toolWrapper), file2, inspectionManager, (ProgressIndicator)new EmptyProgressIndicator());
                List<ProblemDescriptor> list3 = list2;
                if (list3 == null) {
                    InspectionEngine.$$$reportNull$$$0(29);
                }
                return list3;
            }
            if (!(toolWrapper instanceof GlobalInspectionToolWrapper)) break block15;
            final GlobalInspectionTool globalTool = (GlobalInspectionTool)((GlobalInspectionToolWrapper)toolWrapper).getTool();
            final ArrayList<ProblemDescriptor> descriptors = new ArrayList<ProblemDescriptor>();
            if (globalTool instanceof GlobalSimpleInspectionTool) {
                GlobalSimpleInspectionTool simpleTool = (GlobalSimpleInspectionTool)globalTool;
                ProblemsHolder problemsHolder = new ProblemsHolder(inspectionManager, file2, false);
                ProblemDescriptionsProcessor collectProcessor = new ProblemDescriptionsProcessor(){

                    public CommonProblemDescriptor[] getDescriptions(@NotNull RefEntity refEntity) {
                        if (refEntity == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return descriptors.toArray(CommonProblemDescriptor.EMPTY_ARRAY);
                    }

                    public void ignoreElement(@NotNull RefEntity refEntity) {
                        if (refEntity == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        throw new UnsupportedOperationException();
                    }

                    public void resolveProblem(@NotNull CommonProblemDescriptor descriptor2) {
                        if (descriptor2 == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        throw new UnsupportedOperationException();
                    }

                    public void addProblemElement(@Nullable RefEntity refEntity, CommonProblemDescriptor ... commonProblemDescriptors) {
                        if (commonProblemDescriptors == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        if (!(refEntity instanceof RefElement)) {
                            return;
                        }
                        PsiElement element2 = ((RefElement)refEntity).getPsiElement();
                        InspectionEngine.convertToProblemDescriptors(element2, commonProblemDescriptors, descriptors);
                    }

                    public RefEntity getElement(@NotNull CommonProblemDescriptor descriptor2) {
                        if (descriptor2 == null) {
                            1.$$$reportNull$$$0(4);
                        }
                        throw new RuntimeException();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "refEntity";
                                break;
                            }
                            case 2: 
                            case 4: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "descriptor";
                                break;
                            }
                            case 3: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "commonProblemDescriptors";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/codeInspection/InspectionEngine$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "getDescriptions";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "ignoreElement";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "resolveProblem";
                                break;
                            }
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[2] = "addProblemElement";
                                break;
                            }
                            case 4: {
                                objectArray = objectArray2;
                                objectArray2[2] = "getElement";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                simpleTool.checkFile(file2, inspectionManager, problemsHolder, inspectionContext, collectProcessor);
                ArrayList<ProblemDescriptor> arrayList = descriptors;
                ArrayList<ProblemDescriptor> arrayList2 = arrayList;
                if (arrayList2 == null) {
                    InspectionEngine.$$$reportNull$$$0(30);
                }
                return arrayList2;
            }
            RefElement fileRef = refManager.getReference((PsiElement)file2);
            final AnalysisScope scope = new AnalysisScope(file2);
            assert (fileRef != null);
            fileRef.accept(new RefVisitor(){

                public void visitElement(@NotNull RefEntity elem) {
                    CommonProblemDescriptor[] elemDescriptors;
                    if (elem == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if ((elemDescriptors = globalTool.checkElement(elem, scope, inspectionManager, inspectionContext)) != null) {
                        InspectionEngine.convertToProblemDescriptors((PsiElement)file2, elemDescriptors, descriptors);
                    }
                    for (RefEntity child2 : elem.getChildren()) {
                        child2.accept((RefVisitor)this);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elem", "com/intellij/codeInspection/InspectionEngine$2", "visitElement"));
                }
            });
            ArrayList<ProblemDescriptor> arrayList = descriptors;
            ArrayList<ProblemDescriptor> arrayList3 = arrayList;
            if (arrayList3 == null) {
                InspectionEngine.$$$reportNull$$$0(31);
            }
            return arrayList3;
            finally {
                refManager.inspectionReadActionFinished();
                toolWrapper.cleanup(file2.getProject());
                inspectionContext.cleanup();
            }
        }
        List<ProblemDescriptor> list4 = Collections.emptyList();
        if (list4 == null) {
            InspectionEngine.$$$reportNull$$$0(32);
        }
        return list4;
    }

    private static void convertToProblemDescriptors(@NotNull PsiElement element2, CommonProblemDescriptor @NotNull [] commonProblemDescriptors, @NotNull List<? super ProblemDescriptor> descriptors) {
        if (element2 == null) {
            InspectionEngine.$$$reportNull$$$0(33);
        }
        if (descriptors == null) {
            InspectionEngine.$$$reportNull$$$0(34);
        }
        if (commonProblemDescriptors == null) {
            InspectionEngine.$$$reportNull$$$0(35);
        }
        for (CommonProblemDescriptor common : commonProblemDescriptors) {
            if (common instanceof ProblemDescriptor) {
                descriptors.add((ProblemDescriptor)((ProblemDescriptor)common));
                continue;
            }
            ProblemDescriptorBase base = new ProblemDescriptorBase(element2, element2, common.getDescriptionTemplate(), (LocalQuickFix[])common.getFixes(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, null, false, false);
            descriptors.add(base);
        }
    }

    @NotNull
    public static List<LocalInspectionToolWrapper> filterToolsApplicableByLanguage(@NotNull Collection<? extends LocalInspectionToolWrapper> tools, @NotNull Set<String> elementDialectIds) {
        if (tools == null) {
            InspectionEngine.$$$reportNull$$$0(36);
        }
        if (elementDialectIds == null) {
            InspectionEngine.$$$reportNull$$$0(37);
        }
        List list2 = ContainerUtil.filter(tools, tool -> {
            Set<String> dialectIdsSpecifiedForTool = InspectionEngine.getDialectIdsSpecifiedForTool(tool);
            return dialectIdsSpecifiedForTool == null || InspectionEngine.intersect(elementDialectIds, dialectIdsSpecifiedForTool);
        });
        if (list2 == null) {
            InspectionEngine.$$$reportNull$$$0(38);
        }
        return list2;
    }

    @Nullable(value="null means not specified")
    private static @Nullable(value="null means not specified") Set<String> getDialectIdsSpecifiedForTool(@NotNull LocalInspectionToolWrapper wrapper2) {
        THashSet result2;
        String langId;
        if (wrapper2 == null) {
            InspectionEngine.$$$reportNull$$$0(39);
        }
        if ((langId = wrapper2.getLanguage()) == null) {
            return null;
        }
        Language language = Language.findLanguageByID((String)langId);
        if (language == null) {
            result2 = Collections.singleton(langId);
        } else if (language instanceof MetaLanguage) {
            Collection matchingLanguages = ((MetaLanguage)language).getMatchingLanguages();
            result2 = new THashSet();
            for (Language matchingLanguage : matchingLanguages) {
                result2.addAll(InspectionEngine.getLanguageWithDialects(wrapper2, matchingLanguage));
            }
        } else {
            result2 = InspectionEngine.getLanguageWithDialects(wrapper2, language);
        }
        return result2;
    }

    @NotNull
    private static Set<String> getLanguageWithDialects(@NotNull LocalInspectionToolWrapper wrapper2, @NotNull Language language) {
        if (wrapper2 == null) {
            InspectionEngine.$$$reportNull$$$0(40);
        }
        if (language == null) {
            InspectionEngine.$$$reportNull$$$0(41);
        }
        List dialects = language.getDialects();
        boolean applyToDialects = wrapper2.applyToDialects();
        SmartHashSet result2 = applyToDialects && !dialects.isEmpty() ? new THashSet(1 + dialects.size()) : new SmartHashSet();
        result2.add(language.getID());
        if (applyToDialects) {
            InspectionEngine.addDialects(language, (Set<? super String>)result2);
        }
        SmartHashSet smartHashSet = result2;
        if (smartHashSet == null) {
            InspectionEngine.$$$reportNull$$$0(42);
        }
        return smartHashSet;
    }

    private static void addDialects(@NotNull Language language, @NotNull Set<? super String> result2) {
        if (language == null) {
            InspectionEngine.$$$reportNull$$$0(43);
        }
        if (result2 == null) {
            InspectionEngine.$$$reportNull$$$0(44);
        }
        for (Language dialect : language.getDialects()) {
            result2.add(dialect.getID());
            InspectionEngine.addDialects(dialect, result2);
        }
    }

    @NotNull
    public static Set<String> calcElementDialectIds(@NotNull List<? extends PsiElement> inside, @NotNull List<? extends PsiElement> outside) {
        if (inside == null) {
            InspectionEngine.$$$reportNull$$$0(45);
        }
        if (outside == null) {
            InspectionEngine.$$$reportNull$$$0(46);
        }
        SmartHashSet dialectIds = new SmartHashSet();
        SmartHashSet processedLanguages = new SmartHashSet();
        InspectionEngine.addDialects(inside, (Set<? super Language>)processedLanguages, (Set<? super String>)dialectIds);
        InspectionEngine.addDialects(outside, (Set<? super Language>)processedLanguages, (Set<? super String>)dialectIds);
        SmartHashSet smartHashSet = dialectIds;
        if (smartHashSet == null) {
            InspectionEngine.$$$reportNull$$$0(47);
        }
        return smartHashSet;
    }

    @NotNull
    public static Set<String> calcElementDialectIds(@NotNull List<? extends PsiElement> elements2) {
        if (elements2 == null) {
            InspectionEngine.$$$reportNull$$$0(48);
        }
        SmartHashSet dialectIds = new SmartHashSet();
        SmartHashSet processedLanguages = new SmartHashSet();
        InspectionEngine.addDialects(elements2, (Set<? super Language>)processedLanguages, (Set<? super String>)dialectIds);
        SmartHashSet smartHashSet = dialectIds;
        if (smartHashSet == null) {
            InspectionEngine.$$$reportNull$$$0(49);
        }
        return smartHashSet;
    }

    private static void addDialects(@NotNull List<? extends PsiElement> elements2, @NotNull Set<? super Language> outProcessedLanguages, @NotNull Set<? super String> outDialectIds) {
        if (elements2 == null) {
            InspectionEngine.$$$reportNull$$$0(50);
        }
        if (outProcessedLanguages == null) {
            InspectionEngine.$$$reportNull$$$0(51);
        }
        if (outDialectIds == null) {
            InspectionEngine.$$$reportNull$$$0(52);
        }
        for (PsiElement psiElement : elements2) {
            Language language = psiElement.getLanguage();
            outDialectIds.add(language.getID());
            InspectionEngine.addDialects(language, outProcessedLanguages, outDialectIds);
        }
    }

    private static void addDialects(@NotNull Language language, @NotNull Set<? super Language> outProcessedLanguages, @NotNull Set<? super String> outDialectIds) {
        if (language == null) {
            InspectionEngine.$$$reportNull$$$0(53);
        }
        if (outProcessedLanguages == null) {
            InspectionEngine.$$$reportNull$$$0(54);
        }
        if (outDialectIds == null) {
            InspectionEngine.$$$reportNull$$$0(55);
        }
        if (outProcessedLanguages.add((Language)language)) {
            for (Language dialect : language.getDialects()) {
                outDialectIds.add(dialect.getID());
                InspectionEngine.addDialects(dialect, outProcessedLanguages, outDialectIds);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 13: 
            case 18: 
            case 25: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 38: 
            case 42: 
            case 47: 
            case 49: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 13: 
            case 18: 
            case 25: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 38: 
            case 42: 
            case 47: 
            case 49: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 3: 
            case 5: 
            case 23: 
            case 48: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 4: 
            case 13: 
            case 18: 
            case 25: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 38: 
            case 42: 
            case 47: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/InspectionEngine";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementVisitor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids1";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids2";
                break;
            }
            case 9: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrappers";
                break;
            }
            case 10: 
            case 15: 
            case 20: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: 
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iManager";
                break;
            }
            case 12: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 24: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementDialectIds";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionContext";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonProblemDescriptors";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tools";
                break;
            }
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
            case 41: 
            case 43: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inside";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outside";
                break;
            }
            case 51: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outProcessedLanguages";
                break;
            }
            case 52: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outDialectIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/InspectionEngine";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitorAndAcceptElements";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "inspect";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "inspectEx";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "inspectElements";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "runInspectionOnFile";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "filterToolsApplicableByLanguage";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageWithDialects";
                break;
            }
            case 47: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "calcElementDialectIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createVisitorAndAcceptElements";
                break;
            }
            case 4: 
            case 13: 
            case 18: 
            case 25: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 38: 
            case 42: 
            case 47: 
            case 49: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "acceptElements";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "intersect";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "inspect";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "inspectEx";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "inspectElements";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "runInspectionOnFile";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "convertToProblemDescriptors";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "filterToolsApplicableByLanguage";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getDialectIdsSpecifiedForTool";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageWithDialects";
                break;
            }
            case 43: 
            case 44: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "addDialects";
                break;
            }
            case 45: 
            case 46: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "calcElementDialectIds";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 13: 
            case 18: 
            case 25: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 38: 
            case 42: 
            case 47: 
            case 49: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

