/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui.actions;

import com.intellij.codeEditor.printing.ExportToHTMLSettings;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.export.ExportToHTMLDialog;
import com.intellij.codeInspection.export.InspectionTreeHtmlWriter;
import com.intellij.codeInspection.ui.AggregateResultsExporter;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTreeModel;
import com.intellij.configurationStore.JbXmlOutputter;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.awt.Component;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public final class ExportHTMLAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(ExportHTMLAction.class);
    private final InspectionResultsView myView;
    private static final String ROOT = "root";
    private static final String AGGREGATE = "_aggregate";
    private static final String HTML = "HTML";
    private static final String XML = "XML";

    public ExportHTMLAction(@NotNull InspectionResultsView view) {
        if (view == null) {
            ExportHTMLAction.$$$reportNull$$$0(0);
        }
        super(InspectionsBundle.message((String)"inspection.action.export.html", (Object[])new Object[0]), null, AllIcons.ToolbarDecorator.Export);
        this.myView = view;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ExportHTMLAction.$$$reportNull$$$0(1);
        }
        ListPopup popup2 = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<String>(InspectionsBundle.message((String)"inspection.action.export.popup.title", (Object[])new Object[0]), new String[]{HTML, XML}){

            public PopupStep<?> onChosen(String selectedValue, boolean finalChoice) {
                return this.doFinalStep(() -> ExportHTMLAction.this.exportHTML(Comparing.strEqual((String)selectedValue, (String)ExportHTMLAction.HTML)));
            }
        });
        InspectionResultsView.showPopup(e, (JBPopup)popup2);
    }

    private void exportHTML(boolean exportToHTML) {
        ExportToHTMLDialog exportToHTMLDialog = new ExportToHTMLDialog(this.myView.getProject(), exportToHTML);
        ExportToHTMLSettings exportToHTMLSettings = ExportToHTMLSettings.getInstance(this.myView.getProject());
        if (exportToHTMLSettings.OUTPUT_DIRECTORY == null) {
            exportToHTMLSettings.OUTPUT_DIRECTORY = PathManager.getHomePath() + File.separator + "inspections";
        }
        exportToHTMLDialog.reset();
        if (!exportToHTMLDialog.showAndGet()) {
            return;
        }
        exportToHTMLDialog.apply();
        Path outputDir = Paths.get(exportToHTMLSettings.OUTPUT_DIRECTORY, new String[0]);
        ApplicationManager.getApplication().invokeLater(() -> {
            ThrowableComputable exportRunnable = () -> {
                ApplicationManager.getApplication().runReadAction(() -> {
                    if (this.myView.isDisposed()) {
                        return null;
                    }
                    if (exportToHTML) {
                        new InspectionTreeHtmlWriter(this.myView, outputDir);
                    } else {
                        ExportHTMLAction.dumpToXml(outputDir, this.myView);
                    }
                    return null;
                });
                return null;
            };
            try {
                ProgressManager.getInstance().runProcessWithProgressSynchronously(exportRunnable, InspectionsBundle.message((String)(exportToHTML ? "inspection.generating.html.progress.title" : "inspection.generating.xml.progress.title"), (Object[])new Object[0]), true, this.myView.getProject());
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Component)this.myView, (String)e.getMessage()));
                return;
            }
            if (exportToHTML && exportToHTMLSettings.OPEN_IN_BROWSER) {
                BrowserUtil.browse((File)outputDir.resolve("index.html").toFile());
            }
        }, this.myView.getProject().getDisposed());
    }

    @Deprecated
    public static void dump2xml(@NotNull Path outputDirectory, @NotNull InspectionResultsView view) throws IOException {
        if (outputDirectory == null) {
            ExportHTMLAction.$$$reportNull$$$0(2);
        }
        if (view == null) {
            ExportHTMLAction.$$$reportNull$$$0(3);
        }
        ExportHTMLAction.dumpToXml(outputDirectory, view);
    }

    public static void dumpToXml(@NotNull Path outputDirectory, @NotNull InspectionResultsView view) throws IOException {
        if (outputDirectory == null) {
            ExportHTMLAction.$$$reportNull$$$0(4);
        }
        if (view == null) {
            ExportHTMLAction.$$$reportNull$$$0(5);
        }
        InspectionProfileImpl profile = view.getCurrentProfile();
        String singleTool = profile.getSingleTool();
        MultiMap shortName2Wrapper = new MultiMap();
        if (singleTool != null) {
            shortName2Wrapper.put((Object)singleTool, ExportHTMLAction.getWrappersForAllScopes(singleTool, view));
        } else {
            InspectionTreeModel model = view.getTree().getInspectionTreeModel();
            model.traverse(model.getRoot()).filter(InspectionNode.class).filter(n -> !n.isExcluded()).map(InspectionNode::getToolWrapper).forEach(w -> shortName2Wrapper.putValue((Object)w.getShortName(), w));
        }
        for (Map.Entry entry : shortName2Wrapper.entrySet()) {
            String shortName = (String)entry.getKey();
            Collection wrappers = (Collection)entry.getValue();
            ExportHTMLAction.writeInspectionResult(shortName, wrappers, outputDirectory, view);
        }
        ExportHTMLAction.writeProfileName(outputDirectory, view);
    }

    private static void writeInspectionResult(@NotNull String shortName, @NotNull Collection<? extends InspectionToolWrapper<?, ?>> wrappers, @NotNull Path outputDirectory, @NotNull InspectionResultsView view) throws IOException {
        if (shortName == null) {
            ExportHTMLAction.$$$reportNull$$$0(6);
        }
        if (wrappers == null) {
            ExportHTMLAction.$$$reportNull$$$0(7);
        }
        if (outputDirectory == null) {
            ExportHTMLAction.$$$reportNull$$$0(8);
        }
        if (view == null) {
            ExportHTMLAction.$$$reportNull$$$0(9);
        }
        if (wrappers.isEmpty()) {
            return;
        }
        try (XmlWriterWrapper reportWriter = new XmlWriterWrapper(view.getProject(), outputDirectory, shortName, "problems");
             XmlWriterWrapper aggregateWriter = new XmlWriterWrapper(view.getProject(), outputDirectory, shortName + AGGREGATE, ROOT);){
            reportWriter.checkOpen();
            for (InspectionToolWrapper<?, ?> wrapper2 : wrappers) {
                InspectionToolPresentation presentation = view.getGlobalInspectionContext().getPresentation(wrapper2);
                presentation.exportResults(reportWriter::writeElement, presentation::isExcluded, presentation::isExcluded);
                if (!(presentation instanceof AggregateResultsExporter)) continue;
                ((AggregateResultsExporter)((Object)presentation)).exportAggregateResults(aggregateWriter::writeElement);
            }
        }
    }

    private static void writeProfileName(@NotNull Path outputDirectory, @NotNull InspectionResultsView view) throws IOException {
        if (outputDirectory == null) {
            ExportHTMLAction.$$$reportNull$$$0(10);
        }
        if (view == null) {
            ExportHTMLAction.$$$reportNull$$$0(11);
        }
        Element element2 = new Element("inspections");
        element2.setAttribute("profile", Objects.requireNonNull(view.getCurrentProfileName()));
        JDOMUtil.write((Element)element2, (Path)outputDirectory.resolve(".descriptions.xml"));
    }

    @NotNull
    public static BufferedWriter getWriter(@NotNull Path outputDirectory, @NotNull String name) throws IOException {
        if (outputDirectory == null) {
            ExportHTMLAction.$$$reportNull$$$0(12);
        }
        if (name == null) {
            ExportHTMLAction.$$$reportNull$$$0(13);
        }
        Path file2 = ExportHTMLAction.getInspectionResultFile(outputDirectory, name);
        Files.createDirectories(outputDirectory, new FileAttribute[0]);
        BufferedWriter bufferedWriter = Files.newBufferedWriter(file2, new OpenOption[0]);
        if (bufferedWriter == null) {
            ExportHTMLAction.$$$reportNull$$$0(14);
        }
        return bufferedWriter;
    }

    @NotNull
    public static Path getInspectionResultFile(@NotNull Path outputDirectory, @NotNull String name) {
        if (outputDirectory == null) {
            ExportHTMLAction.$$$reportNull$$$0(15);
        }
        if (name == null) {
            ExportHTMLAction.$$$reportNull$$$0(16);
        }
        Path path = outputDirectory.resolve(name + ".xml");
        if (path == null) {
            ExportHTMLAction.$$$reportNull$$$0(17);
        }
        return path;
    }

    @NotNull
    public static Path getInspectionResultPath(@NotNull Path outputDir, String name) {
        if (outputDir == null) {
            ExportHTMLAction.$$$reportNull$$$0(18);
        }
        Path path = outputDir.resolve(name + ".xml");
        if (path == null) {
            ExportHTMLAction.$$$reportNull$$$0(19);
        }
        return path;
    }

    @NotNull
    private static Collection<InspectionToolWrapper<?, ?>> getWrappersForAllScopes(@NotNull String shortName, @NotNull InspectionResultsView view) {
        GlobalInspectionContextImpl context;
        Tools tools;
        if (shortName == null) {
            ExportHTMLAction.$$$reportNull$$$0(20);
        }
        if (view == null) {
            ExportHTMLAction.$$$reportNull$$$0(21);
        }
        if ((tools = (context = view.getGlobalInspectionContext()).getTools().get(shortName)) != null) {
            List list2 = ContainerUtil.map((Collection)tools.getTools(), ScopeToolState::getTool);
            if (list2 == null) {
                ExportHTMLAction.$$$reportNull$$$0(22);
            }
            return list2;
        }
        List<InspectionToolWrapper<?, ?>> list3 = Collections.emptyList();
        if (list3 == null) {
            ExportHTMLAction.$$$reportNull$$$0(23);
        }
        return list3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 17: 
            case 19: 
            case 22: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 17: 
            case 19: 
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 10: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDirectory";
                break;
            }
            case 6: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrappers";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: 
            case 17: 
            case 19: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ui/actions/ExportHTMLAction";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ui/actions/ExportHTMLAction";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getWriter";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionResultFile";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionResultPath";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getWrappersForAllScopes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "dump2xml";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "dumpToXml";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "writeInspectionResult";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "writeProfileName";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getWriter";
                break;
            }
            case 14: 
            case 17: 
            case 19: 
            case 22: 
            case 23: {
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getInspectionResultFile";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getInspectionResultPath";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getWrappersForAllScopes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 17: 
            case 19: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class XmlWriterWrapper
    implements Closeable {
        private final Project myProject;
        private final Path myOutputDirectory;
        private final String myName;
        private final String myRootTagName;
        private Writer myFileWriter;
        private JbXmlOutputter myOutputter;

        XmlWriterWrapper(@NotNull Project project, @NotNull Path outputDirectory, @NotNull String name, @NotNull String rootTagName) {
            if (project == null) {
                XmlWriterWrapper.$$$reportNull$$$0(0);
            }
            if (outputDirectory == null) {
                XmlWriterWrapper.$$$reportNull$$$0(1);
            }
            if (name == null) {
                XmlWriterWrapper.$$$reportNull$$$0(2);
            }
            if (rootTagName == null) {
                XmlWriterWrapper.$$$reportNull$$$0(3);
            }
            this.myProject = project;
            this.myOutputDirectory = outputDirectory;
            this.myName = name;
            this.myRootTagName = rootTagName;
        }

        void writeElement(@NotNull Element element2) {
            if (element2 == null) {
                XmlWriterWrapper.$$$reportNull$$$0(4);
            }
            try {
                this.checkOpen();
                this.myFileWriter.write(10);
                this.myOutputter.output(element2, this.myFileWriter);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        void checkOpen() throws IOException {
            if (this.myFileWriter == null) {
                this.myFileWriter = XmlWriterWrapper.openFile(this.myOutputDirectory, this.myName);
                this.myOutputter = JbXmlOutputter.createOutputter((ComponentManager)this.myProject);
                this.startWritingXml();
            }
        }

        @Override
        public void close() throws IOException {
            if (this.myFileWriter == null) {
                return;
            }
            try {
                this.endWritingXml();
            }
            finally {
                Writer fileWriter = this.myFileWriter;
                this.myFileWriter = null;
                fileWriter.close();
            }
        }

        @NotNull
        private static Writer openFile(@NotNull Path outputDirectory, @NotNull String name) throws IOException {
            if (outputDirectory == null) {
                XmlWriterWrapper.$$$reportNull$$$0(5);
            }
            if (name == null) {
                XmlWriterWrapper.$$$reportNull$$$0(6);
            }
            BufferedWriter bufferedWriter = ExportHTMLAction.getWriter(outputDirectory, name);
            if (bufferedWriter == null) {
                XmlWriterWrapper.$$$reportNull$$$0(7);
            }
            return bufferedWriter;
        }

        private void startWritingXml() throws IOException {
            this.myFileWriter.write(60);
            this.myFileWriter.write(this.myRootTagName);
            this.myFileWriter.write(62);
        }

        private void endWritingXml() throws IOException {
            try {
                this.myFileWriter.write("\n");
                this.myFileWriter.write(60);
                this.myFileWriter.write(47);
                this.myFileWriter.write(this.myRootTagName);
                this.myFileWriter.write(62);
            }
            finally {
                this.myFileWriter.close();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputDirectory";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootTagName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ui/actions/ExportHTMLAction$XmlWriterWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ui/actions/ExportHTMLAction$XmlWriterWrapper";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "openFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "writeElement";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "openFile";
                    break;
                }
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

