/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/diagnostic/PrivacyNoticeComponent;", "Ljavax/swing/JPanel;", "label", "", "expandedLabel", "(Ljava/lang/String;Ljava/lang/String;)V", "expanded", "", "getExpanded", "()Z", "setExpanded", "(Z)V", "iconLabel", "Ljavax/swing/JLabel;", "text", "privacyPolicy", "getPrivacyPolicy", "()Ljava/lang/String;", "setPrivacyPolicy", "(Ljava/lang/String;)V", "privacyPolicyPane", "Ljavax/swing/JEditorPane;", "titleLabel", "useInHeader", "", "component", "Ljavax/swing/JComponent;", "Companion", "intellij.platform.ide.impl"})
public final class PrivacyNoticeComponent
extends JPanel {
    private final JLabel iconLabel;
    private final JLabel titleLabel;
    private final JEditorPane privacyPolicyPane;
    private boolean expanded;
    private final String label;
    private final String expandedLabel;
    public static final Companion Companion = new Companion(null);

    public final boolean getExpanded() {
        return this.expanded;
    }

    public final void setExpanded(boolean expanded) {
        this.expanded = expanded;
        if (expanded) {
            this.titleLabel.setText(this.expandedLabel);
            this.iconLabel.setIcon(AllIcons.General.ArrowDown);
            this.privacyPolicyPane.setVisible(true);
        } else {
            this.titleLabel.setText(this.label);
            this.iconLabel.setIcon(AllIcons.General.ArrowRight);
            this.privacyPolicyPane.setVisible(false);
        }
    }

    @NotNull
    public final String getPrivacyPolicy() {
        String string = this.privacyPolicyPane.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"privacyPolicyPane.text");
        return string;
    }

    public final void setPrivacyPolicy(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        this.privacyPolicyPane.setText(text2);
    }

    private final void useInHeader(JComponent component2) {
        component2.setBorder((Border)JBUI.Borders.empty((int)6, (int)0));
        component2.setBackground(PrivacyNoticeComponent.Companion.backgroundColor());
        component2.setCursor(Cursor.getPredefinedCursor(12));
        component2.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ PrivacyNoticeComponent this$0;

            public void mouseReleased(@Nullable MouseEvent e) {
                this.this$0.setExpanded(!this.this$0.getExpanded());
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    public PrivacyNoticeComponent(@NotNull String label2, @NotNull String expandedLabel) {
        Intrinsics.checkParameterIsNotNull((Object)label2, (String)"label");
        Intrinsics.checkParameterIsNotNull((Object)expandedLabel, (String)"expandedLabel");
        super(new GridBagLayout());
        this.label = label2;
        this.expandedLabel = expandedLabel;
        this.iconLabel = new JLabel();
        this.titleLabel = new JLabel();
        this.privacyPolicyPane = new JEditorPane();
        this.expanded = true;
        this.setBackground(PrivacyNoticeComponent.Companion.backgroundColor());
        JPanel iconLabelPanel = new JPanel(new BorderLayout());
        this.useInHeader(iconLabelPanel);
        iconLabelPanel.add((Component)this.iconLabel, "West");
        JPanel mySeparatorPanel = new JPanel();
        this.useInHeader(mySeparatorPanel);
        mySeparatorPanel.setPreferredSize(new Dimension(6, 1));
        this.useInHeader(this.titleLabel);
        this.titleLabel.setForeground(PrivacyNoticeComponent.Companion.titleColor());
        Font font = this.titleLabel.getFont();
        Font font2 = this.titleLabel.getFont();
        Intrinsics.checkExpressionValueIsNotNull((Object)font2, (String)"titleLabel.font");
        this.titleLabel.setFont(font.deriveFont((float)(font2.getSize() - 1)));
        this.privacyPolicyPane.setEditable(false);
        this.privacyPolicyPane.setFocusable(false);
        this.privacyPolicyPane.setBackground(PrivacyNoticeComponent.Companion.backgroundColor());
        this.privacyPolicyPane.setForeground(PrivacyNoticeComponent.Companion.noticeColor());
        Font font3 = this.privacyPolicyPane.getFont();
        Font font4 = this.privacyPolicyPane.getFont();
        Intrinsics.checkExpressionValueIsNotNull((Object)font4, (String)"privacyPolicyPane.font");
        this.privacyPolicyPane.setFont(font3.deriveFont((float)(font4.getSize() - (SystemInfo.isWindows ? 2 : 1))));
        this.privacyPolicyPane.setEditorKit(UIUtil.getHTMLEditorKit());
        this.privacyPolicyPane.setBorder((Border)JBUI.Borders.empty((int)0, (int)0, (int)6, (int)6));
        this.privacyPolicyPane.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
        this.add((Component)mySeparatorPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 3, (Insets)JBUI.emptyInsets(), 0, 0));
        this.add((Component)iconLabelPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, (Insets)JBUI.emptyInsets(), 0, 0));
        this.add((Component)this.titleLabel, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        this.add((Component)this.privacyPolicyPane, new GridBagConstraints(2, 1, 1, 1, 0.0, 1.0, 17, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        this.setExpanded(true);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\r\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005H\u0002J\r\u0010\u0006\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005H\u0002J\r\u0010\u0007\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005H\u0002\u00a8\u0006\b"}, d2={"Lcom/intellij/diagnostic/PrivacyNoticeComponent$Companion;", "", "()V", "backgroundColor", "Ljava/awt/Color;", "Lorg/jetbrains/annotations/NotNull;", "noticeColor", "titleColor", "intellij.platform.ide.impl"})
    public static final class Companion {
        private final Color titleColor() {
            Color color = UIUtil.getLabelForeground();
            Intrinsics.checkExpressionValueIsNotNull((Object)color, (String)"UIUtil.getLabelForeground()");
            return color;
        }

        private final Color noticeColor() {
            Color color = UIUtil.getContextHelpForeground();
            Intrinsics.checkExpressionValueIsNotNull((Object)color, (String)"UIUtil.getContextHelpForeground()");
            return color;
        }

        private final Color backgroundColor() {
            Color color = ColorUtil.hackBrightness((Color)JBUI.CurrentTheme.CustomFrameDecorations.paneBackground(), (int)1, (float)0.952381f);
            Intrinsics.checkExpressionValueIsNotNull((Object)color, (String)"ColorUtil.hackBrightness\u2026ckground(), 1, 1 / 1.05f)");
            return color;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

