/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.HyperlinkLabel;
import java.awt.Color;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffNotifications {
    @NotNull
    public static JPanel createInsertedContent() {
        return DiffNotifications.createNotification(DiffBundle.message((String)"notification.status.content.added", (Object[])new Object[0]), TextDiffType.INSERTED.getColor(null));
    }

    @NotNull
    public static JPanel createRemovedContent() {
        return DiffNotifications.createNotification(DiffBundle.message((String)"notification.status.content.removed", (Object[])new Object[0]), TextDiffType.DELETED.getColor(null));
    }

    @NotNull
    public static JPanel createEqualContents() {
        return DiffNotifications.createEqualContents(true, true);
    }

    @NotNull
    public static JPanel createEqualContents(boolean equalCharsets, boolean equalSeparators) {
        if (!equalCharsets && !equalSeparators) {
            return DiffNotifications.createNotification(DiffBundle.message((String)"diff.contents.have.differences.only.in.charset.and.line.separators.message.text", (Object[])new Object[0]));
        }
        if (!equalSeparators) {
            return DiffNotifications.createNotification(DiffBundle.message((String)"diff.contents.have.differences.only.in.line.separators.message.text", (Object[])new Object[0]));
        }
        if (!equalCharsets) {
            return DiffNotifications.createNotification(DiffBundle.message((String)"diff.contents.have.differences.only.in.charset.message.text", (Object[])new Object[0]));
        }
        return DiffNotifications.createNotification(DiffBundle.message((String)"diff.contents.are.identical.message.text", (Object[])new Object[0]));
    }

    @NotNull
    public static JPanel createError() {
        return DiffNotifications.createNotification(DiffBundle.message((String)"diff.cant.calculate.diff", (Object[])new Object[0]));
    }

    @NotNull
    public static JPanel createOperationCanceled() {
        return DiffNotifications.createNotification(DiffBundle.message((String)"error.can.not.calculate.diff.operation.canceled", (Object[])new Object[0]));
    }

    @NotNull
    public static JPanel createDiffTooBig() {
        return DiffNotifications.createNotification(DiffBundle.message((String)"error.can.not.calculate.diff.file.too.big", (Object[])new Object[0]));
    }

    @NotNull
    public static JPanel createNotification(@NotNull @Nls String text2) {
        if (text2 == null) {
            DiffNotifications.$$$reportNull$$$0(0);
        }
        return DiffNotifications.createNotification(text2, null);
    }

    @NotNull
    public static JPanel createNotification(@NotNull @Nls String text2, @Nullable Color background) {
        if (text2 == null) {
            DiffNotifications.$$$reportNull$$$0(1);
        }
        return DiffNotifications.createNotification(text2, background, true);
    }

    @NotNull
    public static JPanel createNotification(@NotNull @Nls String text2, @Nullable Color background, boolean showHideAction) {
        if (text2 == null) {
            DiffNotifications.$$$reportNull$$$0(2);
        }
        EditorNotificationPanel panel2 = new EditorNotificationPanel(background);
        panel2.text(text2);
        if (showHideAction) {
            HyperlinkLabel link = panel2.createActionLabel(DiffBundle.message((String)"button.hide.notification", (Object[])new Object[0]), () -> panel2.setVisible(false));
            link.setToolTipText(DiffBundle.message((String)"hide.this.notification", (Object[])new Object[0]));
        }
        EditorNotificationPanel editorNotificationPanel = panel2;
        if (editorNotificationPanel == null) {
            DiffNotifications.$$$reportNull$$$0(3);
        }
        return editorNotificationPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/util/DiffNotifications";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/util/DiffNotifications";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createNotification";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createNotification";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

