/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.base;

import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.diff.DiffNavigationContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import java.awt.Point;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InitialScrollPositionSupport {
    public static Point @NotNull [] doGetScrollingPositions(@NotNull List<? extends Editor> editors) {
        if (editors == null) {
            InitialScrollPositionSupport.$$$reportNull$$$0(0);
        }
        Point[] carets = new Point[editors.size()];
        for (int i = 0; i < editors.size(); ++i) {
            carets[i] = DiffUtil.getScrollingPosition(editors.get(i));
        }
        if (carets == null) {
            InitialScrollPositionSupport.$$$reportNull$$$0(1);
        }
        return carets;
    }

    public static LogicalPosition @NotNull [] doGetCaretPositions(@NotNull List<? extends Editor> editors) {
        if (editors == null) {
            InitialScrollPositionSupport.$$$reportNull$$$0(2);
        }
        LogicalPosition[] carets = new LogicalPosition[editors.size()];
        for (int i = 0; i < editors.size(); ++i) {
            carets[i] = DiffUtil.getCaretPosition(editors.get(i));
        }
        if (carets == null) {
            InitialScrollPositionSupport.$$$reportNull$$$0(3);
        }
        return carets;
    }

    @Nullable
    public static EditorsVisiblePositions doGetVisiblePositions(@NotNull List<? extends Editor> editors) {
        if (editors == null) {
            InitialScrollPositionSupport.$$$reportNull$$$0(4);
        }
        LogicalPosition[] carets = InitialScrollPositionSupport.doGetCaretPositions(editors);
        Point[] points = InitialScrollPositionSupport.doGetScrollingPositions(editors);
        return new EditorsVisiblePositions(carets, points);
    }

    public static void doMoveCaretsToPositions(LogicalPosition @NotNull [] positions, @NotNull List<? extends Editor> editors) {
        if (editors == null) {
            InitialScrollPositionSupport.$$$reportNull$$$0(5);
        }
        if (positions == null) {
            InitialScrollPositionSupport.$$$reportNull$$$0(6);
        }
        for (int i = 0; i < editors.size(); ++i) {
            Editor editor = editors.get(i);
            if (editor == null) continue;
            editor.getCaretModel().moveToLogicalPosition(positions[i]);
        }
    }

    public static void doScrollToVisiblePositions(@NotNull EditorsVisiblePositions visiblePositions, @NotNull List<? extends Editor> editors) {
        if (visiblePositions == null) {
            InitialScrollPositionSupport.$$$reportNull$$$0(7);
        }
        if (editors == null) {
            InitialScrollPositionSupport.$$$reportNull$$$0(8);
        }
        for (int i = 0; i < editors.size(); ++i) {
            Editor editor = editors.get(i);
            if (editor == null) continue;
            DiffUtil.scrollToPoint(editor, visiblePositions.myPoints[i], false);
        }
    }

    public static void doScrollToCaret(@NotNull List<? extends Editor> editors) {
        if (editors == null) {
            InitialScrollPositionSupport.$$$reportNull$$$0(9);
        }
        for (int i = 0; i < editors.size(); ++i) {
            Editor editor = editors.get(i);
            if (editor == null) continue;
            DiffUtil.scrollToCaret(editor, false);
        }
    }

    public static boolean wasScrolled(@NotNull List<? extends Editor> editors) {
        if (editors == null) {
            InitialScrollPositionSupport.$$$reportNull$$$0(10);
        }
        for (Editor editor : editors) {
            if (editor == null) continue;
            if (editor.getCaretModel().getOffset() != 0) {
                return true;
            }
            if (editor.getScrollingModel().getVerticalScrollOffset() != 0) {
                return true;
            }
            if (editor.getScrollingModel().getHorizontalScrollOffset() == 0) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editors";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/util/base/InitialScrollPositionSupport";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "positions";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visiblePositions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/util/base/InitialScrollPositionSupport";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetScrollingPositions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetCaretPositions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doGetScrollingPositions";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doGetCaretPositions";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doGetVisiblePositions";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doMoveCaretsToPositions";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doScrollToVisiblePositions";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doScrollToCaret";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "wasScrolled";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class EditorsVisiblePositions {
        public static final Key<EditorsVisiblePositions> KEY = Key.create((String)"Diff.EditorsVisiblePositions");
        public final LogicalPosition @NotNull [] myCaretPosition;
        public final Point @NotNull [] myPoints;

        public EditorsVisiblePositions(@NotNull LogicalPosition caretPosition, @NotNull Point points) {
            if (caretPosition == null) {
                EditorsVisiblePositions.$$$reportNull$$$0(0);
            }
            if (points == null) {
                EditorsVisiblePositions.$$$reportNull$$$0(1);
            }
            this(new LogicalPosition[]{caretPosition}, new Point[]{points});
        }

        public EditorsVisiblePositions(LogicalPosition @NotNull [] caretPosition, Point @NotNull [] points) {
            if (caretPosition == null) {
                EditorsVisiblePositions.$$$reportNull$$$0(2);
            }
            if (points == null) {
                EditorsVisiblePositions.$$$reportNull$$$0(3);
            }
            this.myCaretPosition = caretPosition;
            this.myPoints = points;
        }

        public boolean isSame(LogicalPosition ... caretPosition) {
            if (caretPosition == null) {
                return true;
            }
            if (this.myCaretPosition.length != caretPosition.length) {
                return false;
            }
            for (int i = 0; i < caretPosition.length; ++i) {
                if (caretPosition[i].equals((Object)this.myCaretPosition[i])) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "caretPosition";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "points";
                    break;
                }
            }
            objectArray[1] = "com/intellij/diff/tools/util/base/InitialScrollPositionSupport$EditorsVisiblePositions";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class ThreesideInitialScrollHelper
    extends SideInitialScrollHelper {
        @Nullable
        protected Pair<ThreeSide, Integer> myScrollToLine;

        @Override
        public void processContext(@NotNull DiffRequest request2) {
            if (request2 == null) {
                ThreesideInitialScrollHelper.$$$reportNull$$$0(0);
            }
            super.processContext(request2);
            this.myScrollToLine = (Pair)request2.getUserData(DiffUserDataKeys.SCROLL_TO_LINE_THREESIDE);
        }

        @Override
        public void updateContext(@NotNull DiffRequest request2) {
            if (request2 == null) {
                ThreesideInitialScrollHelper.$$$reportNull$$$0(1);
            }
            super.updateContext(request2);
            request2.putUserData(DiffUserDataKeys.SCROLL_TO_LINE_THREESIDE, null);
        }

        public void onSlowRediff() {
            if (InitialScrollPositionSupport.wasScrolled(this.getEditors())) {
                this.myShouldScroll = false;
            }
            if (this.myScrollToChange != null) {
                return;
            }
            if (this.myShouldScroll) {
                boolean bl = this.myShouldScroll = !this.doScrollToLine();
            }
            if (this.myShouldScroll) {
                this.myShouldScroll = !this.doScrollToPosition();
            }
        }

        public void onRediff() {
            if (InitialScrollPositionSupport.wasScrolled(this.getEditors())) {
                this.myShouldScroll = false;
            }
            if (this.myShouldScroll) {
                boolean bl = this.myShouldScroll = !this.doScrollToChange();
            }
            if (this.myShouldScroll) {
                boolean bl = this.myShouldScroll = !this.doScrollToLine();
            }
            if (this.myShouldScroll) {
                boolean bl = this.myShouldScroll = !this.doScrollToPosition();
            }
            if (this.myShouldScroll) {
                this.doScrollToFirstChange();
            }
            this.myShouldScroll = false;
        }

        protected abstract boolean doScrollToChange();

        protected abstract boolean doScrollToFirstChange();

        protected abstract boolean doScrollToLine();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "request";
            objectArray2[1] = "com/intellij/diff/tools/util/base/InitialScrollPositionSupport$ThreesideInitialScrollHelper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processContext";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateContext";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class TwosideInitialScrollHelper
    extends SideInitialScrollHelper {
        @Nullable
        protected Pair<Side, Integer> myScrollToLine;
        @Nullable
        protected DiffNavigationContext myNavigationContext;

        @Override
        public void processContext(@NotNull DiffRequest request2) {
            if (request2 == null) {
                TwosideInitialScrollHelper.$$$reportNull$$$0(0);
            }
            super.processContext(request2);
            this.myScrollToLine = (Pair)request2.getUserData(DiffUserDataKeys.SCROLL_TO_LINE);
            this.myNavigationContext = (DiffNavigationContext)request2.getUserData(DiffUserDataKeysEx.NAVIGATION_CONTEXT);
        }

        @Override
        public void updateContext(@NotNull DiffRequest request2) {
            if (request2 == null) {
                TwosideInitialScrollHelper.$$$reportNull$$$0(1);
            }
            super.updateContext(request2);
            request2.putUserData(DiffUserDataKeys.SCROLL_TO_LINE, null);
            request2.putUserData(DiffUserDataKeysEx.NAVIGATION_CONTEXT, null);
        }

        public void onSlowRediff() {
            if (InitialScrollPositionSupport.wasScrolled(this.getEditors())) {
                this.myShouldScroll = false;
            }
            if (this.myScrollToChange != null) {
                return;
            }
            if (this.myShouldScroll) {
                boolean bl = this.myShouldScroll = !this.doScrollToLine();
            }
            if (this.myNavigationContext != null) {
                return;
            }
            if (this.myShouldScroll) {
                this.myShouldScroll = !this.doScrollToPosition();
            }
        }

        public void onRediff() {
            if (InitialScrollPositionSupport.wasScrolled(this.getEditors())) {
                this.myShouldScroll = false;
            }
            if (this.myShouldScroll) {
                boolean bl = this.myShouldScroll = !this.doScrollToChange();
            }
            if (this.myShouldScroll) {
                boolean bl = this.myShouldScroll = !this.doScrollToLine();
            }
            if (this.myShouldScroll) {
                boolean bl = this.myShouldScroll = !this.doScrollToContext();
            }
            if (this.myShouldScroll) {
                boolean bl = this.myShouldScroll = !this.doScrollToPosition();
            }
            if (this.myShouldScroll) {
                this.doScrollToFirstChange();
            }
            this.myShouldScroll = false;
        }

        protected abstract boolean doScrollToChange();

        protected abstract boolean doScrollToFirstChange();

        protected abstract boolean doScrollToContext();

        protected abstract boolean doScrollToLine();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "request";
            objectArray2[1] = "com/intellij/diff/tools/util/base/InitialScrollPositionSupport$TwosideInitialScrollHelper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processContext";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateContext";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class SideInitialScrollHelper
    extends InitialScrollHelperBase {
        private SideInitialScrollHelper() {
        }

        @Override
        protected LogicalPosition @Nullable [] getCaretPositions() {
            return InitialScrollPositionSupport.doGetCaretPositions(this.getEditors());
        }

        @Override
        @Nullable
        protected EditorsVisiblePositions getVisiblePositions() {
            return InitialScrollPositionSupport.doGetVisiblePositions(this.getEditors());
        }

        protected boolean doScrollToPosition() {
            List<? extends Editor> editors = this.getEditors();
            if (this.myCaretPosition == null || this.myCaretPosition.length != editors.size()) {
                return false;
            }
            InitialScrollPositionSupport.doMoveCaretsToPositions(this.myCaretPosition, editors);
            try {
                this.disableSyncScroll(true);
                if (this.myEditorsPosition != null && this.myEditorsPosition.isSame(this.myCaretPosition)) {
                    InitialScrollPositionSupport.doScrollToVisiblePositions(this.myEditorsPosition, editors);
                } else {
                    InitialScrollPositionSupport.doScrollToCaret(editors);
                }
            }
            finally {
                this.disableSyncScroll(false);
            }
            return true;
        }

        @NotNull
        protected abstract List<? extends Editor> getEditors();

        protected abstract void disableSyncScroll(boolean var1);
    }

    public static abstract class InitialScrollHelperBase {
        protected boolean myShouldScroll = true;
        @Nullable
        protected DiffUserDataKeysEx.ScrollToPolicy myScrollToChange;
        @Nullable
        protected EditorsVisiblePositions myEditorsPosition;
        protected LogicalPosition @Nullable [] myCaretPosition;

        public void processContext(@NotNull DiffRequest request2) {
            if (request2 == null) {
                InitialScrollHelperBase.$$$reportNull$$$0(0);
            }
            this.myScrollToChange = (DiffUserDataKeysEx.ScrollToPolicy)((Object)request2.getUserData(DiffUserDataKeysEx.SCROLL_TO_CHANGE));
            this.myEditorsPosition = (EditorsVisiblePositions)request2.getUserData(EditorsVisiblePositions.KEY);
            this.myCaretPosition = (LogicalPosition[])request2.getUserData(DiffUserDataKeysEx.EDITORS_CARET_POSITION);
        }

        public void updateContext(@NotNull DiffRequest request2) {
            if (request2 == null) {
                InitialScrollHelperBase.$$$reportNull$$$0(1);
            }
            LogicalPosition[] carets = this.getCaretPositions();
            EditorsVisiblePositions visiblePositions = this.getVisiblePositions();
            request2.putUserData(DiffUserDataKeysEx.SCROLL_TO_CHANGE, null);
            request2.putUserData(EditorsVisiblePositions.KEY, (Object)visiblePositions);
            request2.putUserData(DiffUserDataKeysEx.EDITORS_CARET_POSITION, (Object)carets);
        }

        protected abstract LogicalPosition @Nullable [] getCaretPositions();

        @Nullable
        protected abstract EditorsVisiblePositions getVisiblePositions();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "request";
            objectArray2[1] = "com/intellij/diff/tools/util/base/InitialScrollPositionSupport$InitialScrollHelperBase";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processContext";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateContext";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

