/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetListener;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.ExecutionTargetProvider;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.compound.CompoundRunConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.TargetAwareRunProfile;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ExecutionTargetManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class ExecutionTargetManagerImpl
extends ExecutionTargetManager
implements PersistentStateComponent<Element> {
    public static final ExecutionTarget MULTIPLE_TARGETS = new ExecutionTarget(){

        @NotNull
        public String getId() {
            return "multiple_targets";
        }

        @NotNull
        public String getDisplayName() {
            String string = ExecutionBundle.message((String)"multiple.specified", (Object[])new Object[0]);
            if (string == null) {
                1.$$$reportNull$$$0(0);
            }
            return string;
        }

        public Icon getIcon() {
            return null;
        }

        public boolean canRun(@NotNull RunConfiguration configuration) {
            if (configuration == null) {
                1.$$$reportNull$$$0(1);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/ExecutionTargetManagerImpl$1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/ExecutionTargetManagerImpl$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "canRun";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    @NotNull
    private final Project myProject;
    @NotNull
    private final Object myActiveTargetLock;
    @Nullable
    private ExecutionTarget myActiveTarget;
    @Nullable
    private String mySavedActiveTargetId;
    @Nullable
    private RunManagerImpl myRunManager;

    public ExecutionTargetManagerImpl(@NotNull Project project) {
        if (project == null) {
            ExecutionTargetManagerImpl.$$$reportNull$$$0(0);
        }
        this.myActiveTargetLock = new Object();
        this.myProject = project;
        project.getMessageBus().connect().subscribe(RunManagerListener.TOPIC, (Object)new RunManagerListener(){

            @Override
            public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (settings == ExecutionTargetManagerImpl.this.getRunManager().getSelectedConfiguration()) {
                    ExecutionTargetManagerImpl.this.updateActiveTarget(settings);
                }
            }

            @Override
            public void runConfigurationSelected(@Nullable RunnerAndConfigurationSettings settings) {
                ExecutionTargetManagerImpl.this.updateActiveTarget(settings);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/ExecutionTargetManagerImpl$2", "runConfigurationChanged"));
            }
        });
    }

    @NotNull
    private RunManagerImpl getRunManager() {
        RunManagerImpl runManager = this.myRunManager;
        if (runManager == null) {
            this.myRunManager = runManager = RunManagerImpl.getInstanceImpl(this.myProject);
        }
        RunManagerImpl runManagerImpl = runManager;
        if (runManagerImpl == null) {
            ExecutionTargetManagerImpl.$$$reportNull$$$0(1);
        }
        return runManagerImpl;
    }

    public void setRunManager(@NotNull RunManagerImpl runManager) {
        if (runManager == null) {
            ExecutionTargetManagerImpl.$$$reportNull$$$0(2);
        }
        this.myRunManager = runManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getState() {
        Element state = new Element("state");
        Object object = this.myActiveTargetLock;
        synchronized (object) {
            String id2;
            String string = id2 = this.myActiveTarget == null ? this.mySavedActiveTargetId : this.myActiveTarget.getId();
            if (id2 != null && !id2.equals(DefaultExecutionTarget.INSTANCE.getId())) {
                state.setAttribute("SELECTED_TARGET", id2);
            }
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull Element state) {
        if (state == null) {
            ExecutionTargetManagerImpl.$$$reportNull$$$0(3);
        }
        Object object = this.myActiveTargetLock;
        synchronized (object) {
            if (this.myActiveTarget == null && this.mySavedActiveTargetId == null) {
                this.mySavedActiveTargetId = state.getAttributeValue("SELECTED_TARGET");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public ExecutionTarget getActiveTarget() {
        Object object = this.myActiveTargetLock;
        // MONITORENTER : object
        if (this.myActiveTarget == null) {
            this.updateActiveTarget();
        }
        ExecutionTarget executionTarget = this.myActiveTarget;
        // MONITOREXIT : object
        if (executionTarget != null) return executionTarget;
        ExecutionTargetManagerImpl.$$$reportNull$$$0(4);
        return executionTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActiveTarget(@NotNull ExecutionTarget target2) {
        if (target2 == null) {
            ExecutionTargetManagerImpl.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Object object = this.myActiveTargetLock;
        synchronized (object) {
            this.updateActiveTarget(this.getRunManager().getSelectedConfiguration(), target2);
        }
    }

    private void updateActiveTarget() {
        this.updateActiveTarget(this.getRunManager().getSelectedConfiguration());
    }

    private void updateActiveTarget(@Nullable RunnerAndConfigurationSettings settings) {
        this.updateActiveTarget(settings, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateActiveTarget(@Nullable RunnerAndConfigurationSettings settings, @Nullable ExecutionTarget toSelect2) {
        ExecutionTarget toNotify;
        List<ExecutionTarget> suitable = settings == null ? Collections.singletonList(DefaultExecutionTarget.INSTANCE) : this.getTargetsFor(settings.getConfiguration());
        Object object = this.myActiveTargetLock;
        synchronized (object) {
            if (toSelect2 == null) {
                toSelect2 = this.myActiveTarget;
            }
            int index = -1;
            if (toSelect2 != null) {
                index = suitable.indexOf(toSelect2);
            } else if (this.mySavedActiveTargetId != null) {
                int size = suitable.size();
                for (int i = 0; i < size; ++i) {
                    if (!suitable.get(i).getId().equals(this.mySavedActiveTargetId)) continue;
                    index = i;
                    break;
                }
            }
            toNotify = this.doSetActiveTarget(index >= 0 ? suitable.get(index) : this.getDefaultTarget(suitable));
        }
        if (toNotify != null) {
            ((ExecutionTargetListener)this.myProject.getMessageBus().syncPublisher(TOPIC)).activeTargetChanged(toNotify);
        }
    }

    private ExecutionTarget getDefaultTarget(List<? extends ExecutionTarget> suitable) {
        ExecutionTarget result2 = this.mySavedActiveTargetId == null ? (ExecutionTarget)ContainerUtil.find(suitable, ExecutionTarget::isReady) : (ExecutionTarget)ContainerUtil.getFirstItem(suitable);
        return result2 != null ? result2 : DefaultExecutionTarget.INSTANCE;
    }

    @Nullable
    private ExecutionTarget doSetActiveTarget(@NotNull ExecutionTarget newTarget) {
        if (newTarget == null) {
            ExecutionTargetManagerImpl.$$$reportNull$$$0(6);
        }
        this.mySavedActiveTargetId = null;
        ExecutionTarget prev = this.myActiveTarget;
        this.myActiveTarget = newTarget;
        if (prev != null && !prev.equals((Object)this.myActiveTarget)) {
            return this.myActiveTarget;
        }
        return null;
    }

    public boolean doCanRun(@Nullable RunConfiguration configuration, @NotNull ExecutionTarget target2) {
        if (target2 == null) {
            ExecutionTargetManagerImpl.$$$reportNull$$$0(7);
        }
        if (configuration == null) {
            return false;
        }
        boolean isCompound = configuration instanceof CompoundRunConfiguration;
        if (isCompound && target2 == MULTIPLE_TARGETS) {
            return true;
        }
        ExecutionTarget defaultTarget = DefaultExecutionTarget.INSTANCE;
        boolean checkFallbackToDefault = isCompound && !target2.equals((Object)defaultTarget);
        return this.doWithEachNonCompoundWithSpecifiedTarget(configuration, (subConfiguration, executionTarget) -> {
            if (!(subConfiguration instanceof TargetAwareRunProfile)) {
                return true;
            }
            if (Registry.is((String)"update.run.configuration.actions.from.cache", (boolean)false) && this.getRunManager().isInvalidInCache((RunConfiguration)subConfiguration)) {
                return false;
            }
            TargetAwareRunProfile targetAwareProfile = (TargetAwareRunProfile)subConfiguration;
            return target2.canRun(subConfiguration) && targetAwareProfile.canRunOn(target2) || checkFallbackToDefault && defaultTarget.canRun(subConfiguration) && targetAwareProfile.canRunOn(defaultTarget);
        });
    }

    @NotNull
    public List<ExecutionTarget> getTargetsFor(@Nullable RunConfiguration configuration) {
        if (configuration == null) {
            List<ExecutionTarget> list2 = Collections.emptyList();
            if (list2 == null) {
                ExecutionTargetManagerImpl.$$$reportNull$$$0(8);
            }
            return list2;
        }
        List providers = ExecutionTargetProvider.EXTENSION_NAME.getExtensionList();
        LinkedHashSet<ExecutionTarget> result2 = new LinkedHashSet<ExecutionTarget>();
        THashSet specifiedTargets = new THashSet();
        this.doWithEachNonCompoundWithSpecifiedTarget(configuration, (arg_0, arg_1) -> this.lambda$getTargetsFor$1(providers, result2, (Set)specifiedTargets, arg_0, arg_1));
        if (!result2.isEmpty()) {
            specifiedTargets.forEach(it -> result2.retainAll(Collections.singleton(it)));
            if (result2.isEmpty()) {
                result2.add(MULTIPLE_TARGETS);
            }
        }
        List<ExecutionTarget> list3 = Collections.unmodifiableList(ContainerUtil.filter(result2, it -> this.doCanRun(configuration, (ExecutionTarget)it)));
        if (list3 == null) {
            ExecutionTargetManagerImpl.$$$reportNull$$$0(9);
        }
        return list3;
    }

    private boolean doWithEachNonCompoundWithSpecifiedTarget(@NotNull RunConfiguration configuration, @NotNull BiPredicate<? super RunConfiguration, ? super ExecutionTarget> action2) {
        if (configuration == null) {
            ExecutionTargetManagerImpl.$$$reportNull$$$0(10);
        }
        if (action2 == null) {
            ExecutionTargetManagerImpl.$$$reportNull$$$0(11);
        }
        THashSet recursionGuard = new THashSet();
        LinkedList<Pair> toProcess2 = new LinkedList<Pair>();
        toProcess2.add(Pair.create((Object)configuration, null));
        while (!toProcess2.isEmpty()) {
            Pair eachWithTarget = (Pair)toProcess2.pollFirst();
            assert (eachWithTarget != null);
            if (!recursionGuard.add(eachWithTarget.first)) continue;
            RunConfiguration eachConfiguration = (RunConfiguration)eachWithTarget.first;
            if (eachConfiguration instanceof CompoundRunConfiguration) {
                for (Map.Entry<RunConfiguration, ExecutionTarget> subConfigWithTarget : ((CompoundRunConfiguration)eachConfiguration).getConfigurationsWithTargets(this.getRunManager()).entrySet()) {
                    toProcess2.add(Pair.create((Object)subConfigWithTarget.getKey(), (Object)subConfigWithTarget.getValue()));
                }
                continue;
            }
            if (action2.test((RunConfiguration)eachWithTarget.first, (ExecutionTarget)eachWithTarget.second)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public ExecutionTarget findTargetByIdFor(@Nullable RunConfiguration configuration, @Nullable String id2) {
        if (id2 == null) {
            return null;
        }
        return (ExecutionTarget)ContainerUtil.find(this.getTargetsFor(configuration), it -> it.getId().equals(id2));
    }

    public void update() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.updateActiveTarget();
    }

    public void reset(@Nullable RunManagerImpl runManager) {
        this.mySavedActiveTargetId = null;
        this.myActiveTarget = null;
        this.myRunManager = runManager;
    }

    private /* synthetic */ boolean lambda$getTargetsFor$1(List providers, LinkedHashSet result2, Set specifiedTargets, RunConfiguration subConfiguration, ExecutionTarget executionTarget) {
        for (ExecutionTargetProvider eachTargetProvider : providers) {
            List supportedTargets = eachTargetProvider.getTargets(this.myProject, subConfiguration);
            if (executionTarget == null) {
                result2.addAll(supportedTargets);
                continue;
            }
            if (!supportedTargets.contains(executionTarget)) continue;
            result2.add(executionTarget);
            specifiedTargets.add(executionTarget);
            break;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/ExecutionTargetManagerImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTarget";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/ExecutionTargetManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveTarget";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetsFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setRunManager";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setActiveTarget";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doSetActiveTarget";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doCanRun";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doWithEachNonCompoundWithSpecifiedTarget";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

