/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.configurationStore.SerializableScheme;
import com.intellij.diagnostic.PluginException;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configuration.PersistentAwareRunConfiguration;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.configurations.SimpleConfigurationType;
import com.intellij.execution.configurations.UnknownConfigurationType;
import com.intellij.execution.configurations.UnknownRunConfiguration;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.RunConfigurationLevel;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImplKt;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.impl.ProjectPathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SchemeState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.JdomKt;
import com.intellij.util.PathUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.text.StringKt;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0013*\u0002\u0013\u001d\u0018\u0000 c2\u00020\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00040\u00032\u00020\u0005:\u0003cdeB'\b\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\rB/\b\u0007\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0012\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J\b\u0010%\u001a\u00020\u0000H\u0016J\u0011\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0004H\u0096\u0002J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00020*H\u0016J\u001b\u0010+\u001a\u0004\u0018\u00010,2\u000e\b\u0004\u0010-\u001a\b\u0012\u0004\u0012\u00020\"0.H\u0082\bJ\b\u0010/\u001a\u00020\tH\u0016J\u0016\u00100\u001a\u0004\u0018\u0001012\n\u00102\u001a\u0006\u0012\u0002\b\u000303H\u0016J\r\u00104\u001a\u000705\u00a2\u0006\u0002\b6H\u0016J\n\u00107\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u00108\u001a\u00020\u0016H\u0016J\n\u00109\u001a\u0004\u0018\u00010\u0016H\u0016J'\u0010:\u001a\u0004\u0018\u0001H;\"\b\b\u0000\u0010;*\u00020<2\f\u00102\u001a\b\u0012\u0004\u0012\u0002H;03H\u0016\u00a2\u0006\u0002\u0010=J\n\u0010>\u001a\u0004\u0018\u00010?H\u0016J\r\u0010@\u001a\u00070A\u00a2\u0006\u0002\bBH\u0016J\b\u0010C\u001a\u00020\u0016H\u0016J\u0012\u0010D\u001a\u00020\"2\n\u00102\u001a\u0006\u0012\u0002\b\u000303J2\u0010E\u001a\u00020\"\"\u0004\b\u0000\u0010;2\u0010\u0010F\u001a\f\u0012\u0004\u0012\u0002H;0GR\u00020\u00002\u0010\u0010H\u001a\f\u0012\u0004\u0012\u0002H;0GR\u00020\u0000H\u0002J\u0015\u0010I\u001a\u00020\"2\u0006\u0010J\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\bKJ\b\u0010\u0017\u001a\u00020\u000bH\u0016J\b\u0010\u0018\u001a\u00020\u000bH\u0016J\b\u0010L\u001a\u00020\u000bH\u0016J\b\u0010M\u001a\u00020\u000bH\u0016J\b\u0010N\u001a\u00020\u000bH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010O\u001a\u00020\u000bH\u0016J\u0006\u0010P\u001a\u00020\u000bJ\u0016\u0010Q\u001a\u00020\"2\u0006\u0010R\u001a\u00020S2\u0006\u0010M\u001a\u00020\u000bJ\u0010\u0010T\u001a\u00020\"2\u0006\u0010U\u001a\u00020\u000bH\u0016J\u0010\u0010V\u001a\u00020\"2\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u0010\u0010W\u001a\u00020\"2\u0006\u0010U\u001a\u00020\u000bH\u0016J\u0012\u0010X\u001a\u00020\"2\b\u0010U\u001a\u0004\u0018\u00010\u0016H\u0016J\u0010\u0010Y\u001a\u00020\"2\u0006\u0010Z\u001a\u00020\u0016H\u0016J\u0010\u0010[\u001a\u00020\"2\u0006\u0010U\u001a\u00020\u000bH\u0016J\u0010\u0010\\\u001a\u00020\"2\u0006\u0010]\u001a\u00020\u0016H\u0016J\b\u0010^\u001a\u00020\"H\u0016J\b\u0010_\u001a\u00020\"H\u0016J\b\u0010`\u001a\u00020\u0016H\u0016J\u000e\u0010a\u001a\u00020\"2\u0006\u0010R\u001a\u00020SJ\b\u0010b\u001a\u00020SH\u0016R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001eR\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006f"}, d2={"Lcom/intellij/execution/impl/RunnerAndConfigurationSettingsImpl;", "", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "", "", "Lcom/intellij/configurationStore/SerializableScheme;", "manager", "Lcom/intellij/execution/impl/RunManagerImpl;", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "isTemplate", "", "isSingleton", "(Lcom/intellij/execution/impl/RunManagerImpl;Lcom/intellij/execution/configurations/RunConfiguration;ZZ)V", "_configuration", "level", "Lcom/intellij/execution/impl/RunConfigurationLevel;", "(Lcom/intellij/execution/impl/RunManagerImpl;Lcom/intellij/execution/configurations/RunConfiguration;ZLcom/intellij/execution/impl/RunConfigurationLevel;)V", "configurationPerRunnerSettings", "com/intellij/execution/impl/RunnerAndConfigurationSettingsImpl$configurationPerRunnerSettings$1", "Lcom/intellij/execution/impl/RunnerAndConfigurationSettingsImpl$configurationPerRunnerSettings$1;", "folderName", "", "isActivateToolWindowBeforeRun", "isEditBeforeRun", "getManager", "()Lcom/intellij/execution/impl/RunManagerImpl;", "pathIfStoredInArbitraryFile", "runnerSettings", "com/intellij/execution/impl/RunnerAndConfigurationSettingsImpl$runnerSettings$1", "Lcom/intellij/execution/impl/RunnerAndConfigurationSettingsImpl$runnerSettings$1;", "uniqueId", "wasSingletonSpecifiedExplicitly", "checkSettings", "", "executor", "Lcom/intellij/execution/Executor;", "clone", "compareTo", "", "other", "createFactory", "Lcom/intellij/openapi/util/Factory;", "doCheck", "Lcom/intellij/execution/configurations/RuntimeConfigurationWarning;", "check", "Lkotlin/Function0;", "getConfiguration", "getConfigurationSettings", "Lcom/intellij/execution/configurations/ConfigurationPerRunnerSettings;", "runner", "Lcom/intellij/execution/runners/ProgramRunner;", "getFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "Lorg/jetbrains/annotations/Nullable;", "getFolderName", "getName", "getPathIfStoredInArbitraryFileInProject", "getRunnerSettings", "T", "Lcom/intellij/execution/configurations/RunnerSettings;", "(Lcom/intellij/execution/runners/ProgramRunner;)Lcom/intellij/execution/configurations/RunnerSettings;", "getSchemeState", "Lcom/intellij/openapi/options/SchemeState;", "getType", "Lcom/intellij/execution/configurations/ConfigurationType;", "Lorg/jetbrains/annotations/NotNull;", "getUniqueID", "handleRunnerRemoved", "importFromTemplate", "templateItem", "Lcom/intellij/execution/impl/RunnerAndConfigurationSettingsImpl$RunnerItem;", "item", "importRunnerAndConfigurationSettings", "template", "importRunnerAndConfigurationSettings$intellij_platform_execution_impl", "isStoredInArbitraryFileInProject", "isStoredInDotIdeaFolder", "isStoredInLocalWorkspace", "isTemporary", "needsToBeMigrated", "readExternal", "element", "Lorg/jdom/Element;", "setActivateToolWindowBeforeRun", "value", "setConfiguration", "setEditBeforeRun", "setFolderName", "setName", "name", "setTemporary", "storeInArbitraryFileInProject", "filePath", "storeInDotIdeaFolder", "storeInLocalWorkspace", "toString", "writeExternal", "writeScheme", "Companion", "InfoProvider", "RunnerItem", "intellij.platform.execution.impl"})
public final class RunnerAndConfigurationSettingsImpl
implements Cloneable,
RunnerAndConfigurationSettings,
Comparable<Object>,
SerializableScheme {
    private final runnerSettings.1 runnerSettings;
    private final configurationPerRunnerSettings.1 configurationPerRunnerSettings;
    private String pathIfStoredInArbitraryFile;
    private boolean isEditBeforeRun;
    private boolean isActivateToolWindowBeforeRun;
    private boolean wasSingletonSpecifiedExplicitly;
    private String folderName;
    private String uniqueId;
    @NotNull
    private final RunManagerImpl manager;
    private RunConfiguration _configuration;
    private boolean isTemplate;
    private RunConfigurationLevel level;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public ConfigurationFactory getFactory() {
        RunConfiguration runConfiguration = this._configuration;
        if (runConfiguration == null || (runConfiguration = runConfiguration.getFactory()) == null) {
            runConfiguration = (ConfigurationFactory)UnknownConfigurationType.getInstance();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)runConfiguration, (String)"_configuration?.factory \u2026urationType.getInstance()");
        return runConfiguration;
    }

    public boolean isTemplate() {
        return this.isTemplate;
    }

    public boolean isTemporary() {
        return this.level == RunConfigurationLevel.TEMPORARY;
    }

    public void setTemporary(boolean value2) {
        this.level = value2 ? RunConfigurationLevel.TEMPORARY : RunConfigurationLevel.WORKSPACE;
    }

    public void storeInLocalWorkspace() {
        if (this.level != RunConfigurationLevel.TEMPORARY) {
            this.level = RunConfigurationLevel.WORKSPACE;
        }
        this.pathIfStoredInArbitraryFile = null;
    }

    public boolean isStoredInLocalWorkspace() {
        return this.level == RunConfigurationLevel.WORKSPACE || this.level == RunConfigurationLevel.TEMPORARY;
    }

    public void storeInDotIdeaFolder() {
        this.level = RunConfigurationLevel.PROJECT;
        this.pathIfStoredInArbitraryFile = null;
    }

    public boolean isStoredInDotIdeaFolder() {
        return this.level == RunConfigurationLevel.PROJECT && this.pathIfStoredInArbitraryFile == null;
    }

    public void storeInArbitraryFileInProject(@NotNull String filePath) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        this.level = RunConfigurationLevel.PROJECT;
        this.pathIfStoredInArbitraryFile = filePath;
    }

    public boolean isStoredInArbitraryFileInProject() {
        return this.level == RunConfigurationLevel.PROJECT && this.pathIfStoredInArbitraryFile != null;
    }

    @Nullable
    public String getPathIfStoredInArbitraryFileInProject() {
        return this.pathIfStoredInArbitraryFile;
    }

    @NotNull
    public RunConfiguration getConfiguration() {
        RunConfiguration runConfiguration = this._configuration;
        if (runConfiguration == null) {
            RunConfiguration runConfiguration2 = UnknownConfigurationType.getInstance().createTemplateConfiguration(this.manager.getProject());
            runConfiguration = runConfiguration2;
            Intrinsics.checkExpressionValueIsNotNull((Object)runConfiguration2, (String)"UnknownConfigurationType\u2026guration(manager.project)");
        }
        return runConfiguration;
    }

    public final void setConfiguration(@Nullable RunConfiguration configuration) {
        this._configuration = configuration;
    }

    @NotNull
    public Factory<RunnerAndConfigurationSettings> createFactory() {
        return (Factory)new Factory<RunnerAndConfigurationSettings>(this){
            final /* synthetic */ RunnerAndConfigurationSettingsImpl this$0;

            @NotNull
            public final RunnerAndConfigurationSettingsImpl create() {
                RunConfiguration configuration = this.this$0.getConfiguration();
                RunManagerImpl runManagerImpl = this.this$0.getManager();
                ConfigurationFactory configurationFactory = configuration.getFactory();
                if (configurationFactory == null) {
                    Intrinsics.throwNpe();
                }
                return new RunnerAndConfigurationSettingsImpl(runManagerImpl, configurationFactory.createConfiguration(ExecutionBundle.message((String)"default.run.configuration.name", (Object[])new Object[0]), configuration), false, null, 12, null);
            }
            {
                this.this$0 = runnerAndConfigurationSettingsImpl;
            }
        };
    }

    public void setName(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        boolean existing = this.uniqueId != null && this.manager.getConfigurationById(this.getUniqueID()) != null;
        this.uniqueId = null;
        this.getConfiguration().setName(name);
        if (existing) {
            this.manager.addConfiguration(this);
        }
    }

    @NotNull
    public String getName() {
        RunConfiguration configuration = this.getConfiguration();
        if (this.isTemplate) {
            return "<template> of " + this.getFactory().getId();
        }
        String string = configuration.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"configuration.name");
        return string;
    }

    @NotNull
    public String getUniqueID() {
        String result2;
        block3: {
            block2: {
                result2 = this.uniqueId;
                if (result2 == null) break block2;
                CharSequence charSequence = result2;
                String string = this.getConfiguration().getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"configuration.name");
                if (StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string, (boolean)false, (int)2, null)) break block3;
            }
            RunConfiguration configuration = this.getConfiguration();
            this.uniqueId = result2 = Companion.getUniqueIdFor(configuration);
        }
        return result2;
    }

    public void setEditBeforeRun(boolean value2) {
        this.isEditBeforeRun = value2;
    }

    public boolean isEditBeforeRun() {
        return this.isEditBeforeRun;
    }

    public void setActivateToolWindowBeforeRun(boolean value2) {
        this.isActivateToolWindowBeforeRun = value2;
    }

    public boolean isActivateToolWindowBeforeRun() {
        return this.isActivateToolWindowBeforeRun;
    }

    public void setFolderName(@Nullable String value2) {
        this.folderName = value2;
    }

    @Nullable
    public String getFolderName() {
        return this.folderName;
    }

    /*
     * Unable to fully structure code
     */
    public final void readExternal(@NotNull Element element, boolean isStoredInDotIdeaFolder) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        this.isTemplate = JdomKt.getAttributeBooleanValue((Element)element, (String)"default");
        this.level = isStoredInDotIdeaFolder != false ? RunConfigurationLevel.PROJECT : (JdomKt.getAttributeBooleanValue((Element)element, (String)"temporary") != false || Intrinsics.areEqual((Object)"tempConfiguration", (Object)element.getName()) != false ? RunConfigurationLevel.TEMPORARY : RunConfigurationLevel.WORKSPACE);
        this.isEditBeforeRun = JdomKt.getAttributeBooleanValue((Element)element, (String)"editBeforeRun");
        value = element.getAttributeValue("activateToolWindowBeforeRun");
        v0 = this;
        if (value == null) ** GOTO lbl-1000
        var4_4 = value;
        var12_5 = v0;
        var5_6 = false;
        var13_8 = Boolean.parseBoolean(var4_4);
        v0 = var12_5;
        if (var13_8) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        v0.isActivateToolWindowBeforeRun = v1;
        this.folderName = element.getAttributeValue("folderName");
        v2 = this.manager.getFactory(element.getAttributeValue("type"), element.getAttributeValue("factoryName"), this.isTemplate == false);
        if (v2 == null) {
            return;
        }
        factory = v2;
        v3 = factory.createTemplateConfiguration(this.manager.getProject(), (RunManager)this.manager);
        Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"factory.createTemplateCo\u2026manager.project, manager)");
        configuration = v3;
        if (!this.isTemplate) {
            v4 = element.getAttributeValue("name");
            if (v4 == null) {
                return;
            }
            configuration.setName(v4);
        }
        this._configuration = configuration;
        this.uniqueId = null;
        PathMacroManager.getInstance((ComponentManager)configuration.getProject()).expandPaths(element);
        if (configuration instanceof ModuleBasedConfiguration && ((ModuleBasedConfiguration)configuration).isModuleDirMacroSupported()) {
            v5 = element.getChild("module");
            v6 = moduleName = v5 != null ? v5.getAttributeValue("name") : null;
            if (moduleName != null) {
                v7 = ((ModuleBasedConfiguration)configuration).getConfigurationModule().findModule(moduleName);
                if (v7 != null) {
                    var7_10 = v7;
                    var8_11 = false;
                    var9_12 = false;
                    it = var7_10;
                    $i$a$-let-RunnerAndConfigurationSettingsImpl$readExternal$1 = false;
                    PathMacroManager.getInstance((ComponentManager)it).expandPaths(element);
                }
            }
        }
        RunnerAndConfigurationSettingsImplKt.deserializeConfigurationFrom(configuration, element, this.isTemplate);
        this.wasSingletonSpecifiedExplicitly = false;
        singletonStr = element.getAttributeValue("singleton");
        var7_10 = singletonStr;
        var8_11 = false;
        var9_12 = false;
        if (var7_10 == null || var7_10.length() == 0) {
            configuration.setAllowRunningInParallel(factory.getSingletonPolicy().isAllowRunningInParallel());
        } else {
            this.wasSingletonSpecifiedExplicitly = true;
            var7_10 = singletonStr;
            var12_5 = configuration;
            var8_11 = false;
            var13_8 = Boolean.parseBoolean((String)var7_10);
            var12_5.setAllowRunningInParallel(var13_8 == false);
        }
        this.runnerSettings.loadState(element);
        this.configurationPerRunnerSettings.loadState(element);
        this.manager.readBeforeRunTasks$intellij_platform_execution_impl(element.getChild("method"), this, configuration);
    }

    public final void writeExternal(@NotNull Element element2) {
        String string;
        boolean bl;
        char c;
        ConfigurationFactory factory;
        CharSequence it;
        boolean bl2;
        boolean bl3;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        RunConfiguration configuration = this.getConfiguration();
        ConfigurationType configurationType = configuration.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)configurationType, (String)"configuration.type");
        if (configurationType.isManaged()) {
            if (this.isTemplate) {
                element2.setAttribute("default", "true");
            } else {
                if (!RunnerAndConfigurationSettingsImplKt.access$isNewSerializationAllowed$p(this)) {
                    element2.setAttribute("default", "false");
                }
                String string2 = StringKt.nullize$default((String)configuration.getName(), (boolean)false, (int)1, null);
                if (string2 != null) {
                    String string3 = string2;
                    bl3 = false;
                    bl2 = false;
                    it = string3;
                    boolean bl4 = false;
                    element2.setAttribute("name", (String)it);
                }
            }
            factory = this.getFactory();
            ConfigurationType configurationType2 = factory.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)configurationType2, (String)"factory.type");
            element2.setAttribute("type", configurationType2.getId());
            if (!(factory.getType() instanceof SimpleConfigurationType)) {
                element2.setAttribute("factoryName", factory.getId());
            }
            if (this.folderName != null) {
                String string4 = this.folderName;
                if (string4 == null) {
                    Intrinsics.throwNpe();
                }
                element2.setAttribute("folderName", string4);
            }
            if (this.isEditBeforeRun) {
                element2.setAttribute("editBeforeRun", "true");
            }
            if (!this.isActivateToolWindowBeforeRun) {
                element2.setAttribute("activateToolWindowBeforeRun", "false");
            }
            if (this.wasSingletonSpecifiedExplicitly || configuration.isAllowRunningInParallel() != factory.getSingletonPolicy().isAllowRunningInParallel()) {
                element2.setAttribute("singleton", String.valueOf(!configuration.isAllowRunningInParallel()));
            }
            if (this.isTemporary()) {
                element2.setAttribute("temporary", "true");
            }
        }
        RunnerAndConfigurationSettingsImplKt.serializeConfigurationInto(configuration, element2);
        ConfigurationType configurationType3 = configuration.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)configurationType3, (String)"configuration.type");
        if (configurationType3.isManaged()) {
            this.runnerSettings.getState(element2);
            this.configurationPerRunnerSettings.getState(element2);
        }
        ConfigurationType configurationType4 = configuration.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)configurationType4, (String)"configuration.type");
        if (configurationType4.isManaged()) {
            Element element3 = this.manager.writeBeforeRunTasks$intellij_platform_execution_impl(configuration);
            if (element3 != null) {
                factory = element3;
                bl3 = false;
                bl2 = false;
                it = factory;
                boolean bl5 = false;
                element2.addContent((Element)it);
            }
        }
        if (configuration instanceof ModuleBasedConfiguration && ((ModuleBasedConfiguration)configuration).isModuleDirMacroSupported()) {
            RunConfigurationModule runConfigurationModule = ((ModuleBasedConfiguration)configuration).getConfigurationModule();
            Intrinsics.checkExpressionValueIsNotNull((Object)runConfigurationModule, (String)"configuration.configurationModule");
            Module module = runConfigurationModule.getModule();
            if (module != null) {
                factory = module;
                bl3 = false;
                bl2 = false;
                it = factory;
                boolean bl6 = false;
                PathMacroManager.getInstance((ComponentManager)it).collapsePathsRecursively(element2);
            }
        }
        Project project = configuration.getProject();
        PathMacroManager pathMacroManager = PathMacroManager.getInstance((ComponentManager)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)pathMacroManager, (String)"PathMacroManager.getInstance(project)");
        PathMacroManager macroManager = pathMacroManager;
        Project project2 = project;
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        String string5 = project2.getBasePath();
        if (string5 != null) {
            it = string5;
            c = '\u0000';
            bl = false;
            String it2 = it;
            boolean bl7 = false;
            string = PathUtilRt.getParentPath((String)it2);
        } else {
            string = null;
        }
        String projectParentPath = string;
        it = projectParentPath;
        c = '\u0000';
        bl = false;
        if (!(it == null || it.length() == 0)) {
            ReplacePathToMacroMap replacePathMap;
            PathMacroManager pathMacroManager2 = macroManager;
            if (!(pathMacroManager2 instanceof ProjectPathMacroManager)) {
                pathMacroManager2 = null;
            }
            ProjectPathMacroManager projectPathMacroManager = (ProjectPathMacroManager)pathMacroManager2;
            ReplacePathToMacroMap replacePathToMacroMap = replacePathMap = projectPathMacroManager != null ? projectPathMacroManager.getReplacePathMap() : null;
            if (replacePathMap != null) {
                c = '$';
                String string6 = "PROJECT_DIR";
                StringBuilder stringBuilder = new StringBuilder();
                String string7 = projectParentPath;
                ReplacePathToMacroMap replacePathToMacroMap2 = replacePathMap;
                boolean bl8 = false;
                String string8 = String.valueOf(c) + string6;
                replacePathToMacroMap2.addReplacement(string7, stringBuilder.append(string8).append("$/..").toString(), true);
                PathMacroManager.collapsePaths(element2, true, replacePathMap);
                return;
            }
        }
        PathMacroManager.getInstance((ComponentManager)project).collapsePathsRecursively(element2);
    }

    @Override
    @NotNull
    public Element writeScheme() {
        Element element2 = new Element("configuration");
        this.writeExternal(element2);
        return element2;
    }

    public void checkSettings(@Nullable Executor executor) {
        boolean bl;
        ProgramRunner it$iv$iv;
        ProgramRunner programRunner;
        boolean bl2;
        boolean bl3;
        String it;
        boolean bl4;
        Object element$iv$iv;
        Object element$iv$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        RuntimeConfigurationWarning runtimeConfigurationWarning;
        RunConfiguration configuration = this.getConfiguration();
        RuntimeConfigurationWarning warning = null;
        RunnerAndConfigurationSettingsImpl this_$iv = this;
        boolean $i$f$doCheck22 = false;
        try {
            boolean bl5 = false;
            boolean $i$f$runReadAction = false;
            ApplicationManager.getApplication().runReadAction(new Computable<T>(configuration){
                final /* synthetic */ RunConfiguration $configuration$inlined;
                {
                    this.$configuration$inlined = runConfiguration;
                }

                public final T compute() {
                    boolean bl = false;
                    this.$configuration$inlined.checkConfiguration();
                    return (T)Unit.INSTANCE;
                }
            });
            runtimeConfigurationWarning = null;
        }
        catch (RuntimeConfigurationWarning ex$iv) {
            runtimeConfigurationWarning = warning = ex$iv;
        }
        if (!(configuration instanceof RunConfigurationBase)) {
            if (warning != null) {
                throw (Throwable)warning;
            }
            return;
        }
        THashSet runners = new THashSet();
        Set set = this.runnerSettings.getSettings().keySet();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"runnerSettings.settings.keys");
        Iterable $i$f$doCheck22 = set;
        THashSet tHashSet = runners;
        boolean $i$f$mapNotNull = false;
        void $i$f$runReadAction = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv$iv = element$iv$iv$iv = iterator2.next();
            bl4 = false;
            it = (String)element$iv$iv;
            boolean bl6 = false;
            if (ProgramRunner.findRunnerById((String)it) == null) continue;
            bl3 = false;
            bl2 = false;
            it$iv$iv = programRunner;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        tHashSet.addAll((Collection)list2);
        Set set2 = this.configurationPerRunnerSettings.getSettings().keySet();
        Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"configurationPerRunnerSettings.settings.keys");
        $this$mapNotNull$iv = set2;
        tHashSet = runners;
        $i$f$mapNotNull = false;
        $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv$iv = element$iv$iv$iv = iterator2.next();
            bl4 = false;
            it = (String)element$iv$iv;
            boolean bl7 = false;
            if (ProgramRunner.findRunnerById((String)it) == null) continue;
            bl3 = false;
            bl2 = false;
            it$iv$iv = programRunner;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        list2 = (List)destination$iv$iv;
        tHashSet.addAll((Collection)list2);
        Executor executor2 = executor;
        if (executor2 != null) {
            $this$mapNotNull$iv = executor2;
            $i$f$mapNotNull = false;
            boolean $this$mapNotNullTo$iv$iv2 = false;
            Iterable it2 = $this$mapNotNull$iv;
            boolean bl8 = false;
            ProgramRunner programRunner2 = ProgramRunner.getRunner((String)executor.getId(), (RunProfile)((RunProfile)configuration));
            if (programRunner2 != null) {
                $this$forEach$iv$iv$iv = programRunner2;
                $i$f$forEach = false;
                boolean bl9 = false;
                Iterable it3 = $this$forEach$iv$iv$iv;
                boolean bl10 = false;
                runners.add((Object)it3);
            }
        }
        boolean runnerFound = false;
        for (ProgramRunner runner : runners) {
            RuntimeConfigurationWarning runnerWarning;
            RuntimeConfigurationWarning runtimeConfigurationWarning2;
            if (executor != null && !runner.canRun(executor.getId(), (RunProfile)configuration)) continue;
            RunnerAndConfigurationSettingsImpl this_$iv2 = this;
            boolean $i$f$doCheck = false;
            try {
                boolean bl11 = false;
                RunConfigurationBase runConfigurationBase = (RunConfigurationBase)configuration;
                THashMap tHashMap = this.runnerSettings.getSettings();
                ProgramRunner programRunner3 = runner;
                Intrinsics.checkExpressionValueIsNotNull((Object)programRunner3, (String)"runner");
                runConfigurationBase.checkRunnerSettings(runner, (RunnerSettings)tHashMap.get((Object)programRunner3.getRunnerId()), (ConfigurationPerRunnerSettings)this.configurationPerRunnerSettings.getSettings().get((Object)runner.getRunnerId()));
                runtimeConfigurationWarning2 = null;
            }
            catch (RuntimeConfigurationWarning ex$iv) {
                runtimeConfigurationWarning2 = runnerWarning = ex$iv;
            }
            if (runnerWarning != null) {
                if (warning != null) continue;
                warning = runnerWarning;
                continue;
            }
            runnerFound = true;
        }
        if (executor != null && Intrinsics.areEqual((Object)executor, (Object)DefaultRunExecutor.getRunExecutorInstance()) ^ true && !runnerFound) {
            throw (Throwable)new RuntimeConfigurationError(executor.getId() + ": there are no runners for " + configuration);
        }
        if (executor != null) {
            RuntimeConfigurationWarning beforeRunWarning;
            RuntimeConfigurationWarning runtimeConfigurationWarning3;
            RunnerAndConfigurationSettingsImpl this_$iv3 = this;
            boolean $i$f$doCheck = false;
            try {
                boolean bl12 = false;
                ((RunConfigurationBase)configuration).checkSettingsBeforeRun();
                runtimeConfigurationWarning3 = null;
            }
            catch (RuntimeConfigurationWarning ex$iv) {
                runtimeConfigurationWarning3 = beforeRunWarning = ex$iv;
            }
            if (warning == null && beforeRunWarning != null) {
                warning = beforeRunWarning;
            }
        }
        if (warning != null) {
            throw (Throwable)warning;
        }
    }

    private final RuntimeConfigurationWarning doCheck(Function0<Unit> check) {
        int $i$f$doCheck = 0;
        try {
            check.invoke();
            return null;
        }
        catch (RuntimeConfigurationWarning ex) {
            return ex;
        }
    }

    @Nullable
    public <T extends RunnerSettings> T getRunnerSettings(@NotNull ProgramRunner<T> runner) {
        Intrinsics.checkParameterIsNotNull(runner, (String)"runner");
        return (T)((RunnerSettings)this.runnerSettings.getOrCreateSettings(runner));
    }

    @Nullable
    public ConfigurationPerRunnerSettings getConfigurationSettings(@NotNull ProgramRunner<?> runner) {
        Intrinsics.checkParameterIsNotNull(runner, (String)"runner");
        return (ConfigurationPerRunnerSettings)this.configurationPerRunnerSettings.getOrCreateSettings(runner);
    }

    @NotNull
    public ConfigurationType getType() {
        ConfigurationType configurationType = this.getFactory().getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)configurationType, (String)"factory.type");
        return configurationType;
    }

    @NotNull
    public RunnerAndConfigurationSettingsImpl clone() {
        RunConfiguration runConfiguration = this._configuration;
        if (runConfiguration == null) {
            Intrinsics.throwNpe();
        }
        RunnerAndConfigurationSettingsImpl copy2 = new RunnerAndConfigurationSettingsImpl(this.manager, runConfiguration.clone(), false, null, 12, null);
        copy2.importRunnerAndConfigurationSettings$intellij_platform_execution_impl(this);
        return copy2;
    }

    public final void importRunnerAndConfigurationSettings$intellij_platform_execution_impl(@NotNull RunnerAndConfigurationSettingsImpl template) {
        Intrinsics.checkParameterIsNotNull((Object)template, (String)"template");
        this.importFromTemplate(template.runnerSettings, this.runnerSettings);
        this.importFromTemplate(template.configurationPerRunnerSettings, this.configurationPerRunnerSettings);
        this.isEditBeforeRun = template.isEditBeforeRun;
        this.isActivateToolWindowBeforeRun = template.isActivateToolWindowBeforeRun;
        this.level = template.level;
        this.pathIfStoredInArbitraryFile = template.pathIfStoredInArbitraryFile;
    }

    private final <T> void importFromTemplate(RunnerItem<T> templateItem, RunnerItem<T> item) {
        for (String runnerId : templateItem.getSettings().keySet()) {
            ProgramRunner runner;
            if (ProgramRunner.findRunnerById((String)runnerId) == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)runner, (String)"ProgramRunner.findRunnerById(runnerId) ?: continue");
            T data2 = item.createSettings(runner);
            item.getSettings().put((Object)runnerId, data2);
            if (data2 == null) continue;
            Element temp = new Element("dummy");
            if (templateItem.getSettings().get((Object)runnerId) == null) {
                continue;
            }
            try {
                Object templateSettings;
                Object object = templateSettings;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.util.JDOMExternalizable");
                }
                ((JDOMExternalizable)object).writeExternal(temp);
                ((JDOMExternalizable)data2).readExternal(temp);
            }
            catch (WriteExternalException e) {
                RunManagerImpl.Companion.getLOG$intellij_platform_execution_impl().error((Throwable)e);
            }
            catch (InvalidDataException e) {
                RunManagerImpl.Companion.getLOG$intellij_platform_execution_impl().error((Throwable)e);
            }
        }
    }

    public final void handleRunnerRemoved(@NotNull ProgramRunner<?> runner) {
        Intrinsics.checkParameterIsNotNull(runner, (String)"runner");
        this.runnerSettings.handleRunnerRemoved(runner);
    }

    @Override
    public int compareTo(@NotNull Object other) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        if (other instanceof RunnerAndConfigurationSettings) {
            String string = this.getName();
            String string2 = ((RunnerAndConfigurationSettings)other).getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"other.name");
            n = string.compareTo(string2);
        } else {
            n = 0;
        }
        return n;
    }

    @NotNull
    public String toString() {
        return this.getType().getDisplayName() + ": " + (this.isTemplate ? "<template>" : this.getName()) + " (level: " + (Object)((Object)this.level) + ')';
    }

    @Override
    @Nullable
    public SchemeState getSchemeState() {
        SchemeState schemeState;
        RunConfiguration configuration = this._configuration;
        if (configuration == null) {
            schemeState = SchemeState.UNCHANGED;
        } else if (configuration instanceof UnknownRunConfiguration) {
            schemeState = ((UnknownRunConfiguration)configuration).isDoNotStore() ? SchemeState.NON_PERSISTENT : SchemeState.UNCHANGED;
        } else {
            ConfigurationType configurationType = configuration.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)configurationType, (String)"configuration.type");
            schemeState = !configurationType.isManaged() ? SchemeState.NON_PERSISTENT : null;
        }
        return schemeState;
    }

    public final boolean needsToBeMigrated() {
        RunConfiguration runConfiguration = this._configuration;
        if (!(runConfiguration instanceof PersistentAwareRunConfiguration)) {
            runConfiguration = null;
        }
        PersistentAwareRunConfiguration persistentAwareRunConfiguration = (PersistentAwareRunConfiguration)runConfiguration;
        return persistentAwareRunConfiguration != null ? persistentAwareRunConfiguration.needsToBeMigrated() : false;
    }

    @NotNull
    public final RunManagerImpl getManager() {
        return this.manager;
    }

    @JvmOverloads
    public RunnerAndConfigurationSettingsImpl(@NotNull RunManagerImpl manager, @Nullable RunConfiguration _configuration, boolean isTemplate, @NotNull RunConfigurationLevel level) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)manager), (String)"manager");
        Intrinsics.checkParameterIsNotNull((Object)((Object)level), (String)"level");
        this.manager = manager;
        this._configuration = _configuration;
        this.isTemplate = isTemplate;
        this.level = level;
        RunConfiguration runConfiguration = this._configuration;
        if (!(runConfiguration instanceof PersistentAwareRunConfiguration)) {
            runConfiguration = null;
        }
        PersistentAwareRunConfiguration persistentAwareRunConfiguration = (PersistentAwareRunConfiguration)runConfiguration;
        if (persistentAwareRunConfiguration != null) {
            persistentAwareRunConfiguration.setTemplate(this.isTemplate);
        }
        this.runnerSettings = new RunnerItem<RunnerSettings>(this, "RunnerSettings"){
            final /* synthetic */ RunnerAndConfigurationSettingsImpl this$0;

            @Nullable
            public RunnerSettings createSettings(@NotNull ProgramRunner<?> runner) {
                Intrinsics.checkParameterIsNotNull(runner, (String)"runner");
                return runner.createConfigurationData((ConfigurationInfoProvider)this.this$0.new InfoProvider(runner));
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
            }
        };
        this.configurationPerRunnerSettings = new RunnerItem<ConfigurationPerRunnerSettings>(this, "ConfigurationWrapper"){
            final /* synthetic */ RunnerAndConfigurationSettingsImpl this$0;

            @Nullable
            public ConfigurationPerRunnerSettings createSettings(@NotNull ProgramRunner<?> runner) {
                Intrinsics.checkParameterIsNotNull(runner, (String)"runner");
                return this.this$0.getConfiguration().createRunnerSettings((ConfigurationInfoProvider)this.this$0.new InfoProvider(runner));
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
            }
        };
        this.isActivateToolWindowBeforeRun = true;
    }

    public /* synthetic */ RunnerAndConfigurationSettingsImpl(RunManagerImpl runManagerImpl, RunConfiguration runConfiguration, boolean bl, RunConfigurationLevel runConfigurationLevel, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            runConfiguration = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            runConfigurationLevel = RunConfigurationLevel.WORKSPACE;
        }
        this(runManagerImpl, runConfiguration, bl, runConfigurationLevel);
    }

    @JvmOverloads
    public RunnerAndConfigurationSettingsImpl(@NotNull RunManagerImpl manager, @Nullable RunConfiguration _configuration, boolean isTemplate) {
        this(manager, _configuration, isTemplate, null, 8, null);
    }

    @JvmOverloads
    public RunnerAndConfigurationSettingsImpl(@NotNull RunManagerImpl manager, @Nullable RunConfiguration _configuration) {
        this(manager, _configuration, false, null, 12, null);
    }

    @JvmOverloads
    public RunnerAndConfigurationSettingsImpl(@NotNull RunManagerImpl manager) {
        this(manager, null, false, null, 14, null);
    }

    @Deprecated(message="isSingleton parameter removed", level=DeprecationLevel.ERROR)
    public RunnerAndConfigurationSettingsImpl(@NotNull RunManagerImpl manager, @NotNull RunConfiguration configuration, boolean isTemplate, boolean isSingleton) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)manager), (String)"manager");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        this(manager, configuration, isTemplate, null, 8, null);
    }

    @JvmStatic
    @NotNull
    public static final String getUniqueIdFor(@NotNull RunConfiguration configuration) {
        return Companion.getUniqueIdFor(configuration);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\u0004\u0018\u00010\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/execution/impl/RunnerAndConfigurationSettingsImpl$InfoProvider;", "Lcom/intellij/execution/configurations/ConfigurationInfoProvider;", "runner", "Lcom/intellij/execution/runners/ProgramRunner;", "(Lcom/intellij/execution/impl/RunnerAndConfigurationSettingsImpl;Lcom/intellij/execution/runners/ProgramRunner;)V", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "getConfiguration", "()Lcom/intellij/execution/configurations/RunConfiguration;", "configurationSettings", "Lcom/intellij/execution/configurations/ConfigurationPerRunnerSettings;", "getConfigurationSettings", "()Lcom/intellij/execution/configurations/ConfigurationPerRunnerSettings;", "getRunner", "()Lcom/intellij/execution/runners/ProgramRunner;", "runnerSettings", "Lcom/intellij/execution/configurations/RunnerSettings;", "getRunnerSettings", "()Lcom/intellij/execution/configurations/RunnerSettings;", "intellij.platform.execution.impl"})
    private final class InfoProvider
    implements ConfigurationInfoProvider {
        @NotNull
        private final ProgramRunner<?> runner;

        @NotNull
        public RunConfiguration getConfiguration() {
            return RunnerAndConfigurationSettingsImpl.this.getConfiguration();
        }

        @Nullable
        public RunnerSettings getRunnerSettings() {
            return RunnerAndConfigurationSettingsImpl.this.getRunnerSettings(this.getRunner());
        }

        @Nullable
        public ConfigurationPerRunnerSettings getConfigurationSettings() {
            return RunnerAndConfigurationSettingsImpl.this.getConfigurationSettings(this.getRunner());
        }

        @NotNull
        public ProgramRunner<?> getRunner() {
            return this.runner;
        }

        public InfoProvider(ProgramRunner<?> runner) {
            Intrinsics.checkParameterIsNotNull(runner, (String)"runner");
            this.runner = runner;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u00a2\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J-\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\f\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00018\u0000H\u0002\u00a2\u0006\u0002\u0010\u0015J\u001b\u0010\u0016\u001a\u0004\u0018\u00018\u00002\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H&\u00a2\u0006\u0002\u0010\u0017J\u0016\u0010\u0018\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00132\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J\u0019\u0010\u001a\u001a\u0004\u0018\u00018\u00002\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013\u00a2\u0006\u0002\u0010\u0017J\u000e\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u000eJ\u0012\u0010\u001d\u001a\u00020\u00102\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013J\u000e\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/execution/impl/RunnerAndConfigurationSettingsImpl$RunnerItem;", "T", "", "childTagName", "", "(Lcom/intellij/execution/impl/RunnerAndConfigurationSettingsImpl;Ljava/lang/String;)V", "loadedIds", "Lgnu/trove/THashSet;", "settings", "Lgnu/trove/THashMap;", "getSettings", "()Lgnu/trove/THashMap;", "unloadedSettings", "", "Lorg/jdom/Element;", "add", "", "state", "runner", "Lcom/intellij/execution/runners/ProgramRunner;", "data", "(Lorg/jdom/Element;Lcom/intellij/execution/runners/ProgramRunner;Ljava/lang/Object;)V", "createSettings", "(Lcom/intellij/execution/runners/ProgramRunner;)Ljava/lang/Object;", "findRunner", "runnerId", "getOrCreateSettings", "getState", "element", "handleRunnerRemoved", "loadState", "intellij.platform.execution.impl"})
    private abstract class RunnerItem<T> {
        @NotNull
        private final THashMap<String, T> settings;
        private List<Element> unloadedSettings;
        private final THashSet<String> loadedIds;
        private final String childTagName;

        @NotNull
        public final THashMap<String, T> getSettings() {
            return this.settings;
        }

        public final void loadState(@NotNull Element element2) {
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            this.settings.clear();
            if (this.unloadedSettings != null) {
                List<Element> list2 = this.unloadedSettings;
                if (list2 == null) {
                    Intrinsics.throwNpe();
                }
                list2.clear();
            }
            this.loadedIds.clear();
            Iterator iterator2 = element2.getChildren(this.childTagName).iterator();
            while (iterator2.hasNext()) {
                ProgramRunner<?> runner;
                ProgramRunner<?> programRunner;
                Element state = (Element)iterator2.next();
                if (state.getAttributeValue("RunnerId") != null) {
                    String string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string;
                    boolean bl3 = false;
                    programRunner = this.findRunner(it);
                } else {
                    programRunner = runner = null;
                }
                if (runner == null) {
                    iterator2.remove();
                }
                Element element3 = state;
                Intrinsics.checkExpressionValueIsNotNull((Object)element3, (String)"state");
                this.add(element3, runner, runner == null ? null : (T)this.createSettings(runner));
            }
        }

        /*
         * WARNING - void declaration
         */
        private final ProgramRunner<?> findRunner(String runnerId) {
            ProgramRunner programRunner;
            void $this$filterTo$iv$iv;
            ExtensionPointName extensionPointName = ProgramRunner.PROGRAM_RUNNER_EP;
            Intrinsics.checkExpressionValueIsNotNull((Object)extensionPointName, (String)"ProgramRunner.PROGRAM_RUNNER_EP");
            Iterable iterable = extensionPointName.getIterable();
            Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"ProgramRunner.PROGRAM_RUNNER_EP.iterable");
            Iterable $this$filter$iv = iterable;
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ProgramRunner it = (ProgramRunner)element$iv$iv;
                boolean bl = false;
                ProgramRunner programRunner2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)programRunner2, (String)"it");
                if (!Intrinsics.areEqual((Object)runnerId, (Object)programRunner2.getRunnerId())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List runnersById = (List)destination$iv$iv;
            if (runnersById.isEmpty()) {
                programRunner = null;
            } else if (runnersById.size() == 1) {
                programRunner = (ProgramRunner)CollectionsKt.firstOrNull((List)runnersById);
            } else {
                RunManagerImpl.Companion.getLOG$intellij_platform_execution_impl().error("More than one runner found for ID: " + runnerId);
                ExtensionPointName extensionPointName2 = Executor.EXECUTOR_EXTENSION_NAME;
                Intrinsics.checkExpressionValueIsNotNull((Object)extensionPointName2, (String)"Executor.EXECUTOR_EXTENSION_NAME");
                for (Executor executor : extensionPointName2.getExtensionList()) {
                    Object v6;
                    block7: {
                        Iterable $this$firstOrNull$iv = runnersById;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            ProgramRunner it = (ProgramRunner)element$iv;
                            boolean bl = false;
                            Executor executor2 = executor;
                            Intrinsics.checkExpressionValueIsNotNull((Object)executor2, (String)"executor");
                            if (!it.canRun(executor2.getId(), (RunProfile)RunnerAndConfigurationSettingsImpl.this.getConfiguration())) continue;
                            v6 = element$iv;
                            break block7;
                        }
                        v6 = null;
                    }
                    ProgramRunner programRunner3 = v6;
                    if (programRunner3 == null) continue;
                    iterable2 = programRunner3;
                    boolean bl = false;
                    boolean bl2 = false;
                    Iterable it = iterable2;
                    boolean bl3 = false;
                    return it;
                }
                programRunner = null;
            }
            return programRunner;
        }

        /*
         * WARNING - void declaration
         */
        public final void getState(@NotNull Element element2) {
            Element state;
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            SmartList runnerSettings2 = new SmartList();
            for (String runnerId : this.settings.keySet()) {
                Object settings = this.settings.get((Object)runnerId);
                boolean wasLoaded = this.loadedIds.contains((Object)runnerId);
                if (settings == null && !wasLoaded) continue;
                state = new Element(this.childTagName);
                if (settings != null) {
                    ((JDOMExternalizable)settings).writeExternal(state);
                }
                if (!wasLoaded && JDOMUtil.isEmpty((Element)state)) continue;
                state.setAttribute("RunnerId", runnerId);
                runnerSettings2.add((Object)state);
            }
            List<Element> list2 = this.unloadedSettings;
            if (list2 != null) {
                Iterable $this$mapTo$iv = list2;
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void it;
                    state = (Element)item$iv;
                    Collection collection = (Collection)runnerSettings2;
                    boolean bl = false;
                    Element element3 = it.clone();
                    collection.add(element3);
                }
                SmartList cfr_ignored_0 = (SmartList)((Collection)runnerSettings2);
            }
            CollectionsKt.sortWith((List)((List)runnerSettings2), (Comparator)getState.2.INSTANCE);
            for (Element runnerSetting : runnerSettings2) {
                element2.addContent(runnerSetting);
            }
        }

        @Nullable
        public abstract T createSettings(@NotNull ProgramRunner<?> var1);

        private final void add(Element state, ProgramRunner<?> runner, T data2) {
            if (runner == null) {
                if (this.unloadedSettings == null) {
                    this.unloadedSettings = (List)new SmartList();
                }
                List<Element> list2 = this.unloadedSettings;
                if (list2 == null) {
                    Intrinsics.throwNpe();
                }
                Element element2 = JDOMUtil.internElement((Element)state);
                Intrinsics.checkExpressionValueIsNotNull((Object)element2, (String)"JDOMUtil.internElement(state)");
                list2.add(element2);
                return;
            }
            if (data2 != null) {
                ((JDOMExternalizable)data2).readExternal(state);
            }
            this.settings.put((Object)runner.getRunnerId(), data2);
            this.loadedIds.add((Object)runner.getRunnerId());
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final T getOrCreateSettings(@NotNull ProgramRunner<?> runner) {
            Intrinsics.checkParameterIsNotNull(runner, (String)"runner");
            try {
                Object object;
                void $this$getOrPut$iv;
                Map map2 = (Map)this.settings;
                String key$iv = runner.getRunnerId();
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    T answer$iv = this.createSettings(runner);
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                return (T)object;
            }
            catch (AbstractMethodError e) {
                Logger logger = RunManagerImpl.Companion.getLOG$intellij_platform_execution_impl();
                StringBuilder stringBuilder = new StringBuilder().append("Update failed for: ");
                ConfigurationType configurationType = RunnerAndConfigurationSettingsImpl.this.getConfiguration().getType();
                Intrinsics.checkExpressionValueIsNotNull((Object)configurationType, (String)"configuration.type");
                PluginException.logPluginError((Logger)logger, (String)stringBuilder.append(configurationType.getDisplayName()).append(", runner: ").append(runner.getRunnerId()).toString(), (Throwable)e, runner.getClass());
                return null;
            }
        }

        public final void handleRunnerRemoved(@NotNull ProgramRunner<?> runner) {
            Intrinsics.checkParameterIsNotNull(runner, (String)"runner");
            RunnerSettings runnerSettings2 = (RunnerSettings)this.settings.get((Object)runner.getRunnerId());
            if (runnerSettings2 != null) {
                this.settings.remove((Object)runner.getRunnerId());
                Element element2 = new Element(this.childTagName);
                runnerSettings2.writeExternal(element2);
                if (this.unloadedSettings == null) {
                    this.unloadedSettings = (List)new SmartList();
                }
                List<Element> list2 = this.unloadedSettings;
                if (list2 == null) {
                    Intrinsics.throwNpe();
                }
                Element element3 = JDOMUtil.internElement((Element)element2);
                Intrinsics.checkExpressionValueIsNotNull((Object)element3, (String)"JDOMUtil.internElement(element)");
                list2.add(element3);
                this.loadedIds.remove((Object)runner.getRunnerId());
            }
        }

        public RunnerItem(String childTagName) {
            Intrinsics.checkParameterIsNotNull((Object)childTagName, (String)"childTagName");
            this.childTagName = childTagName;
            this.settings = new THashMap();
            this.loadedIds = new THashSet();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/execution/impl/RunnerAndConfigurationSettingsImpl$Companion;", "", "()V", "getUniqueIdFor", "", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "intellij.platform.execution.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final String getUniqueIdFor(@NotNull RunConfiguration configuration) {
            Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
            ConfigurationType configurationType = configuration.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)configurationType, (String)"configuration.type");
            ConfigurationType type = configurationType;
            if (!type.isManaged()) {
                String string = configuration.getId();
                if (string != null) {
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string2;
                    boolean bl3 = false;
                    String string3 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it");
                    return string3;
                }
            }
            StringBuilder stringBuilder = new StringBuilder();
            ConfigurationType configurationType2 = configuration.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)configurationType2, (String)"configuration.type");
            StringBuilder stringBuilder2 = stringBuilder.append(configurationType2.getDisplayName()).append('.').append(configuration.getName());
            RunConfiguration runConfiguration = configuration;
            if (!(runConfiguration instanceof UnknownRunConfiguration)) {
                runConfiguration = null;
            }
            UnknownRunConfiguration unknownRunConfiguration = (UnknownRunConfiguration)runConfiguration;
            return stringBuilder2.append(unknownRunConfiguration != null ? Integer.valueOf(unknownRunConfiguration.getUniqueID()) : "").toString();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

