/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.icons.AllIcons;
import com.intellij.ide.macro.EditorMacro;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.MacrosDialog;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.TextAccessor;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonProgramParametersPanel
extends JPanel
implements PanelWithAnchor {
    protected LabeledComponent<RawCommandLineEditor> myProgramParametersComponent;
    protected LabeledComponent<JComponent> myWorkingDirectoryComponent;
    protected TextFieldWithBrowseButton myWorkingDirectoryField;
    protected EnvironmentVariablesComponent myEnvVariablesComponent;
    protected JComponent myAnchor;
    private Module myModuleContext = null;
    private boolean myHasModuleMacro;

    public CommonProgramParametersPanel() {
        this(true);
    }

    public CommonProgramParametersPanel(boolean init2) {
        this.setLayout((LayoutManager)new VerticalFlowLayout(1, 0, 5, true, false));
        if (init2) {
            this.init();
        }
    }

    protected void init() {
        this.initComponents();
        this.updateUI();
        this.setupAnchor();
    }

    protected void setupAnchor() {
        this.myAnchor = UIUtil.mergeComponentsWithAnchor((PanelWithAnchor[])new PanelWithAnchor[]{this.myProgramParametersComponent, this.myWorkingDirectoryComponent, this.myEnvVariablesComponent});
    }

    @Nullable
    protected Project getProject() {
        return this.myModuleContext != null ? this.myModuleContext.getProject() : null;
    }

    protected void initComponents() {
        this.myProgramParametersComponent = LabeledComponent.create((JComponent)new RawCommandLineEditor(), (String)ExecutionBundle.message((String)"run.configuration.program.parameters", (Object[])new Object[0]));
        this.myWorkingDirectoryField = new TextFieldWithBrowseButton();
        this.myWorkingDirectoryField.addBrowseFolderListener(ExecutionBundle.message((String)"select.working.directory.message", (Object[])new Object[0]), null, this.getProject(), FileChooserDescriptorFactory.createSingleFolderDescriptor(), TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        this.myWorkingDirectoryComponent = LabeledComponent.create((JComponent)this.myWorkingDirectoryField, (String)ExecutionBundle.message((String)"run.configuration.working.directory.label", (Object[])new Object[0]));
        this.myEnvVariablesComponent = new EnvironmentVariablesComponent();
        this.myEnvVariablesComponent.setLabelLocation("West");
        this.myProgramParametersComponent.setLabelLocation("West");
        this.myWorkingDirectoryComponent.setLabelLocation("West");
        this.addComponents();
        if (this.isMacroSupportEnabled()) {
            this.initMacroSupport();
        }
        this.setPreferredSize(new Dimension(10, 10));
        this.copyDialogCaption(this.myProgramParametersComponent);
    }

    @Deprecated
    protected JComponent createComponentWithMacroBrowse(final @NotNull TextFieldWithBrowseButton textAccessor) {
        if (textAccessor == null) {
            CommonProgramParametersPanel.$$$reportNull$$$0(0);
        }
        final FixedSizeButton button2 = new FixedSizeButton((JComponent)textAccessor);
        button2.setIcon(AllIcons.Actions.ListFiles);
        button2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List macros = ContainerUtil.map(CommonProgramParametersPanel.this.getPathMacros().keySet(), s -> s.startsWith("%") ? s : "$" + s + "$");
                JBPopupFactory.getInstance().createPopupChooserBuilder(macros).setItemChosenCallback(value2 -> textAccessor.setText(value2)).setMovable(false).setResizable(false).createPopup().showUnderneathOf((Component)button2);
            }
        });
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)textAccessor, "Center");
        panel2.add((Component)button2, "East");
        return panel2;
    }

    protected void addComponents() {
        this.add((Component)this.myProgramParametersComponent);
        this.add((Component)this.myWorkingDirectoryComponent);
        this.add((Component)((Object)this.myEnvVariablesComponent));
    }

    protected boolean isMacroSupportEnabled() {
        return false;
    }

    protected void initMacroSupport() {
        CommonProgramParametersPanel.addMacroSupport((ExtendableTextField)((RawCommandLineEditor)this.myProgramParametersComponent.getComponent()).getEditorField(), MacrosDialog.Filters.ALL, this.getPathMacros());
        CommonProgramParametersPanel.addMacroSupport((ExtendableTextField)this.myWorkingDirectoryField.getTextField(), MacrosDialog.Filters.DIRECTORY_PATH, this.getPathMacros());
    }

    public static void addMacroSupport(@NotNull ExtendableTextField textField2) {
        if (textField2 == null) {
            CommonProgramParametersPanel.$$$reportNull$$$0(1);
        }
        CommonProgramParametersPanel.addMacroSupport(textField2, MacrosDialog.Filters.ALL, null);
    }

    protected static void addMacroSupport(@NotNull ExtendableTextField textField2, @NotNull Predicate<? super Macro> macroFilter, @Nullable Map<String, String> userMacros) {
        if (textField2 == null) {
            CommonProgramParametersPanel.$$$reportNull$$$0(2);
        }
        if (macroFilter == null) {
            CommonProgramParametersPanel.$$$reportNull$$$0(3);
        }
        if (Registry.is((String)"allow.macros.for.run.configurations")) {
            MacrosDialog.addTextFieldExtension(textField2, macroFilter.and(macro -> !(macro instanceof EditorMacro)), userMacros);
        }
    }

    @NotNull
    protected Map<String, String> getPathMacros() {
        HashMap<String, String> macros = new HashMap<String, String>(PathMacros.getInstance().getUserMacros());
        if (this.myModuleContext != null || this.myHasModuleMacro) {
            macros.put("MODULE_DIR", PathMacros.getInstance().getValue("MODULE_DIR"));
            macros.put("%MODULE_WORKING_DIR%", PathMacros.getInstance().getValue("MODULE_WORKING_DIR"));
        }
        HashMap<String, String> hashMap = macros;
        if (hashMap == null) {
            CommonProgramParametersPanel.$$$reportNull$$$0(4);
        }
        return hashMap;
    }

    protected void copyDialogCaption(LabeledComponent<RawCommandLineEditor> component2) {
        RawCommandLineEditor rawCommandLineEditor = (RawCommandLineEditor)component2.getComponent();
        rawCommandLineEditor.setDialogCaption(component2.getRawText());
        component2.getLabel().setLabelFor((Component)rawCommandLineEditor.getTextField());
    }

    public void setProgramParametersLabel(String textWithMnemonic) {
        this.myProgramParametersComponent.setText(textWithMnemonic);
        this.copyDialogCaption(this.myProgramParametersComponent);
    }

    public void setProgramParameters(String params) {
        ((RawCommandLineEditor)this.myProgramParametersComponent.getComponent()).setText(params);
    }

    public TextAccessor getWorkingDirectoryAccessor() {
        return this.myWorkingDirectoryField;
    }

    public void setWorkingDirectory(String dir) {
        this.myWorkingDirectoryField.setText(dir);
    }

    public void setModuleContext(Module moduleContext) {
        this.myModuleContext = moduleContext;
    }

    public void setHasModuleMacro() {
        this.myHasModuleMacro = true;
    }

    public LabeledComponent<RawCommandLineEditor> getProgramParametersComponent() {
        return this.myProgramParametersComponent;
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(JComponent anchor2) {
        this.myAnchor = anchor2;
        this.myProgramParametersComponent.setAnchor(anchor2);
        this.myWorkingDirectoryComponent.setAnchor(anchor2);
        this.myEnvVariablesComponent.setAnchor(anchor2);
    }

    public void applyTo(@NotNull CommonProgramRunConfigurationParameters configuration) {
        if (configuration == null) {
            CommonProgramParametersPanel.$$$reportNull$$$0(5);
        }
        configuration.setProgramParameters(this.fromTextField((TextAccessor)this.myProgramParametersComponent.getComponent(), configuration));
        configuration.setWorkingDirectory(this.fromTextField((TextAccessor)this.myWorkingDirectoryField, configuration));
        configuration.setEnvs(this.myEnvVariablesComponent.getEnvs());
        configuration.setPassParentEnvs(this.myEnvVariablesComponent.isPassParentEnvs());
    }

    @Nullable
    protected String fromTextField(@NotNull TextAccessor textAccessor, @NotNull CommonProgramRunConfigurationParameters configuration) {
        if (textAccessor == null) {
            CommonProgramParametersPanel.$$$reportNull$$$0(6);
        }
        if (configuration == null) {
            CommonProgramParametersPanel.$$$reportNull$$$0(7);
        }
        return textAccessor.getText();
    }

    public void reset(@NotNull CommonProgramRunConfigurationParameters configuration) {
        if (configuration == null) {
            CommonProgramParametersPanel.$$$reportNull$$$0(8);
        }
        this.setProgramParameters(configuration.getProgramParameters());
        this.setWorkingDirectory(PathUtil.toSystemDependentName((String)configuration.getWorkingDirectory()));
        this.myEnvVariablesComponent.setEnvs(configuration.getEnvs());
        this.myEnvVariablesComponent.setPassParentEnvs(configuration.isPassParentEnvs());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textAccessor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "macroFilter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/ui/CommonProgramParametersPanel";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/ui/CommonProgramParametersPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathMacros";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createComponentWithMacroBrowse";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addMacroSupport";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyTo";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fromTextField";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

