/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.impl.FTManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.velocity.runtime.parser.ParseException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileTemplateBase
implements FileTemplate {
    static final boolean DEFAULT_REFORMAT_CODE_VALUE = true;
    static final boolean DEFAULT_ENABLED_VALUE = true;
    @Nullable
    private String myText;
    private boolean myShouldReformatCode = true;
    private boolean myLiveTemplateEnabled;
    private boolean myLiveTemplateEnabledChanged;

    @Override
    public final boolean isReformatCode() {
        return this.myShouldReformatCode;
    }

    @Override
    public final void setReformatCode(boolean reformat) {
        this.myShouldReformatCode = reformat;
    }

    @NotNull
    public final String getQualifiedName() {
        return FileTemplateBase.getQualifiedName(this.getName(), this.getExtension());
    }

    @NotNull
    public static String getQualifiedName(@NotNull String name, @NotNull String extension) {
        if (name == null) {
            FileTemplateBase.$$$reportNull$$$0(0);
        }
        if (extension == null) {
            FileTemplateBase.$$$reportNull$$$0(1);
        }
        String string = FTManager.encodeFileName(name, extension);
        if (string == null) {
            FileTemplateBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public final String getText() {
        String text2 = this.myText;
        String string = text2 != null ? text2 : this.getDefaultText();
        if (string == null) {
            FileTemplateBase.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public final void setText(@Nullable String text2) {
        String converted;
        this.myText = text2 == null ? null : ((converted = StringUtil.convertLineSeparators((String)text2)).equals(this.getDefaultText()) ? null : StringUtil.internEmptyString((String)converted));
    }

    @NotNull
    protected String getDefaultText() {
        return "";
    }

    @Override
    @NotNull
    public final String getText(@NotNull Map attributes) throws IOException {
        if (attributes == null) {
            FileTemplateBase.$$$reportNull$$$0(4);
        }
        String string = FileTemplateUtil.mergeTemplate(attributes, this.getText(), false);
        if (string == null) {
            FileTemplateBase.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    public final String getText(@NotNull Properties attributes) throws IOException {
        if (attributes == null) {
            FileTemplateBase.$$$reportNull$$$0(6);
        }
        String string = FileTemplateUtil.mergeTemplate(attributes, this.getText(), false);
        if (string == null) {
            FileTemplateBase.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    public final String @NotNull [] getUnsetAttributes(@NotNull Properties properties, @NotNull Project project) throws ParseException {
        if (properties == null) {
            FileTemplateBase.$$$reportNull$$$0(8);
        }
        if (project == null) {
            FileTemplateBase.$$$reportNull$$$0(9);
        }
        String[] stringArray = FileTemplateUtil.calculateAttributes(this.getText(), properties, false, project);
        if (stringArray == null) {
            FileTemplateBase.$$$reportNull$$$0(10);
        }
        return stringArray;
    }

    @Override
    @NotNull
    public FileTemplateBase clone() {
        FileTemplateBase fileTemplateBase;
        try {
            fileTemplateBase = (FileTemplateBase)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        if (fileTemplateBase == null) {
            FileTemplateBase.$$$reportNull$$$0(11);
        }
        return fileTemplateBase;
    }

    @Override
    public boolean isTemplateOfType(@NotNull FileType fType) {
        if (fType == null) {
            FileTemplateBase.$$$reportNull$$$0(12);
        }
        return fType.equals(FileTypeManagerEx.getInstanceEx().getFileTypeByExtension(this.getExtension()));
    }

    @Override
    public boolean isLiveTemplateEnabled() {
        return this.myLiveTemplateEnabled;
    }

    @Override
    public void setLiveTemplateEnabled(boolean value2) {
        this.myLiveTemplateEnabledChanged |= this.myLiveTemplateEnabled != value2;
        this.myLiveTemplateEnabled = value2;
    }

    public boolean isLiveTemplateEnabledChanged() {
        return this.myLiveTemplateEnabledChanged;
    }

    public boolean isLiveTemplateEnabledByDefault() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/fileTemplates/impl/FileTemplateBase";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/fileTemplates/impl/FileTemplateBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnsetAttributes";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 11: {
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getUnsetAttributes";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isTemplateOfType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

