/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.script;

import com.intellij.ide.script.IdeScriptEngine;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IDE {
    public final Application application;
    public final Project project;
    private final Map<Object, Object> bindings;
    private final IdeScriptEngine myEngine;

    public IDE(@Nullable Project project, @NotNull IdeScriptEngine engine) {
        if (engine == null) {
            IDE.$$$reportNull$$$0(0);
        }
        this.application = ApplicationManager.getApplication();
        this.bindings = ContainerUtil.newConcurrentMap();
        this.project = project;
        this.myEngine = engine;
    }

    public void print(Object o) {
        IDE.print(this.myEngine.getStdOut(), o);
    }

    public void error(Object o) {
        IDE.print(this.myEngine.getStdErr(), o);
    }

    public Object put(Object key, Object value2) {
        return value2 == null ? this.bindings.remove(key) : this.bindings.put(key, value2);
    }

    public Object get(Object key) {
        return this.bindings.get(key);
    }

    private static void print(Writer writer, Object o) {
        try {
            writer.append(String.valueOf(o)).append("\n");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "engine", "com/intellij/ide/script/IDE", "<init>"));
    }
}

