/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeView;
import com.intellij.ide.util.DirectoryChooser;
import com.intellij.ide.util.DirectoryChooserModuleTreeView;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.refactoring.RefactoringBundle;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirectoryChooserUtil {
    private DirectoryChooserUtil() {
    }

    @Nullable
    public static PsiDirectory getOrChooseDirectory(@NotNull IdeView view) {
        PsiDirectory[] dirs;
        if (view == null) {
            DirectoryChooserUtil.$$$reportNull$$$0(0);
        }
        if ((dirs = view.getDirectories()).length == 0) {
            return null;
        }
        if (dirs.length == 1) {
            return dirs[0];
        }
        Project project = dirs[0].getProject();
        return DirectoryChooserUtil.selectDirectory(project, dirs, null, "");
    }

    @Nullable
    public static PsiDirectory selectDirectory(@NotNull Project project, PsiDirectory @NotNull [] packageDirectories, @Nullable PsiDirectory defaultDirectory, @Nullable String postfixToShow) {
        if (project == null) {
            DirectoryChooserUtil.$$$reportNull$$$0(1);
        }
        if (packageDirectories == null) {
            DirectoryChooserUtil.$$$reportNull$$$0(2);
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        ArrayList<PsiDirectory> possibleDirs = new ArrayList<PsiDirectory>();
        for (PsiDirectory dir : packageDirectories) {
            if (!dir.isValid() || !dir.isWritable() || possibleDirs.contains(dir) || !projectFileIndex.isInContent(dir.getVirtualFile())) continue;
            possibleDirs.add(dir);
        }
        if (possibleDirs.isEmpty()) {
            return null;
        }
        if (possibleDirs.size() == 1) {
            return (PsiDirectory)possibleDirs.get(0);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return (PsiDirectory)possibleDirs.get(0);
        }
        DirectoryChooser chooser = new DirectoryChooser(project);
        chooser.setTitle(IdeBundle.message((String)"title.choose.destination.directory", (Object[])new Object[0]));
        chooser.fillList(possibleDirs.toArray(PsiDirectory.EMPTY_ARRAY), defaultDirectory, project, postfixToShow);
        return chooser.showAndGet() ? chooser.getSelectedDirectory() : null;
    }

    @Nullable
    public static PsiDirectory chooseDirectory(PsiDirectory @NotNull [] targetDirectories, @Nullable PsiDirectory initialDirectory, @NotNull Project project, @Nullable Map<PsiDirectory, String> relativePathsToCreate) {
        if (project == null) {
            DirectoryChooserUtil.$$$reportNull$$$0(3);
        }
        if (targetDirectories == null) {
            DirectoryChooserUtil.$$$reportNull$$$0(4);
        }
        DirectoryChooser chooser = new DirectoryChooser(project, new DirectoryChooserModuleTreeView(project));
        chooser.setTitle(RefactoringBundle.message((String)"choose.destination.directory"));
        chooser.fillList(targetDirectories, initialDirectory, project, relativePathsToCreate);
        if (!chooser.showAndGet()) {
            return null;
        }
        return chooser.getSelectedDirectory();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageDirectories";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDirectories";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/util/DirectoryChooserUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getOrChooseDirectory";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "selectDirectory";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "chooseDirectory";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

