/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.ComponentWithExpandableItems;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TableCell;
import com.intellij.ui.TableUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiStateElementsChooser<T, S>
extends JPanel
implements ComponentWithEmptyText,
ComponentWithExpandableItems<TableCell> {
    private final MarkStateDescriptor<T, S> myMarkStateDescriptor;
    private final JBTable myTable;
    private final MyTableModel myTableModel;
    private boolean myColorUnmarkedElements = true;
    private final List<ElementsMarkStateListener<T, S>> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final Map<T, ElementProperties> myElementToPropertiesMap = new HashMap<T, ElementProperties>();
    private final Map<T, Boolean> myDisabledMap = new HashMap<T, Boolean>();
    private int[] mySavedSelection = null;

    public MultiStateElementsChooser(boolean elementsCanBeMarked, MarkStateDescriptor<T, S> markStateDescriptor) {
        this(null, null, elementsCanBeMarked, markStateDescriptor);
    }

    public MultiStateElementsChooser(List<T> elements2, S markState, MarkStateDescriptor<T, S> markStateDescriptor) {
        this(elements2, markState, true, markStateDescriptor);
    }

    private MultiStateElementsChooser(@Nullable List<T> elements2, S markState, boolean elementsCanBeMarked, MarkStateDescriptor<T, S> markStateDescriptor) {
        super(new BorderLayout());
        this.myMarkStateDescriptor = markStateDescriptor;
        this.myTableModel = new MyTableModel(elementsCanBeMarked);
        this.myTable = new JBTable((TableModel)this.myTableModel);
        this.myTable.setShowGrid(false);
        this.myTable.setIntercellSpacing((Dimension)JBUI.emptySize());
        this.myTable.setTableHeader(null);
        this.myTable.setAutoResizeMode(3);
        this.myTable.setColumnSelectionAllowed(false);
        this.myTable.resetDefaultFocusTraversalKeys();
        JScrollPane pane2 = ScrollPaneFactory.createScrollPane((Component)this.myTable);
        pane2.setPreferredSize((Dimension)JBUI.size((int)100, (int)155));
        TableColumnModel columnModel = this.myTable.getColumnModel();
        if (elementsCanBeMarked) {
            TableColumn checkMarkColumn = columnModel.getColumn(this.myTableModel.CHECK_MARK_COLUM_INDEX);
            TableUtil.setupCheckboxColumn((TableColumn)checkMarkColumn, (int)0);
            TableCellRenderer checkMarkRenderer = this.myMarkStateDescriptor.getMarkRenderer();
            if (checkMarkRenderer == null) {
                checkMarkRenderer = new CheckMarkColumnCellRenderer(this.myTable.getDefaultRenderer(Boolean.class));
            }
            checkMarkColumn.setCellRenderer(checkMarkRenderer);
        }
        columnModel.getColumn(this.myTableModel.ELEMENT_COLUMN_INDEX).setCellRenderer((TableCellRenderer)((Object)new MyElementColumnCellRenderer()));
        this.add((Component)pane2, "Center");
        this.myTable.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selectedRows = MultiStateElementsChooser.this.myTable.getSelectedRows();
                LinkedHashMap selectedElements = new LinkedHashMap(selectedRows.length);
                for (int selectedRow : selectedRows) {
                    selectedElements.put(MultiStateElementsChooser.this.myTableModel.getElementAt(selectedRow), MultiStateElementsChooser.this.myTableModel.getElementMarkState(selectedRow));
                }
                Object nextState = MultiStateElementsChooser.this.myMarkStateDescriptor.getNextState(selectedElements);
                if (nextState != null) {
                    MultiStateElementsChooser.this.myTableModel.setMarkState(selectedRows, nextState);
                }
            }
        }, KeyStroke.getKeyStroke(32, 0), 0);
        SpeedSearchBase<JBTable> speedSearch = new SpeedSearchBase<JBTable>(this.myTable){

            @Override
            public int getSelectedIndex() {
                return MultiStateElementsChooser.this.myTable.getSelectedRow();
            }

            @Override
            protected int convertIndexToModel(int viewIndex) {
                return MultiStateElementsChooser.this.myTable.convertRowIndexToModel(viewIndex);
            }

            @Override
            public Object @NotNull [] getAllElements() {
                int count = MultiStateElementsChooser.this.myTableModel.getRowCount();
                Object[] elements2 = new Object[count];
                for (int idx = 0; idx < count; ++idx) {
                    elements2[idx] = MultiStateElementsChooser.this.myTableModel.getElementAt(idx);
                }
                if (elements2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return elements2;
            }

            @Override
            public String getElementText(Object element2) {
                return MultiStateElementsChooser.this.getItemText(element2);
            }

            @Override
            public void selectElement(Object element2, String selectedText) {
                int count = MultiStateElementsChooser.this.myTableModel.getRowCount();
                for (int row = 0; row < count; ++row) {
                    if (!element2.equals(MultiStateElementsChooser.this.myTableModel.getElementAt(row))) continue;
                    int viewRow = MultiStateElementsChooser.this.myTable.convertRowIndexToView(row);
                    MultiStateElementsChooser.this.myTable.getSelectionModel().setSelectionInterval(viewRow, viewRow);
                    TableUtil.scrollSelectionToVisible((JTable)MultiStateElementsChooser.this.myTable);
                    break;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/MultiStateElementsChooser$2", "getAllElements"));
            }
        };
        speedSearch.setComparator(new SpeedSearchComparator(false));
        this.setElements(elements2, markState);
        MultiStateElementsChooser.installActions((JTable)this.myTable);
    }

    private static void installActions(JTable table) {
        InputMap inputMap = table.getInputMap(0);
        inputMap.put(KeyStroke.getKeyStroke(35, 0), "selectLastRow");
        inputMap.put(KeyStroke.getKeyStroke(36, 0), "selectFirstRow");
        inputMap.put(KeyStroke.getKeyStroke(36, 64), "selectFirstRowExtendSelection");
        inputMap.put(KeyStroke.getKeyStroke(35, 64), "selectLastRowExtendSelection");
    }

    @NotNull
    public StatusText getEmptyText() {
        StatusText statusText = this.myTable.getEmptyText();
        if (statusText == null) {
            MultiStateElementsChooser.$$$reportNull$$$0(0);
        }
        return statusText;
    }

    @NotNull
    public ExpandableItemsHandler<TableCell> getExpandableItemsHandler() {
        ExpandableItemsHandler expandableItemsHandler = this.myTable.getExpandableItemsHandler();
        if (expandableItemsHandler == null) {
            MultiStateElementsChooser.$$$reportNull$$$0(1);
        }
        return expandableItemsHandler;
    }

    public void setExpandableItemsEnabled(boolean enabled) {
        this.myTable.setExpandableItemsEnabled(enabled);
    }

    public void setSingleSelectionMode() {
        this.myTable.setSelectionMode(0);
    }

    public void refresh() {
        this.myTableModel.fireTableDataChanged();
    }

    public void refresh(T element2) {
        int row = this.myTableModel.getElementRow(element2);
        if (row >= 0) {
            this.myTableModel.fireTableRowsUpdated(row, row);
        }
    }

    public void saveSelection() {
        this.mySavedSelection = this.myTable.getSelectedRows();
    }

    public void restoreSelection() {
        if (this.mySavedSelection != null) {
            TableUtil.selectRows((JTable)this.myTable, (int[])this.mySavedSelection);
            this.mySavedSelection = null;
        }
    }

    public void setColorUnmarkedElements(boolean colorUnmarkedElements) {
        this.myColorUnmarkedElements = colorUnmarkedElements;
    }

    public void addElementsMarkListener(ElementsMarkStateListener<T, S> listener2) {
        this.myListeners.add(listener2);
    }

    public void removeElementsMarkListener(ElementsMarkStateListener<T, S> listener2) {
        this.myListeners.remove(listener2);
    }

    public void addListSelectionListener(ListSelectionListener listener2) {
        this.myTable.getSelectionModel().addListSelectionListener(listener2);
    }

    public void removeListSelectionListener(ListSelectionListener listener2) {
        this.myTable.getSelectionModel().removeListSelectionListener(listener2);
    }

    public void addElement(T element2, S markState) {
        this.addElement(element2, markState, element2 instanceof ElementProperties ? (ElementProperties)element2 : null);
    }

    public S getElementMarkState(T element2) {
        int elementRow = this.myTableModel.getElementRow(element2);
        return this.myTableModel.getElementMarkState(elementRow);
    }

    public void setElementMarkState(T element2, S markState) {
        int elementRow = this.myTableModel.getElementRow(element2);
        this.myTableModel.setMarkState(elementRow, markState);
    }

    public void removeElement(T element2) {
        int elementRow = this.myTableModel.getElementRow(element2);
        if (elementRow < 0) {
            return;
        }
        boolean wasSelected = this.myTable.getSelectionModel().isSelectedIndex(elementRow);
        this.myTableModel.removeElement(element2);
        this.myElementToPropertiesMap.remove(element2);
        if (wasSelected) {
            int rowCount = this.myTableModel.getRowCount();
            if (rowCount > 0) {
                this.selectRow(elementRow % rowCount);
            } else {
                this.myTable.getSelectionModel().clearSelection();
            }
        }
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myTable, true));
    }

    public void removeAllElements() {
        this.myTableModel.removeAllElements();
        this.myTable.getSelectionModel().clearSelection();
    }

    private void selectRow(int row) {
        this.myTable.getSelectionModel().setSelectionInterval(row, row);
        this.myTable.scrollRectToVisible(this.myTable.getCellRect(row, 0, true));
    }

    public void moveElement(T element2, int newRow) {
        int elementRow = this.myTableModel.getElementRow(element2);
        if (elementRow < 0 || elementRow == newRow || newRow < 0 || newRow >= this.myTableModel.getRowCount()) {
            return;
        }
        boolean wasSelected = this.myTable.getSelectionModel().isSelectedIndex(elementRow);
        this.myTableModel.changeElementRow(element2, newRow);
        if (wasSelected) {
            this.selectRow(newRow);
        }
    }

    public void addElement(T element2, S markState, ElementProperties elementProperties) {
        this.myTableModel.addElement(element2, markState);
        this.myElementToPropertiesMap.put(element2, elementProperties);
        this.selectRow(this.myTableModel.getRowCount() - 1);
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myTable, true));
    }

    public void setElementProperties(T element2, ElementProperties properties) {
        this.myElementToPropertiesMap.put(element2, properties);
    }

    public void setElements(List<? extends T> elements2, S markState) {
        this.myTableModel.clear();
        this.myTableModel.addElements(elements2, markState);
    }

    @Nullable
    public T getSelectedElement() {
        int selectedRow = this.getSelectedElementRow();
        return selectedRow < 0 ? null : (T)this.myTableModel.getElementAt(selectedRow);
    }

    public int getSelectedElementRow() {
        return this.myTable.getSelectedRow();
    }

    @NotNull
    public List<T> getSelectedElements() {
        int[] selectedRows;
        ArrayList elements2 = new ArrayList();
        for (int selectedRow : selectedRows = this.myTable.getSelectedRows()) {
            if (selectedRow < 0) continue;
            elements2.add(this.myTableModel.getElementAt(selectedRow));
        }
        ArrayList arrayList = elements2;
        if (arrayList == null) {
            MultiStateElementsChooser.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public void selectElements(Collection<? extends T> elements2) {
        if (elements2.isEmpty()) {
            this.myTable.clearSelection();
            return;
        }
        int[] rows = this.getElementsRows(elements2);
        TableUtil.selectRows((JTable)this.myTable, (int[])rows);
        TableUtil.scrollSelectionToVisible((JTable)this.myTable);
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myTable, true));
    }

    private int[] getElementsRows(Collection<? extends T> elements2) {
        int[] rows = new int[elements2.size()];
        int index = 0;
        for (T element2 : elements2) {
            rows[index++] = this.myTable.convertRowIndexToView(this.myTableModel.getElementRow(element2));
        }
        return rows;
    }

    public void markElements(Collection<? extends T> elements2, S markState) {
        this.myTableModel.setMarkState(this.getElementsRows(elements2), markState);
    }

    @NotNull
    public Map<T, S> getElementMarkStates() {
        int count = this.myTableModel.getRowCount();
        LinkedHashMap elements2 = new LinkedHashMap();
        for (int idx = 0; idx < count; ++idx) {
            Object element2 = this.myTableModel.getElementAt(idx);
            elements2.put(element2, this.myTableModel.getElementMarkState(idx));
        }
        LinkedHashMap linkedHashMap = elements2;
        if (linkedHashMap == null) {
            MultiStateElementsChooser.$$$reportNull$$$0(3);
        }
        return linkedHashMap;
    }

    public void sort(Comparator<? super T> comparator2) {
        this.myTableModel.sort(comparator2);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.myTable.setRowSelectionAllowed(enabled);
        this.myTableModel.fireTableDataChanged();
    }

    public void stopEditing() {
        TableCellEditor editor = this.myTable.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
    }

    public JComponent getComponent() {
        return this.myTable;
    }

    public void setAllElementsMarked(S markState) {
        int[] rows = new int[this.myTableModel.getRowCount()];
        for (int idx = 0; idx < rows.length; ++idx) {
            rows[idx] = idx;
        }
        this.myTableModel.setMarkState(rows, markState);
    }

    private void notifyElementMarked(T element2, S markState) {
        for (ElementsMarkStateListener<T, S> listener2 : this.myListeners) {
            listener2.elementMarkChanged(element2, markState);
        }
    }

    public void clear() {
        this.myTableModel.clear();
        this.myElementToPropertiesMap.clear();
    }

    public int getElementCount() {
        return this.myTableModel.getRowCount();
    }

    public T getElementAt(int row) {
        return this.myTableModel.getElementAt(row);
    }

    public void disableElement(T element2) {
        this.myDisabledMap.put(element2, Boolean.TRUE);
    }

    protected String getItemText(@NotNull T value2) {
        if (value2 == null) {
            MultiStateElementsChooser.$$$reportNull$$$0(4);
        }
        return value2.toString();
    }

    @Nullable
    protected Icon getItemIcon(@NotNull T value2) {
        if (value2 == null) {
            MultiStateElementsChooser.$$$reportNull$$$0(5);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/MultiStateElementsChooser";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptyText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpandableItemsHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedElements";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementMarkStates";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/MultiStateElementsChooser";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getItemText";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getItemIcon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CheckMarkColumnCellRenderer
    implements TableCellRenderer {
        private final TableCellRenderer myDelegate;

        CheckMarkColumnCellRenderer(TableCellRenderer delegate) {
            this.myDelegate = delegate;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component2 = this.myDelegate.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row, column);
            component2.setEnabled(MultiStateElementsChooser.this.isEnabled());
            if (component2 instanceof JComponent) {
                ((JComponent)component2).setBorder(null);
            }
            return component2;
        }
    }

    private class MyElementColumnCellRenderer
    extends ColoredTableCellRenderer {
        private MyElementColumnCellRenderer() {
        }

        protected void customizeCellRenderer(JTable table, @Nullable Object value2, boolean selected2, boolean hasFocus, int row, int column) {
            Icon icon2;
            String location2;
            Object item = value2;
            String text2 = item == null ? "" : MultiStateElementsChooser.this.getItemText(item);
            this.append(text2);
            ElementProperties properties = (ElementProperties)MultiStateElementsChooser.this.myElementToPropertiesMap.get(item);
            if (properties != null && StringUtil.isNotEmpty((String)(location2 = properties.getLocation()))) {
                this.append(" (" + location2 + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
            this.setTransparentIconBackground(true);
            Icon icon3 = properties != null ? properties.getIcon() : (icon2 = item != null ? MultiStateElementsChooser.this.getItemIcon(item) : null);
            if (icon2 != null) {
                this.setIcon(icon2);
            }
            this.setForeground(properties != null && properties.getColor() != null ? properties.getColor() : (selected2 ? table.getSelectionForeground() : table.getForeground()));
            MyTableModel model = (MyTableModel)table.getModel();
            this.setEnabled(selected2 || MultiStateElementsChooser.this.isEnabled() && (!MultiStateElementsChooser.this.myColorUnmarkedElements || MultiStateElementsChooser.this.myMarkStateDescriptor.isMarked(model.getElementMarkState(row))));
        }
    }

    private final class MyTableModel
    extends AbstractTableModel {
        private final List<T> myElements = new ArrayList();
        private final Map<T, S> myMarkedMap = new HashMap();
        public final int CHECK_MARK_COLUM_INDEX;
        public final int ELEMENT_COLUMN_INDEX;
        private final boolean myElementsCanBeMarked;

        MyTableModel(boolean elementsCanBeMarked) {
            this.myElementsCanBeMarked = elementsCanBeMarked;
            if (elementsCanBeMarked) {
                this.CHECK_MARK_COLUM_INDEX = 0;
                this.ELEMENT_COLUMN_INDEX = 1;
            } else {
                this.CHECK_MARK_COLUM_INDEX = -1;
                this.ELEMENT_COLUMN_INDEX = 0;
            }
        }

        public void sort(Comparator<? super T> comparator2) {
            Collections.sort(this.myElements, comparator2);
            this.fireTableDataChanged();
        }

        public T getElementAt(int index) {
            return this.myElements.get(index);
        }

        public S getElementMarkState(int index) {
            Object element2 = this.myElements.get(index);
            return this.myMarkedMap.get(element2);
        }

        private void addElement(T element2, S markState) {
            this.myElements.add(element2);
            this.myMarkedMap.put(element2, this.notNullMarkState(element2, markState));
            int row = this.myElements.size() - 1;
            this.fireTableRowsInserted(row, row);
        }

        private void addElements(@Nullable List<? extends T> elements2, S markState) {
            if (elements2 == null || elements2.isEmpty()) {
                return;
            }
            for (Object element2 : elements2) {
                this.myElements.add(element2);
                this.myMarkedMap.put(element2, this.notNullMarkState(element2, markState));
            }
            this.fireTableRowsInserted(this.myElements.size() - elements2.size(), this.myElements.size() - 1);
        }

        public void removeElement(T element2) {
            boolean reallyRemoved = this.myElements.remove(element2);
            if (reallyRemoved) {
                this.myMarkedMap.remove(element2);
                this.fireTableDataChanged();
            }
        }

        public void changeElementRow(T element2, int row) {
            boolean reallyRemoved = this.myElements.remove(element2);
            if (reallyRemoved) {
                this.myElements.add(row, element2);
                this.fireTableDataChanged();
            }
        }

        public int getElementRow(T element2) {
            return this.myElements.indexOf(element2);
        }

        public void removeAllElements() {
            this.myElements.clear();
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return this.myElements.size();
        }

        @Override
        public int getColumnCount() {
            return this.myElementsCanBeMarked ? 2 : 1;
        }

        @Override
        @Nullable
        public Object getValueAt(int rowIndex, int columnIndex) {
            Object element2 = this.myElements.get(rowIndex);
            if (columnIndex == this.ELEMENT_COLUMN_INDEX) {
                return element2;
            }
            if (columnIndex == this.CHECK_MARK_COLUM_INDEX) {
                return this.myMarkedMap.get(element2);
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == this.CHECK_MARK_COLUM_INDEX) {
                Object nextState = MultiStateElementsChooser.this.myMarkStateDescriptor.getMarkState(aValue);
                if (nextState == null) {
                    Object element2 = MultiStateElementsChooser.this.myTableModel.getElementAt(rowIndex);
                    Object currentState = MultiStateElementsChooser.this.myTableModel.getElementMarkState(rowIndex);
                    nextState = MultiStateElementsChooser.this.myMarkStateDescriptor.getNextState(element2, currentState);
                }
                this.setMarkState(rowIndex, nextState);
            }
        }

        private void setMarkState(int rowIndex, S markState) {
            Object element2 = this.myElements.get(rowIndex);
            Object newValue = this.notNullMarkState(element2, markState);
            Object prevValue = this.myMarkedMap.put(element2, newValue);
            this.fireTableRowsUpdated(rowIndex, rowIndex);
            if (!newValue.equals(prevValue)) {
                MultiStateElementsChooser.this.notifyElementMarked(element2, newValue);
            }
        }

        private void setMarkState(int[] rows, S markState) {
            if (rows == null || rows.length == 0) {
                return;
            }
            int firstRow = Integer.MAX_VALUE;
            int lastRow = Integer.MIN_VALUE;
            for (int row : rows) {
                Object prevValue;
                Object element2 = this.myElements.get(row);
                Object newValue = this.notNullMarkState(element2, markState);
                if (!newValue.equals(prevValue = this.myMarkedMap.put(element2, newValue))) {
                    MultiStateElementsChooser.this.notifyElementMarked(element2, newValue);
                }
                firstRow = Math.min(firstRow, row);
                lastRow = Math.max(lastRow, row);
            }
            this.fireTableRowsUpdated(firstRow, lastRow);
        }

        @NotNull
        private S notNullMarkState(T element2, S markState) {
            Object s = markState != null ? markState : MultiStateElementsChooser.this.myMarkStateDescriptor.getDefaultState(element2);
            if (s == null) {
                MyTableModel.$$$reportNull$$$0(0);
            }
            return s;
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == this.CHECK_MARK_COLUM_INDEX) {
                return Boolean.class;
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (!MultiStateElementsChooser.this.isEnabled() || columnIndex != this.CHECK_MARK_COLUM_INDEX) {
                return false;
            }
            Object o = this.getValueAt(rowIndex, this.ELEMENT_COLUMN_INDEX);
            return MultiStateElementsChooser.this.myDisabledMap.get(o) == null;
        }

        public void clear() {
            this.myElements.clear();
            this.myMarkedMap.clear();
            this.fireTableDataChanged();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/MultiStateElementsChooser$MyTableModel", "notNullMarkState"));
        }
    }

    public static interface ElementProperties {
        @Nullable
        default public Icon getIcon() {
            return null;
        }

        @Nullable
        default public Color getColor() {
            return null;
        }

        @Nullable
        default public String getLocation() {
            return null;
        }
    }

    public static interface MarkStateDescriptor<T, S> {
        @NotNull
        public S getDefaultState(@NotNull T var1);

        @NotNull
        public S getNextState(@NotNull T var1, @NotNull S var2);

        @Nullable
        public S getNextState(@NotNull Map<T, S> var1);

        public boolean isMarked(@NotNull S var1);

        @Nullable
        public S getMarkState(@Nullable Object var1);

        @Nullable
        public TableCellRenderer getMarkRenderer();
    }

    public static interface ElementsMarkStateListener<T, S> {
        public void elementMarkChanged(T var1, S var2);
    }
}

