/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.model.psi.impl;

import com.intellij.lang.Language;
import com.intellij.lang.MetaLanguage;
import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiSymbolReferenceProviderBean;
import com.intellij.model.psi.impl.LanguageReferenceProviders;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Service
@ApiStatus.Internal
public final class ReferenceProviders {
    private static final ExtensionPointName<PsiSymbolReferenceProviderBean> EP_NAME = new ExtensionPointName("com.intellij.psi.symbolReferenceProvider");
    private final Map<Language, LanguageReferenceProviders> myByHostLanguage = new ConcurrentHashMap<Language, LanguageReferenceProviders>();
    private final Map<Class<? extends Symbol>, List<PsiSymbolReferenceProviderBean>> myByTargetClass = new ConcurrentHashMap<Class<? extends Symbol>, List<PsiSymbolReferenceProviderBean>>();

    public ReferenceProviders() {
        EP_NAME.addExtensionPointListener(this::clearCaches, (Disposable)ApplicationManager.getApplication());
    }

    public void clearCaches() {
        this.myByHostLanguage.clear();
        this.myByTargetClass.clear();
    }

    @NotNull
    public static ReferenceProviders getInstance() {
        ReferenceProviders referenceProviders = (ReferenceProviders)ServiceManager.getService(ReferenceProviders.class);
        if (referenceProviders == null) {
            ReferenceProviders.$$$reportNull$$$0(0);
        }
        return referenceProviders;
    }

    @NotNull
    LanguageReferenceProviders byLanguage(@NotNull Language language) {
        if (language == null) {
            ReferenceProviders.$$$reportNull$$$0(1);
        }
        LanguageReferenceProviders languageReferenceProviders = this.myByHostLanguage.computeIfAbsent(language, ReferenceProviders::createLanguageProviders);
        if (languageReferenceProviders == null) {
            ReferenceProviders.$$$reportNull$$$0(2);
        }
        return languageReferenceProviders;
    }

    @NotNull
    private static LanguageReferenceProviders createLanguageProviders(@NotNull Language language) {
        if (language == null) {
            ReferenceProviders.$$$reportNull$$$0(3);
        }
        return new LanguageReferenceProviders(ReferenceProviders.byLanguageInner(language));
    }

    @NotNull
    private static List<PsiSymbolReferenceProviderBean> byLanguageInner(@NotNull Language language) {
        if (language == null) {
            ReferenceProviders.$$$reportNull$$$0(4);
        }
        ArrayList<PsiSymbolReferenceProviderBean> result2 = new ArrayList<PsiSymbolReferenceProviderBean>();
        for (PsiSymbolReferenceProviderBean bean : EP_NAME.getExtensionList()) {
            Language hostLanguage = bean.getHostLanguage();
            boolean matches = hostLanguage instanceof MetaLanguage ? ((MetaLanguage)hostLanguage).matchesLanguage(language) : language.isKindOf(hostLanguage);
            if (!matches) continue;
            result2.add(bean);
        }
        ArrayList<PsiSymbolReferenceProviderBean> arrayList = result2;
        if (arrayList == null) {
            ReferenceProviders.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    public List<PsiSymbolReferenceProviderBean> byTargetClass(@NotNull Class<? extends Symbol> targetClass) {
        if (targetClass == null) {
            ReferenceProviders.$$$reportNull$$$0(6);
        }
        List list2 = this.myByTargetClass.computeIfAbsent(targetClass, ReferenceProviders::byTargetClassInner);
        if (list2 == null) {
            ReferenceProviders.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @NotNull
    private static List<PsiSymbolReferenceProviderBean> byTargetClassInner(@NotNull Class<? extends Symbol> targetClass) {
        if (targetClass == null) {
            ReferenceProviders.$$$reportNull$$$0(8);
        }
        ArrayList<PsiSymbolReferenceProviderBean> result2 = new ArrayList<PsiSymbolReferenceProviderBean>();
        for (PsiSymbolReferenceProviderBean bean : EP_NAME.getExtensionList()) {
            if (!bean.getResolveTargetClass().isAssignableFrom(targetClass)) continue;
            result2.add(bean);
        }
        ArrayList<PsiSymbolReferenceProviderBean> arrayList = result2;
        if (arrayList == null) {
            ReferenceProviders.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/model/psi/impl/ReferenceProviders";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/model/psi/impl/ReferenceProviders";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "byLanguage";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "byLanguageInner";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "byTargetClass";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "byTargetClassInner";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "byLanguage";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createLanguageProviders";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "byLanguageInner";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "byTargetClass";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "byTargetClassInner";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

