/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.command.impl.DocumentUndoProvider;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.util.CompressionUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

final class EditorChangeAction
extends BasicUndoableAction {
    private final int myOffset;
    private final Object myOldString;
    private final Object myNewString;
    private final long myOldTimeStamp;
    private final long myNewTimeStamp;
    private final int myOldLength;
    private final int myNewLength;

    EditorChangeAction(@NotNull DocumentEvent e) {
        if (e == null) {
            EditorChangeAction.$$$reportNull$$$0(0);
        }
        this((DocumentImpl)e.getDocument(), e.getOffset(), e.getOldFragment(), e.getNewFragment(), e.getOldTimeStamp());
    }

    private EditorChangeAction(@NotNull DocumentImpl document, int offset, @NotNull CharSequence oldString, @NotNull CharSequence newString, long oldTimeStamp) {
        if (document == null) {
            EditorChangeAction.$$$reportNull$$$0(1);
        }
        if (oldString == null) {
            EditorChangeAction.$$$reportNull$$$0(2);
        }
        if (newString == null) {
            EditorChangeAction.$$$reportNull$$$0(3);
        }
        super(new Document[]{document});
        this.myOffset = offset;
        this.myOldString = CompressionUtil.compressStringRawBytes((CharSequence)oldString);
        this.myNewString = CompressionUtil.compressStringRawBytes((CharSequence)newString);
        this.myOldTimeStamp = oldTimeStamp;
        this.myNewTimeStamp = document.getModificationStamp();
        this.myNewLength = document.getTextLength();
        this.myOldLength = this.myNewLength - newString.length() + oldString.length();
    }

    public void undo() throws UnexpectedUndoException {
        this.doChange(this.myNewLength, this.myOldString, this.myOldLength, this.myOldTimeStamp);
    }

    public void redo() throws UnexpectedUndoException {
        this.doChange(this.myOldLength, this.myNewString, this.myNewLength, this.myNewTimeStamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doChange(int fromLength, Object to, int toLength, long toTimeStamp) throws UnexpectedUndoException {
        DocumentImpl document = (DocumentImpl)this.getAffectedDocuments()[0].getDocument();
        assert (document != null);
        if (document.getTextLength() != fromLength) {
            throw new UnexpectedUndoException("Unexpected document state");
        }
        DocumentUndoProvider.startDocumentUndo(document);
        try {
            CharSequence toString2 = CompressionUtil.uncompressStringRawBytes((Object)to);
            int fromStringLength = toString2.length() - toLength + fromLength;
            document.replaceString(this.myOffset, this.myOffset + fromStringLength, toString2, toTimeStamp, false);
        }
        finally {
            DocumentUndoProvider.finishDocumentUndo(document);
        }
    }

    @NonNls
    public String toString() {
        return "editor change: '" + this.myOldString + "' to '" + this.myNewString + "' at: " + this.myOffset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "e";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "document";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "oldString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "newString";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/command/impl/EditorChangeAction";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

