/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPermuteLinesHandler
extends EditorWriteActionHandler {
    protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        if (editor == null) {
            AbstractPermuteLinesHandler.$$$reportNull$$$0(0);
        }
        if (caret == null) {
            AbstractPermuteLinesHandler.$$$reportNull$$$0(1);
        }
        return AbstractPermuteLinesHandler.getTargetLineRange(caret) != null;
    }

    public void executeWriteAction(Editor editor, @Nullable Caret caret, DataContext dataContext) {
        if (caret == null) {
            caret = editor.getCaretModel().getPrimaryCaret();
        }
        Document document = editor.getDocument();
        Couple<Integer> lineRange = AbstractPermuteLinesHandler.getTargetLineRange(caret);
        if (lineRange == null) {
            return;
        }
        int startLine = (Integer)lineRange.first;
        int endLine = (Integer)lineRange.second;
        int lineCount = endLine - startLine + 1;
        CharSequence[] lines = new String[lineCount];
        for (int i = 0; i < lineCount; ++i) {
            int line = i + startLine;
            lines[i] = document.getText(new TextRange(document.getLineStartOffset(line), document.getLineEndOffset(line)));
        }
        boolean hasSelection = caret.hasSelection();
        CharSequence caretLineContent = null;
        int caretOffsetInLine = 0;
        if (!hasSelection) {
            int caretLine = caret.getLogicalPosition().line;
            caretLineContent = lines[caretLine - startLine];
            caretOffsetInLine = caret.getOffset() - document.getLineStartOffset(caretLine);
        }
        this.permute((String[])lines);
        String newContent = String.join((CharSequence)"\n", lines);
        int toReplaceStart = document.getLineStartOffset(startLine);
        int toReplaceEnd = document.getLineEndOffset(endLine);
        document.replaceString(toReplaceStart, toReplaceEnd, (CharSequence)newContent);
        if (hasSelection) {
            int selectionEnd = endLine < document.getLineCount() - 1 ? document.getLineStartOffset(endLine + 1) : document.getTextLength();
            caret.moveToOffset(selectionEnd);
            caret.setSelection(toReplaceStart, selectionEnd);
        } else {
            for (int i = 0; i < lineCount; ++i) {
                if (lines[i] != caretLineContent) continue;
                caret.moveToOffset(document.getLineStartOffset(startLine + i) + caretOffsetInLine);
                break;
            }
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
    }

    @Nullable
    private static Couple<Integer> getTargetLineRange(@NotNull Caret caret) {
        if (caret == null) {
            AbstractPermuteLinesHandler.$$$reportNull$$$0(2);
        }
        Document document = caret.getEditor().getDocument();
        int startOffset = caret.hasSelection() ? caret.getSelectionStart() : 0;
        int endOffset = caret.hasSelection() ? caret.getSelectionEnd() : document.getTextLength();
        int startLine = document.getLineNumber(startOffset);
        int endLine = document.getLineNumber(endOffset);
        if (endOffset == document.getLineStartOffset(endLine)) {
            --endLine;
        }
        return startLine < endLine ? Couple.of((Object)startLine, (Object)endLine) : null;
    }

    public abstract void permute(String @NotNull [] var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/actions/AbstractPermuteLinesHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledForCaret";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getTargetLineRange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

