/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionStub;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class EditorLastActionTracker {
    private String myLastActionId;
    private Editor myCurrentEditor;
    private Editor myLastEditor;

    @NotNull
    public static EditorLastActionTracker getInstance() {
        EditorLastActionTracker editorLastActionTracker = (EditorLastActionTracker)ServiceManager.getService(EditorLastActionTracker.class);
        if (editorLastActionTracker == null) {
            EditorLastActionTracker.$$$reportNull$$$0(0);
        }
        return editorLastActionTracker;
    }

    private static boolean is(Editor currentEditor, EditorImpl killedEditor) {
        return currentEditor == killedEditor || currentEditor instanceof EditorWindow && ((EditorWindow)currentEditor).getDelegate() == killedEditor;
    }

    @Nullable
    public String getLastActionId() {
        return this.myLastActionId;
    }

    private static String getActionId(AnAction action2) {
        return action2 instanceof ActionStub ? ((ActionStub)action2).getId() : ActionManager.getInstance().getId(action2);
    }

    private void doResetLastAction() {
        this.myLastActionId = null;
        this.myLastEditor = null;
    }

    @Nullable
    private static EditorLastActionTracker getTrackerIfCreated() {
        return (EditorLastActionTracker)ServiceManager.getServiceIfCreated(EditorLastActionTracker.class);
    }

    private static void resetLastAction() {
        EditorLastActionTracker tracker = EditorLastActionTracker.getTrackerIfCreated();
        if (tracker != null) {
            tracker.doResetLastAction();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorLastActionTracker", "getInstance"));
    }

    static final class MyEditorMouseListener
    implements EditorMouseListener {
        MyEditorMouseListener() {
        }

        public void mousePressed(@NotNull EditorMouseEvent e) {
            if (e == null) {
                MyEditorMouseListener.$$$reportNull$$$0(0);
            }
            EditorLastActionTracker.resetLastAction();
        }

        public void mouseClicked(@NotNull EditorMouseEvent e) {
            if (e == null) {
                MyEditorMouseListener.$$$reportNull$$$0(1);
            }
            EditorLastActionTracker.resetLastAction();
        }

        public void mouseReleased(@NotNull EditorMouseEvent e) {
            if (e == null) {
                MyEditorMouseListener.$$$reportNull$$$0(2);
            }
            EditorLastActionTracker.resetLastAction();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/editor/impl/EditorLastActionTracker$MyEditorMouseListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mousePressed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseClicked";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseReleased";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class MyAnActionListener
    implements AnActionListener {
        MyAnActionListener() {
        }

        public void beforeActionPerformed(@NotNull AnAction action2, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
            Editor editor;
            EditorLastActionTracker tracker;
            if (action2 == null) {
                MyAnActionListener.$$$reportNull$$$0(0);
            }
            if (dataContext == null) {
                MyAnActionListener.$$$reportNull$$$0(1);
            }
            if (event == null) {
                MyAnActionListener.$$$reportNull$$$0(2);
            }
            EditorLastActionTracker editorLastActionTracker = tracker = (editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext)) == null ? EditorLastActionTracker.getTrackerIfCreated() : EditorLastActionTracker.getInstance();
            if (tracker == null) {
                return;
            }
            tracker.myCurrentEditor = editor;
            if (tracker.myCurrentEditor != tracker.myLastEditor) {
                tracker.doResetLastAction();
            }
        }

        public void afterActionPerformed(@NotNull AnAction action2, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
            if (action2 == null) {
                MyAnActionListener.$$$reportNull$$$0(3);
            }
            if (dataContext == null) {
                MyAnActionListener.$$$reportNull$$$0(4);
            }
            if (event == null) {
                MyAnActionListener.$$$reportNull$$$0(5);
            }
            EditorLastActionTracker tracker = EditorLastActionTracker.getInstance();
            tracker.myLastActionId = EditorLastActionTracker.getActionId(action2);
            tracker.myLastEditor = tracker.myCurrentEditor;
            tracker.myCurrentEditor = null;
        }

        public void beforeEditorTyping(char c, @NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyAnActionListener.$$$reportNull$$$0(6);
            }
            EditorLastActionTracker.resetLastAction();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 1: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/impl/EditorLastActionTracker$MyAnActionListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeActionPerformed";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterActionPerformed";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeEditorTyping";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class MyEditorFactoryListener
    implements EditorFactoryListener {
        MyEditorFactoryListener() {
        }

        public void editorReleased(@NotNull EditorFactoryEvent event) {
            if (event == null) {
                MyEditorFactoryListener.$$$reportNull$$$0(0);
            }
            EditorLastActionTracker tracker = EditorLastActionTracker.getInstance();
            EditorImpl killedEditor = (EditorImpl)event.getEditor();
            if (EditorLastActionTracker.is(tracker.myCurrentEditor, killedEditor)) {
                tracker.myCurrentEditor = null;
            }
            if (EditorLastActionTracker.is(tracker.myLastEditor, killedEditor)) {
                tracker.myLastEditor = null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/editor/impl/EditorLastActionTracker$MyEditorFactoryListener", "editorReleased"));
        }
    }
}

