/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.execution.AbstractExternalSystemTaskConfigurationType;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.service.project.manage.TaskActivationState;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.task.TaskCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.task.ModuleBuildTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskManager;
import com.intellij.task.impl.ProjectTaskManagerImpl;
import com.intellij.task.impl.ProjectTaskManagerListener;
import com.intellij.task.impl.ProjectTaskScope;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class ExternalSystemTaskActivator {
    private static final Logger LOG = Logger.getInstance(ExternalSystemTaskActivator.class);
    public static final String RUN_CONFIGURATION_TASK_PREFIX = "run: ";
    @NotNull
    private final Project myProject;
    private final List<Listener> myListeners;

    public ExternalSystemTaskActivator(@NotNull Project project) {
        if (project == null) {
            ExternalSystemTaskActivator.$$$reportNull$$$0(0);
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myProject = project;
    }

    @NotNull
    public static String getRunConfigurationActivationTaskName(@NotNull RunnerAndConfigurationSettings settings) {
        if (settings == null) {
            ExternalSystemTaskActivator.$$$reportNull$$$0(1);
        }
        String string = RUN_CONFIGURATION_TASK_PREFIX + settings.getName();
        if (string == null) {
            ExternalSystemTaskActivator.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void init() {
        ProjectTaskManagerImpl projectTaskManager = (ProjectTaskManagerImpl)ProjectTaskManager.getInstance((Project)this.myProject);
        projectTaskManager.addListener(new ProjectTaskManagerListener(){

            @Override
            public void beforeRun(@NotNull ProjectTaskContext context) throws ExecutionException {
                if (context == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!ExternalSystemTaskActivator.this.doExecuteBuildPhaseTriggers(true, context)) {
                    throw new ExecutionException("Before build triggering task failed");
                }
            }

            @Override
            public void afterRun(@NotNull ProjectTaskManager.Result result2) throws ExecutionException {
                if (result2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!ExternalSystemTaskActivator.this.doExecuteBuildPhaseTriggers(false, result2.getContext())) {
                    throw new ExecutionException("After build triggering task failed");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "result";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/ExternalSystemTaskActivator$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeRun";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "afterRun";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.fireTasksChanged();
    }

    public String getDescription(ProjectSystemId systemId, String projectPath, String taskName) {
        ArrayList<String> result2 = new ArrayList<String>();
        ExternalProjectsManagerImpl.ExternalProjectsStateProvider stateProvider = ExternalProjectsManagerImpl.getInstance(this.myProject).getStateProvider();
        TaskActivationState taskActivationState = stateProvider.getTasksActivation(systemId, projectPath);
        if (taskActivationState == null) {
            return null;
        }
        for (Phase phase : Phase.values()) {
            if (!taskActivationState.getTasks(phase).contains(taskName)) continue;
            result2.add(phase.toString());
        }
        return StringUtil.join(result2, (String)", ");
    }

    private boolean doExecuteBuildPhaseTriggers(boolean myBefore, @NotNull ProjectTaskContext context) {
        ProjectTaskScope taskScope;
        if (context == null) {
            ExternalSystemTaskActivator.$$$reportNull$$$0(3);
        }
        if ((taskScope = (ProjectTaskScope)context.getUserData(ProjectTaskScope.KEY)) == null) {
            return true;
        }
        LinkedHashSet<String> modulesToBuild = new LinkedHashSet<String>();
        LinkedHashSet<String> modulesToRebuild = new LinkedHashSet<String>();
        for (ModuleBuildTask task2 : taskScope.getRequestedTasks(ModuleBuildTask.class)) {
            String projectPath = ExternalSystemApiUtil.getExternalProjectPath((Module)task2.getModule());
            if (projectPath == null) continue;
            if (task2.isIncrementalBuild()) {
                modulesToBuild.add(projectPath);
                continue;
            }
            modulesToRebuild.add(projectPath);
        }
        boolean result2 = true;
        if (myBefore) {
            if (!modulesToRebuild.isEmpty()) {
                result2 = this.runTasks(modulesToRebuild, Phase.BEFORE_REBUILD);
            }
            if (result2 && !modulesToBuild.isEmpty()) {
                result2 = this.runTasks(modulesToBuild, Phase.BEFORE_COMPILE);
            }
        } else {
            if (!modulesToRebuild.isEmpty()) {
                result2 = this.runTasks(modulesToRebuild, Phase.AFTER_REBUILD);
            }
            if (result2 && !modulesToBuild.isEmpty()) {
                result2 = this.runTasks(modulesToBuild, Phase.AFTER_COMPILE);
            }
        }
        return result2;
    }

    public boolean runTasks(@NotNull String modulePath, Phase ... phases) {
        if (modulePath == null) {
            ExternalSystemTaskActivator.$$$reportNull$$$0(4);
        }
        if (phases == null) {
            ExternalSystemTaskActivator.$$$reportNull$$$0(5);
        }
        return this.runTasks(Collections.singleton(modulePath), phases);
    }

    public boolean runTasks(@NotNull Collection<String> modules, Phase ... phases) {
        if (modules == null) {
            ExternalSystemTaskActivator.$$$reportNull$$$0(6);
        }
        if (phases == null) {
            ExternalSystemTaskActivator.$$$reportNull$$$0(7);
        }
        ExternalProjectsManagerImpl.ExternalProjectsStateProvider stateProvider = ExternalProjectsManagerImpl.getInstance(this.myProject).getStateProvider();
        LinkedList<Pair<ProjectSystemId, ExternalSystemTaskExecutionSettings>> tasksQueue = new LinkedList<Pair<ProjectSystemId, ExternalSystemTaskExecutionSettings>>();
        Map lazyConfigurationsMap = FactoryMap.create(key -> {
            AbstractExternalSystemTaskConfigurationType configurationType = ExternalSystemUtil.findConfigurationType(key);
            if (configurationType == null) {
                return null;
            }
            return ContainerUtil.map2Map((Collection)RunManager.getInstance((Project)this.myProject).getConfigurationSettingsList((ConfigurationType)configurationType), configurationSettings1 -> Pair.create((Object)configurationSettings1.getName(), (Object)configurationSettings1));
        });
        for (ExternalProjectsManagerImpl.ExternalProjectsStateProvider.TasksActivation activation : stateProvider.getAllTasksActivation()) {
            boolean hashPath = modules.contains(activation.projectPath);
            LinkedHashSet<String> tasks = new LinkedHashSet<String>();
            for (Phase phase : phases) {
                List<String> activationTasks = activation.state.getTasks(phase);
                if (!hashPath && (!phase.isSyncPhase() || activationTasks.isEmpty() || !this.isShareSameRootPath(modules, activation))) continue;
                tasks.addAll(activationTasks);
            }
            if (tasks.isEmpty()) continue;
            Iterator iterator2 = tasks.iterator();
            while (iterator2.hasNext()) {
                RunnerAndConfigurationSettings configurationSettings;
                String task2 = (String)iterator2.next();
                if (task2.length() <= RUN_CONFIGURATION_TASK_PREFIX.length() || !task2.startsWith(RUN_CONFIGURATION_TASK_PREFIX)) continue;
                iterator2.remove();
                String configurationName = task2.substring(RUN_CONFIGURATION_TASK_PREFIX.length());
                Map settings = (Map)lazyConfigurationsMap.get(activation.systemId);
                if (settings == null || (configurationSettings = (RunnerAndConfigurationSettings)settings.get(configurationName)) == null) continue;
                RunConfiguration runConfiguration = configurationSettings.getConfiguration();
                if (!configurationName.equals(configurationSettings.getName()) || !(runConfiguration instanceof ExternalSystemRunConfiguration)) continue;
                tasksQueue.add((Pair<ProjectSystemId, ExternalSystemTaskExecutionSettings>)Pair.create((Object)activation.systemId, (Object)((ExternalSystemRunConfiguration)runConfiguration).getSettings()));
            }
            if (tasks.isEmpty() || ExternalProjectsManager.getInstance((Project)this.myProject).isIgnored(activation.systemId, activation.projectPath)) continue;
            ExternalSystemTaskExecutionSettings executionSettings = new ExternalSystemTaskExecutionSettings();
            executionSettings.setExternalSystemIdString(activation.systemId.toString());
            executionSettings.setExternalProjectPath(activation.projectPath);
            executionSettings.getTaskNames().addAll(tasks);
            tasksQueue.add((Pair<ProjectSystemId, ExternalSystemTaskExecutionSettings>)Pair.create((Object)activation.systemId, (Object)executionSettings));
        }
        return this.runTasksQueue(tasksQueue);
    }

    private boolean isShareSameRootPath(@NotNull Collection<String> modules, @NotNull ExternalProjectsManagerImpl.ExternalProjectsStateProvider.TasksActivation activation) {
        if (modules == null) {
            ExternalSystemTaskActivator.$$$reportNull$$$0(8);
        }
        if (activation == null) {
            ExternalSystemTaskActivator.$$$reportNull$$$0(9);
        }
        AbstractExternalSystemSettings systemSettings = ExternalSystemApiUtil.getSettings((Project)this.myProject, (ProjectSystemId)activation.systemId);
        String rootProjectPath = ExternalSystemTaskActivator.getRootProjectPath(systemSettings, activation.projectPath);
        List rootPath = ContainerUtil.mapNotNull(modules, path -> ExternalSystemTaskActivator.getRootProjectPath(systemSettings, path));
        return rootPath.contains(rootProjectPath);
    }

    @Nullable
    private static String getRootProjectPath(@NotNull AbstractExternalSystemSettings systemSettings, @NotNull String projectPath) {
        ExternalProjectSettings projectSettings;
        if (systemSettings == null) {
            ExternalSystemTaskActivator.$$$reportNull$$$0(10);
        }
        if (projectPath == null) {
            ExternalSystemTaskActivator.$$$reportNull$$$0(11);
        }
        return (projectSettings = systemSettings.getLinkedProjectSettings(projectPath)) != null ? projectSettings.getExternalProjectPath() : null;
    }

    private boolean runTasksQueue(final Queue<Pair<ProjectSystemId, ExternalSystemTaskExecutionSettings>> tasksQueue) {
        Pair<ProjectSystemId, ExternalSystemTaskExecutionSettings> pair = tasksQueue.poll();
        if (pair == null) {
            return true;
        }
        ProjectSystemId systemId = (ProjectSystemId)pair.first;
        ExternalSystemTaskExecutionSettings executionSettings = (ExternalSystemTaskExecutionSettings)pair.getSecond();
        final Semaphore targetDone = new Semaphore();
        targetDone.down();
        final Ref result2 = new Ref((Object)false);
        ExternalSystemUtil.runTask(executionSettings, "Run", this.myProject, systemId, new TaskCallback(){

            public void onSuccess() {
                result2.set((Object)ExternalSystemTaskActivator.this.runTasksQueue(tasksQueue));
                targetDone.up();
            }

            public void onFailure() {
                targetDone.up();
            }
        }, ProgressExecutionMode.IN_BACKGROUND_ASYNC, false);
        targetDone.waitFor();
        return (Boolean)result2.get();
    }

    public void addListener(@NotNull Listener l) {
        if (l == null) {
            ExternalSystemTaskActivator.$$$reportNull$$$0(12);
        }
        this.myListeners.add(l);
    }

    public boolean isTaskOfPhase(@NotNull TaskData taskData, @NotNull Phase phase) {
        ExternalProjectsManagerImpl.ExternalProjectsStateProvider stateProvider;
        TaskActivationState taskActivationState;
        if (taskData == null) {
            ExternalSystemTaskActivator.$$$reportNull$$$0(13);
        }
        if (phase == null) {
            ExternalSystemTaskActivator.$$$reportNull$$$0(14);
        }
        if ((taskActivationState = (stateProvider = ExternalProjectsManagerImpl.getInstance(this.myProject).getStateProvider()).getTasksActivation(taskData.getOwner(), taskData.getLinkedExternalProjectPath())) == null) {
            return false;
        }
        return taskActivationState.getTasks(phase).contains(taskData.getName());
    }

    public void addTasks(@NotNull Collection<? extends TaskData> tasks, @NotNull Phase phase) {
        if (tasks == null) {
            ExternalSystemTaskActivator.$$$reportNull$$$0(15);
        }
        if (phase == null) {
            ExternalSystemTaskActivator.$$$reportNull$$$0(16);
        }
        if (tasks.isEmpty()) {
            return;
        }
        this.addTasks(ContainerUtil.map(tasks, data2 -> new TaskActivationEntry(data2.getOwner(), phase, data2.getLinkedExternalProjectPath(), data2.getName())));
        this.fireTasksChanged();
    }

    public void addTasks(@NotNull Collection<? extends TaskActivationEntry> entries) {
        if (entries == null) {
            ExternalSystemTaskActivator.$$$reportNull$$$0(17);
        }
        if (entries.isEmpty()) {
            return;
        }
        ExternalProjectsManagerImpl.ExternalProjectsStateProvider stateProvider = ExternalProjectsManagerImpl.getInstance(this.myProject).getStateProvider();
        for (TaskActivationEntry taskActivationEntry : entries) {
            TaskActivationState taskActivationState = stateProvider.getTasksActivation(taskActivationEntry.systemId, taskActivationEntry.projectPath);
            taskActivationState.getTasks(taskActivationEntry.phase).add(taskActivationEntry.taskName);
        }
        this.fireTasksChanged();
    }

    public void removeTasks(@NotNull Collection<? extends TaskData> tasks, @NotNull Phase phase) {
        if (tasks == null) {
            ExternalSystemTaskActivator.$$$reportNull$$$0(18);
        }
        if (phase == null) {
            ExternalSystemTaskActivator.$$$reportNull$$$0(19);
        }
        if (tasks.isEmpty()) {
            return;
        }
        this.removeTasks(ContainerUtil.map(tasks, data2 -> new TaskActivationEntry(data2.getOwner(), phase, data2.getLinkedExternalProjectPath(), data2.getName())));
    }

    public void removeTasks(@NotNull Collection<? extends TaskActivationEntry> entries) {
        if (entries == null) {
            ExternalSystemTaskActivator.$$$reportNull$$$0(20);
        }
        if (entries.isEmpty()) {
            return;
        }
        ExternalProjectsManagerImpl.ExternalProjectsStateProvider stateProvider = ExternalProjectsManagerImpl.getInstance(this.myProject).getStateProvider();
        for (TaskActivationEntry taskActivationEntry : entries) {
            TaskActivationState taskActivationState = stateProvider.getTasksActivation(taskActivationEntry.systemId, taskActivationEntry.projectPath);
            taskActivationState.getTasks(taskActivationEntry.phase).remove(taskActivationEntry.taskName);
        }
        this.fireTasksChanged();
    }

    public void addTask(@NotNull TaskActivationEntry entry) {
        if (entry == null) {
            ExternalSystemTaskActivator.$$$reportNull$$$0(21);
        }
        this.addTasks(Collections.singleton(entry));
    }

    public void removeTask(@NotNull TaskActivationEntry entry) {
        if (entry == null) {
            ExternalSystemTaskActivator.$$$reportNull$$$0(22);
        }
        this.removeTasks(Collections.singleton(entry));
    }

    public void moveTasks(@NotNull Collection<? extends TaskActivationEntry> entries, int increment) {
        if (entries == null) {
            ExternalSystemTaskActivator.$$$reportNull$$$0(23);
        }
        LOG.assertTrue(increment == -1 || increment == 1);
        ExternalProjectsManagerImpl.ExternalProjectsStateProvider stateProvider = ExternalProjectsManagerImpl.getInstance(this.myProject).getStateProvider();
        for (TaskActivationEntry taskActivationEntry : entries) {
            TaskActivationState taskActivationState = stateProvider.getTasksActivation(taskActivationEntry.systemId, taskActivationEntry.projectPath);
            List<String> tasks = taskActivationState.getTasks(taskActivationEntry.phase);
            int i1 = tasks.indexOf(taskActivationEntry.taskName);
            int i2 = i1 + increment;
            if (i1 == -1 || tasks.size() <= i2 || i2 < 0) continue;
            Collections.swap(tasks, i1, i2);
        }
    }

    public void moveProjects(@NotNull ProjectSystemId systemId, @NotNull List<String> projectsPathsToMove, @Nullable Collection<String> pathsGroup, int increment) {
        if (systemId == null) {
            ExternalSystemTaskActivator.$$$reportNull$$$0(24);
        }
        if (projectsPathsToMove == null) {
            ExternalSystemTaskActivator.$$$reportNull$$$0(25);
        }
        LOG.assertTrue(increment == -1 || increment == 1);
        ExternalProjectsManagerImpl.ExternalProjectsStateProvider stateProvider = ExternalProjectsManagerImpl.getInstance(this.myProject).getStateProvider();
        Map<String, TaskActivationState> activationMap = stateProvider.getProjectsTasksActivationMap(systemId);
        ArrayList<String> currentPaths = new ArrayList<String>(activationMap.keySet());
        if (pathsGroup != null) {
            currentPaths.retainAll(pathsGroup);
        }
        for (String path : projectsPathsToMove) {
            int i1 = currentPaths.indexOf(path);
            int i2 = i1 + increment;
            if (i1 == -1 || currentPaths.size() <= i2 || i2 < 0) continue;
            Collections.swap(currentPaths, i1, i2);
        }
        LinkedHashMap<String, TaskActivationState> rearrangedMap = new LinkedHashMap<String, TaskActivationState>();
        for (String path : currentPaths) {
            rearrangedMap.put(path, activationMap.get(path));
            activationMap.remove(path);
        }
        activationMap.putAll(rearrangedMap);
    }

    public void fireTasksChanged() {
        for (Listener each : this.myListeners) {
            each.tasksActivationChanged();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/manage/ExternalSystemTaskActivator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulePath";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phases";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activation";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemSettings";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskData";
                break;
            }
            case 14: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phase";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 17: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemId";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectsPathsToMove";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/ExternalSystemTaskActivator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunConfigurationActivationTaskName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRunConfigurationActivationTaskName";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doExecuteBuildPhaseTriggers";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "runTasks";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isShareSameRootPath";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getRootProjectPath";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isTaskOfPhase";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addTasks";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "removeTasks";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addTask";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "removeTask";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "moveTasks";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "moveProjects";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TaskActivationEntry {
        @NotNull
        private final ProjectSystemId systemId;
        @NotNull
        private final Phase phase;
        @NotNull
        private final String projectPath;
        @NotNull
        private final String taskName;

        public TaskActivationEntry(@NotNull ProjectSystemId systemId, @NotNull Phase phase, @NotNull String projectPath, @NotNull String taskName) {
            if (systemId == null) {
                TaskActivationEntry.$$$reportNull$$$0(0);
            }
            if (phase == null) {
                TaskActivationEntry.$$$reportNull$$$0(1);
            }
            if (projectPath == null) {
                TaskActivationEntry.$$$reportNull$$$0(2);
            }
            if (taskName == null) {
                TaskActivationEntry.$$$reportNull$$$0(3);
            }
            this.systemId = systemId;
            this.phase = phase;
            this.projectPath = projectPath;
            this.taskName = taskName;
        }

        @NotNull
        public ProjectSystemId getSystemId() {
            ProjectSystemId projectSystemId = this.systemId;
            if (projectSystemId == null) {
                TaskActivationEntry.$$$reportNull$$$0(4);
            }
            return projectSystemId;
        }

        @NotNull
        public Phase getPhase() {
            Phase phase = this.phase;
            if (phase == null) {
                TaskActivationEntry.$$$reportNull$$$0(5);
            }
            return phase;
        }

        @NotNull
        public String getProjectPath() {
            String string = this.projectPath;
            if (string == null) {
                TaskActivationEntry.$$$reportNull$$$0(6);
            }
            return string;
        }

        @NotNull
        public String getTaskName() {
            String string = this.taskName;
            if (string == null) {
                TaskActivationEntry.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "systemId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "phase";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectPath";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "taskName";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/manage/ExternalSystemTaskActivator$TaskActivationEntry";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/ExternalSystemTaskActivator$TaskActivationEntry";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSystemId";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPhase";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProjectPath";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTaskName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface Listener {
        public void tasksActivationChanged();
    }

    public static enum Phase {
        BEFORE_RUN("external.system.task.before.run"),
        BEFORE_SYNC("external.system.task.before.sync"),
        AFTER_SYNC("external.system.task.after.sync"),
        BEFORE_COMPILE("external.system.task.before.compile"),
        AFTER_COMPILE("external.system.task.after.compile"),
        BEFORE_REBUILD("external.system.task.before.rebuild"),
        AFTER_REBUILD("external.system.task.after.rebuild");

        @PropertyKey(resourceBundle="messages.ExternalSystemBundle")
        public final String myMessageKey;

        private Phase(String messageKey) {
            this.myMessageKey = messageKey;
        }

        public boolean isSyncPhase() {
            return this == BEFORE_SYNC || this == AFTER_SYNC;
        }

        public String toString() {
            return ExternalSystemBundle.message((String)this.myMessageKey, (Object[])new Object[0]);
        }
    }
}

