/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.TextEditorBackgroundHighlighter;
import com.intellij.codeInsight.daemon.impl.focusMode.FocusModePassFactory;
import com.intellij.codeInsight.documentation.render.DocRenderPassFactory;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.fileEditor.impl.text.CodeFoldingState;
import com.intellij.openapi.fileEditor.impl.text.TextEditorComponent;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiAwareTextEditorImpl
extends TextEditorImpl {
    private TextEditorBackgroundHighlighter myBackgroundHighlighter;

    public PsiAwareTextEditorImpl(@NotNull Project project, @NotNull VirtualFile file2, TextEditorProvider provider) {
        if (project == null) {
            PsiAwareTextEditorImpl.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            PsiAwareTextEditorImpl.$$$reportNull$$$0(1);
        }
        super(project, file2, provider);
    }

    @Override
    @NotNull
    protected Runnable loadEditorInBackground() {
        Runnable baseResult = super.loadEditorInBackground();
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(this.myFile);
        Document document = FileDocumentManager.getInstance().getDocument(this.myFile);
        boolean shouldBuildInitialFoldings = document != null && !this.myProject.isDefault() && PsiDocumentManager.getInstance((Project)this.myProject).isCommitted(document);
        CodeFoldingState foldingState = shouldBuildInitialFoldings ? CodeFoldingManager.getInstance(this.myProject).buildInitialFoldings(document) : null;
        List<? extends Segment> focusZones = FocusModePassFactory.calcFocusZones(psiFile);
        PsiAwareTextEditorImpl.migrateDocRenderSettingIfNeeded();
        DocRenderPassFactory.Items items = document != null && psiFile != null && EditorSettingsExternalizable.getInstance().isDocCommentRenderingEnabled() ? DocRenderPassFactory.calculateItemsToRender(document, psiFile) : null;
        Runnable runnable2 = () -> {
            baseResult.run();
            Editor editor = this.getEditor();
            if (foldingState != null) {
                foldingState.setToEditor(editor);
            }
            if (focusZones != null) {
                FocusModePassFactory.setToEditor(focusZones, editor);
                if (editor instanceof EditorImpl) {
                    ((EditorImpl)editor).applyFocusMode();
                }
            }
            if (items != null) {
                DocRenderPassFactory.applyItemsToRender(editor, this.myProject, items, true);
            }
            if (psiFile != null && psiFile.isValid()) {
                DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart(psiFile);
            }
        };
        if (runnable2 == null) {
            PsiAwareTextEditorImpl.$$$reportNull$$$0(2);
        }
        return runnable2;
    }

    private static void migrateDocRenderSettingIfNeeded() {
        RegistryValue value2 = Registry.get((String)"editor.render.doc.comments");
        if (value2.asBoolean()) {
            value2.setValue(false);
            EditorSettingsExternalizable.getInstance().setDocCommentRenderingEnabled(true);
        }
    }

    @Override
    @NotNull
    protected TextEditorComponent createEditorComponent(Project project, VirtualFile file2) {
        return new PsiAwareTextEditorComponent(project, file2, this);
    }

    @Override
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        if (!AsyncEditorLoader.isEditorLoaded(this.getEditor())) {
            return null;
        }
        if (this.myBackgroundHighlighter == null) {
            this.myBackgroundHighlighter = new TextEditorBackgroundHighlighter(this.myProject, this.getEditor());
        }
        return this.myBackgroundHighlighter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "loadEditorInBackground";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PsiAwareTextEditorComponent
    extends TextEditorComponent {
        private final Project myProject;
        private final VirtualFile myFile;

        private PsiAwareTextEditorComponent(@NotNull Project project, @NotNull VirtualFile file2, @NotNull TextEditorImpl textEditor) {
            if (project == null) {
                PsiAwareTextEditorComponent.$$$reportNull$$$0(0);
            }
            if (file2 == null) {
                PsiAwareTextEditorComponent.$$$reportNull$$$0(1);
            }
            if (textEditor == null) {
                PsiAwareTextEditorComponent.$$$reportNull$$$0(2);
            }
            super(project, file2, textEditor);
            this.myProject = project;
            this.myFile = file2;
        }

        @Override
        public void dispose() {
            super.dispose();
            CodeFoldingManager foldingManager = (CodeFoldingManager)this.myProject.getServiceIfCreated(CodeFoldingManager.class);
            if (foldingManager != null) {
                foldingManager.releaseFoldings(this.getEditor());
            }
        }

        @Override
        @Nullable
        public DataProvider createBackgroundDataProvider() {
            DataProvider superProvider = super.createBackgroundDataProvider();
            if (superProvider == null) {
                return null;
            }
            return dataId -> {
                LookupImpl lookup2;
                if (PlatformDataKeys.DOMINANT_HINT_AREA_RECTANGLE.is(dataId) && (lookup2 = (LookupImpl)LookupManager.getInstance(this.myProject).getActiveLookup()) != null && lookup2.isVisible()) {
                    return lookup2.getBounds();
                }
                if (LangDataKeys.MODULE.is(dataId)) {
                    return ModuleUtilCore.findModuleForFile((VirtualFile)this.myFile, (Project)this.myProject);
                }
                return superProvider.getData(dataId);
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "textEditor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/fileEditor/impl/text/PsiAwareTextEditorImpl$PsiAwareTextEditorComponent";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

