/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.comparison.iterables.DiffIterable;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.openapi.vcs.ex.BlocksRefresher;
import com.intellij.openapi.vcs.ex.BulkRangeChangeHandler;
import com.intellij.openapi.vcs.ex.DocumentTracker;
import com.intellij.openapi.vcs.ex.DocumentTrackerKt;
import com.intellij.openapi.vcs.ex.RangeChangeHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0010\u001a\u00020\u0011J(\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r0\u0016J&\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0019J\u0016\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001eJ.\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020\rJ\u001c\u0010'\u001a\u00020\u00112\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010)\u001a\u00020\rR*\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006*"}, d2={"Lcom/intellij/openapi/vcs/ex/LineTracker;", "", "handler", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Handler;", "originalChanges", "", "Lcom/intellij/diff/util/Range;", "(Lcom/intellij/openapi/vcs/ex/DocumentTracker$Handler;Ljava/util/List;)V", "<set-?>", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "blocks", "getBlocks", "()Ljava/util/List;", "", "isDirty", "()Z", "destroy", "", "partiallyApplyBlocks", "side", "Lcom/intellij/diff/util/Side;", "condition", "Lkotlin/Function1;", "rangeChanged", "startLine", "", "beforeLength", "afterLength", "rangesChanged", "iterable", "Lcom/intellij/diff/comparison/iterables/DiffIterable;", "refreshDirty", "text1", "", "text2", "lineOffsets1", "Lcom/intellij/diff/tools/util/text/LineOffsets;", "lineOffsets2", "fastRefresh", "setRanges", "ranges", "dirty", "intellij.platform.diff.impl"})
final class LineTracker {
    @NotNull
    private List<DocumentTracker.Block> blocks;
    private boolean isDirty;
    private final DocumentTracker.Handler handler;

    @NotNull
    public final List<DocumentTracker.Block> getBlocks() {
        return this.blocks;
    }

    public final boolean isDirty() {
        return this.isDirty;
    }

    /*
     * WARNING - void declaration
     */
    public final void setRanges(@NotNull List<? extends Range> ranges, boolean dirty) {
        Collection<DocumentTracker.Block> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull(ranges, (String)"ranges");
        Iterable iterable = ranges;
        LineTracker lineTracker = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Range range2 = (Range)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            DocumentTracker.Block block = new DocumentTracker.Block((Range)it, dirty, false);
            collection.add(block);
        }
        collection = (List)destination$iv$iv;
        lineTracker.blocks = collection;
        this.isDirty = dirty;
        this.handler.afterBulkRangeChange();
    }

    public final void destroy() {
        this.blocks = CollectionsKt.emptyList();
    }

    public final void refreshDirty(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, boolean fastRefresh) {
        Intrinsics.checkParameterIsNotNull((Object)text1, (String)"text1");
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text2");
        Intrinsics.checkParameterIsNotNull((Object)lineOffsets1, (String)"lineOffsets1");
        Intrinsics.checkParameterIsNotNull((Object)lineOffsets2, (String)"lineOffsets2");
        if (!this.isDirty) {
            return;
        }
        BlocksRefresher.Result result2 = new BlocksRefresher(this.handler, text1, text2, lineOffsets1, lineOffsets2).refresh(this.blocks, fastRefresh);
        this.blocks = result2.getNewBlocks();
        this.isDirty = false;
        this.handler.afterBulkRangeChange();
    }

    /*
     * WARNING - void declaration
     */
    public final void rangeChanged(@NotNull Side side, int startLine, int beforeLength, int afterLength) {
        Intrinsics.checkParameterIsNotNull((Object)side, (String)"side");
        RangeChangeHandler.Result data2 = new RangeChangeHandler().run(this.blocks, side, startLine, beforeLength, afterLength);
        this.handler.onRangesChanged(data2.getAffectedBlocks(), data2.getNewAffectedBlock());
        int n = 0;
        int n2 = ((Collection)data2.getAfterBlocks()).size();
        while (n < n2) {
            void i;
            this.handler.onRangeShifted(data2.getAfterBlocks().get((int)i), data2.getNewAfterBlocks().get((int)i));
            ++i;
        }
        this.blocks = data2.getNewBlocks();
        this.isDirty = true;
        this.handler.afterRangeChange();
    }

    public final void rangesChanged(@NotNull Side side, @NotNull DiffIterable iterable) {
        Intrinsics.checkParameterIsNotNull((Object)side, (String)"side");
        Intrinsics.checkParameterIsNotNull((Object)iterable, (String)"iterable");
        List<DocumentTracker.Block> newBlocks = new BulkRangeChangeHandler(this.handler, this.blocks, side).run(iterable);
        this.blocks = newBlocks;
        this.isDirty = true;
        this.handler.afterBulkRangeChange();
    }

    @NotNull
    public final List<DocumentTracker.Block> partiallyApplyBlocks(@NotNull Side side, @NotNull Function1<? super DocumentTracker.Block, Boolean> condition) {
        Intrinsics.checkParameterIsNotNull((Object)side, (String)"side");
        Intrinsics.checkParameterIsNotNull(condition, (String)"condition");
        boolean bl = false;
        List newBlocks = new ArrayList();
        boolean bl2 = false;
        List appliedBlocks = new ArrayList();
        int shift = 0;
        for (DocumentTracker.Block block : this.blocks) {
            if (((Boolean)condition.invoke((Object)block)).booleanValue()) {
                appliedBlocks.add(block);
                shift += DocumentTrackerKt.access$getRangeDelta(block.getRange(), side);
                continue;
            }
            DocumentTracker.Block newBlock = DocumentTrackerKt.access$shift(block, side, shift);
            this.handler.onRangeShifted(block, newBlock);
            newBlocks.add(newBlock);
        }
        this.blocks = newBlocks;
        this.handler.afterBulkRangeChange();
        return appliedBlocks;
    }

    /*
     * WARNING - void declaration
     */
    public LineTracker(@NotNull DocumentTracker.Handler handler2, @NotNull List<? extends Range> originalChanges) {
        Collection<DocumentTracker.Block> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull((Object)handler2, (String)"handler");
        Intrinsics.checkParameterIsNotNull(originalChanges, (String)"originalChanges");
        this.handler = handler2;
        Iterable iterable = originalChanges;
        LineTracker lineTracker = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Range range2 = (Range)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            DocumentTracker.Block block = new DocumentTracker.Block((Range)it, false, false);
            collection.add(block);
        }
        collection = (List)destination$iv$iv;
        lineTracker.blocks = collection;
    }
}

