/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies;

import com.intellij.analysis.AnalysisScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.DependencyRule;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.packageDependencies.DependencyVisitorFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiFileEx;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class DependenciesBuilder {
    private final Project myProject;
    private final AnalysisScope myScope;
    private final Map<PsiFile, Set<PsiFile>> myDependencies;
    protected int myTotalFileCount;
    protected int myFileCount;

    protected DependenciesBuilder(@NotNull Project project, @NotNull AnalysisScope scope) {
        if (project == null) {
            DependenciesBuilder.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            DependenciesBuilder.$$$reportNull$$$0(1);
        }
        this.myDependencies = new HashMap<PsiFile, Set<PsiFile>>();
        this.myFileCount = 0;
        this.myProject = project;
        this.myScope = scope;
        this.myTotalFileCount = scope.getFileCount();
    }

    public void setInitialFileCount(int fileCount) {
        this.myFileCount = fileCount;
    }

    public void setTotalFileCount(int totalFileCount) {
        this.myTotalFileCount = totalFileCount;
    }

    @NotNull
    public Map<PsiFile, Set<PsiFile>> getDependencies() {
        Map<PsiFile, Set<PsiFile>> map2 = this.myDependencies;
        if (map2 == null) {
            DependenciesBuilder.$$$reportNull$$$0(2);
        }
        return map2;
    }

    @NotNull
    public Map<PsiFile, Set<PsiFile>> getDirectDependencies() {
        Map<PsiFile, Set<PsiFile>> map2 = this.getDependencies();
        if (map2 == null) {
            DependenciesBuilder.$$$reportNull$$$0(3);
        }
        return map2;
    }

    @NotNull
    public AnalysisScope getScope() {
        AnalysisScope analysisScope = this.myScope;
        if (analysisScope == null) {
            DependenciesBuilder.$$$reportNull$$$0(4);
        }
        return analysisScope;
    }

    @Deprecated
    public AnalysisScope getScopeOfInterest() {
        return null;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            DependenciesBuilder.$$$reportNull$$$0(5);
        }
        return project;
    }

    @Nls
    public abstract String getRootNodeNameInUsageView();

    @Nls
    public abstract String getInitialUsagesPosition();

    public abstract boolean isBackward();

    public abstract void analyze();

    public Map<PsiFile, Map<DependencyRule, Set<PsiFile>>> getIllegalDependencies() {
        HashMap<PsiFile, Map<DependencyRule, Set<PsiFile>>> result2 = new HashMap<PsiFile, Map<DependencyRule, Set<PsiFile>>>();
        DependencyValidationManager validator = DependencyValidationManager.getInstance((Project)this.myProject);
        for (PsiFile file2 : this.getDirectDependencies().keySet()) {
            Set<PsiFile> deps = this.getDirectDependencies().get(file2);
            HashMap<DependencyRule, HashSet<PsiFile>> illegal = null;
            for (PsiFile dependency : deps) {
                HashSet<PsiFile> illegalFilesByRule;
                DependencyRule rule = this.isBackward() ? validator.getViolatorDependencyRule(dependency, file2) : validator.getViolatorDependencyRule(file2, dependency);
                if (rule == null) continue;
                if (illegal == null) {
                    illegal = new HashMap<DependencyRule, HashSet<PsiFile>>();
                    result2.put(file2, illegal);
                }
                if ((illegalFilesByRule = (HashSet<PsiFile>)illegal.get(rule)) == null) {
                    illegalFilesByRule = new HashSet<PsiFile>();
                }
                illegalFilesByRule.add(dependency);
                illegal.put(rule, illegalFilesByRule);
            }
        }
        return result2;
    }

    public List<List<PsiFile>> findPaths(PsiFile from, PsiFile to) {
        return this.findPaths(from, to, new HashSet());
    }

    private List<List<PsiFile>> findPaths(PsiFile from, PsiFile to, Set<? super PsiFile> processed2) {
        ArrayList<List<PsiFile>> result2 = new ArrayList<List<PsiFile>>();
        Set<PsiFile> reachable = this.getDirectDependencies().get(from);
        if (reachable != null) {
            if (reachable.contains(to)) {
                result2.add(new ArrayList());
                return result2;
            }
            if (processed2.add((PsiFile)from)) {
                for (PsiFile file2 : reachable) {
                    if (this.getScope().contains((PsiElement)file2)) continue;
                    List<List<PsiFile>> paths = this.findPaths(file2, to, processed2);
                    for (List<PsiFile> path : paths) {
                        path.add(0, file2);
                    }
                    result2.addAll(paths);
                }
            }
        }
        return result2;
    }

    @Deprecated
    public boolean isTransitive() {
        return false;
    }

    @Deprecated
    public int getTransitiveBorder() {
        return 0;
    }

    String getRelativeToProjectPath(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            DependenciesBuilder.$$$reportNull$$$0(6);
        }
        return ProjectUtilCore.displayUrlRelativeToProject((VirtualFile)virtualFile, (String)virtualFile.getPresentableUrl(), (Project)this.getProject(), (boolean)true, (boolean)false);
    }

    public static void analyzeFileDependencies(@NotNull PsiFile file2, @NotNull DependencyProcessor processor2) {
        if (file2 == null) {
            DependenciesBuilder.$$$reportNull$$$0(7);
        }
        if (processor2 == null) {
            DependenciesBuilder.$$$reportNull$$$0(8);
        }
        DependenciesBuilder.analyzeFileDependencies(file2, processor2, DependencyVisitorFactory.VisitorOptions.fromSettings(file2.getProject()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void analyzeFileDependencies(@NotNull PsiFile file2, @NotNull DependencyProcessor processor2, @NotNull DependencyVisitorFactory.VisitorOptions options) {
        if (file2 == null) {
            DependenciesBuilder.$$$reportNull$$$0(9);
        }
        if (processor2 == null) {
            DependenciesBuilder.$$$reportNull$$$0(10);
        }
        if (options == null) {
            DependenciesBuilder.$$$reportNull$$$0(11);
        }
        Boolean prev = (Boolean)file2.getUserData(PsiFileEx.BATCH_REFERENCE_PROCESSING);
        file2.putUserData(PsiFileEx.BATCH_REFERENCE_PROCESSING, (Object)Boolean.TRUE);
        try {
            file2.accept(DependencyVisitorFactory.createVisitor(file2, processor2, options));
        }
        finally {
            file2.putUserData(PsiFileEx.BATCH_REFERENCE_PROCESSING, (Object)prev);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packageDependencies/DependenciesBuilder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packageDependencies/DependenciesBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectDependencies";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRelativeToProjectPath";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "analyzeFileDependencies";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    public static interface DependencyProcessor {
        public void process(@NotNull PsiElement var1, @NotNull PsiElement var2);
    }
}

