/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement;

import com.intellij.lang.Language;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.Rearranger;
import com.intellij.psi.codeStyle.arrangement.engine.ArrangementEngine;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsAware;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemberOrderService {
    @Nullable
    public PsiElement getAnchor(@NotNull PsiElement member, @NotNull CommonCodeStyleSettings settings, @NotNull PsiElement context) {
        PsiElement element2;
        Language language;
        Rearranger rearranger;
        if (member == null) {
            MemberOrderService.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            MemberOrderService.$$$reportNull$$$0(1);
        }
        if (context == null) {
            MemberOrderService.$$$reportNull$$$0(2);
        }
        if ((rearranger = (Rearranger)Rearranger.EXTENSION.forLanguage(language = context.getLanguage())) == null) {
            return null;
        }
        ArrangementSettings arrangementSettings = settings.getArrangementSettings();
        if (arrangementSettings == null && rearranger instanceof ArrangementStandardSettingsAware) {
            arrangementSettings = ((ArrangementStandardSettingsAware)rearranger).getDefaultSettings();
        }
        if (arrangementSettings == null) {
            return null;
        }
        Pair pair = rearranger.parseWithNew(context, null, Collections.singleton(context.getTextRange()), member, arrangementSettings);
        if (pair == null || ((List)pair.second).isEmpty()) {
            return null;
        }
        ArrangementEntry memberEntry = (ArrangementEntry)pair.first;
        List entries = (List)pair.second;
        ArrangementEntry parentEntry = (ArrangementEntry)entries.get(0);
        List nonArranged = parentEntry.getChildren();
        ArrayList<ArrangementEntry> entriesWithNew = new ArrayList<ArrangementEntry>(nonArranged);
        entriesWithNew.add(memberEntry);
        List rulesByPriority = arrangementSettings.getRulesSortedByPriority();
        List extendedSectionRules = ArrangementUtil.getExtendedSectionRules((ArrangementSettings)arrangementSettings);
        List arranged = ArrangementEngine.arrange(entriesWithNew, extendedSectionRules, rulesByPriority, null);
        int i = arranged.indexOf(memberEntry);
        if (i <= 0) {
            return context;
        }
        ArrangementEntry anchorEntry = null;
        if (i >= arranged.size() - 1) {
            anchorEntry = (ArrangementEntry)nonArranged.get(nonArranged.size() - 1);
        } else {
            ArrangementEntry entry;
            HashSet entriesBelow = new HashSet(arranged.subList(i + 1, arranged.size()));
            Iterator iterator2 = nonArranged.iterator();
            while (iterator2.hasNext() && !entriesBelow.contains(entry = (ArrangementEntry)iterator2.next())) {
                anchorEntry = entry;
            }
        }
        if (anchorEntry == null) {
            return context;
        }
        int offset = anchorEntry.getEndOffset() - 1 - context.getTextRange().getStartOffset();
        for (PsiElement e = element2 = context.findElementAt(offset); e != null && e.getTextRange().getStartOffset() >= anchorEntry.getStartOffset(); e = e.getParent()) {
            element2 = e;
        }
        return element2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "member";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "settings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/codeStyle/arrangement/MemberOrderService";
        objectArray[2] = "getAnchor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

