/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.icons.AllIcons;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.INativeFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.IconManager;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.BitUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.PsiIconUtil;
import java.util.function.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ElementBase
extends UserDataHolderBase
implements Iconable {
    private static final Logger LOG = Logger.getInstance(ElementBase.class);
    public static final int FLAGS_LOCKED = 2048;
    private static final Function<ElementIconRequest, Icon> ICON_COMPUTE = request2 -> {
        PsiElement element2 = ((ElementIconRequest)request2).myPointer.getElement();
        if (element2 == null) {
            return null;
        }
        Icon icon2 = ElementBase.computeIconNow(element2, ((ElementIconRequest)request2).myFlags);
        Iconable.LastComputedIcon.put((UserDataHolder)element2, (Icon)icon2, (int)((ElementIconRequest)request2).myFlags);
        return icon2;
    };
    private static final NotNullLazyValue<Icon> VISIBILITY_ICON_PLACEHOLDER = new NotNullLazyValue<Icon>(){

        @NotNull
        protected Icon compute() {
            Icon icon2 = IconManager.getInstance().createEmptyIcon(PlatformIcons.PUBLIC_ICON);
            if (icon2 == null) {
                1.$$$reportNull$$$0(0);
            }
            return icon2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/ElementBase$1", "compute"));
        }
    };
    public static final NotNullLazyValue<Icon> ICON_PLACEHOLDER = new NotNullLazyValue<Icon>(){

        @NotNull
        protected Icon compute() {
            Icon icon2 = AllIcons.Nodes.NodePlaceholder;
            if (icon2 == null) {
                2.$$$reportNull$$$0(0);
            }
            return icon2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/ElementBase$2", "compute"));
        }
    };

    @Nullable
    public Icon getIcon(int flags) {
        if (!(this instanceof PsiElement)) {
            return null;
        }
        try {
            return this.computeIcon(flags);
        }
        catch (ProcessCanceledException | IndexNotReadyException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @Nullable
    private Icon computeIcon(@Iconable.IconFlags int flags) {
        PsiElement psiElement = (PsiElement)this;
        if (!psiElement.isValid()) {
            return null;
        }
        if (Registry.is((String)"psi.deferIconLoading")) {
            Icon baseIcon = Iconable.LastComputedIcon.get((UserDataHolder)psiElement, (int)flags);
            if (baseIcon == null) {
                baseIcon = (Icon)AstLoadingFilter.disallowTreeLoading(() -> this.computeBaseIcon(flags));
            }
            return IconManager.getInstance().createDeferredIcon(baseIcon, (Object)new ElementIconRequest(psiElement, psiElement.getProject(), flags), ICON_COMPUTE);
        }
        return ElementBase.computeIconNow(psiElement, flags);
    }

    @Nullable
    private static Icon computeIconNow(@NotNull PsiElement element2, @Iconable.IconFlags int flags) {
        if (element2 == null) {
            ElementBase.$$$reportNull$$$0(0);
        }
        return (Icon)AstLoadingFilter.disallowTreeLoading(() -> ElementBase.doComputeIconNow(element2, flags));
    }

    private static Icon doComputeIconNow(@NotNull PsiElement element2, @Iconable.IconFlags int flags) {
        Icon providersIcon;
        if (element2 == null) {
            ElementBase.$$$reportNull$$$0(1);
        }
        if ((providersIcon = PsiIconUtil.getProvidersIcon((PsiElement)element2, (int)flags)) != null) {
            if (providersIcon instanceof RowIcon) {
                return providersIcon;
            }
            return IconManager.getInstance().createLayeredIcon((Iconable)element2, providersIcon, flags);
        }
        return ((ElementBase)element2).getElementIcon(flags);
    }

    protected Icon computeBaseIcon(@Iconable.IconFlags int flags) {
        PsiFile file2;
        Icon baseIcon;
        Icon icon2 = baseIcon = this.isVisibilitySupported() ? this.getAdjustedBaseIcon(this.getBaseIcon(), flags) : this.getBaseIcon();
        if (this instanceof PsiElement && (file2 = ((PsiElement)this).getContainingFile()) != null) {
            return IconManager.getInstance().createLayeredIcon((Iconable)file2, baseIcon, flags);
        }
        return baseIcon;
    }

    protected Icon getBaseIcon() {
        PsiFile file2;
        if (this instanceof PsiElement && (file2 = ((PsiElement)this).getContainingFile()) != null && !ElementBase.isNativeFileType(file2.getFileType())) {
            return file2.getFileType().getIcon();
        }
        return (Icon)ICON_PLACEHOLDER.getValue();
    }

    public static boolean isNativeFileType(FileType fileType) {
        return fileType instanceof INativeFileType && ((INativeFileType)fileType).useNativeIcon() || fileType instanceof UnknownFileType;
    }

    protected Icon getAdjustedBaseIcon(Icon icon2, @Iconable.IconFlags int flags) {
        if (BitUtil.isSet((int)flags, (int)1)) {
            return IconManager.getInstance().createRowIcon(new Icon[]{icon2, (Icon)VISIBILITY_ICON_PLACEHOLDER.getValue()});
        }
        return icon2;
    }

    protected boolean isVisibilitySupported() {
        return false;
    }

    @NotNull
    public static Icon overlayIcons(Icon ... icons) {
        if (icons == null) {
            ElementBase.$$$reportNull$$$0(2);
        }
        LayeredIcon icon2 = new LayeredIcon(icons.length);
        int i = 0;
        for (Icon ic2 : icons) {
            icon2.setIcon(ic2, i++);
        }
        LayeredIcon layeredIcon = icon2;
        if (layeredIcon == null) {
            ElementBase.$$$reportNull$$$0(3);
        }
        return layeredIcon;
    }

    @NotNull
    public static RowIcon buildRowIcon(Icon baseIcon, Icon visibilityIcon) {
        RowIcon rowIcon = IconManager.getInstance().createRowIcon(new Icon[]{baseIcon, visibilityIcon});
        if (rowIcon == null) {
            ElementBase.$$$reportNull$$$0(4);
        }
        return rowIcon;
    }

    public static Icon iconWithVisibilityIfNeeded(@Iconable.IconFlags int flags, Icon baseIcon, Icon visibility) {
        return BitUtil.isSet((int)flags, (int)1) ? ElementBase.buildRowIcon(baseIcon, visibility) : baseIcon;
    }

    @Nullable
    protected Icon getElementIcon(@Iconable.IconFlags int flags) {
        Icon baseIcon;
        int elementFlags;
        PsiElement element2 = (PsiElement)this;
        if (!element2.isValid()) {
            return null;
        }
        boolean isLocked = BitUtil.isSet((int)flags, (int)2) && !element2.isWritable();
        int n = elementFlags = isLocked ? 2048 : 0;
        if (element2 instanceof ItemPresentation && (baseIcon = ((ItemPresentation)element2).getIcon(false)) != null) {
            return IconManager.getInstance().createLayeredIcon((Iconable)this, baseIcon, elementFlags);
        }
        if (element2 instanceof PsiFile) {
            PsiFile psiFile = (PsiFile)element2;
            VirtualFile vFile = psiFile.getVirtualFile();
            Icon baseIcon2 = vFile != null ? IconUtil.getIcon((VirtualFile)vFile, (int)(flags & 0xFFFFFFFD), (Project)psiFile.getProject()) : psiFile.getFileType().getIcon();
            return IconManager.getInstance().createLayeredIcon((Iconable)this, baseIcon2, elementFlags);
        }
        return null;
    }

    @Deprecated
    @NotNull
    @ApiStatus.ScheduledForRemoval
    public static com.intellij.ui.RowIcon createLayeredIcon(@NotNull Iconable instance, Icon icon2, int flags) {
        if (instance == null) {
            ElementBase.$$$reportNull$$$0(5);
        }
        com.intellij.ui.RowIcon rowIcon = (com.intellij.ui.RowIcon)IconManager.getInstance().createLayeredIcon(instance, icon2, flags);
        if (rowIcon == null) {
            ElementBase.$$$reportNull$$$0(6);
        }
        return rowIcon;
    }

    public static int transformFlags(PsiElement element2, @Iconable.IconFlags int _flags) {
        boolean isLocked;
        int flags = BitUtil.clear((int)_flags, (int)2);
        boolean bl = isLocked = BitUtil.isSet((int)_flags, (int)2) && !element2.isWritable();
        if (isLocked) {
            flags |= 0x800;
        }
        return flags;
    }

    @Deprecated
    public static void registerIconLayer(int flagMask, @NotNull Icon icon2) {
        if (icon2 == null) {
            ElementBase.$$$reportNull$$$0(7);
        }
        IconManager.getInstance().registerIconLayer(flagMask, icon2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icons";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/ElementBase";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instance";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/ElementBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "overlayIcons";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildRowIcon";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createLayeredIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "computeIconNow";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doComputeIconNow";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "overlayIcons";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createLayeredIcon";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerIconLayer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ElementIconRequest {
        private final SmartPsiElementPointer<?> myPointer;
        @Iconable.IconFlags
        private final int myFlags;

        private ElementIconRequest(@NotNull PsiElement element2, @NotNull Project project, @Iconable.IconFlags int flags) {
            if (element2 == null) {
                ElementIconRequest.$$$reportNull$$$0(0);
            }
            if (project == null) {
                ElementIconRequest.$$$reportNull$$$0(1);
            }
            this.myPointer = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer(element2);
            this.myFlags = flags;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ElementIconRequest)) {
                return false;
            }
            ElementIconRequest request2 = (ElementIconRequest)o;
            if (this.myFlags != request2.myFlags) {
                return false;
            }
            return this.myPointer.equals(request2.myPointer);
        }

        public int hashCode() {
            int result2 = this.myPointer.hashCode();
            result2 = 31 * result2 + this.myFlags;
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/impl/ElementBase$ElementIconRequest";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

