/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.Key;
import com.intellij.psi.impl.cache.impl.IdAndToDoScannerBasedOnFilterLexer;
import com.intellij.psi.impl.cache.impl.IndexPatternUtil;
import com.intellij.psi.impl.cache.impl.OccurrenceConsumer;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.impl.cache.impl.id.IdTableBuilding;
import com.intellij.psi.impl.cache.impl.id.LexingIdIndexer;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexEntry;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexers;
import com.intellij.psi.search.IndexPattern;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.IdDataConsumer;
import gnu.trove.THashMap;
import java.util.Collections;
import java.util.Map;

public class BaseFilterLexerUtil {
    private static final Key<ScanContent> scanContentKey = Key.create((String)"id.todo.scan.content");
    private static final ScanContent EMPTY = new ScanContent(Collections.emptyMap(), Collections.emptyMap());

    public static ScanContent scanContent(FileContent content2, IdAndToDoScannerBasedOnFilterLexer indexer) {
        IndexPattern[] patterns = IndexPatternUtil.getIndexPatterns();
        if (patterns.length <= 0) {
            return EMPTY;
        }
        ScanContent data2 = (ScanContent)content2.getUserData(scanContentKey);
        if (data2 != null) {
            content2.putUserData(scanContentKey, null);
            return data2;
        }
        boolean needTodo = TodoIndexers.needsTodoIndex(content2.getFile());
        boolean needIdIndex = IdTableBuilding.getFileTypeIndexer(content2.getFileType()) instanceof LexingIdIndexer;
        IdDataConsumer consumer = needIdIndex ? new IdDataConsumer() : null;
        OccurrenceConsumer todoOccurrenceConsumer = new OccurrenceConsumer(consumer, needTodo);
        Lexer filterLexer = indexer.createLexer(todoOccurrenceConsumer);
        filterLexer.start(content2.getContentAsText());
        while (filterLexer.getTokenType() != null) {
            filterLexer.advance();
        }
        THashMap todoMap = null;
        if (needTodo) {
            for (IndexPattern indexPattern : patterns) {
                int count = todoOccurrenceConsumer.getOccurrenceCount(indexPattern);
                if (count <= 0) continue;
                if (todoMap == null) {
                    todoMap = new THashMap();
                }
                todoMap.put(new TodoIndexEntry(indexPattern.getPatternString(), indexPattern.isCaseSensitive()), count);
            }
        }
        data2 = new ScanContent(consumer != null ? consumer.getResult() : Collections.emptyMap(), (Map<TodoIndexEntry, Integer>)(todoMap != null ? todoMap : Collections.emptyMap()));
        if (needIdIndex && needTodo) {
            content2.putUserData(scanContentKey, (Object)data2);
        }
        return data2;
    }

    public static class ScanContent {
        public final Map<IdIndexEntry, Integer> idMap;
        public final Map<TodoIndexEntry, Integer> todoMap;

        public ScanContent(Map<IdIndexEntry, Integer> _idMap, Map<TodoIndexEntry, Integer> _todoMap) {
            this.idMap = _idMap;
            this.todoMap = _todoMap;
        }
    }
}

