/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.ChangedRangesInfo;
import com.intellij.psi.impl.source.codeStyle.FormattingRangesExtender;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

class ChangedRangesUtil {
    @Contract(pure=true)
    private ChangedRangesUtil() {
    }

    @NotNull
    static List<TextRange> processChangedRanges(@NotNull PsiFile file2, @NotNull ChangedRangesInfo changedRangesInfo) {
        if (file2 == null) {
            ChangedRangesUtil.$$$reportNull$$$0(0);
        }
        if (changedRangesInfo == null) {
            ChangedRangesUtil.$$$reportNull$$$0(1);
        }
        Document document = file2.getViewProvider().getDocument();
        ArrayList<TextRange> result2 = new ArrayList<TextRange>();
        if (document != null) {
            FormattingRangesExtender extender = new FormattingRangesExtender(document, file2);
            for (TextRange range2 : changedRangesInfo.allChangedRanges) {
                List<TextRange> extended = extender.getExtendedRanges(Collections.singletonList(range2));
                result2.addAll(extended);
            }
        } else {
            result2.addAll(changedRangesInfo.allChangedRanges);
        }
        return ChangedRangesUtil.optimizedChangedRanges(result2);
    }

    @NotNull
    private static List<TextRange> optimizedChangedRanges(@NotNull List<TextRange> allChangedRanges) {
        if (allChangedRanges == null) {
            ChangedRangesUtil.$$$reportNull$$$0(2);
        }
        if (allChangedRanges.isEmpty()) {
            List<TextRange> list2 = allChangedRanges;
            if (list2 == null) {
                ChangedRangesUtil.$$$reportNull$$$0(3);
            }
            return list2;
        }
        List sorted = ContainerUtil.sorted(allChangedRanges, (Comparator)Segment.BY_START_OFFSET_THEN_END_OFFSET);
        SmartList result2 = new SmartList();
        TextRange prev = (TextRange)sorted.get(0);
        for (TextRange next : sorted) {
            if (next.getStartOffset() <= prev.getEndOffset()) {
                int newEndOffset = Math.max(prev.getEndOffset(), next.getEndOffset());
                prev = new TextRange(prev.getStartOffset(), newEndOffset);
                continue;
            }
            result2.add(prev);
            prev = next;
        }
        result2.add(prev);
        SmartList smartList = result2;
        if (smartList == null) {
            ChangedRangesUtil.$$$reportNull$$$0(4);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedRangesInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allChangedRanges";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/codeStyle/ChangedRangesUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/ChangedRangesUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "optimizedChangedRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processChangedRanges";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "optimizedChangedRanges";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

