/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.patterns.CaseInsensitiveValuePatternCondition;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiNamePatternCondition;
import com.intellij.patterns.ValuePatternCondition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.impl.source.resolve.reference.NamedObjectProviderBinding;
import com.intellij.psi.impl.source.resolve.reference.ProviderBinding;
import com.intellij.psi.impl.source.resolve.reference.SimpleProviderBinding;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiReferenceRegistrarImpl
extends PsiReferenceRegistrar {
    private static final Logger LOG = Logger.getInstance(PsiReferenceRegistrarImpl.class);
    private final Map<Class<?>, SimpleProviderBinding> myBindingsMap = new THashMap();
    private final Map<Class<?>, NamedObjectProviderBinding> myNamedBindingsMap = new THashMap();
    private final ConcurrentMap<Class, ProviderBinding[]> myBindingCache = ConcurrentFactoryMap.createMap(key -> {
        SmartList result2 = new SmartList();
        for (Class<?> bindingClass : this.myBindingsMap.keySet()) {
            if (!bindingClass.isAssignableFrom((Class<?>)key)) continue;
            result2.add(this.myBindingsMap.get(bindingClass));
        }
        for (Class<?> bindingClass : this.myNamedBindingsMap.keySet()) {
            if (!bindingClass.isAssignableFrom((Class<?>)key)) continue;
            result2.add(this.myNamedBindingsMap.get(bindingClass));
        }
        return result2.toArray(new ProviderBinding[0]);
    });
    private boolean myInitialized;

    PsiReferenceRegistrarImpl() {
    }

    void markInitialized() {
        this.myInitialized = true;
    }

    public <T extends PsiElement> void registerReferenceProvider(@NotNull ElementPattern<T> pattern, @NotNull PsiReferenceProvider provider, double priority) {
        if (pattern == null) {
            PsiReferenceRegistrarImpl.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            PsiReferenceRegistrarImpl.$$$reportNull$$$0(1);
        }
        this.registerReferenceProvider(pattern, provider, priority, null);
    }

    /*
     * WARNING - void declaration
     */
    public <T extends PsiElement> void registerReferenceProvider(@NotNull ElementPattern<T> pattern, @NotNull PsiReferenceProvider provider, double priority, @Nullable Disposable disposable2) {
        SimpleProviderBinding providerBinding;
        void parentDisposable;
        if (pattern == null) {
            PsiReferenceRegistrarImpl.$$$reportNull$$$0(2);
        }
        if (provider == null) {
            PsiReferenceRegistrarImpl.$$$reportNull$$$0(3);
        }
        if (this.myInitialized && !ApplicationManager.getApplication().isUnitTestMode() && parentDisposable == null) {
            LOG.error("Reference provider registration is only allowed from PsiReferenceContributor");
        }
        Class scope = pattern.getCondition().getInitialCondition().getAcceptedClass();
        List conditions = pattern.getCondition().getConditions();
        for (PatternCondition _condition : conditions) {
            if (!(_condition instanceof PsiNamePatternCondition)) continue;
            PsiNamePatternCondition nameCondition = (PsiNamePatternCondition)_condition;
            List conditions1 = nameCondition.getNamePattern().getCondition().getConditions();
            for (PatternCondition condition1 : conditions1) {
                if (condition1 instanceof ValuePatternCondition) {
                    Collection strings = ((ValuePatternCondition)condition1).getValues();
                    this.registerNamedReferenceProvider(ArrayUtilRt.toStringArray((Collection)strings), nameCondition, scope, true, provider, priority, pattern, (Disposable)parentDisposable);
                    return;
                }
                if (!(condition1 instanceof CaseInsensitiveValuePatternCondition)) continue;
                String[] strings = ((CaseInsensitiveValuePatternCondition)condition1).getValues();
                this.registerNamedReferenceProvider(strings, nameCondition, scope, false, provider, priority, pattern, (Disposable)parentDisposable);
                return;
            }
        }
        if ((providerBinding = this.myBindingsMap.get(scope)) == null) {
            providerBinding = new SimpleProviderBinding();
            this.myBindingsMap.put(scope, providerBinding);
        }
        providerBinding.registerProvider(provider, pattern, priority);
        if (parentDisposable != null) {
            Disposer.register((Disposable)parentDisposable, () -> this.unregisterReferenceProvider(scope, provider));
        }
        this.myBindingCache.clear();
    }

    public void unregisterReferenceProvider(@NotNull Class scope, @NotNull PsiReferenceProvider provider) {
        SimpleProviderBinding binding;
        if (scope == null) {
            PsiReferenceRegistrarImpl.$$$reportNull$$$0(4);
        }
        if (provider == null) {
            PsiReferenceRegistrarImpl.$$$reportNull$$$0(5);
        }
        if ((binding = this.myBindingsMap.get(scope)) != null) {
            binding.unregisterProvider(provider);
            if (binding.isEmpty()) {
                this.myBindingsMap.remove(scope);
            }
        }
        this.myBindingCache.clear();
    }

    /*
     * WARNING - void declaration
     */
    private void registerNamedReferenceProvider(String @NotNull [] names2, final PsiNamePatternCondition<?> nameCondition, @NotNull Class scopeClass, boolean caseSensitive, @NotNull PsiReferenceProvider provider, double priority, @NotNull ElementPattern pattern, @Nullable Disposable disposable2) {
        void parentDisposable;
        NamedObjectProviderBinding providerBinding;
        if (scopeClass == null) {
            PsiReferenceRegistrarImpl.$$$reportNull$$$0(6);
        }
        if (provider == null) {
            PsiReferenceRegistrarImpl.$$$reportNull$$$0(7);
        }
        if (pattern == null) {
            PsiReferenceRegistrarImpl.$$$reportNull$$$0(8);
        }
        if (names2 == null) {
            PsiReferenceRegistrarImpl.$$$reportNull$$$0(9);
        }
        if ((providerBinding = this.myNamedBindingsMap.get(scopeClass)) == null) {
            providerBinding = new NamedObjectProviderBinding(){

                @Override
                protected String getName(@NotNull PsiElement position) {
                    if (position == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return nameCondition.getPropertyValue((Object)position);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/psi/impl/source/resolve/reference/PsiReferenceRegistrarImpl$1", "getName"));
                }
            };
            this.myNamedBindingsMap.put(scopeClass, providerBinding);
        }
        providerBinding.registerProvider(names2, pattern, caseSensitive, provider, priority);
        if (parentDisposable != null) {
            NamedObjectProviderBinding finalProviderBinding = providerBinding;
            Disposer.register((Disposable)parentDisposable, () -> {
                finalProviderBinding.unregisterProvider(provider);
                if (finalProviderBinding.isEmpty()) {
                    this.myNamedBindingsMap.remove(scopeClass);
                }
            });
        }
    }

    @NotNull
    List<ProviderBinding.ProviderInfo<ProcessingContext>> getPairsByElement(@NotNull PsiElement element2, @NotNull PsiReferenceService.Hints hints) {
        ProviderBinding[] bindings;
        if (element2 == null) {
            PsiReferenceRegistrarImpl.$$$reportNull$$$0(10);
        }
        if (hints == null) {
            PsiReferenceRegistrarImpl.$$$reportNull$$$0(11);
        }
        if ((bindings = (ProviderBinding[])this.myBindingCache.get(element2.getClass())).length == 0) {
            List<ProviderBinding.ProviderInfo<ProcessingContext>> list2 = Collections.emptyList();
            if (list2 == null) {
                PsiReferenceRegistrarImpl.$$$reportNull$$$0(12);
            }
            return list2;
        }
        SmartList ret = new SmartList();
        for (ProviderBinding binding : bindings) {
            binding.addAcceptableReferenceProviders(element2, (List<? super ProviderBinding.ProviderInfo<ProcessingContext>>)ret, hints);
        }
        SmartList smartList = ret;
        if (smartList == null) {
            PsiReferenceRegistrarImpl.$$$reportNull$$$0(13);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hints";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/PsiReferenceRegistrarImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/PsiReferenceRegistrarImpl";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPairsByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerReferenceProvider";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "unregisterReferenceProvider";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "registerNamedReferenceProvider";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPairsByElement";
                break;
            }
            case 12: 
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

