/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.ui.JBTabsPaneImpl;
import com.intellij.ui.PrevNextActionsDescriptor;
import com.intellij.ui.TabbedPane;
import com.intellij.ui.TabbedPaneImpl;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.util.IJSwingUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TabbedPaneWrapper {
    protected TabbedPane myTabbedPane;
    private JComponent myTabbedPaneHolder;
    private TabFactory myFactory;

    protected TabbedPaneWrapper(boolean construct) {
        if (construct) {
            this.init(1, TabbedPaneImpl.DEFAULT_PREV_NEXT_SHORTCUTS, new JTabbedPaneFactory(this));
        }
    }

    public TabbedPaneWrapper(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            TabbedPaneWrapper.$$$reportNull$$$0(0);
        }
        this(1, TabbedPaneImpl.DEFAULT_PREV_NEXT_SHORTCUTS, parentDisposable);
    }

    public TabbedPaneWrapper(int tabPlacement, @NotNull PrevNextActionsDescriptor installKeyboardNavigation, @NotNull Disposable parentDisposable) {
        if (installKeyboardNavigation == null) {
            TabbedPaneWrapper.$$$reportNull$$$0(1);
        }
        if (parentDisposable == null) {
            TabbedPaneWrapper.$$$reportNull$$$0(2);
        }
        TabFactory factory = 3 == tabPlacement || 1 == tabPlacement ? new JBTabsFactory(this, null, parentDisposable) : new JTabbedPaneFactory(this);
        this.init(tabPlacement, installKeyboardNavigation, factory);
    }

    void init(int tabPlacement, @NotNull PrevNextActionsDescriptor installKeyboardNavigation, @NotNull TabFactory tabbedPaneFactory) {
        if (installKeyboardNavigation == null) {
            TabbedPaneWrapper.$$$reportNull$$$0(3);
        }
        if (tabbedPaneFactory == null) {
            TabbedPaneWrapper.$$$reportNull$$$0(4);
        }
        this.myFactory = tabbedPaneFactory;
        this.myTabbedPane = this.createTabbedPane(tabPlacement);
        this.myTabbedPane.putClientProperty(TabbedPaneWrapper.class, this.myTabbedPane);
        this.myTabbedPane.setKeyboardNavigation(installKeyboardNavigation);
        this.myTabbedPaneHolder = this.createTabbedPaneHolder();
        this.myTabbedPaneHolder.add((Component)this.myTabbedPane.getComponent(), "Center");
        this.myTabbedPaneHolder.setFocusTraversalPolicyProvider(true);
        this.myTabbedPaneHolder.setFocusTraversalPolicy(new _MyFocusTraversalPolicy());
        this.assertIsDispatchThread();
    }

    private void assertIsDispatchThread() {
        ApplicationEx application = ApplicationManagerEx.getApplicationEx();
        if (application != null) {
            application.assertIsDispatchThread(this.myTabbedPane.getComponent());
        }
    }

    public final void addChangeListener(@NotNull ChangeListener listener2) {
        if (listener2 == null) {
            TabbedPaneWrapper.$$$reportNull$$$0(5);
        }
        this.assertIsDispatchThread();
        this.myTabbedPane.addChangeListener(listener2);
    }

    public final void removeChangeListener(ChangeListener listener2) {
        this.assertIsDispatchThread();
        this.myTabbedPane.removeChangeListener(listener2);
    }

    protected TabbedPaneHolder createTabbedPaneHolder() {
        return this.myFactory.createTabbedPaneHolder();
    }

    public final JComponent getComponent() {
        this.assertIsDispatchThread();
        return this.myTabbedPaneHolder;
    }

    public final synchronized void addTab(@Nls(capitalization=Nls.Capitalization.Title) String title, Icon icon2, JComponent component2, String tip) {
        this.insertTab(title, icon2, component2, tip, this.myTabbedPane.getTabCount());
    }

    public final synchronized void addTab(@Nls(capitalization=Nls.Capitalization.Title) String title, JComponent component2) {
        this.insertTab(title, null, component2, null, this.myTabbedPane.getTabCount());
    }

    public synchronized void insertTab(@Nls(capitalization=Nls.Capitalization.Title) String title, Icon icon2, JComponent component2, String tip, int index) {
        this.myTabbedPane.insertTab(title, icon2, this.createTabWrapper(component2), tip, index);
    }

    private TabWrapper createTabWrapper(JComponent component2) {
        return this.myFactory.createTabWrapper(component2);
    }

    protected TabbedPane createTabbedPane(int tabPlacement) {
        return this.myFactory.createTabbedPane(tabPlacement);
    }

    public final void setTabPlacement(int tabPlacement) {
        this.assertIsDispatchThread();
        this.myTabbedPane.setTabPlacement(tabPlacement);
    }

    public final void addMouseListener(MouseListener listener2) {
        this.assertIsDispatchThread();
        this.myTabbedPane.addMouseListener(listener2);
    }

    public final synchronized int getSelectedIndex() {
        return this.myTabbedPane.getSelectedIndex();
    }

    public final synchronized JComponent getSelectedComponent() {
        TabWrapper tabWrapper = this.myTabbedPane.getTabCount() > 0 ? (TabWrapper)this.myTabbedPane.getSelectedComponent() : null;
        return tabWrapper != null ? tabWrapper.getComponent() : null;
    }

    public final void setSelectedIndex(int index) {
        this.setSelectedIndex(index, true);
    }

    public final void setSelectedIndex(int index, boolean requestFocus) {
        this.assertIsDispatchThread();
        boolean hadFocus = IJSwingUtilities.hasFocus2(this.myTabbedPaneHolder);
        this.myTabbedPane.setSelectedIndex(index);
        if (hadFocus && requestFocus) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myTabbedPaneHolder, true));
        }
    }

    public final void setSelectedComponent(JComponent component2) {
        this.assertIsDispatchThread();
        int index = this.indexOfComponent(component2);
        if (index == -1) {
            throw new IllegalArgumentException("component not found in tabbed pane wrapper");
        }
        this.setSelectedIndex(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void removeTabAt(int index) {
        this.assertIsDispatchThread();
        boolean hadFocus = IJSwingUtilities.hasFocus2(this.myTabbedPaneHolder);
        TabWrapper wrapper2 = this.getWrapperAt(index);
        try {
            this.myTabbedPane.removeTabAt(index);
            if (this.myTabbedPane.getTabCount() == 0) {
                this.myTabbedPane.revalidate();
            }
            if (hadFocus) {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myTabbedPaneHolder, true));
            }
        }
        finally {
            wrapper2.dispose();
        }
    }

    public final synchronized int getTabCount() {
        return this.myTabbedPane.getTabCount();
    }

    public final Color getForegroundAt(int index) {
        this.assertIsDispatchThread();
        return this.myTabbedPane.getForegroundAt(index);
    }

    public final void setForegroundAt(int index, Color color) {
        this.assertIsDispatchThread();
        this.myTabbedPane.setForegroundAt(index, color);
    }

    public final Component getTabComponentAt(int index) {
        return this.myTabbedPane.getTabComponentAt(index);
    }

    public final synchronized JComponent getComponentAt(int i) {
        return this.getWrapperAt(i).getComponent();
    }

    private TabWrapper getWrapperAt(int i) {
        return (TabWrapper)this.myTabbedPane.getComponentAt(i);
    }

    public final void setTitleAt(int index, @NotNull String title) {
        if (title == null) {
            TabbedPaneWrapper.$$$reportNull$$$0(6);
        }
        this.assertIsDispatchThread();
        this.myTabbedPane.setTitleAt(index, title);
    }

    public final void setToolTipTextAt(int index, String toolTipText) {
        this.assertIsDispatchThread();
        this.myTabbedPane.setToolTipTextAt(index, toolTipText);
    }

    public final synchronized void setComponentAt(int index, JComponent component2) {
        this.assertIsDispatchThread();
        this.myTabbedPane.setComponentAt(index, this.createTabWrapper(component2));
    }

    public final void setIconAt(int index, Icon icon2) {
        this.assertIsDispatchThread();
        this.myTabbedPane.setIconAt(index, icon2);
    }

    public final void setEnabledAt(int index, boolean enabled) {
        this.assertIsDispatchThread();
        this.myTabbedPane.setEnabledAt(index, enabled);
    }

    public final synchronized int indexOfComponent(JComponent component2) {
        for (int i = 0; i < this.myTabbedPane.getTabCount(); ++i) {
            JComponent c = this.getWrapperAt(i).getComponent();
            if (c != component2) continue;
            return i;
        }
        return -1;
    }

    public final synchronized int getTabLayoutPolicy() {
        return this.myTabbedPane.getTabLayoutPolicy();
    }

    public final synchronized void setTabLayoutPolicy(int policy) {
        this.myTabbedPane.setTabLayoutPolicy(policy);
        int index = this.myTabbedPane.getSelectedIndex();
        if (index != -1) {
            this.myTabbedPane.scrollTabToVisible(index);
        }
    }

    @Deprecated
    public final void installKeyboardNavigation() {
    }

    @Deprecated
    public final void uninstallKeyboardNavigation() {
    }

    public final String getTitleAt(int i) {
        return this.myTabbedPane.getTitleAt(i);
    }

    public void setSelectedTitle(@Nullable String title) {
        if (title == null) {
            return;
        }
        for (int i = 0; i < this.myTabbedPane.getTabCount(); ++i) {
            String each = this.myTabbedPane.getTitleAt(i);
            if (!title.equals(each)) continue;
            this.myTabbedPane.setSelectedIndex(i);
            break;
        }
    }

    @Nullable
    public String getSelectedTitle() {
        return this.getSelectedIndex() < 0 ? null : this.getTitleAt(this.getSelectedIndex());
    }

    public void removeAll() {
        this.myTabbedPane.removeAll();
    }

    public static TabbedPaneWrapper get(JTabbedPane tabs) {
        return (TabbedPaneWrapper)tabs.getClientProperty(TabbedPaneWrapper.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installKeyboardNavigation";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabbedPaneFactory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/TabbedPaneWrapper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "init";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addChangeListener";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "setTitleAt";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class AsJTabbedPane
    extends TabbedPaneWrapper {
        public AsJTabbedPane(int tabPlacement) {
            super(false);
            this.init(tabPlacement, TabbedPaneImpl.DEFAULT_PREV_NEXT_SHORTCUTS, new JTabbedPaneFactory(this));
        }
    }

    public static class AsJBTabs
    extends TabbedPaneWrapper {
        public AsJBTabs(@Nullable Project project, int tabPlacement, PrevNextActionsDescriptor installKeyboardNavigation, @NotNull Disposable parent) {
            if (parent == null) {
                AsJBTabs.$$$reportNull$$$0(0);
            }
            super(false);
            this.init(tabPlacement, installKeyboardNavigation, new JBTabsFactory(this, project, parent));
        }

        public JBTabs getTabs() {
            return ((JBTabsPaneImpl)this.myTabbedPane).getTabs();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/ui/TabbedPaneWrapper$AsJBTabs", "<init>"));
        }
    }

    private static class JBTabsFactory
    implements TabFactory {
        private final Project myProject;
        private final Disposable myParent;
        private final TabbedPaneWrapper myWrapper;

        private JBTabsFactory(TabbedPaneWrapper wrapper2, Project project, @NotNull Disposable parent) {
            if (parent == null) {
                JBTabsFactory.$$$reportNull$$$0(0);
            }
            this.myWrapper = wrapper2;
            this.myProject = project;
            this.myParent = parent;
        }

        @Override
        @NotNull
        public TabbedPane createTabbedPane(int tabPlacement) {
            return new JBTabsPaneImpl(this.myProject, tabPlacement, this.myParent);
        }

        @Override
        @NotNull
        public TabbedPaneHolder createTabbedPaneHolder() {
            return new TabbedPaneHolder(this.myWrapper){

                @Override
                public boolean requestDefaultFocus() {
                    this.getTabs().requestFocus();
                    return true;
                }
            };
        }

        @Override
        @NotNull
        public TabWrapper createTabWrapper(@NotNull JComponent component2) {
            if (component2 == null) {
                JBTabsFactory.$$$reportNull$$$0(1);
            }
            TabWrapper tabWrapper = new TabWrapper(component2);
            tabWrapper.myCustomFocus = false;
            TabWrapper tabWrapper2 = tabWrapper;
            if (tabWrapper2 == null) {
                JBTabsFactory.$$$reportNull$$$0(2);
            }
            return tabWrapper2;
        }

        public JBTabs getTabs() {
            return ((JBTabsPaneImpl)this.myWrapper.myTabbedPane).getTabs();
        }

        public void dispose() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/TabbedPaneWrapper$JBTabsFactory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/TabbedPaneWrapper$JBTabsFactory";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTabWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createTabWrapper";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class JTabbedPaneFactory
    implements TabFactory {
        private final TabbedPaneWrapper myWrapper;

        private JTabbedPaneFactory(TabbedPaneWrapper wrapper2) {
            this.myWrapper = wrapper2;
        }

        @Override
        @NotNull
        public TabbedPane createTabbedPane(int tabPlacement) {
            return new TabbedPaneImpl(tabPlacement);
        }

        @Override
        @NotNull
        public TabbedPaneHolder createTabbedPaneHolder() {
            return new TabbedPaneHolder(this.myWrapper);
        }

        @Override
        @NotNull
        public TabWrapper createTabWrapper(@NotNull JComponent component2) {
            if (component2 == null) {
                JTabbedPaneFactory.$$$reportNull$$$0(0);
            }
            return new TabWrapper(component2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ui/TabbedPaneWrapper$JTabbedPaneFactory", "createTabWrapper"));
        }
    }

    private static interface TabFactory {
        @NotNull
        public TabbedPane createTabbedPane(int var1);

        @NotNull
        public TabbedPaneHolder createTabbedPaneHolder();

        @NotNull
        public TabWrapper createTabWrapper(@NotNull JComponent var1);
    }

    public static class TabbedPaneHolder
    extends JPanel {
        private final TabbedPaneWrapper myWrapper;

        protected TabbedPaneHolder(TabbedPaneWrapper wrapper2) {
            super(new BorderLayout());
            this.myWrapper = wrapper2;
        }

        @Override
        public boolean requestDefaultFocus() {
            JComponent preferredFocusedComponent = IdeFocusTraversalPolicy.getPreferredFocusedComponent(this.myWrapper.myTabbedPane.getComponent());
            if (preferredFocusedComponent != null) {
                if (!preferredFocusedComponent.requestFocusInWindow()) {
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)preferredFocusedComponent, true));
                }
                return true;
            }
            return super.requestDefaultFocus();
        }

        @Override
        public final void requestFocus() {
            this.requestDefaultFocus();
        }

        @Override
        public final boolean requestFocusInWindow() {
            return this.requestDefaultFocus();
        }

        @Override
        public void updateUI() {
            super.updateUI();
            if (this.myWrapper != null) {
                this.myWrapper.myTabbedPane.updateUI();
            }
        }

        public TabbedPaneWrapper getTabbedPaneWrapper() {
            return this.myWrapper;
        }
    }

    private final class _MyFocusTraversalPolicy
    extends IdeFocusTraversalPolicy {
        private _MyFocusTraversalPolicy() {
        }

        @Override
        public final Component getDefaultComponent(Container focusCycleRoot) {
            JComponent component2 = TabbedPaneWrapper.this.getSelectedComponent();
            return component2 == null ? null : IdeFocusTraversalPolicy.getPreferredFocusedComponent(component2, this);
        }
    }

    public static final class TabWrapper
    extends JPanel
    implements DataProvider {
        private JComponent myComponent;
        boolean myCustomFocus;

        TabWrapper(@NotNull JComponent component2) {
            if (component2 == null) {
                TabWrapper.$$$reportNull$$$0(0);
            }
            super(new BorderLayout());
            this.myCustomFocus = true;
            this.myComponent = component2;
            this.add((Component)component2, "Center");
        }

        public Object getData(@NotNull String dataId) {
            if (dataId == null) {
                TabWrapper.$$$reportNull$$$0(1);
            }
            if (this.myComponent instanceof DataProvider) {
                return ((DataProvider)this.myComponent).getData(dataId);
            }
            return null;
        }

        public JComponent getComponent() {
            return this.myComponent;
        }

        public void dispose() {
            if (this.myComponent != null) {
                this.remove(this.myComponent);
                this.myComponent = null;
            }
        }

        @Override
        public boolean requestDefaultFocus() {
            if (!this.myCustomFocus) {
                return super.requestDefaultFocus();
            }
            if (this.myComponent == null) {
                return false;
            }
            JComponent preferredFocusedComponent = IdeFocusTraversalPolicy.getPreferredFocusedComponent(this.myComponent);
            if (preferredFocusedComponent != null) {
                if (!preferredFocusedComponent.requestFocusInWindow()) {
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)preferredFocusedComponent, true));
                }
                return true;
            }
            return this.myComponent.requestDefaultFocus();
        }

        @Override
        public void requestFocus() {
            if (!this.myCustomFocus) {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> super.requestFocus());
            } else {
                this.requestDefaultFocus();
            }
        }

        @Override
        public boolean requestFocusInWindow() {
            if (!this.myCustomFocus) {
                return super.requestFocusInWindow();
            }
            return this.requestDefaultFocus();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/TabbedPaneWrapper$TabWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

