/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.textCompletion.DefaultTextCompletionValueDescriptor;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextCompletionValueDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TextFieldWithAutoCompletionListProvider<T>
extends DefaultTextCompletionValueDescriptor<T>
implements TextCompletionProvider {
    private static final Logger LOG = Logger.getInstance(TextFieldWithAutoCompletionListProvider.class);
    @NotNull
    protected Collection<T> myVariants;
    @Nullable
    private String myCompletionAdvertisement;

    protected TextFieldWithAutoCompletionListProvider(@Nullable Collection<T> variants) {
        this.setItems(variants);
        this.myCompletionAdvertisement = null;
    }

    @Override
    @Nullable
    public String getPrefix(@NotNull String text2, int offset) {
        if (text2 == null) {
            TextFieldWithAutoCompletionListProvider.$$$reportNull$$$0(0);
        }
        return TextFieldWithAutoCompletionListProvider.getCompletionPrefix(text2, offset);
    }

    @Override
    @NotNull
    public CompletionResultSet applyPrefixMatcher(@NotNull CompletionResultSet result2, @NotNull String prefix) {
        PrefixMatcher prefixMatcher;
        if (result2 == null) {
            TextFieldWithAutoCompletionListProvider.$$$reportNull$$$0(1);
        }
        if (prefix == null) {
            TextFieldWithAutoCompletionListProvider.$$$reportNull$$$0(2);
        }
        if ((prefixMatcher = this.createPrefixMatcher(prefix)) != null) {
            CompletionResultSet completionResultSet = result2.withPrefixMatcher(prefixMatcher);
            if (completionResultSet == null) {
                TextFieldWithAutoCompletionListProvider.$$$reportNull$$$0(3);
            }
            return completionResultSet;
        }
        CompletionResultSet completionResultSet = result2;
        if (completionResultSet == null) {
            TextFieldWithAutoCompletionListProvider.$$$reportNull$$$0(4);
        }
        return completionResultSet;
    }

    @Override
    @Nullable
    public CharFilter.Result acceptChar(char c) {
        return null;
    }

    @Override
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull String prefix, @NotNull CompletionResultSet result2) {
        if (parameters == null) {
            TextFieldWithAutoCompletionListProvider.$$$reportNull$$$0(5);
        }
        if (prefix == null) {
            TextFieldWithAutoCompletionListProvider.$$$reportNull$$$0(6);
        }
        if (result2 == null) {
            TextFieldWithAutoCompletionListProvider.$$$reportNull$$$0(7);
        }
        Collection<T> items = this.getItems(prefix, true, parameters);
        TextFieldWithAutoCompletionListProvider.addCompletionElements(result2, this, items, -10000);
        ProgressManager progressManager = ProgressManager.getInstance();
        ProgressIndicator mainIndicator = progressManager.getProgressIndicator();
        SensitiveProgressWrapper indicator = mainIndicator != null ? new SensitiveProgressWrapper(mainIndicator) : new EmptyProgressIndicator();
        Future future2 = ApplicationManager.getApplication().executeOnPooledThread(() -> (Collection)progressManager.runProcess(() -> this.getItems(prefix, false, parameters), indicator));
        while (true) {
            try {
                Collection tasks = (Collection)future2.get(100L, TimeUnit.MILLISECONDS);
                if (tasks != null) {
                    TextFieldWithAutoCompletionListProvider.addCompletionElements(result2, this, tasks, 0);
                    return;
                }
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception exception) {
                // empty catch block
            }
            ProgressManager.checkCanceled();
        }
    }

    private static <T> void addCompletionElements(CompletionResultSet result2, TextCompletionValueDescriptor<T> descriptor2, Collection<? extends T> items, int index) {
        AutoCompletionPolicy completionPolicy = ApplicationManager.getApplication().isUnitTestMode() ? AutoCompletionPolicy.ALWAYS_AUTOCOMPLETE : AutoCompletionPolicy.NEVER_AUTOCOMPLETE;
        int grouping = index;
        for (T item : items) {
            if (item == null) {
                LOG.error("Null item from " + descriptor2);
                continue;
            }
            LookupElementBuilder builder2 = descriptor2.createLookupBuilder(item);
            result2.addElement(PrioritizedLookupElement.withGrouping((LookupElement)builder2.withAutoCompletionPolicy(completionPolicy), (int)grouping--));
        }
    }

    public void setItems(@Nullable Collection<T> variants) {
        this.myVariants = variants != null ? variants : Collections.emptyList();
    }

    @NotNull
    public Collection<T> getItems(String prefix, boolean cached, CompletionParameters parameters) {
        if (prefix == null) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                TextFieldWithAutoCompletionListProvider.$$$reportNull$$$0(8);
            }
            return list2;
        }
        ArrayList<T> items = new ArrayList<T>(this.myVariants);
        Collections.sort(items, this);
        ArrayList<T> arrayList = items;
        if (arrayList == null) {
            TextFieldWithAutoCompletionListProvider.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @Override
    @Nullable
    public String getAdvertisement() {
        if (this.myCompletionAdvertisement != null) {
            return this.myCompletionAdvertisement;
        }
        String shortcut = KeymapUtil.getFirstKeyboardShortcutText((String)"QuickJavaDoc");
        String advertisementTail = this.getQuickDocHotKeyAdvertisementTail(shortcut);
        if (advertisementTail == null) {
            return null;
        }
        return "Pressing " + shortcut + " would show " + advertisementTail;
    }

    @Nullable
    protected String getQuickDocHotKeyAdvertisementTail(@NotNull String shortcut) {
        if (shortcut == null) {
            TextFieldWithAutoCompletionListProvider.$$$reportNull$$$0(10);
        }
        return null;
    }

    public void setAdvertisement(@Nullable String completionAdvertisement) {
        this.myCompletionAdvertisement = completionAdvertisement;
    }

    @Nullable
    public PrefixMatcher createPrefixMatcher(@NotNull String prefix) {
        if (prefix == null) {
            TextFieldWithAutoCompletionListProvider.$$$reportNull$$$0(11);
        }
        return new PlainPrefixMatcher(prefix);
    }

    @NotNull
    public static String getCompletionPrefix(CompletionParameters parameters) {
        String text2 = parameters.getOriginalFile().getText();
        int offset = parameters.getOffset();
        return TextFieldWithAutoCompletionListProvider.getCompletionPrefix(text2, offset);
    }

    @NotNull
    private static String getCompletionPrefix(String text2, int offset) {
        int i = text2.lastIndexOf(32, offset - 1) + 1;
        int j = text2.lastIndexOf(10, offset - 1) + 1;
        String string = text2.substring(Math.max(i, j), offset);
        if (string == null) {
            TextFieldWithAutoCompletionListProvider.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/TextFieldWithAutoCompletionListProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortcut";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/TextFieldWithAutoCompletionListProvider";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "applyPrefixMatcher";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPrefix";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyPrefixMatcher";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 12: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fillCompletionVariants";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getQuickDocHotKeyAdvertisementTail";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createPrefixMatcher";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

