/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdaterImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileBasedIndexScanRunnableCollector;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IndexAccessValidator;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexableSetContributor;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.indexing.InvertedIndexUtil;
import com.intellij.util.indexing.ProjectIndexableFilesFilter;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.impl.InvertedIndexValueIterator;
import com.intellij.util.indexing.roots.IndexableFilesProvider;
import com.intellij.util.indexing.roots.IndexableSetContributorFilesProvider;
import com.intellij.util.indexing.roots.LibraryIndexableFilesProvider;
import com.intellij.util.indexing.roots.ModuleIndexableFilesProvider;
import com.intellij.util.indexing.roots.SdkIndexableFilesProvider;
import com.intellij.util.indexing.roots.SyntheticLibraryIndexableFilesProvider;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.function.IntPredicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class FileBasedIndexEx
extends FileBasedIndex {
    private final IndexAccessValidator myAccessValidator = new IndexAccessValidator();

    @ApiStatus.Internal
    @NotNull
    public abstract IntPredicate getAccessibleFileIdFilter(@Nullable Project var1);

    @ApiStatus.Internal
    public abstract ProjectIndexableFilesFilter projectIndexableFiles(@Nullable Project var1);

    @ApiStatus.Internal
    abstract <K, V> UpdatableIndex<K, V, FileContent> getIndex(ID<K, V> var1);

    @ApiStatus.Internal
    public abstract void waitUntilIndicesAreInitialized();

    @ApiStatus.Internal
    public abstract <K> boolean ensureUpToDate(@NotNull ID<K, ?> var1, @Nullable Project var2, @Nullable GlobalSearchScope var3, @Nullable VirtualFile var4);

    @NotNull
    public <K, V> List<V> getValues(@NotNull ID<K, V> indexId, @NotNull K dataKey, @NotNull GlobalSearchScope filter2) {
        Iterator virtualFileIterator;
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(0);
        }
        if (dataKey == null) {
            FileBasedIndexEx.$$$reportNull$$$0(1);
        }
        if (filter2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(2);
        }
        VirtualFile restrictToFile = null;
        if (filter2 instanceof Iterable && (virtualFileIterator = ((Iterable)filter2).iterator()).hasNext()) {
            VirtualFile restrictToFileCandidate = (VirtualFile)virtualFileIterator.next();
            if (!virtualFileIterator.hasNext()) {
                restrictToFile = restrictToFileCandidate;
            }
        }
        SmartList values2 = new SmartList();
        FileBasedIndex.ValueProcessor processor2 = (arg_0, arg_1) -> FileBasedIndexEx.lambda$getValues$0((List)values2, arg_0, arg_1);
        if (restrictToFile != null) {
            this.processValuesInOneFile(indexId, dataKey, restrictToFile, processor2, filter2);
        } else {
            this.processValuesInScope(indexId, dataKey, true, filter2, null, processor2);
        }
        SmartList smartList = values2;
        if (smartList == null) {
            FileBasedIndexEx.$$$reportNull$$$0(3);
        }
        return smartList;
    }

    @NotNull
    public <K> Collection<K> getAllKeys(@NotNull ID<K, ?> indexId, @NotNull Project project) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(4);
        }
        if (project == null) {
            FileBasedIndexEx.$$$reportNull$$$0(5);
        }
        THashSet allKeys = new THashSet();
        this.processAllKeys(indexId, Processors.cancelableCollectProcessor((Collection)allKeys), project);
        THashSet tHashSet = allKeys;
        if (tHashSet == null) {
            FileBasedIndexEx.$$$reportNull$$$0(6);
        }
        return tHashSet;
    }

    public <K> boolean processAllKeys(@NotNull ID<K, ?> indexId, @NotNull Processor<? super K> processor2, @Nullable Project project) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(7);
        }
        if (processor2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(8);
        }
        return this.processAllKeys(indexId, processor2, (GlobalSearchScope)(project == null ? new EverythingGlobalScope() : GlobalSearchScope.allScope((Project)project)), null);
    }

    public <K> boolean processAllKeys(@NotNull ID<K, ?> indexId, @NotNull Processor<? super K> processor2, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(9);
        }
        if (processor2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(10);
        }
        if (scope == null) {
            FileBasedIndexEx.$$$reportNull$$$0(11);
        }
        try {
            this.waitUntilIndicesAreInitialized();
            UpdatableIndex<K, ?, FileContent> index = this.getIndex(indexId);
            if (index == null) {
                return true;
            }
            if (!this.ensureUpToDate(indexId, scope.getProject(), scope, null)) {
                return true;
            }
            if (idFilter == null) {
                idFilter = this.projectIndexableFiles(scope.getProject());
            }
            return index.processAllKeys(processor2, scope, idFilter);
        }
        catch (StorageException e) {
            this.scheduleRebuild(indexId, e);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof StorageException || cause instanceof IOException) {
                this.scheduleRebuild(indexId, cause);
            }
            throw e;
        }
        return false;
    }

    @NotNull
    public <K, V> Map<K, V> getFileData(@NotNull ID<K, V> id2, @NotNull VirtualFile virtualFile, @NotNull Project project) {
        if (id2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(12);
        }
        if (virtualFile == null) {
            FileBasedIndexEx.$$$reportNull$$$0(13);
        }
        if (project == null) {
            FileBasedIndexEx.$$$reportNull$$$0(14);
        }
        if (!(virtualFile instanceof VirtualFileWithId)) {
            Map map2 = Collections.emptyMap();
            if (map2 == null) {
                FileBasedIndexEx.$$$reportNull$$$0(15);
            }
            return map2;
        }
        int fileId = FileBasedIndexEx.getFileId((VirtualFile)virtualFile);
        if (this.getAccessibleFileIdFilter(project).test(fileId)) {
            Map map3 = (Map)this.processExceptions(id2, virtualFile, GlobalSearchScope.fileScope((Project)project, (VirtualFile)virtualFile), index -> index.getIndexedFileData(fileId));
            Map map4 = ContainerUtil.notNullize((Map)map3);
            if (map4 == null) {
                FileBasedIndexEx.$$$reportNull$$$0(16);
            }
            return map4;
        }
        Map map5 = Collections.emptyMap();
        if (map5 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(17);
        }
        return map5;
    }

    @NotNull
    public <K, V> Collection<VirtualFile> getContainingFiles(@NotNull ID<K, V> indexId, @NotNull K dataKey, @NotNull GlobalSearchScope filter2) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(18);
        }
        if (dataKey == null) {
            FileBasedIndexEx.$$$reportNull$$$0(19);
        }
        if (filter2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(20);
        }
        THashSet files2 = new THashSet();
        this.processValuesInScope(indexId, dataKey, false, filter2, null, (arg_0, arg_1) -> FileBasedIndexEx.lambda$getContainingFiles$2((Set)files2, arg_0, arg_1));
        THashSet tHashSet = files2;
        if (tHashSet == null) {
            FileBasedIndexEx.$$$reportNull$$$0(21);
        }
        return tHashSet;
    }

    public <K, V> boolean processValues(@NotNull ID<K, V> indexId, @NotNull K dataKey, @Nullable VirtualFile inFile, @NotNull FileBasedIndex.ValueProcessor<? super V> processor2, @NotNull GlobalSearchScope filter2) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(22);
        }
        if (dataKey == null) {
            FileBasedIndexEx.$$$reportNull$$$0(23);
        }
        if (processor2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(24);
        }
        if (filter2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(25);
        }
        return this.processValues(indexId, dataKey, inFile, processor2, filter2, null);
    }

    public <K, V> boolean processValues(@NotNull ID<K, V> indexId, @NotNull K dataKey, @Nullable VirtualFile inFile, @NotNull FileBasedIndex.ValueProcessor<? super V> processor2, @NotNull GlobalSearchScope filter2, @Nullable IdFilter idFilter) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(26);
        }
        if (dataKey == null) {
            FileBasedIndexEx.$$$reportNull$$$0(27);
        }
        if (processor2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(28);
        }
        if (filter2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(29);
        }
        return inFile != null ? this.processValuesInOneFile(indexId, dataKey, inFile, processor2, filter2) : this.processValuesInScope(indexId, dataKey, false, filter2, idFilter, processor2);
    }

    public <K, V> long getIndexModificationStamp(@NotNull ID<K, V> indexId, @NotNull Project project) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(30);
        }
        if (project == null) {
            FileBasedIndexEx.$$$reportNull$$$0(31);
        }
        UpdatableIndex<K, V, FileContent> index = this.getIndex(indexId);
        this.ensureUpToDate(indexId, project, GlobalSearchScope.allScope((Project)project));
        return index.getModificationStamp();
    }

    @Nullable
    private <K, V, R> R processExceptions(@NotNull ID<K, V> indexId, @Nullable VirtualFile restrictToFile, @NotNull GlobalSearchScope filter2, @NotNull ThrowableConvertor<? super UpdatableIndex<K, V, FileContent>, ? extends R, ? extends StorageException> computable) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(32);
        }
        if (filter2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(33);
        }
        if (computable == null) {
            FileBasedIndexEx.$$$reportNull$$$0(34);
        }
        try {
            this.waitUntilIndicesAreInitialized();
            UpdatableIndex index = this.getIndex(indexId);
            if (index == null) {
                return null;
            }
            Project project = filter2.getProject();
            if (!this.ensureUpToDate(indexId, project, filter2, restrictToFile)) {
                return null;
            }
            return (R)this.myAccessValidator.validate(indexId, () -> ConcurrencyUtil.withLock((Lock)index.getReadLock(), () -> computable.convert((Object)index)));
        }
        catch (StorageException e) {
            this.scheduleRebuild(indexId, e);
        }
        catch (RuntimeException e) {
            Throwable cause = FileBasedIndexImpl.getCauseToRebuildIndex(e);
            if (cause != null) {
                this.scheduleRebuild(indexId, cause);
            }
            throw e;
        }
        return null;
    }

    private <K, V> boolean processValuesInOneFile(@NotNull ID<K, V> indexId, @NotNull K dataKey, @NotNull VirtualFile restrictToFile, @NotNull FileBasedIndex.ValueProcessor<? super V> processor2, @NotNull GlobalSearchScope scope) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(35);
        }
        if (dataKey == null) {
            FileBasedIndexEx.$$$reportNull$$$0(36);
        }
        if (restrictToFile == null) {
            FileBasedIndexEx.$$$reportNull$$$0(37);
        }
        if (processor2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(38);
        }
        if (scope == null) {
            FileBasedIndexEx.$$$reportNull$$$0(39);
        }
        if (!(restrictToFile instanceof VirtualFileWithId)) {
            return true;
        }
        int restrictedFileId = FileBasedIndexEx.getFileId((VirtualFile)restrictToFile);
        if (!this.getAccessibleFileIdFilter(scope.getProject()).test(restrictedFileId)) {
            return true;
        }
        return this.processValueIterator(indexId, dataKey, restrictToFile, scope, valueIt -> {
            while (valueIt.hasNext()) {
                Object value2 = valueIt.next();
                if (valueIt.getValueAssociationPredicate().contains(restrictedFileId) && !processor2.process(restrictToFile, value2)) {
                    return false;
                }
                ProgressManager.checkCanceled();
            }
            return true;
        });
    }

    private <K, V> boolean processValuesInScope(@NotNull ID<K, V> indexId, @NotNull K dataKey, boolean ensureValueProcessedOnce, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter, @NotNull FileBasedIndex.ValueProcessor<? super V> processor2) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(40);
        }
        if (dataKey == null) {
            FileBasedIndexEx.$$$reportNull$$$0(41);
        }
        if (scope == null) {
            FileBasedIndexEx.$$$reportNull$$$0(42);
        }
        if (processor2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(43);
        }
        PersistentFS fs = (PersistentFS)ManagingFS.getInstance();
        IdFilter filter2 = idFilter != null ? idFilter : this.projectIndexableFiles(scope.getProject());
        IntPredicate accessibleFileFilter = this.getAccessibleFileIdFilter(scope.getProject());
        return this.processValueIterator(indexId, dataKey, null, scope, valueIt -> {
            block0: while (valueIt.hasNext()) {
                Object value2 = valueIt.next();
                ValueContainer.IntIterator inputIdsIterator = valueIt.getInputIdsIterator();
                while (inputIdsIterator.hasNext()) {
                    int id2 = inputIdsIterator.next();
                    if (!accessibleFileFilter.test(id2) || filter2 != null && !filter2.containsFileId(id2)) continue;
                    VirtualFile file2 = IndexInfrastructure.findFileByIdIfCached(fs, id2);
                    if (file2 != null && scope.accept(file2)) {
                        if (!processor2.process(file2, value2)) {
                            return false;
                        }
                        if (ensureValueProcessedOnce) {
                            ProgressManager.checkCanceled();
                            continue block0;
                        }
                    }
                    ProgressManager.checkCanceled();
                }
            }
            return true;
        });
    }

    private <K, V> boolean processValueIterator(@NotNull ID<K, V> indexId, @NotNull K dataKey, @Nullable VirtualFile restrictToFile, @NotNull GlobalSearchScope scope, @NotNull Processor<? super InvertedIndexValueIterator<V>> valueProcessor) {
        Boolean result2;
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(44);
        }
        if (dataKey == null) {
            FileBasedIndexEx.$$$reportNull$$$0(45);
        }
        if (scope == null) {
            FileBasedIndexEx.$$$reportNull$$$0(46);
        }
        if (valueProcessor == null) {
            FileBasedIndexEx.$$$reportNull$$$0(47);
        }
        return (result2 = (Boolean)this.processExceptions(indexId, restrictToFile, scope, index -> valueProcessor.process((Object)((InvertedIndexValueIterator)index.getData(dataKey).getValueIterator())))) == null || result2 != false;
    }

    public <K, V> boolean processFilesContainingAllKeys(@NotNull ID<K, V> indexId, @NotNull Collection<? extends K> dataKeys, @NotNull GlobalSearchScope filter2, @Nullable Condition<? super V> valueChecker, @NotNull Processor<? super VirtualFile> processor2) {
        ProjectIndexableFilesFilter filesSet;
        TIntHashSet set;
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(48);
        }
        if (dataKeys == null) {
            FileBasedIndexEx.$$$reportNull$$$0(49);
        }
        if (filter2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(50);
        }
        if (processor2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(51);
        }
        return (set = this.collectFileIdsContainingAllKeys(indexId, dataKeys, filter2, valueChecker, filesSet = this.projectIndexableFiles(filter2.getProject()))) != null && FileBasedIndexEx.processVirtualFiles(set, filter2, processor2);
    }

    public <K, V> boolean getFilesWithKey(@NotNull ID<K, V> indexId, @NotNull Set<? extends K> dataKeys, @NotNull Processor<? super VirtualFile> processor2, @NotNull GlobalSearchScope filter2) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(52);
        }
        if (dataKeys == null) {
            FileBasedIndexEx.$$$reportNull$$$0(53);
        }
        if (processor2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(54);
        }
        if (filter2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(55);
        }
        return this.processFilesContainingAllKeys(indexId, dataKeys, filter2, null, processor2);
    }

    public <K> void scheduleRebuild(@NotNull ID<K, ?> indexId, @NotNull Throwable e) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(56);
        }
        if (e == null) {
            FileBasedIndexEx.$$$reportNull$$$0(57);
        }
        this.requestRebuild(indexId, e);
    }

    public <K> void ensureUpToDate(@NotNull ID<K, ?> indexId, @Nullable Project project, @Nullable GlobalSearchScope filter2) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(58);
        }
        this.waitUntilIndicesAreInitialized();
        this.ensureUpToDate(indexId, project, filter2, null);
    }

    public void iterateIndexableFilesConcurrently(@NotNull ContentIterator processor2, @NotNull Project project, @NotNull ProgressIndicator indicator) {
        if (processor2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(59);
        }
        if (project == null) {
            FileBasedIndexEx.$$$reportNull$$$0(60);
        }
        if (indicator == null) {
            FileBasedIndexEx.$$$reportNull$$$0(61);
        }
        PushedFilePropertiesUpdaterImpl.invokeConcurrentlyIfPossible(FileBasedIndexEx.collectScanRootRunnables(processor2, project, indicator));
    }

    public void iterateIndexableFiles(@NotNull ContentIterator processor2, @NotNull Project project, ProgressIndicator indicator) {
        if (processor2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(62);
        }
        if (project == null) {
            FileBasedIndexEx.$$$reportNull$$$0(63);
        }
        for (Runnable r : FileBasedIndexEx.collectScanRootRunnables(processor2, project, indicator)) {
            r.run();
        }
    }

    @ApiStatus.Internal
    @ApiStatus.Experimental
    @NotNull
    public List<IndexableFilesProvider> getOrderedIndexableFilesProviders(@NotNull Project project, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            FileBasedIndexEx.$$$reportNull$$$0(64);
        }
        if (indicator == null) {
            FileBasedIndexEx.$$$reportNull$$$0(65);
        }
        if (LightEdit.owns((Project)project)) {
            List<IndexableFilesProvider> list2 = Collections.emptyList();
            if (list2 == null) {
                FileBasedIndexEx.$$$reportNull$$$0(66);
            }
            return list2;
        }
        List list3 = (List)ReadAction.compute(() -> {
            if (project.isDisposed()) {
                return Collections.emptyList();
            }
            HashSet<Library> seenLibraries = new HashSet<Library>();
            HashSet<Sdk> seenSdks = new HashSet<Sdk>();
            THashSet allEntries = new THashSet();
            ArrayList<IndexableFilesProvider> providers = new ArrayList<IndexableFilesProvider>();
            Module[] modules = ModuleManager.getInstance((Project)project).getSortedModules();
            for (Module module : modules) {
                OrderEntry[] orderEntries;
                providers.add(new ModuleIndexableFilesProvider(module));
                for (OrderEntry orderEntry : orderEntries = ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
                    Sdk sdk2;
                    Library library;
                    allEntries.add(orderEntry);
                    if (orderEntry instanceof LibraryOrderEntry && (library = ((LibraryOrderEntry)orderEntry).getLibrary()) != null && seenLibraries.add(library)) {
                        providers.add(new LibraryIndexableFilesProvider(library));
                    }
                    if (!(orderEntry instanceof JdkOrderEntry) || (sdk2 = ((JdkOrderEntry)orderEntry).getJdk()) == null || !seenSdks.add(sdk2)) continue;
                    providers.add(new SdkIndexableFilesProvider(sdk2));
                }
            }
            for (IndexableSetContributor contributor : IndexableSetContributor.EP_NAME.getExtensionList()) {
                providers.add(new IndexableSetContributorFilesProvider(contributor));
            }
            for (AdditionalLibraryRootsProvider provider : AdditionalLibraryRootsProvider.EP_NAME.getExtensionList()) {
                for (SyntheticLibrary library : provider.getAdditionalProjectLibraries(project)) {
                    providers.add(new SyntheticLibraryIndexableFilesProvider(library));
                }
            }
            return providers;
        });
        if (list3 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(67);
        }
        return list3;
    }

    @NotNull
    private static List<Runnable> collectScanRootRunnables(@NotNull ContentIterator processor2, @NotNull Project project, ProgressIndicator indicator) {
        if (processor2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(68);
        }
        if (project == null) {
            FileBasedIndexEx.$$$reportNull$$$0(69);
        }
        FileBasedIndexScanRunnableCollector collector = FileBasedIndexScanRunnableCollector.getInstance(project);
        ProgressIndicator finalIndicator = indicator != null ? indicator : new EmptyProgressIndicator();
        List<Runnable> list2 = collector.collectScanRootRunnables(processor2, finalIndicator);
        if (list2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(70);
        }
        return list2;
    }

    @Nullable
    private <K, V> TIntHashSet collectFileIdsContainingAllKeys(@NotNull ID<K, V> indexId, @NotNull Collection<? extends K> dataKeys, @NotNull GlobalSearchScope filter2, @Nullable Condition<? super V> valueChecker, @Nullable ProjectIndexableFilesFilter projectFilesFilter) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(71);
        }
        if (dataKeys == null) {
            FileBasedIndexEx.$$$reportNull$$$0(72);
        }
        if (filter2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(73);
        }
        IntPredicate accessibleFileFilter = this.getAccessibleFileIdFilter(filter2.getProject());
        ThrowableConvertor convertor = index -> InvertedIndexUtil.collectInputIdsContainingAllKeys((InvertedIndex)index, (Collection)dataKeys, __ -> {
            ProgressManager.checkCanceled();
            return true;
        }, (Condition)valueChecker, (ValueContainer.IntPredicate)(projectFilesFilter == null ? accessibleFileFilter::test : id2 -> projectFilesFilter.containsFileId(id2) && accessibleFileFilter.test(id2)));
        return (TIntHashSet)this.processExceptions(indexId, null, filter2, convertor);
    }

    private static boolean processVirtualFiles(@NotNull TIntHashSet ids, @NotNull GlobalSearchScope filter2, @NotNull Processor<? super VirtualFile> processor2) {
        if (ids == null) {
            FileBasedIndexEx.$$$reportNull$$$0(74);
        }
        if (filter2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(75);
        }
        if (processor2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(76);
        }
        PersistentFS fs = (PersistentFS)ManagingFS.getInstance();
        return ids.forEach(id2 -> {
            ProgressManager.checkCanceled();
            VirtualFile file2 = IndexInfrastructure.findFileByIdIfCached(fs, id2);
            if (file2 != null && filter2.accept(file2)) {
                return processor2.process((Object)file2);
            }
            return true;
        });
    }

    private static /* synthetic */ boolean lambda$getContainingFiles$2(Set files2, VirtualFile file2, Object value2) {
        files2.add(file2);
        return true;
    }

    private static /* synthetic */ boolean lambda$getValues$0(List values2, VirtualFile file2, Object value2) {
        values2.add(value2);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 66: 
            case 67: 
            case 70: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 66: 
            case 67: 
            case 70: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
            case 1: 
            case 19: 
            case 23: 
            case 27: 
            case 36: 
            case 41: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataKey";
                break;
            }
            case 2: 
            case 20: 
            case 25: 
            case 29: 
            case 33: 
            case 50: 
            case 55: 
            case 73: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 3: 
            case 6: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 66: 
            case 67: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/FileBasedIndexEx";
                break;
            }
            case 5: 
            case 14: 
            case 31: 
            case 60: 
            case 63: 
            case 64: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 10: 
            case 24: 
            case 28: 
            case 38: 
            case 43: 
            case 51: 
            case 54: 
            case 59: 
            case 62: 
            case 68: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 11: 
            case 39: 
            case 42: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restrictToFile";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueProcessor";
                break;
            }
            case 49: 
            case 53: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataKeys";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 61: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/FileBasedIndexEx";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllKeys";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileData";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingFiles";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderedIndexableFilesProviders";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "collectScanRootRunnables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getValues";
                break;
            }
            case 3: 
            case 6: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 66: 
            case 67: 
            case 70: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAllKeys";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processAllKeys";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFileData";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getContainingFiles";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "processValues";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getIndexModificationStamp";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "processExceptions";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "processValuesInOneFile";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "processValuesInScope";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "processValueIterator";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "processFilesContainingAllKeys";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getFilesWithKey";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "scheduleRebuild";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "ensureUpToDate";
                break;
            }
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "iterateIndexableFilesConcurrently";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "iterateIndexableFiles";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getOrderedIndexableFilesProviders";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "collectScanRootRunnables";
                break;
            }
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "collectFileIdsContainingAllKeys";
                break;
            }
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "processVirtualFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 66: 
            case 67: 
            case 70: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

