/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.snapshot;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.VfsAwareIndexStorage;
import com.intellij.util.indexing.impl.forward.IntForwardIndex;
import com.intellij.util.indexing.snapshot.EmptyValueContainer;
import com.intellij.util.indexing.snapshot.OneRecordValueContainer;
import com.intellij.util.indexing.snapshot.SnapshotInputMappings;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SnapshotSingleValueIndexStorage<Key, Value>
implements VfsAwareIndexStorage<Key, Value> {
    private static final Logger LOG = Logger.getInstance(SnapshotSingleValueIndexStorage.class);
    private volatile SnapshotInputMappings<Key, Value> mySnapshotInputMappings;
    private volatile IntForwardIndex myForwardIndex;
    private volatile boolean myInitialized;

    public void init(@NotNull SnapshotInputMappings<Key, Value> snapshotInputMappings, @NotNull IntForwardIndex forwardIndex) {
        if (snapshotInputMappings == null) {
            SnapshotSingleValueIndexStorage.$$$reportNull$$$0(0);
        }
        if (forwardIndex == null) {
            SnapshotSingleValueIndexStorage.$$$reportNull$$$0(1);
        }
        assert (!this.myInitialized);
        this.myForwardIndex = forwardIndex;
        this.mySnapshotInputMappings = snapshotInputMappings;
        this.myInitialized = true;
    }

    @NotNull
    public ValueContainer<Value> read(Key key) throws StorageException {
        int hashId;
        int inputId;
        block5: {
            ValueContainer<Value> valueContainer;
            assert (this.myInitialized);
            inputId = SnapshotSingleValueIndexStorage.inputKey(key);
            try {
                hashId = this.myForwardIndex.getInt(Integer.valueOf(inputId));
                if (hashId != 0) break block5;
                valueContainer = SnapshotSingleValueIndexStorage.empty();
            }
            catch (IOException e) {
                throw new StorageException((Throwable)e);
            }
            if (valueContainer == null) {
                SnapshotSingleValueIndexStorage.$$$reportNull$$$0(2);
            }
            return valueContainer;
        }
        Object item = ContainerUtil.getFirstItem(this.mySnapshotInputMappings.readData(hashId).values());
        return new OneRecordValueContainer<Object>(inputId, item);
    }

    @Override
    public boolean processKeys(@NotNull Processor<? super Key> processor2, GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        if (processor2 == null) {
            SnapshotSingleValueIndexStorage.$$$reportNull$$$0(3);
        }
        assert (this.myInitialized);
        throw new UnsupportedOperationException("Not implemented");
    }

    public void addValue(Key key, int inputId, Value value2) {
        assert (this.myInitialized);
        this.checkKeyInputIdConsistency(key, inputId);
    }

    public void removeAllValues(@NotNull Key key, int inputId) {
        if (key == null) {
            SnapshotSingleValueIndexStorage.$$$reportNull$$$0(4);
        }
        assert (this.myInitialized);
        this.checkKeyInputIdConsistency(key, inputId);
    }

    public void clear() {
    }

    public void clearCaches() {
    }

    public void close() throws StorageException {
    }

    public void flush() throws IOException {
    }

    private void checkKeyInputIdConsistency(Key key, int inputId) {
        if (!Comparing.equal(key, (Object)inputId)) {
            LOG.error("key (" + key + ") and inputId (" + inputId + ") should be the same for " + SingleEntryFileBasedIndexExtension.class.getName());
        }
    }

    private static <Key> int inputKey(Key key) {
        return (Integer)key;
    }

    public static <Value> ValueContainer<Value> empty() {
        return EmptyValueContainer.INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snapshotInputMappings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forwardIndex";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/snapshot/SnapshotSingleValueIndexStorage";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/snapshot/SnapshotSingleValueIndexStorage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "read";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processKeys";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeAllValues";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

