/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspace.jps;

import com.intellij.workspace.api.LibraryEntity;
import com.intellij.workspace.api.LibraryTableId;
import com.intellij.workspace.api.TypedEntity;
import com.intellij.workspace.api.TypedEntityStorageBuilder;
import com.intellij.workspace.api.VirtualFileUrl;
import com.intellij.workspace.ide.JpsFileEntitySource;
import com.intellij.workspace.jps.JpsFileContentReader;
import com.intellij.workspace.jps.JpsFileContentWriter;
import com.intellij.workspace.jps.JpsFileEntitiesSerializer;
import com.intellij.workspace.jps.JpsFormatEntitiesSerializationKt;
import com.intellij.workspace.jps.JpsLibraryEntitiesSerializerKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0010\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016JF\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00020\u001e2 \u0010\u001f\u001a\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001c0\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001b0 2\u0006\u0010!\u001a\u00020\"H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006#"}, d2={"Lcom/intellij/workspace/jps/JpsLibraryEntitiesSerializer;", "Lcom/intellij/workspace/jps/JpsFileEntitiesSerializer;", "Lcom/intellij/workspace/api/LibraryEntity;", "fileUrl", "Lcom/intellij/workspace/api/VirtualFileUrl;", "entitySource", "Lcom/intellij/workspace/ide/JpsFileEntitySource;", "libraryTableId", "Lcom/intellij/workspace/api/LibraryTableId;", "(Lcom/intellij/workspace/api/VirtualFileUrl;Lcom/intellij/workspace/ide/JpsFileEntitySource;Lcom/intellij/workspace/api/LibraryTableId;)V", "getEntitySource", "()Lcom/intellij/workspace/ide/JpsFileEntitySource;", "getFileUrl", "()Lcom/intellij/workspace/api/VirtualFileUrl;", "getLibraryTableId", "()Lcom/intellij/workspace/api/LibraryTableId;", "mainEntityClass", "Ljava/lang/Class;", "getMainEntityClass", "()Ljava/lang/Class;", "loadEntities", "", "builder", "Lcom/intellij/workspace/api/TypedEntityStorageBuilder;", "reader", "Lcom/intellij/workspace/jps/JpsFileContentReader;", "saveEntities", "", "Lcom/intellij/workspace/api/TypedEntity;", "mainEntities", "", "entities", "", "writer", "Lcom/intellij/workspace/jps/JpsFileContentWriter;", "intellij.platform.workspaceModel.ide"})
public class JpsLibraryEntitiesSerializer
implements JpsFileEntitiesSerializer<LibraryEntity> {
    @NotNull
    private final VirtualFileUrl fileUrl;
    @NotNull
    private final JpsFileEntitySource entitySource;
    @NotNull
    private final LibraryTableId libraryTableId;

    @Override
    @NotNull
    public Class<LibraryEntity> getMainEntityClass() {
        return LibraryEntity.class;
    }

    @Override
    public void loadEntities(@NotNull TypedEntityStorageBuilder builder2, @NotNull JpsFileContentReader reader) {
        Intrinsics.checkParameterIsNotNull((Object)builder2, (String)"builder");
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        JpsFileEntitySource source = this.getEntitySource();
        Element element2 = reader.loadComponent(this.getFileUrl().getUrl(), "libraryTable");
        if (element2 == null) {
            return;
        }
        Element libraryTableTag = element2;
        Iterator iterator2 = libraryTableTag.getChildren("library").iterator();
        while (iterator2.hasNext()) {
            Element libraryTag;
            Element element3 = libraryTag = (Element)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)element3, (String)"libraryTag");
            String name = JpsFormatEntitiesSerializationKt.getAttributeValueStrict(element3, "name");
            JpsLibraryEntitiesSerializerKt.loadLibrary(name, libraryTag, this.libraryTableId, builder2, source);
        }
    }

    @Override
    @NotNull
    public List<TypedEntity> saveEntities(@NotNull Collection<? extends LibraryEntity> mainEntities, @NotNull Map<Class<? extends TypedEntity>, ? extends List<? extends TypedEntity>> entities2, @NotNull JpsFileContentWriter writer) {
        Intrinsics.checkParameterIsNotNull(mainEntities, (String)"mainEntities");
        Intrinsics.checkParameterIsNotNull(entities2, (String)"entities");
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        if (mainEntities.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        ArrayList savedEntities = new ArrayList();
        Element componentTag = JDomSerializationUtil.createComponentElement((String)"libraryTable");
        Iterable $this$sortedBy$iv = mainEntities;
        boolean $i$f$sortedBy = false;
        Iterable iterable = $this$sortedBy$iv;
        boolean bl = false;
        Comparator comparator2 = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                LibraryEntity it = (LibraryEntity)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (LibraryEntity)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = it.getName();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        };
        Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LibraryEntity it = (LibraryEntity)element$iv;
            boolean bl2 = false;
            componentTag.addContent(JpsLibraryEntitiesSerializerKt.saveLibrary(it, savedEntities));
        }
        writer.saveComponent(this.getFileUrl().getUrl(), "libraryTable", componentTag);
        return savedEntities;
    }

    @Override
    @NotNull
    public VirtualFileUrl getFileUrl() {
        return this.fileUrl;
    }

    @Override
    @NotNull
    public JpsFileEntitySource getEntitySource() {
        return this.entitySource;
    }

    @NotNull
    protected final LibraryTableId getLibraryTableId() {
        return this.libraryTableId;
    }

    public JpsLibraryEntitiesSerializer(@NotNull VirtualFileUrl fileUrl, @NotNull JpsFileEntitySource entitySource, @NotNull LibraryTableId libraryTableId) {
        Intrinsics.checkParameterIsNotNull((Object)fileUrl, (String)"fileUrl");
        Intrinsics.checkParameterIsNotNull((Object)entitySource, (String)"entitySource");
        Intrinsics.checkParameterIsNotNull((Object)libraryTableId, (String)"libraryTableId");
        this.fileUrl = fileUrl;
        this.entitySource = entitySource;
        this.libraryTableId = libraryTableId;
    }

    @Override
    @NotNull
    public List<Class<? extends TypedEntity>> getAdditionalEntityTypes() {
        return JpsFileEntitiesSerializer.DefaultImpls.getAdditionalEntityTypes(this);
    }
}

