/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspace.legacyBridge.intellij;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.module.impl.ModulePathKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.projectModel.ProjectModelBundle;
import com.intellij.util.PathUtil;
import com.intellij.workspace.api.EntitySource;
import com.intellij.workspace.api.ModifiableModuleEntity;
import com.intellij.workspace.api.ModifiableModuleGroupPathEntity;
import com.intellij.workspace.api.ModifiableProxyBasedImlModelEntitiesKt;
import com.intellij.workspace.api.ModuleDependencyItem;
import com.intellij.workspace.api.ModuleEntity;
import com.intellij.workspace.api.ModuleGroupPathEntity;
import com.intellij.workspace.api.ModuleId;
import com.intellij.workspace.api.TypedEntity;
import com.intellij.workspace.api.TypedEntityStorage;
import com.intellij.workspace.api.TypedEntityStorageBuilder;
import com.intellij.workspace.api.VirtualFileUrl;
import com.intellij.workspace.api.VirtualFileUrlManager;
import com.intellij.workspace.ide.JpsEntitySourcesKt;
import com.intellij.workspace.ide.JpsFileEntitySource;
import com.intellij.workspace.ide.JpsProjectStoragePlace;
import com.intellij.workspace.ide.WorkspaceModel;
import com.intellij.workspace.legacyBridge.intellij.LegacyBridgeModifiableModuleModel;
import com.intellij.workspace.legacyBridge.intellij.LegacyBridgeModule;
import com.intellij.workspace.legacyBridge.intellij.LegacyBridgeModuleImpl;
import com.intellij.workspace.legacyBridge.intellij.LegacyBridgeModuleManagerComponent;
import com.intellij.workspace.legacyBridge.libraries.libraries.LegacyBridgeModifiableBase;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0011\u001a\u00020\bJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0019\u001a\u00020\fH\u0016J\u0010\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001c\u001a\u00020\fH\u0002J\u001d\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u001e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010\u001fJ\u0012\u0010 \u001a\u0004\u0018\u00010\u00172\u0006\u0010!\u001a\u00020\fH\u0016J\u0013\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00170\u001eH\u0016\u00a2\u0006\u0002\u0010#J\u0012\u0010$\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010%\u001a\u00020\u0004H\u0016J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020'H\u0016J\u0010\u0010)\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\fH\u0016J\u0018\u0010*\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010+\u001a\u00020\fH\u0016J.\u0010*\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010+\u001a\u00020\f2\u0014\u0010,\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f\u0018\u00010-H\u0016J\u0018\u0010.\u001a\u00020\u00172\u0006\u0010/\u001a\u00020\f2\u0006\u0010+\u001a\u00020\fH\u0016J\u0018\u00100\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\fH\u0016J'\u00101\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0010\u00102\u001a\f\u0012\u0006\b\u0001\u0012\u00020\f\u0018\u00010\u001eH\u0016\u00a2\u0006\u0002\u00103R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\n\u001aB\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f\u0012\f\u0012\n \r*\u0004\u0018\u00010\u000e0\u000e \r* \u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f\u0012\f\u0012\n \r*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u000f\u001aB\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f\u0012\f\u0012\n \r*\u0004\u0018\u00010\u000e0\u000e \r* \u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f\u0012\f\u0012\n \r*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u0010\u001aB\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f\u0012\f\u0012\n \r*\u0004\u0018\u00010\u000e0\u000e \r* \u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f\u0012\f\u0012\n \r*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/intellij/workspace/legacyBridge/intellij/LegacyBridgeModifiableModuleModel;", "Lcom/intellij/workspace/legacyBridge/libraries/libraries/LegacyBridgeModifiableBase;", "Lcom/intellij/openapi/module/ModifiableModuleModel;", "project", "Lcom/intellij/openapi/project/Project;", "moduleManager", "Lcom/intellij/workspace/legacyBridge/intellij/LegacyBridgeModuleManagerComponent;", "diff", "Lcom/intellij/workspace/api/TypedEntityStorageBuilder;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/workspace/legacyBridge/intellij/LegacyBridgeModuleManagerComponent;Lcom/intellij/workspace/api/TypedEntityStorageBuilder;)V", "myModulesToAdd", "Lcom/google/common/collect/HashBiMap;", "", "kotlin.jvm.PlatformType", "Lcom/intellij/workspace/legacyBridge/intellij/LegacyBridgeModule;", "myModulesToDispose", "myNewNameToModule", "collectChanges", "commit", "", "dispose", "disposeModule", "module", "Lcom/intellij/openapi/module/Module;", "findModuleByName", "name", "getActualName", "getModuleByFilePath", "filePath", "getModuleGroupPath", "", "(Lcom/intellij/openapi/module/Module;)[Ljava/lang/String;", "getModuleToBeRenamed", "newName", "getModules", "()[Lcom/intellij/openapi/module/Module;", "getNewName", "getProject", "hasModuleGroups", "", "isChanged", "loadModule", "newModule", "moduleTypeId", "options", "", "newNonPersistentModule", "moduleName", "renameModule", "setModuleGroupPath", "groupPath", "(Lcom/intellij/openapi/module/Module;[Ljava/lang/String;)V", "intellij.platform.workspaceModel.ide"})
public final class LegacyBridgeModifiableModuleModel
extends LegacyBridgeModifiableBase
implements ModifiableModuleModel {
    private final HashBiMap<String, LegacyBridgeModule> myModulesToAdd;
    private final HashBiMap<String, LegacyBridgeModule> myModulesToDispose;
    private final HashBiMap<String, LegacyBridgeModule> myNewNameToModule;
    private final Project project;
    private final LegacyBridgeModuleManagerComponent moduleManager;

    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    public Module[] getModules() {
        List modules = ArraysKt.toMutableList((Object[])this.moduleManager.getModules());
        Set set = (Set)this.myModulesToDispose.values();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"myModulesToDispose.values");
        modules.removeAll(set);
        Set set2 = (Set)this.myModulesToAdd.values();
        Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"myModulesToAdd.values");
        modules.addAll(set2);
        Collection $this$toTypedArray$iv = modules;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Module[] moduleArray = thisCollection$iv.toArray(new Module[0]);
        if (moduleArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return moduleArray;
    }

    @NotNull
    public Module newModule(@NotNull String filePath, @NotNull String moduleTypeId) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        Intrinsics.checkParameterIsNotNull((Object)moduleTypeId, (String)"moduleTypeId");
        return this.newModule(filePath, moduleTypeId, null);
    }

    @NotNull
    public Module newNonPersistentModule(@NotNull String moduleName, @NotNull String moduleTypeId) {
        Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
        Intrinsics.checkParameterIsNotNull((Object)moduleTypeId, (String)"moduleTypeId");
        ModuleEntity moduleEntity2 = ModifiableProxyBasedImlModelEntitiesKt.addModuleEntity(this.getDiff(), moduleName, CollectionsKt.listOf((Object)ModuleDependencyItem.ModuleSourceDependency.INSTANCE), new EntitySource(){});
        LegacyBridgeModuleImpl module = new LegacyBridgeModuleImpl(moduleEntity2.persistentId(), moduleName, this.project, null, this.getEntityStoreOnDiff(), this.getDiff());
        HashBiMap<String, LegacyBridgeModule> hashBiMap = this.myModulesToAdd;
        Intrinsics.checkExpressionValueIsNotNull(hashBiMap, (String)"myModulesToAdd");
        ((Map)hashBiMap).put(moduleName, module);
        module.init(newNonPersistentModule.1.INSTANCE);
        module.setModuleType(moduleTypeId);
        return module;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Module newModule(@NotNull String filePath, @NotNull String moduleTypeId, @Nullable Map<String, String> options) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        Intrinsics.checkParameterIsNotNull((Object)moduleTypeId, (String)"moduleTypeId");
        String string = FileUtil.toSystemIndependentName((String)FileUtil.resolveShortWindowsName((String)filePath));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileUtil.toSystemIndepen\u2026ortWindowsName(filePath))");
        String canonicalPath = string;
        LegacyBridgeModule existingModule = this.getModuleByFilePath(canonicalPath);
        if (existingModule != null) {
            return existingModule;
        }
        String moduleName = ModulePathKt.getModuleNameByFilePath(canonicalPath);
        if (this.findModuleByName(moduleName) != null) {
            throw (Throwable)new ModuleWithNameAlreadyExists("Module already exists: " + moduleName, moduleName);
        }
        String string2 = PathUtil.getParentPath((String)canonicalPath);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"PathUtil.getParentPath(canonicalPath)");
        VirtualFileUrl virtualFileUrl = VirtualFileUrlManager.INSTANCE.fromPath(string2);
        JpsProjectStoragePlace jpsProjectStoragePlace = JpsEntitySourcesKt.getStoragePlace(this.project);
        if (jpsProjectStoragePlace == null) {
            Intrinsics.throwNpe();
        }
        JpsFileEntitySource.FileInDirectory entitySource = new JpsFileEntitySource.FileInDirectory(virtualFileUrl, jpsProjectStoragePlace);
        ModuleEntity moduleEntity2 = ModifiableProxyBasedImlModelEntitiesKt.addModuleEntity(this.getDiff(), moduleName, CollectionsKt.listOf((Object)ModuleDependencyItem.ModuleSourceDependency.INSTANCE), entitySource);
        LegacyBridgeModule moduleInstance = this.moduleManager.createModuleInstance(moduleEntity2, this.getEntityStoreOnDiff(), this.getDiff(), true);
        HashBiMap<String, LegacyBridgeModule> hashBiMap = this.myModulesToAdd;
        Intrinsics.checkExpressionValueIsNotNull(hashBiMap, (String)"myModulesToAdd");
        ((Map)hashBiMap).put(moduleName, moduleInstance);
        moduleInstance.setModuleType(moduleTypeId);
        if (options != null) {
            Object object = options;
            boolean bl = false;
            Iterator<Map.Entry<String, String>> iterator2 = object.entrySet().iterator();
            while (iterator2.hasNext()) {
                void key;
                Map.Entry<String, String> entry;
                Map.Entry<String, String> entry2 = entry = iterator2.next();
                boolean bl2 = false;
                object = entry2.getKey();
                entry2 = entry;
                bl2 = false;
                String value2 = entry2.getValue();
                moduleInstance.setOption((String)key, value2);
            }
        }
        return moduleInstance;
    }

    private final LegacyBridgeModule getModuleByFilePath(String filePath) {
        for (Module module : this.getModules()) {
            boolean bl;
            boolean bl2 = SystemInfo.isFileSystemCaseSensitive;
            if (bl2) {
                bl = Intrinsics.areEqual((Object)module.getModuleFilePath(), (Object)filePath);
            } else if (!bl2) {
                bl = StringsKt.equals((String)module.getModuleFilePath(), (String)filePath, (boolean)true);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            boolean sameFilePath = bl;
            if (!sameFilePath) continue;
            Module module2 = module;
            if (module2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.workspace.legacyBridge.intellij.LegacyBridgeModule");
            }
            return (LegacyBridgeModule)module2;
        }
        return null;
    }

    @NotNull
    public Module loadModule(@NotNull String filePath) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        return this.newModule(filePath, "", null);
    }

    public void disposeModule(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        LegacyBridgeModule cfr_ignored_0 = (LegacyBridgeModule)module;
        String string = ((LegacyBridgeModule)module).getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"module.name");
        if (this.findModuleByName(string) == null) {
            String string2 = "Module '" + ((LegacyBridgeModule)module).getName() + "' is not found. Probably it's already disposed.";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        if (this.myModulesToAdd.inverse().remove((Object)module) != null) {
            Disposer.dispose((Disposable)((Disposable)module));
        }
        this.myNewNameToModule.inverse().remove((Object)module);
        HashBiMap<String, LegacyBridgeModule> hashBiMap = this.myModulesToDispose;
        Intrinsics.checkExpressionValueIsNotNull(hashBiMap, (String)"myModulesToDispose");
        ((Map)hashBiMap).put(((LegacyBridgeModule)module).getName(), module);
    }

    @Nullable
    public Module findModuleByName(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        LegacyBridgeModule addedModule = (LegacyBridgeModule)this.myModulesToAdd.get((Object)name);
        if (addedModule != null) {
            return addedModule;
        }
        if (this.myModulesToDispose.containsKey((Object)name)) {
            return null;
        }
        LegacyBridgeModule newNameModule = (LegacyBridgeModule)this.myNewNameToModule.get((Object)name);
        if (newNameModule != null) {
            return null;
        }
        return this.moduleManager.findModuleByName(name);
    }

    public void dispose() {
        this.assertModelIsLive();
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        for (LegacyBridgeModule moduleToAdd : (Set)this.myModulesToAdd.values()) {
            Disposer.dispose((Disposable)((Disposable)moduleToAdd));
        }
        this.myModulesToAdd.clear();
        this.myModulesToDispose.clear();
        this.myNewNameToModule.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isChanged() {
        HashBiMap<String, LegacyBridgeModule> hashBiMap = this.myModulesToAdd;
        Intrinsics.checkExpressionValueIsNotNull(hashBiMap, (String)"myModulesToAdd");
        Map map2 = (Map)hashBiMap;
        boolean bl = false;
        if (!map2.isEmpty()) {
            return true;
        }
        boolean bl2 = false;
        if (bl2) return true;
        HashBiMap<String, LegacyBridgeModule> hashBiMap2 = this.myModulesToDispose;
        Intrinsics.checkExpressionValueIsNotNull(hashBiMap2, (String)"myModulesToDispose");
        map2 = (Map)hashBiMap2;
        bl = false;
        if (!map2.isEmpty()) {
            return true;
        }
        boolean bl3 = false;
        if (bl3) return true;
        HashBiMap<String, LegacyBridgeModule> hashBiMap3 = this.myNewNameToModule;
        Intrinsics.checkExpressionValueIsNotNull(hashBiMap3, (String)"myNewNameToModule");
        map2 = (Map)hashBiMap3;
        bl = false;
        if (map2.isEmpty()) return false;
        return true;
    }

    public void commit() {
        TypedEntityStorageBuilder diff = this.collectChanges();
        WorkspaceModel.Companion.getInstance(this.project).updateProjectModel((Function1)new Function1<TypedEntityStorageBuilder, Unit>(diff){
            final /* synthetic */ TypedEntityStorageBuilder $diff;

            public final void invoke(@NotNull TypedEntityStorageBuilder it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                it.addDiff(this.$diff);
            }
            {
                this.$diff = typedEntityStorageBuilder;
                super(1);
            }
        });
    }

    @NotNull
    public final TypedEntityStorageBuilder collectChanges() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        TypedEntityStorage storage = this.getEntityStoreOnDiff().getCurrent();
        for (LegacyBridgeModule moduleToDispose : (Set)this.myModulesToDispose.values()) {
            ModuleEntity moduleEntity2;
            if ((ModuleEntity)storage.resolve(moduleToDispose.getModuleEntityId()) == null) {
                String string = "Could not find module to remove by id: " + moduleToDispose.getModuleEntityId();
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.getDiff().removeEntity(moduleEntity2);
        }
        Set set = (Set)this.myModulesToAdd.values();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"myModulesToAdd.values");
        this.moduleManager.setNewModuleInstances$intellij_platform_workspaceModel_ide(CollectionsKt.toList((Iterable)set));
        for (Map.Entry entry : this.myNewNameToModule.entrySet()) {
            ModuleEntity entity;
            if ((ModuleEntity)storage.resolve(((LegacyBridgeModule)entry.getValue()).getModuleEntityId()) == null) {
                String string = "Unable to resolve module by id: " + ((LegacyBridgeModule)entry.getValue()).getModuleEntityId();
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.getDiff().modifyEntity(ModifiableModuleEntity.class, (TypedEntity)entity, (Function1)new Function1<ModifiableModuleEntity, Unit>(entry){
                final /* synthetic */ Map.Entry $entry;

                public final void invoke(@NotNull ModifiableModuleEntity $this$modifyEntity) {
                    Intrinsics.checkParameterIsNotNull((Object)$this$modifyEntity, (String)"$receiver");
                    K k = this.$entry.getKey();
                    Intrinsics.checkExpressionValueIsNotNull(k, (String)"entry.key");
                    $this$modifyEntity.setName((String)k);
                }
                {
                    this.$entry = entry;
                    super(1);
                }
            });
        }
        return this.getDiff();
    }

    public void renameModule(@NotNull Module module, @NotNull String newName) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)newName, (String)"newName");
        LegacyBridgeModule cfr_ignored_0 = (LegacyBridgeModule)module;
        Module oldModule = this.findModuleByName(newName);
        this.myNewNameToModule.inverse().remove((Object)module);
        this.myNewNameToModule.remove((Object)newName);
        if (Intrinsics.areEqual((Object)((LegacyBridgeModule)module).getName(), (Object)newName) ^ true) {
            HashBiMap<String, LegacyBridgeModule> hashBiMap = this.myNewNameToModule;
            Intrinsics.checkExpressionValueIsNotNull(hashBiMap, (String)"myNewNameToModule");
            ((Map)hashBiMap).put(newName, module);
        }
        if (oldModule != null) {
            throw (Throwable)new ModuleWithNameAlreadyExists(ProjectModelBundle.message((String)"module.already.exists.error", (Object[])new Object[]{newName}), newName);
        }
    }

    @Nullable
    public Module getModuleToBeRenamed(@NotNull String newName) {
        Intrinsics.checkParameterIsNotNull((Object)newName, (String)"newName");
        return (Module)this.myNewNameToModule.get((Object)newName);
    }

    @Nullable
    public String getNewName(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        BiMap biMap = this.myNewNameToModule.inverse();
        Intrinsics.checkExpressionValueIsNotNull((Object)biMap, (String)"myNewNameToModule.inverse()");
        Map map2 = (Map)biMap;
        boolean bl = false;
        return (String)map2.get(module);
    }

    @NotNull
    public String getActualName(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        String string = this.getNewName(module);
        if (string == null) {
            String string2 = module.getName();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"module.name");
        }
        return string;
    }

    @Nullable
    public String[] getModuleGroupPath(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        return LegacyBridgeModuleManagerComponent.Companion.getModuleGroupPath$intellij_platform_workspaceModel_ide(module, this.getEntityStoreOnDiff());
    }

    public boolean hasModuleGroups() {
        return LegacyBridgeModuleManagerComponent.Companion.hasModuleGroups$intellij_platform_workspaceModel_ide(this.getEntityStoreOnDiff());
    }

    public void setModuleGroupPath(@NotNull Module module, @Nullable String[] groupPath2) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        ModuleId moduleId = ((LegacyBridgeModule)module).getModuleEntityId();
        TypedEntityStorage storage = this.getEntityStoreOnDiff().getCurrent();
        ModuleEntity moduleEntity2 = (ModuleEntity)storage.resolve(moduleId);
        if (moduleEntity2 == null) {
            String string = "Could not resolve module by moduleId: " + moduleId;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        ModuleEntity moduleEntity3 = moduleEntity2;
        ModuleGroupPathEntity moduleGroupEntity = moduleEntity3.getGroupPath();
        List groupPathList = groupPath2 != null ? ArraysKt.toList((Object[])groupPath2) : null;
        ModuleGroupPathEntity moduleGroupPathEntity = moduleGroupEntity;
        if (Intrinsics.areEqual(moduleGroupPathEntity != null ? moduleGroupPathEntity.getPath() : null, (Object)groupPathList) ^ true) {
            if (moduleGroupEntity == null && groupPathList != null) {
                EntitySource entitySource = moduleEntity3.getEntitySource();
                List list2 = groupPathList;
                ModuleEntity moduleEntity4 = moduleEntity3;
                ModifiableProxyBasedImlModelEntitiesKt.addModuleGroupPathEntity(this.getDiff(), list2, moduleEntity4, entitySource);
            } else if (moduleGroupEntity != null || groupPathList != null) {
                if (moduleGroupEntity != null && groupPathList == null) {
                    this.getDiff().removeEntity(moduleGroupEntity);
                } else if (moduleGroupEntity != null && groupPathList != null) {
                    this.getDiff().modifyEntity(ModifiableModuleGroupPathEntity.class, (TypedEntity)moduleGroupEntity, (Function1)new Function1<ModifiableModuleGroupPathEntity, Unit>(groupPathList){
                        final /* synthetic */ List $groupPathList;

                        public final void invoke(@NotNull ModifiableModuleGroupPathEntity $this$modifyEntity) {
                            Intrinsics.checkParameterIsNotNull((Object)$this$modifyEntity, (String)"$receiver");
                            $this$modifyEntity.setPath(this.$groupPathList);
                        }
                        {
                            this.$groupPathList = list2;
                            super(1);
                        }
                    });
                } else {
                    String string = "Should not be reached";
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
            }
        }
    }

    public LegacyBridgeModifiableModuleModel(@NotNull Project project, @NotNull LegacyBridgeModuleManagerComponent moduleManager, @NotNull TypedEntityStorageBuilder diff) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)moduleManager), (String)"moduleManager");
        Intrinsics.checkParameterIsNotNull((Object)diff, (String)"diff");
        super(diff);
        this.project = project;
        this.moduleManager = moduleManager;
        this.myModulesToAdd = HashBiMap.create();
        this.myModulesToDispose = HashBiMap.create();
        this.myNewNameToModule = HashBiMap.create();
    }
}

