/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.validation.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.Language;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiElement;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Alarm;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.BitSet;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.intellij.lang.xpath.XPathFileType;
import org.intellij.lang.xpath.context.ContextProvider;
import org.intellij.lang.xpath.psi.XPathExpression;
import org.intellij.lang.xpath.psi.XPathFunctionCall;
import org.intellij.lang.xpath.psi.XPathType;
import org.intellij.lang.xpath.validation.ExpectedTypeUtil;
import org.intellij.lang.xpath.validation.inspections.XPathInspection;
import org.intellij.lang.xpath.validation.inspections.quickfix.XPathQuickFixFactory;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImplicitTypeConversion
extends XPathInspection {
    @NonNls
    private static final String SHORT_NAME = "ImplicitTypeConversion";
    public long BITS = 1720L;
    private final BitSet OPTIONS = new BitSet(12);
    public boolean FLAG_EXPLICIT_CONVERSION = true;
    public boolean IGNORE_NODESET_TO_BOOLEAN_VIA_STRING = true;

    public ImplicitTypeConversion() {
        this.update();
    }

    private void update() {
        for (int i = 0; i < 12; ++i) {
            boolean b = (this.BITS & (long)(1 << i)) != 0L;
            this.OPTIONS.set(i, b);
        }
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return SHORT_NAME;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    protected XPathInspection.Visitor createVisitor(InspectionManager manager, boolean isOnTheFly) {
        return new MyElementVisitor(manager, isOnTheFly);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new Options();
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            ImplicitTypeConversion.$$$reportNull$$$0(0);
        }
        super.readSettings(node);
        this.update();
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            ImplicitTypeConversion.$$$reportNull$$$0(1);
        }
        this.BITS = 0L;
        for (int i = 11; i >= 0; --i) {
            this.BITS <<= 1;
            if (!this.OPTIONS.get(i)) continue;
            this.BITS |= 1L;
        }
        super.writeSettings(node);
    }

    @Override
    protected boolean acceptsLanguage(Language language) {
        return language == XPathFileType.XPATH.getLanguage();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "node";
        objectArray2[1] = "org/intellij/lang/xpath/validation/inspections/ImplicitTypeConversion";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "readSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "writeSettings";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public class Options
    extends JPanel {
        private JPanel root;
        private JCheckBox NS_S;
        private JCheckBox NS_N;
        private JCheckBox NS_B;
        private JCheckBox S_S;
        private JCheckBox S_N;
        private JCheckBox S_B;
        private JCheckBox N_S;
        private JCheckBox N_N;
        private JCheckBox N_B;
        private JCheckBox B_S;
        private JCheckBox B_N;
        private JCheckBox B_B;
        private JCheckBox myAlwaysFlagExplicitConversion;
        private JCheckBox myIgnoreNodesetToString;
        private final JCheckBox[][] matrix;

        public Options() {
            JCheckBox[][] jCheckBoxArrayArray = new JCheckBox[3][];
            JCheckBox[] jCheckBoxArray = new JCheckBox[4];
            this.$$$setupUI$$$();
            jCheckBoxArray[0] = this.NS_S;
            jCheckBoxArray[1] = this.S_S;
            jCheckBoxArray[2] = this.N_S;
            jCheckBoxArray[3] = this.B_S;
            jCheckBoxArrayArray[0] = jCheckBoxArray;
            jCheckBoxArrayArray[1] = new JCheckBox[]{this.NS_N, this.S_N, this.N_N, this.B_N};
            jCheckBoxArrayArray[2] = new JCheckBox[]{this.NS_B, this.S_B, this.N_B, this.B_B};
            this.matrix = jCheckBoxArrayArray;
            for (int i = 0; i < this.matrix.length; ++i) {
                JCheckBox[] row = this.matrix[i];
                for (int j = 0; j < row.length; ++j) {
                    JCheckBox to = row[j];
                    final int index = row.length * i + j;
                    to.setSelected(ImplicitTypeConversion.this.OPTIONS.get(index));
                    to.addItemListener(new ItemListener(){

                        @Override
                        public void itemStateChanged(ItemEvent e) {
                            ImplicitTypeConversion.this.OPTIONS.set(index, e.getStateChange() == 1);
                        }
                    });
                    if (j != i + 1) continue;
                    to.setEnabled(false);
                }
            }
            this.myAlwaysFlagExplicitConversion.setSelected(ImplicitTypeConversion.this.FLAG_EXPLICIT_CONVERSION);
            this.myAlwaysFlagExplicitConversion.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ImplicitTypeConversion.this.FLAG_EXPLICIT_CONVERSION = e.getStateChange() == 1;
                }
            });
            this.myIgnoreNodesetToString.setSelected(ImplicitTypeConversion.this.IGNORE_NODESET_TO_BOOLEAN_VIA_STRING);
            this.myIgnoreNodesetToString.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ImplicitTypeConversion.this.IGNORE_NODESET_TO_BOOLEAN_VIA_STRING = e.getStateChange() == 1;
                }
            });
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            new Alarm().addRequest(() -> {
                for (int i = 0; i < this.matrix.length; ++i) {
                    JCheckBox[] row = this.matrix[i];
                    for (int j = 0; j < row.length; ++j) {
                        JCheckBox to = row[j];
                        to.setEnabled(enabled && j != i + 1);
                    }
                }
            }, 200);
        }

        private void createUIComponents() {
            this.root = this;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JCheckBox jCheckBox;
            JCheckBox jCheckBox2;
            JCheckBox jCheckBox3;
            JCheckBox jCheckBox4;
            JCheckBox jCheckBox5;
            JCheckBox jCheckBox6;
            JCheckBox jCheckBox7;
            JCheckBox jCheckBox8;
            JCheckBox jCheckBox9;
            JCheckBox jCheckBox10;
            JCheckBox jCheckBox11;
            JCheckBox jCheckBox12;
            JCheckBox jCheckBox13;
            JCheckBox jCheckBox14;
            this.createUIComponents();
            JPanel jPanel = this.root;
            jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 6, new Insets(10, 10, 0, 0), -1, -1, false, false));
            this.NS_S = jCheckBox14 = new JCheckBox();
            jCheckBox14.setText("");
            jPanel.add((Component)jCheckBox14, new GridConstraints(1, 1, 1, 1, 0, 0, 3, 0, null, null, null));
            this.S_S = jCheckBox13 = new JCheckBox();
            ((Component)jCheckBox13).setEnabled(false);
            jCheckBox13.setText("");
            jPanel.add((Component)jCheckBox13, new GridConstraints(1, 2, 1, 1, 0, 0, 3, 0, null, null, null));
            this.N_S = jCheckBox12 = new JCheckBox();
            jCheckBox12.setText("");
            jPanel.add((Component)jCheckBox12, new GridConstraints(1, 3, 1, 1, 0, 0, 3, 0, null, null, null));
            this.B_S = jCheckBox11 = new JCheckBox();
            jCheckBox11.setText("");
            jPanel.add((Component)jCheckBox11, new GridConstraints(1, 4, 1, 1, 0, 0, 3, 0, null, null, null));
            this.NS_N = jCheckBox10 = new JCheckBox();
            jCheckBox10.setText("");
            jPanel.add((Component)jCheckBox10, new GridConstraints(2, 1, 1, 1, 0, 0, 3, 0, null, null, null));
            this.S_N = jCheckBox9 = new JCheckBox();
            jCheckBox9.setText("");
            jPanel.add((Component)jCheckBox9, new GridConstraints(2, 2, 1, 1, 0, 0, 3, 0, null, null, null));
            this.N_N = jCheckBox8 = new JCheckBox();
            ((Component)jCheckBox8).setEnabled(false);
            jCheckBox8.setText("");
            jPanel.add((Component)jCheckBox8, new GridConstraints(2, 3, 1, 1, 0, 0, 3, 0, null, null, null));
            this.B_N = jCheckBox7 = new JCheckBox();
            jCheckBox7.setText("");
            jPanel.add((Component)jCheckBox7, new GridConstraints(2, 4, 1, 1, 0, 0, 3, 0, null, null, null));
            this.NS_B = jCheckBox6 = new JCheckBox();
            jCheckBox6.setText("");
            jPanel.add((Component)jCheckBox6, new GridConstraints(3, 1, 1, 1, 0, 0, 3, 0, null, null, null));
            this.S_B = jCheckBox5 = new JCheckBox();
            jCheckBox5.setText("");
            jPanel.add((Component)jCheckBox5, new GridConstraints(3, 2, 1, 1, 0, 0, 3, 0, null, null, null));
            this.N_B = jCheckBox4 = new JCheckBox();
            jCheckBox4.setText("");
            jPanel.add((Component)jCheckBox4, new GridConstraints(3, 3, 1, 1, 0, 0, 3, 0, null, null, null));
            this.B_B = jCheckBox3 = new JCheckBox();
            ((Component)jCheckBox3).setEnabled(false);
            jCheckBox3.setText("");
            jPanel.add((Component)jCheckBox3, new GridConstraints(3, 4, 1, 1, 0, 0, 3, 0, null, null, null));
            JLabel jLabel = new JLabel();
            jLabel.setText("NODESET");
            jPanel.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 1, 0, 0, 0, null, null, null));
            JLabel jLabel2 = new JLabel();
            jLabel2.setText("STRING");
            jPanel.add((Component)jLabel2, new GridConstraints(0, 2, 1, 1, 9, 0, 0, 0, null, null, null));
            JLabel jLabel3 = new JLabel();
            jLabel3.setText("NUMBER");
            jPanel.add((Component)jLabel3, new GridConstraints(0, 3, 1, 1, 9, 0, 0, 0, null, null, null));
            JLabel jLabel4 = new JLabel();
            jLabel4.setText("BOOLEAN");
            jPanel.add((Component)jLabel4, new GridConstraints(0, 4, 1, 1, 9, 0, 0, 0, null, null, null));
            JLabel jLabel5 = new JLabel();
            jLabel5.setText("STRING");
            jPanel.add((Component)jLabel5, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            JLabel jLabel6 = new JLabel();
            jLabel6.setText("NUMBER");
            jPanel.add((Component)jLabel6, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            JLabel jLabel7 = new JLabel();
            jLabel7.setText("BOOLEAN");
            jPanel.add((Component)jLabel7, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(0, 5, 1, 1, 0, 1, 6, 1, null, null, null));
            Spacer spacer2 = new Spacer();
            jPanel.add((Component)spacer2, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            JLabel jLabel8 = new JLabel();
            jLabel8.setText("<html>From <hr> <center>To</center></html>");
            jPanel.add((Component)jLabel8, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 6, new Insets(10, 0, 0, 0), -1, -1, false, false));
            jPanel.add((Component)jPanel2, new GridConstraints(4, 0, 1, 6, 0, 3, 3, 3, null, null, null));
            this.myAlwaysFlagExplicitConversion = jCheckBox2 = new JCheckBox();
            jCheckBox2.setText("Always flag explicit conversion to unexpected type");
            jCheckBox2.setMnemonic('A');
            jCheckBox2.setDisplayedMnemonicIndex(0);
            jPanel2.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 6, 8, 0, 3, 0, null, null, null));
            this.myIgnoreNodesetToString = jCheckBox = new JCheckBox();
            jCheckBox.setText("Ignore conversion of NODESET to BOOLEAN by string()-conversion");
            jCheckBox.setMnemonic('I');
            jCheckBox.setDisplayedMnemonicIndex(0);
            jPanel2.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 6, 8, 0, 3, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.root;
        }
    }

    final class MyElementVisitor
    extends XPathInspection.Visitor {
        MyElementVisitor(InspectionManager manager, boolean isOnTheFly) {
            super(manager, isOnTheFly);
        }

        @Override
        protected void checkExpression(@NotNull XPathExpression expression) {
            XPathType expectedType;
            if (expression == null) {
                MyElementVisitor.$$$reportNull$$$0(0);
            }
            if ((expectedType = ExpectedTypeUtil.getExpectedType(expression)) != XPathType.NODESET && expectedType != XPathType.UNKNOWN) {
                boolean isExplicit = ImplicitTypeConversion.this.FLAG_EXPLICIT_CONVERSION && ExpectedTypeUtil.isExplicitConversion(expression);
                this.checkExpressionOfType(expression, expectedType, isExplicit);
            }
        }

        private void checkExpressionOfType(@NotNull XPathExpression expression, XPathType type, boolean explicit) {
            XPathType exprType;
            if (expression == null) {
                MyElementVisitor.$$$reportNull$$$0(1);
            }
            if ((exprType = expression.getType()).isAbstract() || type.isAbstract()) {
                return;
            }
            if (exprType != type && (explicit || this.isCheckedConversion(exprType, type))) {
                XPathQuickFixFactory.Fix<XPathExpression>[] fixes;
                XPathExpression expr;
                if (explicit && exprType == XPathType.STRING && type == XPathType.BOOLEAN && (expr = ExpectedTypeUtil.unparenthesize(expression)) instanceof XPathFunctionCall && ImplicitTypeConversion.this.IGNORE_NODESET_TO_BOOLEAN_VIA_STRING && ((XPathFunctionCall)expr).getArgumentList()[0].getType() == XPathType.NODESET) {
                    return;
                }
                if (type != XPathType.NODESET) {
                    XPathQuickFixFactory fixFactory = ContextProvider.getContextProvider(expression).getQuickFixFactory();
                    explicit = explicit && (exprType != XPathType.STRING || type != XPathType.BOOLEAN);
                    fixes = fixFactory.createImplicitTypeConversionFixes(expression, type, explicit);
                } else {
                    fixes = null;
                }
                this.addProblem(this.myManager.createProblemDescriptor((PsiElement)expression, "Expression should be of type '" + type.getName() + "'", this.myOnTheFly, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
            }
        }

        private boolean isCheckedConversion(XPathType exprType, XPathType type) {
            if (exprType == XPathType.NODESET) {
                if (type == XPathType.STRING && ImplicitTypeConversion.this.OPTIONS.get(0)) {
                    return true;
                }
                if (type == XPathType.NUMBER && ImplicitTypeConversion.this.OPTIONS.get(4)) {
                    return true;
                }
                if (type == XPathType.BOOLEAN && ImplicitTypeConversion.this.OPTIONS.get(8)) {
                    return true;
                }
            } else if (exprType == XPathType.STRING) {
                if (type == XPathType.NUMBER && ImplicitTypeConversion.this.OPTIONS.get(5)) {
                    return true;
                }
                if (type == XPathType.BOOLEAN && ImplicitTypeConversion.this.OPTIONS.get(9)) {
                    return true;
                }
            } else if (exprType == XPathType.NUMBER) {
                if (type == XPathType.STRING && ImplicitTypeConversion.this.OPTIONS.get(2)) {
                    return true;
                }
                if (type == XPathType.BOOLEAN && ImplicitTypeConversion.this.OPTIONS.get(10)) {
                    return true;
                }
            } else if (exprType == XPathType.BOOLEAN) {
                if (type == XPathType.STRING && ImplicitTypeConversion.this.OPTIONS.get(3)) {
                    return true;
                }
                if (type == XPathType.NUMBER && ImplicitTypeConversion.this.OPTIONS.get(11)) {
                    return true;
                }
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "org/intellij/lang/xpath/validation/inspections/ImplicitTypeConversion$MyElementVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkExpressionOfType";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

