/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.associations.impl;

import com.intellij.ide.projectView.ProjectView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.intellij.lang.xpath.xslt.associations.FileAssociationsManager;
import org.intellij.lang.xpath.xslt.associations.impl.TempManager;
import org.intellij.lang.xpath.xslt.associations.impl.TransactionalManager;
import org.jdom.Element;

@State(name="XSLT-Support.FileAssociationsManager", storages={@Storage(value="other.xml")})
final class FileAssociationsManagerImpl
extends FileAssociationsManager
implements Disposable,
JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance(FileAssociationsManagerImpl.class);
    private final Project myProject;
    private final Map<VirtualFilePointer, VirtualFilePointerContainer> myAssociations;
    private boolean myTempCopy;

    FileAssociationsManagerImpl(Project project) {
        this.myProject = project;
        this.myAssociations = new LinkedHashMap<VirtualFilePointer, VirtualFilePointerContainer>();
    }

    public void markAsTempCopy() {
        this.myTempCopy = true;
    }

    public void readExternal(Element element) throws InvalidDataException {
        List children = element.getChildren("file");
        VirtualFilePointerManager filePointerManager = VirtualFilePointerManager.getInstance();
        for (Element child : children) {
            String url = child.getAttributeValue("url");
            if (url == null) continue;
            VirtualFilePointer pointer = filePointerManager.create(url, (Disposable)this.myProject, null);
            VirtualFilePointerContainer container = filePointerManager.createContainer((Disposable)this.myProject);
            container.readExternal(child, "association", false);
            this.myAssociations.put(pointer, container);
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        for (VirtualFilePointer pointer : this.myAssociations.keySet()) {
            Element e = new Element("file");
            e.setAttribute("url", pointer.getUrl());
            VirtualFilePointerContainer container = this.myAssociations.get(pointer);
            container.writeExternal(e, "association", false);
            element.addContent(e);
        }
    }

    public TransactionalManager getTempManager() {
        return new TempManager(this, this.myProject);
    }

    public void dispose() {
        this.clear();
    }

    private void clear() {
        Set<VirtualFilePointer> virtualFilePointers = this.myAssociations.keySet();
        for (VirtualFilePointer pointer : virtualFilePointers) {
            this.myAssociations.get(pointer).killAll();
        }
        this.myAssociations.clear();
    }

    void copyFrom(FileAssociationsManagerImpl source) {
        this.clear();
        this.myAssociations.putAll(FileAssociationsManagerImpl.copy(source));
        this.touch();
    }

    private void touch() {
        ProjectView view;
        this.incModificationCount();
        if (!this.myTempCopy && (view = ProjectView.getInstance((Project)this.myProject)) != null) {
            view.refresh();
        }
    }

    private static HashMap<VirtualFilePointer, VirtualFilePointerContainer> copy(FileAssociationsManagerImpl other) {
        LinkedHashMap<VirtualFilePointer, VirtualFilePointerContainer> hashMap = new LinkedHashMap<VirtualFilePointer, VirtualFilePointerContainer>();
        Set<VirtualFilePointer> virtualFilePointers = other.myAssociations.keySet();
        VirtualFilePointerManager filePointerManager = VirtualFilePointerManager.getInstance();
        for (VirtualFilePointer pointer : virtualFilePointers) {
            VirtualFilePointerContainer container = filePointerManager.createContainer((Disposable)other.myProject);
            container.addAll(other.myAssociations.get(pointer));
            hashMap.put(filePointerManager.duplicate(pointer, (Disposable)other.myProject, null), container);
        }
        return hashMap;
    }

    @Override
    public void removeAssociations(PsiFile file) {
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        for (VirtualFilePointer pointer : this.myAssociations.keySet()) {
            if (!pointer.getUrl().equals(virtualFile.getUrl())) continue;
            this.myAssociations.remove(pointer);
            this.touch();
            return;
        }
    }

    @Override
    public void removeAssociation(PsiFile file, PsiFile assoc) {
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        if (assoc.getVirtualFile() == null) {
            return;
        }
        for (VirtualFilePointer pointer : this.myAssociations.keySet()) {
            VirtualFilePointer p;
            if (!pointer.getUrl().equals(virtualFile.getUrl())) continue;
            VirtualFilePointerContainer container = this.myAssociations.get(pointer);
            if (container != null && (p = container.findByUrl(assoc.getVirtualFile().getUrl())) != null) {
                container.remove(p);
                if (container.size() == 0) {
                    this.myAssociations.remove(pointer);
                }
                this.touch();
            }
            return;
        }
    }

    @Override
    public void addAssociation(PsiFile file, PsiFile assoc) {
        VirtualFile virtualFile = assoc.getVirtualFile();
        if (virtualFile == null) {
            LOG.warn("No VirtualFile for " + file.getName());
            return;
        }
        this.addAssociation(file, virtualFile);
    }

    @Override
    public void addAssociation(PsiFile file, VirtualFile assoc) {
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            LOG.warn("No VirtualFile for " + file.getName());
            return;
        }
        VirtualFilePointerManager filePointerManager = VirtualFilePointerManager.getInstance();
        for (VirtualFilePointer pointer : this.myAssociations.keySet()) {
            if (!pointer.getUrl().equals(virtualFile.getUrl())) continue;
            VirtualFilePointerContainer container = this.myAssociations.get(pointer);
            if (container == null) {
                container = filePointerManager.createContainer((Disposable)this.myProject);
                this.myAssociations.put(pointer, container);
            }
            if (container.findByUrl(assoc.getUrl()) == null) {
                container.add(assoc);
                this.touch();
            }
            return;
        }
        VirtualFilePointerContainer container = filePointerManager.createContainer((Disposable)this.myProject);
        container.add(assoc);
        this.myAssociations.put(filePointerManager.create(virtualFile, (Disposable)this.myProject, null), container);
        this.touch();
    }

    @Override
    public Map<VirtualFile, VirtualFile[]> getAssociations() {
        LinkedHashMap<VirtualFile, VirtualFile[]> map = new LinkedHashMap<VirtualFile, VirtualFile[]>();
        Set<VirtualFilePointer> set = this.myAssociations.keySet();
        for (VirtualFilePointer pointer : set) {
            if (!pointer.isValid()) continue;
            VirtualFile file = pointer.getFile();
            map.put(file, this.myAssociations.get(pointer).getFiles());
        }
        return map;
    }

    @Override
    public PsiFile[] getAssociationsFor(PsiFile file) {
        return this.getAssociationsFor(file, FileType.EMPTY_ARRAY);
    }

    @Override
    public PsiFile[] getAssociationsFor(PsiFile file, FileType ... fileTypes) {
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return PsiFile.EMPTY_ARRAY;
        }
        for (VirtualFilePointer pointer : this.myAssociations.keySet()) {
            if (!pointer.isValid() || !pointer.getUrl().equals(virtualFile.getUrl())) continue;
            VirtualFilePointerContainer container = this.myAssociations.get(pointer);
            if (container != null) {
                VirtualFile[] files = container.getFiles();
                HashSet<PsiFile> list = new HashSet<PsiFile>();
                PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
                for (VirtualFile assoc : files) {
                    PsiFile psiFile = psiManager.findFile(assoc);
                    if (psiFile == null || fileTypes.length != 0 && !FileAssociationsManagerImpl.matchesFileType(psiFile, fileTypes)) continue;
                    list.add(psiFile);
                }
                return PsiUtilCore.toPsiFileArray(list);
            }
            return PsiFile.EMPTY_ARRAY;
        }
        return PsiFile.EMPTY_ARRAY;
    }

    private static boolean matchesFileType(PsiFile psiFile, FileType ... fileTypes) {
        for (FileType fileType : fileTypes) {
            if (!psiFile.getFileType().equals(fileType)) continue;
            return true;
        }
        return false;
    }
}

