/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.impl;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.include.FileIncludeInfo;
import com.intellij.psi.impl.include.FileIncludeProvider;
import com.intellij.util.Consumer;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.xml.NanoXmlBuilder;
import com.intellij.util.xml.NanoXmlUtil;
import java.io.Reader;
import java.util.ArrayList;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.annotations.NotNull;

public class XsltIncludeProvider
extends FileIncludeProvider {
    @NotNull
    public String getId() {
        return "xslt";
    }

    public boolean acceptFile(VirtualFile file) {
        return FileTypeRegistry.getInstance().isFileOfType(file, (FileType)XmlFileType.INSTANCE);
    }

    public void registerFileTypesUsedForIndexing(@NotNull Consumer<FileType> fileTypeSink) {
        if (fileTypeSink == null) {
            XsltIncludeProvider.$$$reportNull$$$0(0);
        }
        fileTypeSink.consume((Object)XmlFileType.INSTANCE);
    }

    public FileIncludeInfo @NotNull [] getIncludeInfos(FileContent content) {
        CharSequence contentAsText = content.getContentAsText();
        if (CharArrayUtil.indexOf((CharSequence)contentAsText, (CharSequence)"http://www.w3.org/1999/XSL/Transform", (int)0) == -1) {
            if (FileIncludeInfo.EMPTY == null) {
                XsltIncludeProvider.$$$reportNull$$$0(1);
            }
            return FileIncludeInfo.EMPTY;
        }
        final ArrayList infos = new ArrayList();
        NanoXmlBuilder builder = new NanoXmlBuilder(){
            boolean isXslt;
            boolean isInclude;

            public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) throws Exception {
                boolean isXsltTag = "http://www.w3.org/1999/XSL/Transform".equals(nsURI);
                if (!this.isXslt) {
                    if (!isXsltTag) {
                        throw NanoXmlUtil.ParserStoppedXmlException.INSTANCE;
                    }
                    this.isXslt = true;
                }
                this.isInclude = isXsltTag && ("include".equals(name) || "import".equals(name));
            }

            public void addAttribute(String key, String nsPrefix, String nsURI, String value, String type) {
                if (this.isInclude && "href".equals(key)) {
                    infos.add(new FileIncludeInfo(value));
                }
            }

            public void endElement(String name, String nsPrefix, String nsURI) {
                this.isInclude = false;
            }
        };
        NanoXmlUtil.parse((Reader)CharArrayUtil.readerFromCharSequence((CharSequence)contentAsText), (IXMLBuilder)builder);
        FileIncludeInfo[] fileIncludeInfoArray = infos.toArray(FileIncludeInfo.EMPTY);
        if (fileIncludeInfoArray == null) {
            XsltIncludeProvider.$$$reportNull$$$0(2);
        }
        return fileIncludeInfoArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypeSink";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/xslt/impl/XsltIncludeProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/xslt/impl/XsltIncludeProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludeInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerFileTypesUsedForIndexing";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

