/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.refactoring;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XsltRefactoringActionBase
implements RefactoringActionHandler {
    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            XsltRefactoringActionBase.$$$reportNull$$$0(0);
        }
        int offset = editor.getCaretModel().getOffset();
        XmlAttribute context = (XmlAttribute)PsiTreeUtil.getContextOfType((PsiElement)file, XmlAttribute.class, (boolean)true);
        if (context != null && this.actionPerformedImpl(file, editor, context, offset)) {
            return;
        }
        String message = this.getErrorMessage(editor, file, context);
        CommonRefactoringUtil.showErrorHint((Project)editor.getProject(), (Editor)editor, (String)("Cannot perform refactoring.\n" + (message != null ? message : this.getRefactoringName() + " is not available in the current context.")), (String)("XSLT - " + this.getRefactoringName()), null);
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            XsltRefactoringActionBase.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            XsltRefactoringActionBase.$$$reportNull$$$0(2);
        }
        throw new UnsupportedOperationException();
    }

    @Nullable
    public String getErrorMessage(Editor editor, PsiFile file, XmlAttribute context) {
        return null;
    }

    public abstract String getRefactoringName();

    protected abstract boolean actionPerformedImpl(PsiFile var1, Editor var2, XmlAttribute var3, int var4);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "elements";
                break;
            }
        }
        objectArray[1] = "org/intellij/lang/xpath/xslt/refactoring/XsltRefactoringActionBase";
        objectArray[2] = "invoke";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

