/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.validation.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.HashMap;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.psi.XsltApplyTemplates;
import org.intellij.lang.xpath.xslt.psi.XsltCallTemplate;
import org.intellij.lang.xpath.xslt.psi.XsltElementFactory;
import org.intellij.lang.xpath.xslt.psi.XsltParameter;
import org.intellij.lang.xpath.xslt.psi.XsltTemplate;
import org.intellij.lang.xpath.xslt.psi.XsltTemplateInvocation;
import org.intellij.lang.xpath.xslt.psi.XsltWithParam;
import org.intellij.lang.xpath.xslt.quickfix.AbstractFix;
import org.intellij.lang.xpath.xslt.quickfix.AddParameterFix;
import org.intellij.lang.xpath.xslt.quickfix.AddWithParamFix;
import org.intellij.lang.xpath.xslt.quickfix.RemoveParamFix;
import org.intellij.lang.xpath.xslt.validation.inspections.XsltInspection;
import org.jetbrains.annotations.NotNull;

public class TemplateInvocationInspection
extends XsltInspection {
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            TemplateInvocationInspection.$$$reportNull$$$0(0);
        }
        return highlightDisplayLevel;
    }

    @NotNull
    public String getShortName() {
        return "XsltTemplateInvocation";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            TemplateInvocationInspection.$$$reportNull$$$0(1);
        }
        if (!(holder.getFile() instanceof XmlFile)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                TemplateInvocationInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        final XsltElementFactory xsltElementFactory = XsltElementFactory.getInstance();
        return new XmlElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                if (XsltSupport.isTemplateCall(tag)) {
                    XsltCallTemplate call = xsltElementFactory.wrapElement(tag, XsltCallTemplate.class);
                    TemplateInvocationInspection.checkTemplateInvocation(call, holder, isOnTheFly);
                } else if (XsltSupport.isApplyTemplates(tag)) {
                    XsltApplyTemplates call = xsltElementFactory.wrapElement(tag, XsltApplyTemplates.class);
                    TemplateInvocationInspection.checkTemplateInvocation(call, holder, isOnTheFly);
                }
            }
        };
    }

    private static void checkTemplateInvocation(XsltTemplateInvocation call, ProblemsHolder holder, boolean onTheFly) {
        XsltWithParam[] arguments = call.getArguments();
        HashMap<String, XsltWithParam> argNames = new HashMap<String, XsltWithParam>();
        for (XsltWithParam arg : arguments) {
            XsltParameter[] attr = arg.getNameAttribute();
            if (attr == null) continue;
            String name = attr.getValue();
            if (argNames.containsKey(name)) {
                PsiElement token = arg.getNameIdentifier();
                assert (token != null);
                holder.registerProblem(token, "Duplicate Argument '" + name + "'", new LocalQuickFix[0]);
            }
            argNames.put(name, arg);
        }
        if (call instanceof XsltCallTemplate) {
            XsltCallTemplate ct = (XsltCallTemplate)call;
            PsiElement nameToken = ct.getNameIdentifier();
            XsltTemplate template = ct.getTemplate();
            if (template != null) {
                if (nameToken != null) {
                    XsltParameter[] parameters;
                    for (XsltParameter parameter : parameters = template.getParameters()) {
                        if (argNames.containsKey(parameter.getName()) || parameter.hasDefault()) continue;
                        LocalQuickFix fix = new AddWithParamFix(parameter, call.getTag()).createQuickFix(onTheFly);
                        holder.registerProblem(nameToken, "Missing template parameter: " + parameter.getName(), AbstractFix.createFixes(fix));
                    }
                }
                for (String s : argNames.keySet()) {
                    XmlAttribute argAttribute = ((XsltWithParam)argNames.get(s)).getNameAttribute();
                    assert (argAttribute != null);
                    XmlAttributeValue valueElement = argAttribute.getValueElement();
                    PsiElement valueToken = XsltSupport.getAttValueToken(argAttribute);
                    if (valueToken != null && s.trim().length() > 0) {
                        if (template.getParameter(s) != null) continue;
                        LocalQuickFix fix1 = new AddParameterFix(s, template).createQuickFix(onTheFly);
                        LocalQuickFix fix2 = new RemoveParamFix(((XsltWithParam)argNames.get(s)).getTag(), s).createQuickFix(onTheFly);
                        holder.registerProblem(valueToken, "Undeclared template parameter: " + s, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, AbstractFix.createFixes(fix1, fix2));
                        continue;
                    }
                    if (valueElement == null) continue;
                    holder.registerProblem((PsiElement)valueElement, "Parameter name expected", new LocalQuickFix[0]);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/xslt/validation/inspections/TemplateInvocationInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/xslt/validation/inspections/TemplateInvocationInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

