/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.fs.CompilationRound;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.kotlin.incremental.storage.FileToPathConverter;
import org.jetbrains.kotlin.jps.build.HasKotlinMarker;
import org.jetbrains.kotlin.jps.build.JpsFileToPathConverter;
import org.jetbrains.kotlin.jps.build.KotlinBuilder;
import org.jetbrains.kotlin.jps.build.KotlinChunk;
import org.jetbrains.kotlin.jps.build.KotlinCompileContext;
import org.jetbrains.kotlin.jps.build.KotlinCompileContext$WhenMappings;
import org.jetbrains.kotlin.jps.build.KotlinCompileContextKt;
import org.jetbrains.kotlin.jps.build.KotlinDirtySourceFilesHolderKt;
import org.jetbrains.kotlin.jps.build.RebuildAfterCacheVersionChangeMarker;
import org.jetbrains.kotlin.jps.build.TestingBuildLogger;
import org.jetbrains.kotlin.jps.build.TestingContext;
import org.jetbrains.kotlin.jps.build.TestingContextKt;
import org.jetbrains.kotlin.jps.incremental.CacheAttributesDiff;
import org.jetbrains.kotlin.jps.incremental.CacheAttributesManager;
import org.jetbrains.kotlin.jps.incremental.CacheAttributesManagerKt;
import org.jetbrains.kotlin.jps.incremental.CacheStatus;
import org.jetbrains.kotlin.jps.incremental.CompositeLookupsCacheAttributes;
import org.jetbrains.kotlin.jps.incremental.CompositeLookupsCacheAttributesManager;
import org.jetbrains.kotlin.jps.incremental.JpsIncrementalCache;
import org.jetbrains.kotlin.jps.incremental.JpsIncrementalCacheKt;
import org.jetbrains.kotlin.jps.incremental.JpsLookupStorageManager;
import org.jetbrains.kotlin.jps.incremental.KotlinDataContainerTarget;
import org.jetbrains.kotlin.jps.targets.KotlinModuleBuildTarget;
import org.jetbrains.kotlin.jps.targets.KotlinTargetsIndex;
import org.jetbrains.kotlin.jps.targets.KotlinTargetsIndexBuilder;
import org.jetbrains.kotlin.jps.targets.KotlinUnsupportedModuleBuildTarget;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010A\u001a\u00020BJ\u000e\u0010C\u001a\u00020B2\u0006\u0010D\u001a\u00020EJ\u0006\u0010F\u001a\u00020BJ\b\u0010G\u001a\u00020BH\u0002J\b\u0010H\u001a\u00020BH\u0002J\u0006\u0010I\u001a\u00020BJ\u0006\u0010J\u001a\u00020BJ\u0010\u0010K\u001a\u0004\u0018\u00010E2\u0006\u0010L\u001a\u00020MJ\u0006\u0010N\u001a\u00020\u0019J\u000e\u0010O\u001a\b\u0012\u0004\u0012\u00020P0\u0017H\u0002J\u0018\u0010Q\u001a\u00020\u00192\u0006\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020\u0019H\u0002J\b\u0010U\u001a\u00020&H\u0002J\u0010\u0010V\u001a\u00020B2\u0006\u0010W\u001a\u00020XH\u0002J\u0010\u0010Y\u001a\u00020B2\u0006\u0010D\u001a\u00020EH\u0002J\u0006\u0010Z\u001a\u00020BR\u0019\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0019\u0010\n\u001a\n \u0007*\u0004\u0018\u00010\u000b0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0012\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0018\u001a\u00020\u00198FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0018\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u001a\"\u0004\b/\u00100R\u0011\u00101\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\u001aR!\u00103\u001a\u0012\u0012\u0004\u0012\u000205\u0012\b\u0012\u0006\u0012\u0002\b\u000306048F\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u0011\u00109\u001a\u00020:\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<R\u0013\u0010=\u001a\u0004\u0018\u00010>8F\u00a2\u0006\u0006\u001a\u0004\b?\u0010@\u00a8\u0006["}, d2={"Lorg/jetbrains/kotlin/jps/build/KotlinCompileContext;", "", "jpsContext", "Lorg/jetbrains/jps/incremental/CompileContext;", "(Lorg/jetbrains/jps/incremental/CompileContext;)V", "dataManager", "Lorg/jetbrains/jps/incremental/storage/BuildDataManager;", "kotlin.jvm.PlatformType", "getDataManager", "()Lorg/jetbrains/jps/incremental/storage/BuildDataManager;", "dataPaths", "Lorg/jetbrains/jps/builders/storage/BuildDataPaths;", "getDataPaths", "()Lorg/jetbrains/jps/builders/storage/BuildDataPaths;", "fileToPathConverter", "Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;", "getFileToPathConverter", "()Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;", "hasKotlinMarker", "Lorg/jetbrains/kotlin/jps/build/HasKotlinMarker;", "getHasKotlinMarker", "()Lorg/jetbrains/kotlin/jps/build/HasKotlinMarker;", "initialLookupsCacheStateDiff", "Lorg/jetbrains/kotlin/jps/incremental/CacheAttributesDiff;", "isInstrumentationEnabled", "", "()Z", "isInstrumentationEnabled$delegate", "Lkotlin/Lazy;", "getJpsContext", "()Lorg/jetbrains/jps/incremental/CompileContext;", "lookupAttributesSaved", "Ljava/util/concurrent/atomic/AtomicBoolean;", "lookupStorageManager", "Lorg/jetbrains/kotlin/jps/incremental/JpsLookupStorageManager;", "getLookupStorageManager", "()Lorg/jetbrains/kotlin/jps/incremental/JpsLookupStorageManager;", "lookupsCacheAttributesManager", "Lorg/jetbrains/kotlin/jps/incremental/CompositeLookupsCacheAttributesManager;", "getLookupsCacheAttributesManager", "()Lorg/jetbrains/kotlin/jps/incremental/CompositeLookupsCacheAttributesManager;", "rebuildAfterCacheVersionChanged", "Lorg/jetbrains/kotlin/jps/build/RebuildAfterCacheVersionChangeMarker;", "getRebuildAfterCacheVersionChanged", "()Lorg/jetbrains/kotlin/jps/build/RebuildAfterCacheVersionChangeMarker;", "rebuildingAllKotlin", "getRebuildingAllKotlin", "setRebuildingAllKotlin", "(Z)V", "shouldCheckCacheVersions", "getShouldCheckCacheVersions", "targetsBinding", "", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget;", "getTargetsBinding", "()Ljava/util/Map;", "targetsIndex", "Lorg/jetbrains/kotlin/jps/targets/KotlinTargetsIndex;", "getTargetsIndex", "()Lorg/jetbrains/kotlin/jps/targets/KotlinTargetsIndex;", "testingLogger", "Lorg/jetbrains/kotlin/jps/build/TestingBuildLogger;", "getTestingLogger", "()Lorg/jetbrains/kotlin/jps/build/TestingBuildLogger;", "checkCacheVersions", "", "checkChunkCacheVersion", "chunk", "Lorg/jetbrains/kotlin/jps/build/KotlinChunk;", "cleanupCaches", "clearAllCaches", "clearLookupCache", "dispose", "ensureLookupsCacheAttributesSaved", "getChunk", "rawChunk", "Lorg/jetbrains/jps/ModuleChunk;", "hasKotlin", "loadLookupsCacheStateDiff", "Lorg/jetbrains/kotlin/jps/incremental/CompositeLookupsCacheAttributes;", "logMarkDirtyForTestingBeforeRound", "file", "Ljava/io/File;", "shouldProcess", "makeLookupsCacheAttributesManager", "markAllKotlinForRebuild", "reason", "", "markChunkForRebuildBeforeBuild", "reportUnsupportedTargets", "jps-plugin"})
public final class KotlinCompileContext {
    private final BuildDataManager dataManager;
    private final BuildDataPaths dataPaths;
    @NotNull
    private final KotlinTargetsIndex targetsIndex;
    @NotNull
    private final CompositeLookupsCacheAttributesManager lookupsCacheAttributesManager;
    private final boolean shouldCheckCacheVersions;
    @NotNull
    private final HasKotlinMarker hasKotlinMarker;
    @NotNull
    private final Lazy isInstrumentationEnabled$delegate;
    @NotNull
    private final FileToPathConverter fileToPathConverter;
    @NotNull
    private final JpsLookupStorageManager lookupStorageManager;
    @NotNull
    private final RebuildAfterCacheVersionChangeMarker rebuildAfterCacheVersionChanged;
    private boolean rebuildingAllKotlin;
    private final CacheAttributesDiff<?> initialLookupsCacheStateDiff;
    private final AtomicBoolean lookupAttributesSaved;
    @NotNull
    private final CompileContext jpsContext;

    public final BuildDataManager getDataManager() {
        return this.dataManager;
    }

    public final BuildDataPaths getDataPaths() {
        return this.dataPaths;
    }

    @Nullable
    public final TestingBuildLogger getTestingLogger() {
        TestingContext testingContext = TestingContextKt.getTestingContext(this.jpsContext);
        return testingContext != null ? testingContext.getBuildLogger() : null;
    }

    @NotNull
    public final KotlinTargetsIndex getTargetsIndex() {
        return this.targetsIndex;
    }

    @NotNull
    public final Map<ModuleBuildTarget, KotlinModuleBuildTarget<?>> getTargetsBinding() {
        return this.targetsIndex.getByJpsTarget();
    }

    @NotNull
    public final CompositeLookupsCacheAttributesManager getLookupsCacheAttributesManager() {
        return this.lookupsCacheAttributesManager;
    }

    public final boolean getShouldCheckCacheVersions() {
        return this.shouldCheckCacheVersions;
    }

    @NotNull
    public final HasKotlinMarker getHasKotlinMarker() {
        return this.hasKotlinMarker;
    }

    public final boolean isInstrumentationEnabled() {
        Lazy lazy = this.isInstrumentationEnabled$delegate;
        KotlinCompileContext kotlinCompileContext = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Boolean)lazy.getValue();
    }

    @NotNull
    public final FileToPathConverter getFileToPathConverter() {
        return this.fileToPathConverter;
    }

    @NotNull
    public final JpsLookupStorageManager getLookupStorageManager() {
        return this.lookupStorageManager;
    }

    @NotNull
    public final RebuildAfterCacheVersionChangeMarker getRebuildAfterCacheVersionChanged() {
        return this.rebuildAfterCacheVersionChanged;
    }

    public final boolean getRebuildingAllKotlin() {
        return this.rebuildingAllKotlin;
    }

    public final void setRebuildingAllKotlin(boolean bl) {
        this.rebuildingAllKotlin = bl;
    }

    private final CompositeLookupsCacheAttributesManager makeLookupsCacheAttributesManager() {
        File lookupsCacheRootPath;
        boolean bl = false;
        Set expectedLookupsCacheComponents = new LinkedHashSet();
        Iterable $this$forEach$iv = this.targetsIndex.getChunks();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinChunk chunk = (KotlinChunk)element$iv;
            boolean bl2 = false;
            Iterable $this$forEach$iv2 = chunk.getTargets();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                KotlinModuleBuildTarget target = (KotlinModuleBuildTarget)element$iv2;
                boolean bl3 = false;
                if (!target.isIncrementalCompilationEnabled()) continue;
                expectedLookupsCacheComponents.add(target.getGlobalLookupCacheId());
            }
        }
        File file2 = lookupsCacheRootPath = this.dataPaths.getTargetDataRoot((BuildTarget)KotlinDataContainerTarget.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"lookupsCacheRootPath");
        return new CompositeLookupsCacheAttributesManager(file2, expectedLookupsCacheComponents);
    }

    private final CacheAttributesDiff<CompositeLookupsCacheAttributes> loadLookupsCacheStateDiff() {
        CacheAttributesDiff diff = CacheAttributesManagerKt.loadDiff$default(this.lookupsCacheAttributesManager, null, null, 3, null);
        if (diff.getStatus() == CacheStatus.VALID) {
            try {
                this.lookupStorageManager.withLookupStorage(loadLookupsCacheStateDiff.1.INSTANCE);
            }
            catch (Exception e) {
                this.jpsContext.processMessage((BuildMessage)new CompilerMessage("Kotlin", BuildMessage.Kind.WARNING, "Incremental caches are corrupted. All Kotlin code will be rebuilt."));
                KotlinBuilder.Companion.getLOG().info((Throwable)new Error("Lookup storage is corrupted, probe failed: " + e.getMessage(), e));
                this.markAllKotlinForRebuild("Lookup storage is corrupted");
                return CacheAttributesDiff.copy$default(diff, null, null, null, 5, null);
            }
        }
        return diff;
    }

    public final boolean hasKotlin() {
        boolean bl;
        block7: {
            Iterable $this$any$iv = this.targetsIndex.getChunks();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    block6: {
                        KotlinChunk chunk = (KotlinChunk)element$iv;
                        boolean bl3 = false;
                        Iterable $this$any$iv2 = chunk.getTargets();
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                KotlinModuleBuildTarget target = (KotlinModuleBuildTarget)element$iv2;
                                boolean bl4 = false;
                                if (!Intrinsics.areEqual((Object)this.hasKotlinMarker.get(target), (Object)true)) continue;
                                bl2 = true;
                                break block6;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void checkCacheVersions() {
        switch (KotlinCompileContext$WhenMappings.$EnumSwitchMapping$0[this.initialLookupsCacheStateDiff.getStatus().ordinal()]) {
            case 1: {
                TestingBuildLogger testingBuildLogger = this.getTestingLogger();
                if (testingBuildLogger != null) {
                    testingBuildLogger.invalidOrUnusedCache(null, null, this.initialLookupsCacheStateDiff);
                }
                if (this.initialLookupsCacheStateDiff.getActual() != null) {
                    this.markAllKotlinForRebuild("Kotlin incremental cache settings or format was changed");
                    this.clearLookupCache();
                    break;
                }
                this.markAllKotlinForRebuild("Kotlin incremental cache is missed or corrupted");
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                Object object = TestingContextKt.getTestingContext(this.jpsContext);
                if (object != null && (object = ((TestingContext)object).getBuildLogger()) != null) {
                    object.invalidOrUnusedCache(null, null, this.initialLookupsCacheStateDiff);
                }
                KotlinBuilder.Companion.getLOG().info("Removing global cache as it is not required anymore: " + this.initialLookupsCacheStateDiff);
                this.clearAllCaches();
                break;
            }
            case 4: {
                break;
            }
        }
    }

    public final void ensureLookupsCacheAttributesSaved() {
        if (this.lookupAttributesSaved.compareAndSet(false, true)) {
            CacheAttributesManager.DefaultImpls.writeVersion$default(this.initialLookupsCacheStateDiff.getManager(), null, 1, null);
        }
    }

    public final void checkChunkCacheVersion(@NotNull KotlinChunk chunk) {
        Intrinsics.checkParameterIsNotNull((Object)chunk, (String)"chunk");
        if (this.shouldCheckCacheVersions && !this.rebuildingAllKotlin && chunk.shouldRebuild()) {
            this.markChunkForRebuildBeforeBuild(chunk);
        }
    }

    private final boolean logMarkDirtyForTestingBeforeRound(File file2, boolean shouldProcess) {
        block1: {
            if (!shouldProcess) break block1;
            TestingBuildLogger testingBuildLogger = this.getTestingLogger();
            if (testingBuildLogger != null) {
                testingBuildLogger.markedAsDirtyBeforeRound(CollectionsKt.listOf((Object)file2));
            }
        }
        return shouldProcess;
    }

    private final void markAllKotlinForRebuild(String reason) {
        if (this.rebuildingAllKotlin) {
            return;
        }
        this.rebuildingAllKotlin = true;
        KotlinBuilder.Companion.getLOG().info("Rebuilding all Kotlin: " + reason);
        Iterable $this$forEach$iv = this.targetsIndex.getChunks();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinChunk it = (KotlinChunk)element$iv;
            boolean bl = false;
            this.markChunkForRebuildBeforeBuild(it);
        }
        this.lookupStorageManager.cleanLookupStorage(KotlinBuilder.Companion.getLOG());
    }

    private final void markChunkForRebuildBeforeBuild(KotlinChunk chunk) {
        Iterable $this$forEach$iv = chunk.getTargets();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinModuleBuildTarget it = (KotlinModuleBuildTarget)element$iv;
            boolean bl = false;
            FSOperations.markDirty((CompileContext)this.jpsContext, (CompilationRound)CompilationRound.NEXT, (ModuleBuildTarget)it.getJpsModuleBuildTarget(), (FileFilter)new FileFilter(this){
                final /* synthetic */ KotlinCompileContext this$0;
                {
                    this.this$0 = kotlinCompileContext;
                }

                public final boolean accept(File file2) {
                    File file3 = file2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"file");
                    return KotlinCompileContext.access$logMarkDirtyForTestingBeforeRound(this.this$0, file3, KotlinDirtySourceFilesHolderKt.isKotlinSourceFile(file2));
                }
            });
            BuildDataManager buildDataManager = this.dataManager;
            Intrinsics.checkExpressionValueIsNotNull((Object)buildDataManager, (String)"dataManager");
            JpsIncrementalCache jpsIncrementalCache = JpsIncrementalCacheKt.getKotlinCache(buildDataManager, it);
            if (jpsIncrementalCache != null) {
                jpsIncrementalCache.clean();
            }
            this.hasKotlinMarker.clean(it);
            this.rebuildAfterCacheVersionChanged.set(it, true);
        }
    }

    private final void clearAllCaches() {
        this.clearLookupCache();
        KotlinBuilder.Companion.getLOG().info("Clearing caches for all targets");
        Iterable $this$forEach$iv = this.targetsIndex.getChunks();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinChunk chunk = (KotlinChunk)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = chunk.getTargets();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                KotlinModuleBuildTarget it = (KotlinModuleBuildTarget)element$iv2;
                boolean bl2 = false;
                BuildDataManager buildDataManager = this.dataManager;
                Intrinsics.checkExpressionValueIsNotNull((Object)buildDataManager, (String)"dataManager");
                JpsIncrementalCache jpsIncrementalCache = JpsIncrementalCacheKt.getKotlinCache(buildDataManager, it);
                if (jpsIncrementalCache == null) continue;
                jpsIncrementalCache.clean();
            }
        }
    }

    private final void clearLookupCache() {
        KotlinBuilder.Companion.getLOG().info("Clearing lookup cache");
        this.lookupStorageManager.cleanLookupStorage(KotlinBuilder.Companion.getLOG());
        CacheAttributesManager.DefaultImpls.writeVersion$default(this.initialLookupsCacheStateDiff.getManager(), null, 1, null);
    }

    public final void cleanupCaches() {
        Iterable $this$forEach$iv = this.targetsIndex.getChunks();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinChunk chunk = (KotlinChunk)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = chunk.getTargets();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                KotlinModuleBuildTarget target = (KotlinModuleBuildTarget)element$iv2;
                boolean bl2 = false;
                if (target.getInitialLocalCacheAttributesDiff().getStatus() != CacheStatus.SHOULD_BE_CLEARED) continue;
                KotlinBuilder.Companion.getLOG().info(target + " caches is cleared as not required anymore: " + target.getInitialLocalCacheAttributesDiff());
                TestingBuildLogger testingBuildLogger = this.getTestingLogger();
                if (testingBuildLogger != null) {
                    testingBuildLogger.invalidOrUnusedCache(null, target, target.getInitialLocalCacheAttributesDiff());
                }
                target.getInitialLocalCacheAttributesDiff().getManager().writeVersion(null);
                BuildDataManager buildDataManager = this.dataManager;
                Intrinsics.checkExpressionValueIsNotNull((Object)buildDataManager, (String)"dataManager");
                JpsIncrementalCache jpsIncrementalCache = JpsIncrementalCacheKt.getKotlinCache(buildDataManager, target);
                if (jpsIncrementalCache == null) continue;
                jpsIncrementalCache.clean();
            }
        }
    }

    public final void dispose() {
    }

    @Nullable
    public final KotlinChunk getChunk(@NotNull ModuleChunk rawChunk) {
        Intrinsics.checkParameterIsNotNull((Object)rawChunk, (String)"rawChunk");
        ModuleBuildTarget rawRepresentativeTarget = rawChunk.representativeTarget();
        Object object = this.getTargetsBinding();
        boolean bl = false;
        Map<ModuleBuildTarget, KotlinModuleBuildTarget<?>> map2 = object;
        boolean bl2 = false;
        if (!map2.containsKey(rawRepresentativeTarget)) {
            return null;
        }
        KotlinChunk kotlinChunk = this.targetsIndex.getChunksByJpsRepresentativeTarget().get(rawRepresentativeTarget);
        if (kotlinChunk == null) {
            object = "Kotlin binding for chunk " + this + " is not loaded at build start";
            bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        return kotlinChunk;
    }

    /*
     * WARNING - void declaration
     */
    public final void reportUnsupportedTargets() {
        String value$iv;
        boolean bl = false;
        Map byKind = new LinkedHashMap();
        Object $this$forEach$iv = this.targetsIndex.getChunks();
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv.iterator();
        while (object.hasNext()) {
            Object object2;
            void $this$getOrPut$iv;
            Object element$iv = object.next();
            KotlinChunk it = (KotlinChunk)element$iv;
            boolean bl2 = false;
            KotlinModuleBuildTarget<?> target = it.getRepresentativeTarget();
            if (!(target instanceof KotlinUnsupportedModuleBuildTarget)) continue;
            Object object3 = target.getSourceFiles();
            boolean bl3 = false;
            if (!(!object3.isEmpty())) continue;
            object3 = byKind;
            String key$iv = ((KotlinUnsupportedModuleBuildTarget)target).getKind();
            boolean $i$f$getOrPut = false;
            value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl4 = false;
                boolean bl5 = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            ((List)object2).add(target);
        }
        $this$forEach$iv = byKind;
        $i$f$forEach = false;
        object = $this$forEach$iv;
        boolean bl6 = false;
        Iterator iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            void kind;
            void $this$mapTo$iv$iv;
            List targets;
            Map.Entry element$iv;
            Map.Entry $dstr$kind$targets = element$iv = iterator2.next();
            boolean bl7 = false;
            Map.Entry key$iv = $dstr$kind$targets;
            boolean $i$f$getOrPut = false;
            value$iv = (String)key$iv.getKey();
            key$iv = $dstr$kind$targets;
            $i$f$getOrPut = false;
            List $this$sortBy$iv = targets = (List)key$iv.getValue();
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() > 1) {
                List list = $this$sortBy$iv;
                boolean bl8 = false;
                Comparator comparator = new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        KotlinUnsupportedModuleBuildTarget it = (KotlinUnsupportedModuleBuildTarget)a;
                        boolean bl2 = false;
                        Comparable comparable = (Comparable)((Object)it.getModule().getName());
                        it = (KotlinUnsupportedModuleBuildTarget)b;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        String string2 = it.getModule().getName();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string2)));
                    }
                };
                CollectionsKt.sortWith((List)list, (Comparator)comparator);
            }
            Iterable $this$map$iv = targets;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KotlinUnsupportedModuleBuildTarget kotlinUnsupportedModuleBuildTarget = (KotlinUnsupportedModuleBuildTarget)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl9 = false;
                String string2 = it.getChunk().getPresentableShortName();
                collection.add(string2);
            }
            List chunkNames = (List)destination$iv$iv;
            String presentableChunksListString = KotlinCompileContextKt.joinToReadableString(chunkNames);
            String msg = kind == null ? presentableChunksListString + " is not yet supported in IDEA internal build system. " + "Please use Gradle to build them (enable 'Delegate IDE build/run actions to Gradle' in Settings)." : (String)kind + " is not yet supported in IDEA internal build system. " + "Please use Gradle to build " + presentableChunksListString + " (enable 'Delegate IDE build/run actions to Gradle' in Settings).";
            TestingBuildLogger testingBuildLogger = this.getTestingLogger();
            if (testingBuildLogger != null) {
                testingBuildLogger.addCustomMessage(msg);
            }
            this.jpsContext.processMessage((BuildMessage)new CompilerMessage("Kotlin", BuildMessage.Kind.WARNING, msg));
        }
    }

    @NotNull
    public final CompileContext getJpsContext() {
        return this.jpsContext;
    }

    public KotlinCompileContext(@NotNull CompileContext jpsContext) {
        Intrinsics.checkParameterIsNotNull((Object)jpsContext, (String)"jpsContext");
        this.jpsContext = jpsContext;
        BuildDataManager buildDataManager = this.dataManager = this.jpsContext.getProjectDescriptor().dataManager;
        Intrinsics.checkExpressionValueIsNotNull((Object)buildDataManager, (String)"dataManager");
        this.dataPaths = buildDataManager.getDataPaths();
        this.targetsIndex = new KotlinTargetsIndexBuilder(this).build();
        this.lookupsCacheAttributesManager = this.makeLookupsCacheAttributesManager();
        this.shouldCheckCacheVersions = System.getProperty("kotlin.jps.skip.cache.version.check") == null;
        BuildDataManager buildDataManager2 = this.dataManager;
        Intrinsics.checkExpressionValueIsNotNull((Object)buildDataManager2, (String)"dataManager");
        this.hasKotlinMarker = new HasKotlinMarker(buildDataManager2);
        this.isInstrumentationEnabled$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ KotlinCompileContext this$0;

            /*
             * WARNING - void declaration
             */
            public final boolean invoke() {
                void var1_3;
                boolean value;
                boolean bl;
                String string2 = System.getProperty("kotlin.jps.instrument.bytecode");
                if (string2 != null) {
                    String string3 = string2;
                    boolean bl2 = false;
                    bl = Boolean.parseBoolean(string3);
                } else {
                    bl = value = false;
                }
                if (value) {
                    String message = "Experimental bytecode instrumentation for Kotlin classes is enabled";
                    this.this$0.getJpsContext().processMessage((BuildMessage)new CompilerMessage("Kotlin", BuildMessage.Kind.INFO, message));
                }
                return (boolean)var1_3;
            }
            {
                this.this$0 = kotlinCompileContext;
                super(0);
            }
        }));
        ProjectDescriptor projectDescriptor = this.jpsContext.getProjectDescriptor();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectDescriptor, (String)"jpsContext.projectDescriptor");
        JpsProject jpsProject = projectDescriptor.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)jpsProject, (String)"jpsContext.projectDescriptor.project");
        this.fileToPathConverter = new JpsFileToPathConverter(jpsProject);
        BuildDataManager buildDataManager3 = this.dataManager;
        Intrinsics.checkExpressionValueIsNotNull((Object)buildDataManager3, (String)"dataManager");
        this.lookupStorageManager = new JpsLookupStorageManager(buildDataManager3, this.fileToPathConverter);
        BuildDataManager buildDataManager4 = this.dataManager;
        Intrinsics.checkExpressionValueIsNotNull((Object)buildDataManager4, (String)"dataManager");
        this.rebuildAfterCacheVersionChanged = new RebuildAfterCacheVersionChangeMarker(buildDataManager4);
        this.initialLookupsCacheStateDiff = this.loadLookupsCacheStateDiff();
        this.lookupAttributesSaved = new AtomicBoolean(false);
    }

    public static final /* synthetic */ boolean access$logMarkDirtyForTestingBeforeRound(KotlinCompileContext $this, File file2, boolean shouldProcess) {
        return $this.logMarkDirtyForTestingBeforeRound(file2, shouldProcess);
    }
}

