/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.load.java.BuiltinMethodsWithDifferentJvmName;
import org.jetbrains.kotlin.load.java.BuiltinMethodsWithSpecialGenericSignature;
import org.jetbrains.kotlin.load.java.SpecialBuiltinMembers;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaMethodDescriptor;
import org.jetbrains.kotlin.load.kotlin.JvmType;
import org.jetbrains.kotlin.load.kotlin.MethodSignatureMappingKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.ExternalOverridabilityCondition;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/load/java/JavaIncompatibilityRulesOverridabilityCondition;", "Lorg/jetbrains/kotlin/resolve/ExternalOverridabilityCondition;", "()V", "getContract", "Lorg/jetbrains/kotlin/resolve/ExternalOverridabilityCondition$Contract;", "isIncompatibleInAccordanceWithBuiltInOverridabilityRules", "", "superDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "subDescriptor", "subClassDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "isOverridable", "Lorg/jetbrains/kotlin/resolve/ExternalOverridabilityCondition$Result;", "Companion", "descriptors.jvm"})
public final class JavaIncompatibilityRulesOverridabilityCondition
implements ExternalOverridabilityCondition {
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public ExternalOverridabilityCondition.Result isOverridable(@NotNull CallableDescriptor superDescriptor, @NotNull CallableDescriptor subDescriptor, @Nullable ClassDescriptor subClassDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)superDescriptor, (String)"superDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)subDescriptor, (String)"subDescriptor");
        if (this.isIncompatibleInAccordanceWithBuiltInOverridabilityRules(superDescriptor, subDescriptor, subClassDescriptor)) {
            return ExternalOverridabilityCondition.Result.INCOMPATIBLE;
        }
        if (Companion.doesJavaOverrideHaveIncompatibleValueParameterKinds(superDescriptor, subDescriptor)) {
            return ExternalOverridabilityCondition.Result.INCOMPATIBLE;
        }
        return ExternalOverridabilityCondition.Result.UNKNOWN;
    }

    private final boolean isIncompatibleInAccordanceWithBuiltInOverridabilityRules(CallableDescriptor superDescriptor, CallableDescriptor subDescriptor, ClassDescriptor subClassDescriptor) {
        boolean isOneOfDescriptorsHidden;
        if (!(superDescriptor instanceof CallableMemberDescriptor) || !(subDescriptor instanceof FunctionDescriptor) || KotlinBuiltIns.isBuiltIn(subDescriptor)) {
            return false;
        }
        Name name = ((FunctionDescriptor)subDescriptor).getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"subDescriptor.name");
        if (!BuiltinMethodsWithSpecialGenericSignature.INSTANCE.getSameAsBuiltinMethodWithErasedValueParameters(name)) {
            Name name2 = ((FunctionDescriptor)subDescriptor).getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"subDescriptor.name");
            if (!BuiltinMethodsWithDifferentJvmName.INSTANCE.getSameAsRenamedInJvmBuiltin(name2)) {
                return false;
            }
        }
        CallableMemberDescriptor overriddenBuiltin = SpecialBuiltinMembers.getOverriddenSpecialBuiltin((CallableMemberDescriptor)superDescriptor);
        boolean bl = ((FunctionDescriptor)subDescriptor).isHiddenToOvercomeSignatureClash();
        CallableDescriptor callableDescriptor = superDescriptor;
        if (!(callableDescriptor instanceof FunctionDescriptor)) {
            callableDescriptor = null;
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)callableDescriptor;
        boolean bl2 = functionDescriptor == null || bl != functionDescriptor.isHiddenToOvercomeSignatureClash() ? true : (isOneOfDescriptorsHidden = false);
        if (isOneOfDescriptorsHidden && (overriddenBuiltin == null || !((FunctionDescriptor)subDescriptor).isHiddenToOvercomeSignatureClash())) {
            return true;
        }
        if (!(subClassDescriptor instanceof JavaClassDescriptor) || ((FunctionDescriptor)subDescriptor).getInitialSignatureDescriptor() != null) {
            return false;
        }
        if (overriddenBuiltin == null || SpecialBuiltinMembers.hasRealKotlinSuperClassWithOverrideOf(subClassDescriptor, overriddenBuiltin)) {
            return false;
        }
        if (overriddenBuiltin instanceof FunctionDescriptor && superDescriptor instanceof FunctionDescriptor && BuiltinMethodsWithSpecialGenericSignature.getOverriddenBuiltinFunctionWithErasedValueParametersInJava((FunctionDescriptor)overriddenBuiltin) != null) {
            String string2 = MethodSignatureMappingKt.computeJvmDescriptor$default((FunctionDescriptor)subDescriptor, false, false, 2, null);
            FunctionDescriptor functionDescriptor2 = ((FunctionDescriptor)superDescriptor).getOriginal();
            Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor2, (String)"superDescriptor.original");
            if (Intrinsics.areEqual((Object)string2, (Object)MethodSignatureMappingKt.computeJvmDescriptor$default(functionDescriptor2, false, false, 2, null))) {
                return false;
            }
        }
        return true;
    }

    @Override
    @NotNull
    public ExternalOverridabilityCondition.Contract getContract() {
        return ExternalOverridabilityCondition.Contract.CONFLICTS_ONLY;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/load/java/JavaIncompatibilityRulesOverridabilityCondition$Companion;", "", "()V", "doesJavaOverrideHaveIncompatibleValueParameterKinds", "", "superDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "subDescriptor", "isPrimitiveCompareTo", "f", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "mapValueParameterType", "Lorg/jetbrains/kotlin/load/kotlin/JvmType;", "valueParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "descriptors.jvm"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        public final boolean doesJavaOverrideHaveIncompatibleValueParameterKinds(@NotNull CallableDescriptor superDescriptor, @NotNull CallableDescriptor subDescriptor) {
            Intrinsics.checkParameterIsNotNull((Object)superDescriptor, (String)"superDescriptor");
            Intrinsics.checkParameterIsNotNull((Object)subDescriptor, (String)"subDescriptor");
            if (!(subDescriptor instanceof JavaMethodDescriptor) || !(superDescriptor instanceof FunctionDescriptor)) {
                return false;
            }
            boolean bl = ((JavaMethodDescriptor)subDescriptor).getValueParameters().size() == ((FunctionDescriptor)superDescriptor).getValueParameters().size();
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-JavaIncompatibilityRulesOverridabilityCondition$Companion$doesJavaOverrideHaveIncompatibleValueParameterKinds$22 = false;
                String $i$a$-assert-JavaIncompatibilityRulesOverridabilityCondition$Companion$doesJavaOverrideHaveIncompatibleValueParameterKinds$22 = "External overridability condition with CONFLICTS_ONLY should not be run with different value parameters size";
                throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-JavaIncompatibilityRulesOverridabilityCondition$Companion$doesJavaOverrideHaveIncompatibleValueParameterKinds$22));
            }
            SimpleFunctionDescriptor simpleFunctionDescriptor = ((JavaMethodDescriptor)subDescriptor).getOriginal();
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleFunctionDescriptor, (String)"subDescriptor.original");
            List<ValueParameterDescriptor> list = simpleFunctionDescriptor.getValueParameters();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"subDescriptor.original.valueParameters");
            Iterable iterable = list;
            FunctionDescriptor functionDescriptor = ((FunctionDescriptor)superDescriptor).getOriginal();
            Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor, (String)"superDescriptor.original");
            List<ValueParameterDescriptor> list2 = functionDescriptor.getValueParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"superDescriptor.original.valueParameters");
            for (Pair pair : CollectionsKt.zip((Iterable)iterable, (Iterable)list2)) {
                void subParameter;
                ValueParameterDescriptor $i$a$-assert-JavaIncompatibilityRulesOverridabilityCondition$Companion$doesJavaOverrideHaveIncompatibleValueParameterKinds$22 = (ValueParameterDescriptor)pair.component1();
                ValueParameterDescriptor superParameter = (ValueParameterDescriptor)pair.component2();
                FunctionDescriptor functionDescriptor2 = (FunctionDescriptor)subDescriptor;
                void v6 = subParameter;
                Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"subParameter");
                boolean isSubPrimitive = this.mapValueParameterType(functionDescriptor2, (ValueParameterDescriptor)v6) instanceof JvmType.Primitive;
                FunctionDescriptor functionDescriptor3 = (FunctionDescriptor)superDescriptor;
                ValueParameterDescriptor valueParameterDescriptor = superParameter;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"superParameter");
                boolean isSuperPrimitive = this.mapValueParameterType(functionDescriptor3, valueParameterDescriptor) instanceof JvmType.Primitive;
                if (isSubPrimitive == isSuperPrimitive) continue;
                return true;
            }
            return false;
        }

        private final JvmType mapValueParameterType(FunctionDescriptor f, ValueParameterDescriptor valueParameterDescriptor) {
            JvmType jvmType;
            if (MethodSignatureMappingKt.forceSingleValueParameterBoxing(f) || this.isPrimitiveCompareTo(f)) {
                KotlinType kotlinType = valueParameterDescriptor.getType();
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"valueParameterDescriptor.type");
                jvmType = MethodSignatureMappingKt.mapToJvmType(TypeUtilsKt.makeNullable(kotlinType));
            } else {
                KotlinType kotlinType = valueParameterDescriptor.getType();
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"valueParameterDescriptor.type");
                jvmType = MethodSignatureMappingKt.mapToJvmType(kotlinType);
            }
            return jvmType;
        }

        private final boolean isPrimitiveCompareTo(FunctionDescriptor f) {
            if (f.getValueParameters().size() != 1) {
                return false;
            }
            DeclarationDescriptor declarationDescriptor = f.getContainingDeclaration();
            if (!(declarationDescriptor instanceof ClassDescriptor)) {
                declarationDescriptor = null;
            }
            ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
            if (classDescriptor == null) {
                return false;
            }
            ClassDescriptor classDescriptor2 = classDescriptor;
            List<ValueParameterDescriptor> list = f.getValueParameters();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"f.valueParameters");
            Object object = CollectionsKt.single(list);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"f.valueParameters.single()");
            ClassifierDescriptor classifierDescriptor = ((ValueParameterDescriptor)object).getType().getConstructor().getDeclarationDescriptor();
            if (!(classifierDescriptor instanceof ClassDescriptor)) {
                classifierDescriptor = null;
            }
            ClassDescriptor classDescriptor3 = (ClassDescriptor)classifierDescriptor;
            if (classDescriptor3 == null) {
                return false;
            }
            ClassDescriptor parameterClass = classDescriptor3;
            return KotlinBuiltIns.isPrimitiveClass(classDescriptor2) && Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe(classDescriptor2), (Object)DescriptorUtilsKt.getFqNameSafe(parameterClass));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

