/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.embedder;

import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtilRt;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Activation;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Repository;
import org.apache.maven.plugin.PluginManager;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.profiles.activation.JdkPrefixProfileActivator;
import org.apache.maven.profiles.activation.OperatingSystemProfileActivator;
import org.apache.maven.profiles.activation.ProfileActivationException;
import org.apache.maven.profiles.activation.ProfileActivator;
import org.apache.maven.profiles.activation.SystemPropertyProfileActivator;
import org.apache.maven.project.DefaultProjectBuilderConfiguration;
import org.apache.maven.project.InvalidProjectModelException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuilderConfiguration;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectUtils;
import org.apache.maven.project.artifact.ProjectArtifactFactory;
import org.apache.maven.project.inheritance.DefaultModelInheritanceAssembler;
import org.apache.maven.project.injection.DefaultProfileInjector;
import org.apache.maven.project.interpolation.ModelInterpolationException;
import org.apache.maven.project.interpolation.ModelInterpolator;
import org.apache.maven.project.path.DefaultPathTranslator;
import org.apache.maven.project.validation.ModelValidationResult;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeResolutionListener;
import org.apache.maven.wagon.events.TransferListener;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.context.DefaultContext;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.model.MavenProjectProblem;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.idea.maven.model.MavenWorkspaceMap;
import org.jetbrains.idea.maven.server.Maven2ServerGlobals;
import org.jetbrains.idea.maven.server.MavenProcessCanceledRuntimeException;
import org.jetbrains.idea.maven.server.MavenRemoteObject;
import org.jetbrains.idea.maven.server.MavenServerConsole;
import org.jetbrains.idea.maven.server.MavenServerEmbedder;
import org.jetbrains.idea.maven.server.MavenServerExecutionResult;
import org.jetbrains.idea.maven.server.MavenServerProcessCanceledException;
import org.jetbrains.idea.maven.server.MavenServerProgressIndicator;
import org.jetbrains.idea.maven.server.MavenServerSettings;
import org.jetbrains.idea.maven.server.MavenServerUtil;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.server.ProfileApplicationResult;
import org.jetbrains.idea.maven.server.embedder.CustomArtifactFactory;
import org.jetbrains.idea.maven.server.embedder.CustomArtifactResolver;
import org.jetbrains.idea.maven.server.embedder.CustomModelInterpolator;
import org.jetbrains.idea.maven.server.embedder.CustomRepositoryMetadataManager;
import org.jetbrains.idea.maven.server.embedder.CustomWagonManager;
import org.jetbrains.idea.maven.server.embedder.ExecutorManager;
import org.jetbrains.idea.maven.server.embedder.Maven2ModelConverter;
import org.jetbrains.idea.maven.server.embedder.Maven2ServerConsoleWrapper;
import org.jetbrains.idea.maven.server.embedder.MyFileProfileActivator;
import org.jetbrains.idea.maven.server.embedder.RemoteNativeMavenProjectHolder;
import org.jetbrains.idea.maven.server.embedder.RuntimeRemoteException;
import org.jetbrains.idea.maven.server.embedder.TransferListenerAdapter;
import org.jetbrains.idea.maven.server.security.MavenToken;
import org.jetbrains.maven.embedder.MavenEmbedder;
import org.jetbrains.maven.embedder.MavenEmbedderSettings;
import org.jetbrains.maven.embedder.MavenExecutionResult;
import org.jetbrains.maven.embedder.PlexusComponentConfigurator;

public class Maven2ServerEmbedderImpl
extends MavenRemoteObject
implements MavenServerEmbedder {
    private final MavenEmbedder myImpl;
    private final Maven2ServerConsoleWrapper myConsoleWrapper;
    private volatile MavenServerProgressIndicator myCurrentIndicator;

    private Maven2ServerEmbedderImpl(MavenEmbedder impl, Maven2ServerConsoleWrapper consoleWrapper) {
        this.myImpl = impl;
        this.myConsoleWrapper = consoleWrapper;
    }

    public static Maven2ServerEmbedderImpl create(MavenServerSettings facadeSettings) throws RemoteException {
        MavenEmbedderSettings settings = new MavenEmbedderSettings();
        ArrayList commandLineOptions = new ArrayList();
        String mavenEmbedderCliOptions = System.getProperty("idea.maven.embedder.ext.cli.args");
        if (mavenEmbedderCliOptions != null) {
            commandLineOptions.addAll(StringUtilRt.splitHonorQuotes((String)mavenEmbedderCliOptions, (char)' '));
        }
        settings.setConfigurator(new PlexusComponentConfigurator(){

            @Override
            public void configureComponents(@NotNull PlexusContainer c) {
                if (c == null) {
                    1.$$$reportNull$$$0(0);
                }
                Maven2ServerEmbedderImpl.setupContainer(c);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/idea/maven/server/embedder/Maven2ServerEmbedderImpl$1", "configureComponents"));
            }
        });
        Maven2ServerConsoleWrapper consoleWrapper = new Maven2ServerConsoleWrapper();
        consoleWrapper.setThreshold(facadeSettings.getLoggingLevel());
        settings.setLogger(consoleWrapper);
        settings.setRecursive(false);
        settings.setWorkOffline(facadeSettings.isOffline());
        settings.setUsePluginRegistry(false);
        settings.setMavenHome(facadeSettings.getMavenHome());
        settings.setUserSettingsFile(facadeSettings.getUserSettingsFile());
        settings.setGlobalSettingsFile(facadeSettings.getGlobalSettingsFile());
        settings.setLocalRepository(facadeSettings.getLocalRepository());
        if (commandLineOptions.contains("-U") || commandLineOptions.contains("--update-snapshots")) {
            settings.setSnapshotUpdatePolicy(MavenEmbedderSettings.UpdatePolicy.ALWAYS_UPDATE);
        } else {
            settings.setSnapshotUpdatePolicy(Maven2ServerEmbedderImpl.convertUpdatePolicy(facadeSettings.getSnapshotUpdatePolicy()));
        }
        settings.setPluginUpdatePolicy(Maven2ServerEmbedderImpl.convertUpdatePolicy(facadeSettings.getPluginUpdatePolicy()));
        settings.setProperties(MavenServerUtil.collectSystemProperties());
        return new Maven2ServerEmbedderImpl(MavenEmbedder.create(settings), consoleWrapper);
    }

    private static MavenEmbedderSettings.UpdatePolicy convertUpdatePolicy(MavenServerSettings.UpdatePolicy policy) throws RemoteException {
        switch (policy) {
            case ALWAYS_UPDATE: {
                return MavenEmbedderSettings.UpdatePolicy.ALWAYS_UPDATE;
            }
            case DO_NOT_UPDATE: {
                return MavenEmbedderSettings.UpdatePolicy.DO_NOT_UPDATE;
            }
        }
        Maven2ServerGlobals.getLogger().error(new Throwable("unexpected update policy"));
        return MavenEmbedderSettings.UpdatePolicy.DO_NOT_UPDATE;
    }

    private static Collection<String> collectProfilesIds(List<Profile> profiles) {
        THashSet result = new THashSet();
        for (Profile each : profiles) {
            if (each.getId() == null) continue;
            result.add(each.getId());
        }
        return result;
    }

    @NotNull
    public static MavenModel interpolateAndAlignModel(MavenModel model, File basedir) throws RemoteException {
        Model result = Maven2ModelConverter.toNativeModel(model);
        result = Maven2ServerEmbedderImpl.doInterpolate(result, basedir);
        DefaultPathTranslator pathTranslator = new DefaultPathTranslator();
        pathTranslator.alignToBaseDirectory(result, basedir);
        MavenModel mavenModel = Maven2ModelConverter.convertModel(result, null);
        if (mavenModel == null) {
            Maven2ServerEmbedderImpl.$$$reportNull$$$0(0);
        }
        return mavenModel;
    }

    private static Model doInterpolate(Model result, File basedir) throws RemoteException {
        try {
            CustomModelInterpolator interpolator = new CustomModelInterpolator(new DefaultPathTranslator());
            interpolator.initialize();
            Properties props = MavenServerUtil.collectSystemProperties();
            ProjectBuilderConfiguration config = new DefaultProjectBuilderConfiguration().setExecutionProperties(props);
            result = interpolator.interpolate(result, basedir, config, false);
        }
        catch (ModelInterpolationException e) {
            Maven2ServerGlobals.getLogger().warn(e);
        }
        catch (InitializationException e) {
            Maven2ServerGlobals.getLogger().error(e);
        }
        return result;
    }

    public static MavenModel assembleInheritance(MavenModel model, MavenModel parentModel) throws RemoteException {
        Model result = Maven2ModelConverter.toNativeModel(model);
        new DefaultModelInheritanceAssembler().assembleModelInheritance(result, Maven2ModelConverter.toNativeModel(parentModel));
        return Maven2ModelConverter.convertModel(result, null);
    }

    public static ProfileApplicationResult applyProfiles(MavenModel model, File basedir, MavenExplicitProfiles explicitProfiles, Collection<String> alwaysOnProfiles) throws RemoteException {
        Model nativeModel = Maven2ModelConverter.toNativeModel(model);
        Collection enabledProfiles = explicitProfiles.getEnabledProfiles();
        Collection disabledProfiles = explicitProfiles.getDisabledProfiles();
        ArrayList<Profile> activatedPom = new ArrayList<Profile>();
        ArrayList<Profile> activatedExternal = new ArrayList<Profile>();
        ArrayList<Profile> activeByDefault = new ArrayList<Profile>();
        List rawProfiles = nativeModel.getProfiles();
        List expandedProfilesCache = null;
        ArrayList<Profile> deactivatedProfiles = new ArrayList<Profile>();
        for (int i = 0; i < rawProfiles.size(); ++i) {
            Profile eachRawProfile = (Profile)rawProfiles.get(i);
            if (disabledProfiles.contains(eachRawProfile.getId())) {
                deactivatedProfiles.add(eachRawProfile);
                continue;
            }
            boolean shouldAdd = enabledProfiles.contains(eachRawProfile.getId()) || alwaysOnProfiles.contains(eachRawProfile.getId());
            Activation activation = eachRawProfile.getActivation();
            if (activation != null) {
                if (activation.isActiveByDefault()) {
                    activeByDefault.add(eachRawProfile);
                }
                if (expandedProfilesCache == null) {
                    expandedProfilesCache = Maven2ServerEmbedderImpl.doInterpolate(nativeModel, basedir).getProfiles();
                }
                Profile eachExpandedProfile = (Profile)expandedProfilesCache.get(i);
                for (ProfileActivator eachActivator : Maven2ServerEmbedderImpl.getProfileActivators(basedir)) {
                    try {
                        if (!eachActivator.canDetermineActivation(eachExpandedProfile) || !eachActivator.isActive(eachExpandedProfile)) continue;
                        shouldAdd = true;
                        break;
                    }
                    catch (ProfileActivationException e) {
                        Maven2ServerGlobals.getLogger().warn(e);
                    }
                }
            }
            if (!shouldAdd) continue;
            if ("pom".equals(eachRawProfile.getSource())) {
                activatedPom.add(eachRawProfile);
                continue;
            }
            activatedExternal.add(eachRawProfile);
        }
        ArrayList<Profile> activatedProfiles = new ArrayList<Profile>(activatedPom.isEmpty() ? activeByDefault : activatedPom);
        activatedProfiles.addAll(activatedExternal);
        for (Profile each : activatedProfiles) {
            new DefaultProfileInjector().inject(each, nativeModel);
        }
        return new ProfileApplicationResult(Maven2ModelConverter.convertModel(nativeModel, null), new MavenExplicitProfiles(Maven2ServerEmbedderImpl.collectProfilesIds(activatedProfiles), Maven2ServerEmbedderImpl.collectProfilesIds(deactivatedProfiles)));
    }

    private static ProfileActivator[] getProfileActivators(File basedir) throws RemoteException {
        SystemPropertyProfileActivator sysPropertyActivator = new SystemPropertyProfileActivator();
        DefaultContext context = new DefaultContext();
        context.put((Object)"SystemProperties", (Object)MavenServerUtil.collectSystemProperties());
        try {
            sysPropertyActivator.contextualize((Context)context);
        }
        catch (ContextException e) {
            Maven2ServerGlobals.getLogger().error(e);
            return new ProfileActivator[0];
        }
        return new ProfileActivator[]{new MyFileProfileActivator(basedir), sysPropertyActivator, new JdkPrefixProfileActivator(), new OperatingSystemProfileActivator()};
    }

    private static void setupContainer(PlexusContainer c) {
        MavenEmbedder.setImplementation(c, ArtifactFactory.class, CustomArtifactFactory.class);
        MavenEmbedder.setImplementation(c, ProjectArtifactFactory.class, CustomArtifactFactory.class);
        MavenEmbedder.setImplementation(c, ArtifactResolver.class, CustomArtifactResolver.class);
        MavenEmbedder.setImplementation(c, RepositoryMetadataManager.class, CustomRepositoryMetadataManager.class);
        MavenEmbedder.setImplementation(c, WagonManager.class, CustomWagonManager.class);
        MavenEmbedder.setImplementation(c, ModelInterpolator.class, CustomModelInterpolator.class);
    }

    @NotNull
    public Collection<MavenServerExecutionResult> resolveProject(@NotNull Collection<File> files, final @NotNull Collection<String> activeProfiles, final @NotNull Collection<String> inactiveProfiles, MavenToken token) {
        if (files == null) {
            Maven2ServerEmbedderImpl.$$$reportNull$$$0(1);
        }
        if (activeProfiles == null) {
            Maven2ServerEmbedderImpl.$$$reportNull$$$0(2);
        }
        if (inactiveProfiles == null) {
            Maven2ServerEmbedderImpl.$$$reportNull$$$0(3);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        List list = ContainerUtilRt.map2List(files, (Function)new Function<File, MavenServerExecutionResult>(){

            public MavenServerExecutionResult fun(final File file) {
                try {
                    return (MavenServerExecutionResult)Maven2ServerEmbedderImpl.this.doExecute(new Executor<MavenServerExecutionResult>(){

                        @Override
                        @NotNull
                        public MavenServerExecutionResult execute() throws Exception {
                            DependencyTreeResolutionListener listener = new DependencyTreeResolutionListener((Logger)Maven2ServerEmbedderImpl.this.myConsoleWrapper);
                            MavenExecutionResult result = Maven2ServerEmbedderImpl.this.myImpl.resolveProject(file, new ArrayList<String>(activeProfiles), new ArrayList<String>(inactiveProfiles), Collections.singletonList(listener));
                            MavenServerExecutionResult mavenServerExecutionResult = Maven2ServerEmbedderImpl.this.createExecutionResult(file, result, listener.getRootNode());
                            if (mavenServerExecutionResult == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return mavenServerExecutionResult;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/embedder/Maven2ServerEmbedderImpl$2$1", "execute"));
                        }
                    });
                }
                catch (MavenServerProcessCanceledException e) {
                    throw new RuntimeException(e);
                }
                catch (RemoteException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        if (list == null) {
            Maven2ServerEmbedderImpl.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    private MavenServerExecutionResult createExecutionResult(File file, MavenExecutionResult result, DependencyNode rootNode) throws RemoteException {
        Collection problems = MavenProjectProblem.createProblemsList();
        THashSet unresolvedArtifacts = new THashSet();
        this.validate(file, result.getExceptions(), problems, (Collection<MavenId>)unresolvedArtifacts);
        MavenProject mavenProject = result.getMavenProject();
        if (mavenProject == null) {
            return new MavenServerExecutionResult(null, problems, (Set)unresolvedArtifacts);
        }
        MavenModel model = Maven2ModelConverter.convertModel(mavenProject.getModel(), mavenProject.getCompileSourceRoots(), mavenProject.getTestCompileSourceRoots(), mavenProject.getArtifacts(), rootNode == null ? Collections.emptyList() : rootNode.getChildren(), mavenProject.getExtensionArtifacts(), this.getLocalRepositoryFile());
        RemoteNativeMavenProjectHolder holder = new RemoteNativeMavenProjectHolder(mavenProject);
        try {
            UnicastRemoteObject.exportObject((Remote)((Object)holder), 0);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        Collection<String> activatedProfiles = this.collectActivatedProfiles(mavenProject);
        MavenServerExecutionResult.ProjectData data = new MavenServerExecutionResult.ProjectData(model, Maven2ModelConverter.convertToMap(mavenProject.getModel()), (NativeMavenProjectHolder)holder, activatedProfiles);
        return new MavenServerExecutionResult(data, problems, (Set)unresolvedArtifacts);
    }

    private Collection<String> collectActivatedProfiles(MavenProject mavenProject) {
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        while (mavenProject != null) {
            if (profiles != null) {
                profiles.addAll(mavenProject.getActiveProfiles());
            }
            mavenProject = mavenProject.getParent();
        }
        return Maven2ServerEmbedderImpl.collectProfilesIds(profiles);
    }

    @Nullable
    public String evaluateEffectivePom(@NotNull File file, @NotNull List<String> activeProfiles, @NotNull List<String> inactiveProfiles, MavenToken token) {
        if (file == null) {
            Maven2ServerEmbedderImpl.$$$reportNull$$$0(5);
        }
        if (activeProfiles == null) {
            Maven2ServerEmbedderImpl.$$$reportNull$$$0(6);
        }
        if (inactiveProfiles == null) {
            Maven2ServerEmbedderImpl.$$$reportNull$$$0(7);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        throw new UnsupportedOperationException();
    }

    @NotNull
    public MavenArtifact resolve(final @NotNull MavenArtifactInfo info, final @NotNull List<MavenRemoteRepository> remoteRepositories, MavenToken token) throws MavenServerProcessCanceledException, RemoteException {
        if (info == null) {
            Maven2ServerEmbedderImpl.$$$reportNull$$$0(8);
        }
        if (remoteRepositories == null) {
            Maven2ServerEmbedderImpl.$$$reportNull$$$0(9);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        return this.doExecute(new Executor<MavenArtifact>(){

            @Override
            @NotNull
            public MavenArtifact execute() throws Exception {
                MavenArtifact mavenArtifact = Maven2ServerEmbedderImpl.this.doResolve(info, remoteRepositories);
                if (mavenArtifact == null) {
                    3.$$$reportNull$$$0(0);
                }
                return mavenArtifact;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/embedder/Maven2ServerEmbedderImpl$3", "execute"));
            }
        });
    }

    @NotNull
    public List<MavenArtifact> resolveTransitively(@NotNull List<MavenArtifactInfo> artifacts, @NotNull List<MavenRemoteRepository> remoteRepositories, MavenToken token) throws RemoteException {
        List<MavenArtifact> list;
        if (artifacts == null) {
            Maven2ServerEmbedderImpl.$$$reportNull$$$0(10);
        }
        if (remoteRepositories == null) {
            Maven2ServerEmbedderImpl.$$$reportNull$$$0(11);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        try {
            LinkedHashSet<Artifact> toResolve = new LinkedHashSet<Artifact>();
            for (MavenArtifactInfo each : artifacts) {
                toResolve.add(this.createArtifact(each));
            }
            list = Maven2ModelConverter.convertArtifacts(this.myImpl.resolveTransitively(toResolve, this.convertRepositories(remoteRepositories)), (Map<Artifact, MavenArtifact>)new THashMap(), this.getLocalRepositoryFile());
        }
        catch (ArtifactResolutionException e) {
            Maven2ServerGlobals.getLogger().info(e);
        }
        catch (ArtifactNotFoundException e) {
            Maven2ServerGlobals.getLogger().info(e);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
        if (list == null) {
            Maven2ServerEmbedderImpl.$$$reportNull$$$0(12);
        }
        return list;
        List<MavenArtifact> list2 = Collections.emptyList();
        if (list2 == null) {
            Maven2ServerEmbedderImpl.$$$reportNull$$$0(13);
        }
        return list2;
    }

    @NotNull
    private MavenArtifact doResolve(MavenArtifactInfo info, List<MavenRemoteRepository> remoteRepositories) throws RemoteException {
        Artifact resolved = this.doResolve(this.createArtifact(info), this.convertRepositories(remoteRepositories));
        MavenArtifact mavenArtifact = Maven2ModelConverter.convertArtifact(resolved, this.getLocalRepositoryFile());
        if (mavenArtifact == null) {
            Maven2ServerEmbedderImpl.$$$reportNull$$$0(14);
        }
        return mavenArtifact;
    }

    private Artifact createArtifact(MavenArtifactInfo info) {
        return this.getComponent(ArtifactFactory.class).createArtifactWithClassifier(info.getGroupId(), info.getArtifactId(), info.getVersion(), info.getPackaging(), info.getClassifier());
    }

    private Artifact doResolve(Artifact artifact, List<ArtifactRepository> remoteRepositories) throws RemoteException {
        try {
            this.myImpl.resolve(artifact, remoteRepositories);
            return artifact;
        }
        catch (Exception e) {
            Maven2ServerGlobals.getLogger().info(e);
            return artifact;
        }
    }

    private List<ArtifactRepository> convertRepositories(List<MavenRemoteRepository> repositories) throws RemoteException {
        ArrayList<ArtifactRepository> result = new ArrayList<ArtifactRepository>();
        for (MavenRemoteRepository each : repositories) {
            try {
                ArtifactRepositoryFactory factory = this.getComponent(ArtifactRepositoryFactory.class);
                result.add(ProjectUtils.buildArtifactRepository((Repository)Maven2ModelConverter.toNativeRepository(each), (ArtifactRepositoryFactory)factory, (PlexusContainer)this.getContainer()));
            }
            catch (InvalidRepositoryException e) {
                Maven2ServerGlobals.getLogger().warn(e);
            }
        }
        return result;
    }

    public Collection<MavenArtifact> resolvePlugin(final @NotNull MavenPlugin plugin, final @NotNull List<MavenRemoteRepository> repositories, final int nativeMavenProjectId, final boolean transitive, MavenToken token) throws MavenServerProcessCanceledException, RemoteException {
        if (plugin == null) {
            Maven2ServerEmbedderImpl.$$$reportNull$$$0(15);
        }
        if (repositories == null) {
            Maven2ServerEmbedderImpl.$$$reportNull$$$0(16);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        return this.doExecute(new Executor<Collection<MavenArtifact>>(){

            @Override
            @NotNull
            public Collection<MavenArtifact> execute() throws Exception {
                try {
                    Plugin mavenPlugin = new Plugin();
                    mavenPlugin.setGroupId(plugin.getGroupId());
                    mavenPlugin.setArtifactId(plugin.getArtifactId());
                    mavenPlugin.setVersion(plugin.getVersion());
                    MavenProject project = RemoteNativeMavenProjectHolder.findProjectById(nativeMavenProjectId);
                    PluginDescriptor result = Maven2ServerEmbedderImpl.this.getComponent(PluginManager.class).verifyPlugin(mavenPlugin, project, Maven2ServerEmbedderImpl.this.myImpl.getSettings(), Maven2ServerEmbedderImpl.this.myImpl.getLocalRepository());
                    THashMap resolvedArtifacts = new THashMap();
                    Artifact pluginArtifact = result.getPluginArtifact();
                    MavenArtifactInfo artifactInfo = new MavenArtifactInfo(pluginArtifact.getGroupId(), pluginArtifact.getArtifactId(), pluginArtifact.getVersion(), pluginArtifact.getType(), null);
                    Maven2ServerEmbedderImpl.this.resolveIfNecessary(artifactInfo, repositories, (Map)resolvedArtifacts);
                    if (transitive) {
                        for (Artifact each : result.getIntroducedDependencyArtifacts()) {
                            Maven2ServerEmbedderImpl.this.resolveIfNecessary(new MavenArtifactInfo(each.getGroupId(), each.getArtifactId(), each.getVersion(), each.getType(), null), repositories, (Map)resolvedArtifacts);
                        }
                        for (Artifact each : result.getDependencies()) {
                            Maven2ServerEmbedderImpl.this.resolveIfNecessary(new MavenArtifactInfo(each.getGroupId(), each.getArtifactId(), each.getVersion(), each.getType(), null), repositories, (Map)resolvedArtifacts);
                        }
                    }
                    return new THashSet(resolvedArtifacts.values());
                }
                catch (Exception e) {
                    Maven2ServerGlobals.getLogger().info(e);
                    List<MavenArtifact> list = Collections.emptyList();
                    if (list == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    return list;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/embedder/Maven2ServerEmbedderImpl$4", "execute"));
            }
        });
    }

    private void resolveIfNecessary(MavenArtifactInfo info, List<MavenRemoteRepository> repos, Map<MavenArtifactInfo, MavenArtifact> resolvedArtifacts) throws RemoteException {
        if (resolvedArtifacts.containsKey(info)) {
            return;
        }
        resolvedArtifacts.put(info, this.doResolve(info, repos));
    }

    @NotNull
    public MavenServerExecutionResult execute(final @NotNull File file, final @NotNull Collection<String> activeProfiles, final @NotNull Collection<String> inactiveProfiles, final @NotNull List<String> goals, final @NotNull List<String> selectedProjects, final boolean alsoMake, final boolean alsoMakeDependents, MavenToken token) throws RemoteException, MavenServerProcessCanceledException {
        if (file == null) {
            Maven2ServerEmbedderImpl.$$$reportNull$$$0(17);
        }
        if (activeProfiles == null) {
            Maven2ServerEmbedderImpl.$$$reportNull$$$0(18);
        }
        if (inactiveProfiles == null) {
            Maven2ServerEmbedderImpl.$$$reportNull$$$0(19);
        }
        if (goals == null) {
            Maven2ServerEmbedderImpl.$$$reportNull$$$0(20);
        }
        if (selectedProjects == null) {
            Maven2ServerEmbedderImpl.$$$reportNull$$$0(21);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        return this.doExecute(new Executor<MavenServerExecutionResult>(){

            @Override
            @NotNull
            public MavenServerExecutionResult execute() throws Exception {
                MavenExecutionResult result = Maven2ServerEmbedderImpl.this.myImpl.execute(file, new ArrayList<String>(activeProfiles), new ArrayList<String>(inactiveProfiles), goals, selectedProjects, alsoMake, alsoMakeDependents);
                MavenServerExecutionResult mavenServerExecutionResult = Maven2ServerEmbedderImpl.this.createExecutionResult(file, result, null);
                if (mavenServerExecutionResult == null) {
                    5.$$$reportNull$$$0(0);
                }
                return mavenServerExecutionResult;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/embedder/Maven2ServerEmbedderImpl$5", "execute"));
            }
        });
    }

    private void validate(File file, Collection<Exception> exceptions, Collection<MavenProjectProblem> problems, Collection<MavenId> unresolvedArtifacts) throws RemoteException {
        for (Exception each : exceptions) {
            Maven2ServerGlobals.getLogger().info(each);
            if (each instanceof InvalidProjectModelException) {
                ModelValidationResult modelValidationResult = ((InvalidProjectModelException)each).getValidationResult();
                if (modelValidationResult != null) {
                    for (Object eachValidationProblem : modelValidationResult.getMessages()) {
                        problems.add(MavenProjectProblem.createStructureProblem((String)file.getPath(), (String)((String)eachValidationProblem)));
                    }
                    continue;
                }
                problems.add(MavenProjectProblem.createStructureProblem((String)file.getPath(), (String)each.getCause().getMessage()));
                continue;
            }
            if (each instanceof ProjectBuildingException) {
                String causeMessage = each.getCause() != null ? each.getCause().getMessage() : each.getMessage();
                problems.add(MavenProjectProblem.createStructureProblem((String)file.getPath(), (String)causeMessage));
                continue;
            }
            problems.add(MavenProjectProblem.createStructureProblem((String)file.getPath(), (String)each.getMessage()));
        }
        unresolvedArtifacts.addAll(this.retrieveUnresolvedArtifactIds());
    }

    private Set<MavenId> retrieveUnresolvedArtifactIds() {
        THashSet result = new THashSet();
        ((CustomWagonManager)this.getComponent(WagonManager.class)).getUnresolvedCollector().retrieveUnresolvedIds((Set<MavenId>)result);
        ((CustomArtifactResolver)this.getComponent(ArtifactResolver.class)).getUnresolvedCollector().retrieveUnresolvedIds((Set<MavenId>)result);
        return result;
    }

    @NotNull
    public File getLocalRepositoryFile() {
        File file = this.myImpl.getLocalRepositoryFile();
        if (file == null) {
            Maven2ServerEmbedderImpl.$$$reportNull$$$0(22);
        }
        return file;
    }

    public <T> T getComponent(Class<T> clazz) {
        return this.myImpl.getComponent(clazz);
    }

    public <T> T getComponent(Class<T> clazz, String roleHint) {
        return this.myImpl.getComponent(clazz, roleHint);
    }

    public PlexusContainer getContainer() {
        return this.myImpl.getContainer();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private <T> T doExecute(final Executor<T> executor) throws MavenServerProcessCanceledException, RemoteException {
        Object t;
        Future future = ExecutorManager.execute(new Callable<T>(){

            @Override
            @NotNull
            public T call() throws Exception {
                Object t = executor.execute();
                if (t == null) {
                    6.$$$reportNull$$$0(0);
                }
                return t;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/embedder/Maven2ServerEmbedderImpl$6", "call"));
            }
        });
        MavenServerProgressIndicator indicator = this.myCurrentIndicator;
        while (true) {
            if (indicator.isCanceled()) {
                throw new MavenServerProcessCanceledException();
            }
            try {
                t = future.get(50L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
                continue;
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof MavenProcessCanceledRuntimeException) {
                    throw new MavenServerProcessCanceledException();
                }
                if (cause instanceof RuntimeRemoteException) {
                    throw ((RuntimeRemoteException)cause).getCause();
                }
                throw this.getRethrowable(cause);
            }
            catch (InterruptedException e) {
                throw new MavenServerProcessCanceledException();
            }
            break;
        }
        if (t == null) {
            Maven2ServerEmbedderImpl.$$$reportNull$$$0(23);
        }
        return t;
    }

    private RuntimeException getRethrowable(Throwable throwable) {
        if (throwable instanceof InvocationTargetException) {
            throwable = throwable.getCause();
        }
        return this.rethrowException(throwable);
    }

    public void customize(@Nullable MavenWorkspaceMap workspaceMap, boolean failOnUnresolvedDependency, @NotNull MavenServerConsole console, @NotNull MavenServerProgressIndicator indicator, boolean alwaysUpdateSnapshots, @Nullable Properties userProperties, MavenToken token) {
        if (console == null) {
            Maven2ServerEmbedderImpl.$$$reportNull$$$0(24);
        }
        if (indicator == null) {
            Maven2ServerEmbedderImpl.$$$reportNull$$$0(25);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        try {
            ((CustomArtifactFactory)this.getComponent(ArtifactFactory.class)).customize();
            ((CustomArtifactFactory)this.getComponent(ProjectArtifactFactory.class)).customize();
            ((CustomArtifactResolver)this.getComponent(ArtifactResolver.class)).customize(workspaceMap, failOnUnresolvedDependency);
            ((CustomRepositoryMetadataManager)this.getComponent(RepositoryMetadataManager.class)).customize(workspaceMap);
            ((CustomWagonManager)this.getComponent(WagonManager.class)).customize(failOnUnresolvedDependency);
            this.myImpl.setUserProperties(userProperties);
            this.setConsoleAndIndicator(console, indicator);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @NotNull
    public List<String> retrieveAvailableVersions(@NotNull String groupId, @NotNull String artifactId, @NotNull List<MavenRemoteRepository> remoteRepositories, MavenToken token) throws RemoteException {
        ArrayList<String> arrayList;
        if (groupId == null) {
            Maven2ServerEmbedderImpl.$$$reportNull$$$0(26);
        }
        if (artifactId == null) {
            Maven2ServerEmbedderImpl.$$$reportNull$$$0(27);
        }
        if (remoteRepositories == null) {
            Maven2ServerEmbedderImpl.$$$reportNull$$$0(28);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        try {
            DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, VersionRange.createFromVersion((String)""), "compile", "pom", null, (ArtifactHandler)new DefaultArtifactHandler("pom"));
            ArtifactRepositoryLayout repositoryLayout = this.getComponent(ArtifactRepositoryLayout.class);
            List versions = this.getComponent(ArtifactMetadataSource.class).retrieveAvailableVersions((Artifact)artifact, (ArtifactRepository)new DefaultArtifactRepository("local", this.getLocalRepositoryFile().getPath(), repositoryLayout), this.convertRepositories(remoteRepositories));
            ArrayList<String> result = new ArrayList<String>();
            for (Object version : versions) {
                result.add(version.toString());
            }
            arrayList = result;
        }
        catch (Exception e) {
            Maven2ServerGlobals.getLogger().info(e);
            List<String> list = Collections.emptyList();
            if (list == null) {
                Maven2ServerEmbedderImpl.$$$reportNull$$$0(30);
            }
            return list;
        }
        if (arrayList == null) {
            Maven2ServerEmbedderImpl.$$$reportNull$$$0(29);
        }
        return arrayList;
    }

    public void customizeComponents(MavenToken token) throws RemoteException {
        MavenServerUtil.checkToken((MavenToken)token);
    }

    private void setConsoleAndIndicator(MavenServerConsole console, MavenServerProgressIndicator indicator) {
        this.myConsoleWrapper.setWrappee(console);
        this.myCurrentIndicator = indicator;
        WagonManager wagon = this.getComponent(WagonManager.class);
        wagon.setDownloadMonitor((TransferListener)(indicator == null ? null : new TransferListenerAdapter(indicator)));
    }

    public void reset(MavenToken token) {
        MavenServerUtil.checkToken((MavenToken)token);
        try {
            this.setConsoleAndIndicator(null, null);
            ((CustomArtifactFactory)this.getComponent(ProjectArtifactFactory.class)).reset();
            ((CustomArtifactFactory)this.getComponent(ArtifactFactory.class)).reset();
            ((CustomArtifactResolver)this.getComponent(ArtifactResolver.class)).reset();
            ((CustomRepositoryMetadataManager)this.getComponent(RepositoryMetadataManager.class)).reset();
            ((CustomWagonManager)this.getComponent(WagonManager.class)).reset();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    public void release(MavenToken token) {
        MavenServerUtil.checkToken((MavenToken)token);
        try {
            this.myImpl.release();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    public void clearCaches(MavenToken token) throws RemoteException {
        MavenServerUtil.checkToken((MavenToken)token);
        this.withProjectCachesDo(new Function<Map, Object>(){

            public Object fun(Map map) {
                map.clear();
                return null;
            }
        });
    }

    public void clearCachesFor(final MavenId projectId, MavenToken token) throws RemoteException {
        MavenServerUtil.checkToken((MavenToken)token);
        this.withProjectCachesDo(new Function<Map, Object>(){

            public Object fun(Map map) {
                map.remove(projectId.getKey());
                return null;
            }
        });
    }

    public MavenModel readModel(File file, MavenToken token) throws RemoteException {
        MavenServerUtil.checkToken((MavenToken)token);
        return null;
    }

    private void withProjectCachesDo(Function<Map, ?> func) throws RemoteException {
        MavenProjectBuilder builder = this.myImpl.getComponent(MavenProjectBuilder.class);
        try {
            Field field = builder.getClass().getDeclaredField("rawProjectCache");
            field.setAccessible(true);
            func.fun((Object)((Map)field.get(builder)));
            field = builder.getClass().getDeclaredField("processedProjectCache");
            field.setAccessible(true);
            func.fun((Object)((Map)field.get(builder)));
        }
        catch (NoSuchFieldException e) {
            Maven2ServerGlobals.getLogger().info(e);
        }
        catch (IllegalAccessException e) {
            Maven2ServerGlobals.getLogger().info(e);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/server/embedder/Maven2ServerEmbedderImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 2: 
            case 6: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeProfiles";
                break;
            }
            case 3: 
            case 7: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inactiveProfiles";
                break;
            }
            case 5: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 9: 
            case 11: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteRepositories";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifacts";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goals";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedProjects";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "interpolateAndAlignModel";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/server/embedder/Maven2ServerEmbedderImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveProject";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveTransitively";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolve";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalRepositoryFile";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "doExecute";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "retrieveAvailableVersions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolveProject";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "evaluateEffectivePom";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resolveTransitively";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "resolvePlugin";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "customize";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "retrieveAvailableVersions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface Executor<T> {
        @NotNull
        public T execute() throws Exception;
    }
}

