/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.cachedValueProfiler;

import com.intellij.internal.cachedValueProfiler.CVPInfo;
import com.intellij.internal.cachedValueProfiler.CVPReader;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TableViewSpeedSearch;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;
import java.util.List;
import javax.swing.SortOrder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.cachedValueProfiler.CVPTableCellEditor;

public class CVPPanel
extends JBPanel {
    private static final ColumnInfo<CVPInfo, String> TOTAL_LIFE_TIME_COLUMN = new ColumnInfo<CVPInfo, String>("Total Life Time"){

        public String valueOf(CVPInfo o) {
            return String.valueOf(o.getTotalLifeTime());
        }

        @Nullable
        public Comparator<CVPInfo> getComparator() {
            return Comparator.comparing(o -> o.getTotalLifeTime());
        }
    };
    private static final ColumnInfo<CVPInfo, String> TOTAL_USE_COUNT_COLUMN = new ColumnInfo<CVPInfo, String>("Total Use Count"){

        public String valueOf(CVPInfo o) {
            return String.valueOf(o.getTotalUseCount());
        }

        @Nullable
        public Comparator<CVPInfo> getComparator() {
            return Comparator.comparing(o -> o.getTotalUseCount());
        }
    };
    private static final ColumnInfo<CVPInfo, String> CREATED_COUNT_COLUMN = new ColumnInfo<CVPInfo, String>("Created"){

        public String valueOf(CVPInfo o) {
            return String.valueOf(o.getCreatedCount());
        }

        @Nullable
        public Comparator<CVPInfo> getComparator() {
            return Comparator.comparing(o -> o.getCreatedCount());
        }
    };
    private static final ColumnInfo<CVPInfo, String> RATIO_COLUMN = new ColumnInfo<CVPInfo, String>("Total Use Count / Created"){

        public String valueOf(CVPInfo o) {
            return String.valueOf(this.value(o));
        }

        private double value(CVPInfo o) {
            return (double)o.getTotalUseCount() / (double)o.getCreatedCount();
        }

        @Nullable
        public Comparator<CVPInfo> getComparator() {
            return Comparator.comparing(o -> this.value((CVPInfo)o));
        }
    };

    public CVPPanel(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            CVPPanel.$$$reportNull$$$0(0);
        }
        if (project == null) {
            CVPPanel.$$$reportNull$$$0(1);
        }
        super((LayoutManager)new BorderLayout());
        try {
            List infos = CVPReader.deserialize((InputStream)file.getInputStream());
            TableView<CVPInfo> table = CVPPanel.createTable(infos, project);
            this.add(ScrollPaneFactory.createScrollPane(table), "Center");
        }
        catch (IOException e) {
            this.add((Component)new JBLabel(e.getMessage()));
        }
    }

    @NotNull
    private static TableView<CVPInfo> createTable(@NotNull List<CVPInfo> infos, @NotNull Project project) {
        if (infos == null) {
            CVPPanel.$$$reportNull$$$0(2);
        }
        if (project == null) {
            CVPPanel.$$$reportNull$$$0(3);
        }
        TableView table = new TableView(new ListTableModel(CVPPanel.getColumns(project), infos, 4, SortOrder.ASCENDING));
        table.setFillsViewportHeight(true);
        table.getColumnModel().getColumn(0).setPreferredWidth(1000);
        CVPPanel.registerSpeedSearch((TableView<CVPInfo>)table);
        CVPPanel.increaseHeaderFontSize((TableView<CVPInfo>)table, 1.2);
        TableView tableView = table;
        if (tableView == null) {
            CVPPanel.$$$reportNull$$$0(4);
        }
        return tableView;
    }

    private static ColumnInfo[] getColumns(@NotNull Project project) {
        if (project == null) {
            CVPPanel.$$$reportNull$$$0(5);
        }
        return new ColumnInfo[]{new OriginColumnInfo(project), TOTAL_LIFE_TIME_COLUMN, TOTAL_USE_COUNT_COLUMN, CREATED_COUNT_COLUMN, RATIO_COLUMN};
    }

    private static void increaseHeaderFontSize(TableView<CVPInfo> table, double ratio) {
        JTableHeader header = table.getTableHeader();
        Font font = header.getFont();
        Font derivedFont = font.deriveFont((float)((double)font.getSize() * ratio));
        header.setFont(derivedFont);
    }

    private static void registerSpeedSearch(TableView<CVPInfo> table) {
        new TableViewSpeedSearch<CVPInfo>(table){

            protected String getItemText(@NotNull CVPInfo element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                return element.getOrigin();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/idea/devkit/cachedValueProfiler/CVPPanel$1", "getItemText"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/cachedValueProfiler/CVPPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/cachedValueProfiler/CVPPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createTable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createTable";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getColumns";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class OriginColumnInfo
    extends ColumnInfo<CVPInfo, String> {
        private final Project myProject;

        private OriginColumnInfo(Project project) {
            super("Origin");
            this.myProject = project;
        }

        public String valueOf(CVPInfo o) {
            return o.getOrigin();
        }

        @Nullable
        public Comparator<CVPInfo> getComparator() {
            return Comparator.comparing(o -> o.getOrigin());
        }

        public boolean isCellEditable(CVPInfo info) {
            return true;
        }

        @Nullable
        public TableCellEditor getEditor(CVPInfo info) {
            return new CVPTableCellEditor(this.myProject);
        }
    }
}

