/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.properties.psi.impl.PropertiesFileImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Action;
import org.jetbrains.idea.devkit.dom.ActionOrGroup;
import org.jetbrains.idea.devkit.inspections.DevKitPluginXmlInspectionBase;

public class PluginXmlI18nInspection
extends DevKitPluginXmlInspectionBase {
    protected void checkDomElement(DomElement element, DomElementAnnotationHolder holder, DomHighlightingHelper helper) {
        if (element instanceof ActionOrGroup) {
            PluginXmlI18nInspection.highlightAction(holder, (ActionOrGroup)element);
        }
    }

    private static void highlightAction(@NotNull DomElementAnnotationHolder holder, @NotNull ActionOrGroup action) {
        String id;
        if (holder == null) {
            PluginXmlI18nInspection.$$$reportNull$$$0(0);
        }
        if (action == null) {
            PluginXmlI18nInspection.$$$reportNull$$$0(1);
        }
        if ((id = action.getId().getStringValue()) == null) {
            return;
        }
        String text = action.getText().getStringValue();
        String desc = action.getDescription().getStringValue();
        if (text == null && desc == null) {
            return;
        }
        GenericAttributeValue internal = PluginXmlI18nInspection.getAttribute(action, "internal");
        if (internal != null && "true".equals(internal.getStringValue())) {
            return;
        }
        holder.createProblem((DomElement)action, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, PluginXmlI18nInspection.getText(), null, new LocalQuickFix[]{PluginXmlI18nInspection.createAnalyzeEPFix(action, id, text, desc)});
    }

    @NotNull
    private static String getText() {
        String string = DevKitBundle.message("inspections.plugin.xml.i18n.name", new Object[0]);
        if (string == null) {
            PluginXmlI18nInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static LocalQuickFix createAnalyzeEPFix(final ActionOrGroup ag, final String id, final String text, final String desc) {
        return new IntentionAndQuickFixAction(){

            @Nls(capitalization=Nls.Capitalization.Sentence)
            @NotNull
            public String getName() {
                String string = PluginXmlI18nInspection.getText();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Nls(capitalization=Nls.Capitalization.Sentence)
            @NotNull
            public String getFamilyName() {
                String string = PluginXmlI18nInspection.getText();
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            public void applyFix(@NotNull Project project, PsiFile xmlFile, @Nullable Editor editor) {
                PropertiesFileImpl propertiesFile;
                PropertiesFileImpl fileToWrite;
                String prefix;
                XmlElement xml;
                if (project == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((xml = ag.getXmlElement()) == null) {
                    return;
                }
                String string = prefix = ag instanceof Action ? "action" : "group";
                if (text != null) {
                    ag.getText().setStringValue(null);
                }
                if (desc != null) {
                    ag.getDescription().setStringValue(null);
                }
                Object object = fileToWrite = (propertiesFile = DevKitPluginXmlInspectionBase.findBundlePropertiesFile(ag)) != null ? propertiesFile : xmlFile;
                if (text != null) {
                    this.append(project, (PsiFile)fileToWrite, prefix + "." + id + ".text=" + text);
                }
                if (desc != null) {
                    this.append(project, (PsiFile)fileToWrite, prefix + "." + id + ".description=" + desc);
                }
                this.removeEmptyLines(xml);
            }

            private void removeEmptyLines(XmlElement xml) {
                xml.processElements(element -> {
                    IElementType type;
                    PsiElement next;
                    if (element instanceof PsiWhiteSpace && element.textContains('\n') && (next = element.getNextSibling()) instanceof LeafPsiElement && ((type = ((LeafPsiElement)next).getElementType()) == XmlTokenType.XML_TAG_END || type == XmlTokenType.XML_EMPTY_ELEMENT_END)) {
                        element.delete();
                        return false;
                    }
                    return true;
                }, xml.getFirstChild());
            }

            private void append(@NotNull Project project, @NotNull PsiFile fileToWrite, @NonNls String text2) {
                Document document;
                if (project == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (fileToWrite == null) {
                    1.$$$reportNull$$$0(4);
                }
                if ((document = PsiDocumentManager.getInstance((Project)project).getDocument(fileToWrite)) == null) {
                    return;
                }
                PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
                int length = document.getTextLength();
                document.insertString(length, (CharSequence)("\n" + text2));
                PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/idea/devkit/inspections/PluginXmlI18nInspection$1";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fileToWrite";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/idea/devkit/inspections/PluginXmlI18nInspection$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "append";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/inspections/PluginXmlI18nInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/PluginXmlI18nInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "highlightAction";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

