/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.ide.DataManager;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.uast.UastHintedVisitorAdapter;
import com.intellij.ui.JBColor;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.idea.devkit.themes.metadata.UIThemeMetadataService;
import org.jetbrains.idea.devkit.util.PsiUtil;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

public class UnregisteredNamedColorInspection
extends DevKitUastInspectionBase {
    private static final String JB_COLOR_FQN = JBColor.class.getCanonicalName();
    private static final String NAMED_COLOR_METHOD_NAME = "namedColor";
    private static final Class<? extends UElement>[] U_ELEMENT_TYPES_HINT = new Class[]{UCallExpression.class};

    @Override
    protected PsiElementVisitor buildInternalVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            UnregisteredNamedColorInspection.$$$reportNull$$$0(0);
        }
        if (!PsiUtil.isPluginProject(holder.getProject())) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return UastHintedVisitorAdapter.create((Language)holder.getFile().getLanguage(), (AbstractUastNonRecursiveVisitor)new AbstractUastNonRecursiveVisitor(){

            public boolean visitExpression(@NotNull UExpression node) {
                UElement parent;
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (node instanceof UCallExpression) {
                    UnregisteredNamedColorInspection.handleCallExpression(holder, (UCallExpression)node);
                } else if (node instanceof UQualifiedReferenceExpression && (parent = node.getUastParent()) instanceof UCallExpression) {
                    UnregisteredNamedColorInspection.handleCallExpression(holder, (UCallExpression)parent);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/idea/devkit/inspections/UnregisteredNamedColorInspection$1", "visitExpression"));
            }
        }, (Class[])U_ELEMENT_TYPES_HINT);
    }

    private static void handleCallExpression(@NotNull ProblemsHolder holder, @NotNull UCallExpression expression) {
        if (holder == null) {
            UnregisteredNamedColorInspection.$$$reportNull$$$0(1);
        }
        if (expression == null) {
            UnregisteredNamedColorInspection.$$$reportNull$$$0(2);
        }
        if (!UnregisteredNamedColorInspection.isNamedColorCall(expression)) {
            return;
        }
        String key = UnregisteredNamedColorInspection.getKey(expression);
        if (key == null) {
            return;
        }
        if (!UnregisteredNamedColorInspection.isRegisteredNamedColor(key)) {
            UnregisteredNamedColorInspection.registerProblem(key, holder, expression);
        }
    }

    private static boolean isNamedColorCall(@NotNull UCallExpression expression) {
        if (expression == null) {
            UnregisteredNamedColorInspection.$$$reportNull$$$0(3);
        }
        if (expression.getKind() != UastCallKind.METHOD_CALL) {
            return false;
        }
        if (!NAMED_COLOR_METHOD_NAME.equals(expression.getMethodName())) {
            return false;
        }
        PsiMethod resolved = expression.resolve();
        if (resolved == null) {
            return false;
        }
        PsiClass containingClass = resolved.getContainingClass();
        return containingClass != null && JB_COLOR_FQN.equals(containingClass.getQualifiedName());
    }

    @Nullable
    private static String getKey(@NotNull UCallExpression expression) {
        List arguments;
        if (expression == null) {
            UnregisteredNamedColorInspection.$$$reportNull$$$0(4);
        }
        if ((arguments = expression.getValueArguments()).isEmpty()) {
            return null;
        }
        UExpression firstArgument = (UExpression)arguments.get(0);
        Object evaluated = firstArgument.evaluate();
        if (!(evaluated instanceof String)) {
            return null;
        }
        return (String)evaluated;
    }

    private static boolean isRegisteredNamedColor(@NotNull String key) {
        if (key == null) {
            UnregisteredNamedColorInspection.$$$reportNull$$$0(5);
        }
        return UIThemeMetadataService.getInstance().findByKey(key) != null;
    }

    private static void registerProblem(@NotNull String key, @NotNull ProblemsHolder holder, @NotNull UCallExpression expression) {
        UIdentifier identifier;
        if (key == null) {
            UnregisteredNamedColorInspection.$$$reportNull$$$0(6);
        }
        if (holder == null) {
            UnregisteredNamedColorInspection.$$$reportNull$$$0(7);
        }
        if (expression == null) {
            UnregisteredNamedColorInspection.$$$reportNull$$$0(8);
        }
        if ((identifier = expression.getMethodIdentifier()) == null) {
            return;
        }
        PsiElement identifierPsi = identifier.getPsi();
        if (identifierPsi == null) {
            return;
        }
        holder.registerProblem(identifierPsi, DevKitBundle.message("inspections.unregistered.named.color", key), new LocalQuickFix[]{new LocalQuickFix(){

            @Nls(capitalization=Nls.Capitalization.Sentence)
            @NotNull
            public String getFamilyName() {
                return "Navigate to Theme metadata file";
            }

            public boolean startInWriteAction() {
                return false;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                Collection metadataFiles;
                if (project == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (descriptor == null) {
                    2.$$$reportNull$$$0(1);
                }
                if ((metadataFiles = FilenameIndex.getAllFilesByExt((Project)project, (String)"themeMetadata.json")).isEmpty()) {
                    return;
                }
                PsiFile[] psiFiles = PsiUtilCore.toPsiFiles((PsiManager)PsiManager.getInstance((Project)project), (Collection)metadataFiles).toArray(PsiFile.EMPTY_ARRAY);
                DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(context -> NavigationUtil.getPsiElementPopup((PsiElement[])psiFiles, (String)"Theme Metadata Files").showInBestPositionFor(context));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "descriptor";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/idea/devkit/inspections/UnregisteredNamedColorInspection$2";
                objectArray[2] = "applyFix";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/devkit/inspections/UnregisteredNamedColorInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildInternalVisitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "handleCallExpression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isNamedColorCall";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getKey";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isRegisteredNamedColor";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "registerProblem";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

