/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionBase;

public class FileEqualsUsageInspection
extends DevKitInspectionBase {
    static final String MESSAGE = "Do not use File.equals/hashCode/compareTo as they don't honor case-sensitivity on macOS. Please use FileUtil.filesEquals/fileHashCode/compareFiles instead";
    private static final Set<String> METHOD_NAMES = ContainerUtil.immutableSet((Object[])new String[]{"equals", "compareTo", "hashCode"});

    @Override
    @NotNull
    public PsiElementVisitor buildInternalVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            FileEqualsUsageInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                PsiReferenceExpression methodExpression = expression.getMethodExpression();
                PsiElement resolved = methodExpression.resolve();
                if (!(resolved instanceof PsiMethod)) {
                    return;
                }
                PsiMethod method = (PsiMethod)resolved;
                PsiClass clazz = method.getContainingClass();
                if (clazz == null) {
                    return;
                }
                if ("java.io.File".equals(clazz.getQualifiedName()) && METHOD_NAMES.contains(method.getName())) {
                    if (JavaPsiFacade.getInstance((Project)holder.getProject()).findClass(FileUtil.class.getName(), expression.getResolveScope()) == null) {
                        return;
                    }
                    holder.registerProblem((PsiReference)methodExpression, FileEqualsUsageInspection.MESSAGE, ProblemHighlightType.LIKE_DEPRECATED);
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/idea/devkit/inspections/internal/FileEqualsUsageInspection", "buildInternalVisitor"));
    }
}

