/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.internal;

import com.intellij.ide.IdeView;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.xml.XmlFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.dom.ApplicationComponents;
import org.jetbrains.idea.devkit.dom.Dependency;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.Extensions;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.dom.ModuleComponents;
import org.jetbrains.idea.devkit.dom.ProjectComponents;
import org.jetbrains.idea.devkit.internal.AnalyzeUnloadablePluginsAction;
import org.jetbrains.idea.devkit.internal.ExtensionPointOwners;
import org.jetbrains.idea.devkit.internal.PluginUnloadabilityStatus;
import org.jetbrains.idea.devkit.util.DescriptorUtil;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016JB\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J&\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u00192\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/idea/devkit/internal/AnalyzeUnloadablePluginsAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "analyzePluginFile", "", "ideaPlugin", "Lorg/jetbrains/idea/devkit/dom/IdeaPlugin;", "analysisErrors", "", "", "nonDynamicEPs", "", "unspecifiedDynamicEPs", "extensionPointOwners", "Lorg/jetbrains/idea/devkit/internal/ExtensionPointOwners;", "analyzeUnloadable", "Lorg/jetbrains/idea/devkit/internal/PluginUnloadabilityStatus;", "showReport", "project", "Lcom/intellij/openapi/project/Project;", "result", "", "intellij.devkit"})
public final class AnalyzeUnloadablePluginsAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        IdeView view;
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        IdeView ideView = view = (IdeView)e.getData(LangDataKeys.IDE_VIEW);
        PsiDirectory dir = ideView != null ? ideView.getOrChooseDirectory() : null;
        boolean bl = false;
        List result = new ArrayList();
        ExtensionPointOwners extensionPointOwners = new ExtensionPointOwners();
        ProgressManager progressManager = ProgressManager.getInstance();
        Runnable runnable = new Runnable(this, dir, project2, extensionPointOwners, result){
            final /* synthetic */ AnalyzeUnloadablePluginsAction this$0;
            final /* synthetic */ PsiDirectory $dir;
            final /* synthetic */ Project $project;
            final /* synthetic */ ExtensionPointOwners $extensionPointOwners;
            final /* synthetic */ List $result;

            public final void run() {
                boolean $i$f$runReadAction = false;
                ApplicationManager.getApplication().runReadAction((Computable)new Computable<T>(this){
                    final /* synthetic */ actionPerformed.show.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final T compute() {
                        ProgressIndicator pi;
                        boolean bl = false;
                        ProgressManager progressManager = ProgressManager.getInstance();
                        Intrinsics.checkExpressionValueIsNotNull((Object)progressManager, (String)"ProgressManager.getInstance()");
                        ProgressIndicator progressIndicator = pi = progressManager.getProgressIndicator();
                        Intrinsics.checkExpressionValueIsNotNull((Object)progressIndicator, (String)"pi");
                        progressIndicator.setIndeterminate(false);
                        PsiDirectory psiDirectory = this.this$0.$dir;
                        GlobalSearchScope globalSearchScope = psiDirectory == null ? GlobalSearchScopesCore.projectProductionScope((Project)this.this$0.$project) : GlobalSearchScopesCore.directoryScope((PsiDirectory)this.this$0.$dir, (boolean)true);
                        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"when (dir) {\n           \u2026pe(dir, true)\n          }");
                        GlobalSearchScope searchScope = globalSearchScope;
                        PsiFile[] pluginXmlFiles = FilenameIndex.getFilesByName((Project)this.this$0.$project, (String)"plugin.xml", (GlobalSearchScope)searchScope);
                        Intrinsics.checkExpressionValueIsNotNull((Object)pluginXmlFiles, (String)"pluginXmlFiles");
                        PsiFile[] psiFileArray = pluginXmlFiles;
                        int n = psiFileArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            void processed;
                            PsiFile pluginXmlFile = psiFileArray[n2];
                            pi.checkCanceled();
                            pi.setFraction((double)processed / (double)pluginXmlFiles.length);
                            if (pluginXmlFile instanceof XmlFile) {
                                ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.this$0.$project);
                                Intrinsics.checkExpressionValueIsNotNull((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
                                if (projectRootManager.getFileIndex().isUnderSourceRootOfType(((XmlFile)pluginXmlFile).getVirtualFile(), JavaModuleSourceRootTypes.PRODUCTION)) {
                                    if (DescriptorUtil.getIdeaPlugin((XmlFile)pluginXmlFile) == null) {
                                    } else {
                                        IdeaPlugin ideaPlugin;
                                        Intrinsics.checkExpressionValueIsNotNull((Object)ideaPlugin, (String)"DescriptorUtil.getIdeaPl\u2026luginXmlFile) ?: continue");
                                        PluginUnloadabilityStatus status = AnalyzeUnloadablePluginsAction.access$analyzeUnloadable(this.this$0.this$0, ideaPlugin, this.this$0.$extensionPointOwners);
                                        this.this$0.$result.add(status);
                                        pi.setText(status.getPluginId());
                                    }
                                }
                            }
                            ++processed;
                        }
                        return (T)Unit.INSTANCE;
                    }
                });
            }
            {
                this.this$0 = analyzeUnloadablePluginsAction;
                this.$dir = psiDirectory;
                this.$project = project;
                this.$extensionPointOwners = extensionPointOwners;
                this.$result = list;
            }
        };
        StringBuilder stringBuilder = new StringBuilder().append("Analyzing Plugins (");
        Object object = dir;
        if (object == null || (object = object.getName()) == null) {
            object = "Project";
        }
        boolean show2 = progressManager.runProcessWithProgressSynchronously(runnable, stringBuilder.append((String)object).append(')').toString(), true, e.getProject());
        if (show2) {
            this.showReport(project2, result, extensionPointOwners);
        }
        extensionPointOwners.dispose();
    }

    /*
     * Unable to fully structure code
     */
    private final void showReport(Project project, List<PluginUnloadabilityStatus> result, ExtensionPointOwners extensionPointOwners) {
        block26: {
            var5_4 = false;
            var6_6 = new StringBuilder();
            var7_7 = false;
            var8_9 = false;
            $this$buildString = var6_6;
            $i$a$-buildString-AnalyzeUnloadablePluginsAction$showReport$report$1 = false;
            $this$any$iv = result;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v0 = false;
            } else {
                var13_18 = $this$any$iv.iterator();
                while (var13_18.hasNext()) {
                    element$iv = var13_18.next();
                    it = (PluginUnloadabilityStatus)element$iv;
                    $i$a$-any-AnalyzeUnloadablePluginsAction$showReport$report$1$1 = false;
                    var17_47 = it.getAnalysisErrors();
                    var18_58 = false;
                    if (!(var17_47.isEmpty() == false)) continue;
                    v0 = true;
                    break block26;
                }
                v0 = false;
            }
        }
        if (v0) {
            $this$any$iv = $this$buildString;
            $i$f$any = "Analysis errors:";
            var13_19 = false;
            v1 = $this$any$iv.append($i$f$any);
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"append(value)");
            StringsKt.appendln((StringBuilder)v1);
            $this$filter$iv = result;
            $i$f$filter = false;
            it = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (PluginUnloadabilityStatus)element$iv$iv;
                $i$a$-filter-AnalyzeUnloadablePluginsAction$showReport$report$1$2 = false;
                var22_83 = it.getAnalysisErrors();
                var23_86 = false;
                if (!(var22_83.isEmpty() == false)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (PluginUnloadabilityStatus status : (List)destination$iv$iv) {
                $this$filter$iv = $this$buildString;
                $i$f$filter = status.getPluginId();
                $this$filterTo$iv$iv = false;
                v2 = $this$filter$iv.append($i$f$filter);
                Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"append(value)");
                StringsKt.appendln((StringBuilder)v2);
                for (String analysisError : status.getAnalysisErrors()) {
                    $this$filterTo$iv$iv = $this$buildString;
                    destination$iv$iv = false;
                    v3 = $this$filterTo$iv$iv.append(analysisError);
                    Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"append(value)");
                    StringsKt.appendln((StringBuilder)v3);
                }
                StringsKt.appendln((StringBuilder)$this$buildString);
            }
        }
        $this$filter$iv = result;
        $i$f$filter = false;
        $i$f$filter = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (PluginUnloadabilityStatus)element$iv$iv;
            $i$a$-filter-AnalyzeUnloadablePluginsAction$showReport$report$1$unloadablePlugins$1 = false;
            if (!(it.getComponentCount() == 0 && it.getUnspecifiedDynamicEPs().isEmpty() != false && it.getNonDynamicEPs().isEmpty() != false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        unloadablePlugins = (List)destination$iv$iv;
        $this$filter$iv = $this$buildString;
        $i$f$filter = "Can unload " + unloadablePlugins.size() + " plugins out of " + result.size();
        $this$filterTo$iv$iv = false;
        v4 = $this$filter$iv.append($i$f$filter);
        Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"append(value)");
        StringsKt.appendln((StringBuilder)v4);
        for (PluginUnloadabilityStatus status : unloadablePlugins) {
            $this$filterTo$iv$iv = $this$buildString;
            destination$iv$iv = status.getPluginId();
            $i$f$filterTo = false;
            v5 = $this$filterTo$iv$iv.append((String)destination$iv$iv);
            Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"append(value)");
            StringsKt.appendln((StringBuilder)v5);
        }
        StringsKt.appendln((StringBuilder)$this$buildString);
        $this$filter$iv = result;
        $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (PluginUnloadabilityStatus)element$iv$iv;
            $i$a$-filter-AnalyzeUnloadablePluginsAction$showReport$report$1$pluginsUsingComponents$1 = false;
            if (!(it.getComponentCount() > 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$sortedByDescending$iv = (List)destination$iv$iv;
        $i$f$sortedByDescending = false;
        $this$filterTo$iv$iv = $this$sortedByDescending$iv;
        destination$iv$iv = false;
        $i$f$filterTo = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                PluginUnloadabilityStatus it = (PluginUnloadabilityStatus)b;
                boolean bl2 = false;
                Comparable comparable = Integer.valueOf(it.getComponentCount());
                it = (PluginUnloadabilityStatus)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Integer n = it.getComponentCount();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        };
        pluginsUsingComponents = CollectionsKt.sortedWith((Iterable)$this$filterTo$iv$iv, (Comparator)$i$f$filterTo);
        $this$sortedByDescending$iv = $this$buildString;
        $i$f$sortedByDescending = "Plugins using components (" + pluginsUsingComponents.size() + "):";
        $this$filterTo$iv$iv = false;
        v6 = $this$sortedByDescending$iv.append($i$f$sortedByDescending);
        Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"append(value)");
        StringsKt.appendln((StringBuilder)v6);
        for (PluginUnloadabilityStatus status : pluginsUsingComponents) {
            $this$filterTo$iv$iv = $this$buildString;
            destination$iv$iv = status.getPluginId() + " (" + status.getComponentCount() + ')';
            $i$f$filterTo = false;
            v7 = $this$filterTo$iv$iv.append(destination$iv$iv);
            Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"append(value)");
            StringsKt.appendln((StringBuilder)v7);
        }
        StringsKt.appendln((StringBuilder)$this$buildString);
        $this$filter$iv = result;
        $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (E element$iv$iv : $this$filterTo$iv$iv) {
            block27: {
                it = (PluginUnloadabilityStatus)element$iv$iv;
                $i$a$-filter-AnalyzeUnloadablePluginsAction$showReport$report$1$closePlugins$1 = false;
                if (it.getComponentCount() != 0 || !it.getNonDynamicEPs().isEmpty()) ** GOTO lbl-1000
                $this$any$iv = it.getUnspecifiedDynamicEPs();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v8 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        it = (String)element$iv;
                        $i$a$-any-AnalyzeUnloadablePluginsAction$showReport$report$1$closePlugins$1$1 = false;
                        if (!(StringsKt.startsWith$default((String)it, (String)"cidr", (boolean)false, (int)2, null) == false && StringsKt.startsWith$default((String)it, (String)"appcode", (boolean)false, (int)2, null) == false)) continue;
                        v8 = true;
                        break block27;
                    }
                    v8 = false;
                }
            }
            if (v8) {
                v9 = true;
            } else lbl-1000:
            // 2 sources

            {
                v9 = false;
            }
            if (!v9) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        closePlugins = (List)destination$iv$iv;
        $this$filter$iv = closePlugins;
        $i$f$filter = false;
        if ($this$filter$iv.isEmpty() == false) {
            $this$filter$iv = $this$buildString;
            $i$f$filter = "Plugins closest to being unloadable (" + RangesKt.coerceAtMost((int)closePlugins.size(), (int)40) + " out of " + closePlugins.size() + "):";
            $this$filterTo$iv$iv = false;
            v10 = $this$filter$iv.append($i$f$filter);
            Intrinsics.checkExpressionValueIsNotNull((Object)v10, (String)"append(value)");
            StringsKt.appendln((StringBuilder)v10);
            $this$sortedBy$iv = closePlugins;
            $i$f$sortedBy = false;
            $i$f$filterTo = $this$sortedBy$iv;
            element$iv$iv = false;
            var20_77 = new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    PluginUnloadabilityStatus it = (PluginUnloadabilityStatus)a;
                    boolean bl2 = false;
                    Comparable comparable = Integer.valueOf(it.getUnspecifiedDynamicEPs().size());
                    it = (PluginUnloadabilityStatus)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Integer n = it.getUnspecifiedDynamicEPs().size();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                }
            };
            for (PluginUnloadabilityStatus status : CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$i$f$filterTo, (Comparator)var20_77), (int)40)) {
                $this$sortedBy$iv = $this$buildString;
                $i$f$sortedBy = status.getPluginId() + " - " + CollectionsKt.joinToString$default((Iterable)status.getUnspecifiedDynamicEPs(), null, null, null, (int)0, null, null, (int)63, null);
                $i$f$filterTo = false;
                v11 = $this$sortedBy$iv.append($i$f$sortedBy);
                Intrinsics.checkExpressionValueIsNotNull((Object)v11, (String)"append(value)");
                StringsKt.appendln((StringBuilder)v11);
            }
            StringsKt.appendln((StringBuilder)$this$buildString);
        }
        $i$f$filter = false;
        epUsagesMap = new LinkedHashMap<K, V>();
        for (PluginUnloadabilityStatus pluginUnloadabilityStatus : result) {
            for (String ep : pluginUnloadabilityStatus.getUnspecifiedDynamicEPs()) {
                epUsagesMap.put(ep, ((Number)epUsagesMap.getOrDefault(ep, 0)).intValue() + 1);
            }
        }
        pluginUnloadabilityStatus = $this$buildString;
        $this$sortedBy$iv = "EP usage statistics (" + epUsagesMap.size() + " non-dynamic EPs remaining):";
        ep = false;
        v12 = pluginUnloadabilityStatus.append((String)$this$sortedBy$iv);
        Intrinsics.checkExpressionValueIsNotNull((Object)v12, (String)"append(value)");
        StringsKt.appendln((StringBuilder)v12);
        $this$sortedByDescending$iv = MapsKt.toList((Map)epUsagesMap);
        $i$f$sortedByDescending = false;
        $i$f$filterTo = $this$sortedByDescending$iv;
        element$iv$iv = false;
        var20_78 = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Pair it = (Pair)b;
                boolean bl2 = false;
                Comparable comparable = Integer.valueOf(((Number)it.getSecond()).intValue());
                it = (Pair)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Integer n = ((Number)it.getSecond()).intValue();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        };
        epUsagesList = CollectionsKt.sortedWith((Iterable)$i$f$filterTo, (Comparator)var20_78);
        for (Object pair : epUsagesList) {
            $this$buildString.append(((Number)pair.getSecond()).intValue() + ": " + (String)pair.getFirst());
            if (Registry.is((String)"analyze.unloadable.discover.owners")) {
                $this$buildString.append(" (" + extensionPointOwners.getOwner((String)pair.getFirst()) + ')');
            }
            StringsKt.appendln((StringBuilder)$this$buildString);
        }
        if (Registry.is((String)"analyze.unloadable.discover.owners")) {
            StringsKt.appendln((StringBuilder)$this$buildString);
            pair = $this$buildString;
            var17_57 = "EPs grouped by owner:";
            $i$f$filterTo = false;
            v13 = pair.append((String)var17_57);
            Intrinsics.checkExpressionValueIsNotNull((Object)v13, (String)"append(value)");
            StringsKt.appendln((StringBuilder)v13);
            for (String owner : extensionPointOwners.getSortedOwners()) {
                owned = extensionPointOwners.getOwnedEPs(owner);
                element$iv$iv = $this$buildString;
                var20_78 = owner + ": " + owned.size();
                var21_81 = false;
                v14 = element$iv$iv.append((String)var20_78);
                Intrinsics.checkExpressionValueIsNotNull((Object)v14, (String)"append(value)");
                StringsKt.appendln((StringBuilder)v14);
                for (String ep : owned) {
                    var21_82 = $this$buildString;
                    var22_85 = false;
                    v15 = var21_82.append(ep);
                    Intrinsics.checkExpressionValueIsNotNull((Object)v15, (String)"append(value)");
                    StringsKt.appendln((StringBuilder)v15);
                }
                StringsKt.appendln((StringBuilder)$this$buildString);
            }
        }
        v16 = var6_6.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)v16, (String)"StringBuilder().apply(builderAction).toString()");
        report = v16;
        var6_6 = StringCompanionObject.INSTANCE;
        var7_8 = "AnalyzeUnloadablePlugins-Report-%s.txt";
        var8_10 = new Object[]{DateFormatUtil.formatDateTime((long)System.currentTimeMillis())};
        var9_12 = false;
        v17 = String.format(var7_8, Arrays.copyOf(var8_10, var8_10.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)v17, (String)"java.lang.String.format(format, *args)");
        fileName = v17;
        file = new LightVirtualFile(fileName, (CharSequence)report);
        descriptor = new OpenFileDescriptor(project, (VirtualFile)file);
        FileEditorManager.getInstance((Project)project).openEditor(descriptor, true);
    }

    private final PluginUnloadabilityStatus analyzeUnloadable(IdeaPlugin ideaPlugin, ExtensionPointOwners extensionPointOwners) {
        boolean bl = false;
        Set unspecifiedDynamicEPs = new LinkedHashSet();
        boolean bl2 = false;
        Set nonDynamicEPs = new LinkedHashSet();
        boolean bl3 = false;
        List analysisErrors = new ArrayList();
        int componentCount = this.analyzePluginFile(ideaPlugin, analysisErrors, nonDynamicEPs, unspecifiedDynamicEPs, extensionPointOwners);
        for (Dependency dependency : ideaPlugin.getDependencies()) {
            IdeaPlugin depIdeaPlugin;
            XmlFile depXmlFile;
            if (DescriptorUtil.resolveDependencyToXmlFile(dependency) == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)depXmlFile, (String)"DescriptorUtil.resolveDe\u2026e(dependency) ?: continue");
            if (DescriptorUtil.getIdeaPlugin(depXmlFile) == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)depIdeaPlugin, (String)"DescriptorUtil.getIdeaPl\u2026n(depXmlFile) ?: continue");
            componentCount += this.analyzePluginFile(depIdeaPlugin, analysisErrors, nonDynamicEPs, unspecifiedDynamicEPs, extensionPointOwners);
        }
        String string = ideaPlugin.getPluginId();
        if (string == null) {
            string = "?";
        }
        return new PluginUnloadabilityStatus(string, unspecifiedDynamicEPs, nonDynamicEPs, componentCount, analysisErrors);
    }

    /*
     * WARNING - void declaration
     */
    private final int analyzePluginFile(IdeaPlugin ideaPlugin, List<String> analysisErrors, Set<String> nonDynamicEPs, Set<String> unspecifiedDynamicEPs, ExtensionPointOwners extensionPointOwners) {
        Iterable list$iv$iv;
        Object it;
        Iterable $this$flatMapTo$iv$iv;
        void $this$flatMapTo$iv$iv2;
        List<Extensions> list = ideaPlugin.getExtensions();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"ideaPlugin.extensions");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap2 = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            Extensions it2 = (Extensions)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv2 = it2.collectExtensions();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv2);
        }
        Iterator iterator = ((List)destination$iv$iv).iterator();
        while (iterator.hasNext()) {
            Extension extension;
            Extension extension2 = extension = (Extension)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)extension2, (String)"extension");
            ExtensionPoint ep = extension2.getExtensionPoint();
            if (ep == null) {
                analysisErrors.add("Cannot resolve EP " + extension.getXmlElementName());
                continue;
            }
            if (Intrinsics.areEqual((Object)ep.getModule(), (Object)ideaPlugin.getModule())) continue;
            if (Registry.is((String)"analyze.unloadable.discover.owners")) {
                extensionPointOwners.discoverOwner(ep);
            }
            GenericAttributeValue<Boolean> genericAttributeValue = ep.getDynamic();
            Intrinsics.checkExpressionValueIsNotNull(genericAttributeValue, (String)"ep.dynamic");
            Boolean $i$f$flatMap2 = (Boolean)genericAttributeValue.getValue();
            if (Intrinsics.areEqual((Object)$i$f$flatMap2, (Object)false)) {
                String string = ep.getEffectiveQualifiedName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ep.effectiveQualifiedName");
                nonDynamicEPs.add(string);
                continue;
            }
            if ($i$f$flatMap2 != null) continue;
            String string = ep.getEffectiveQualifiedName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ep.effectiveQualifiedName");
            unspecifiedDynamicEPs.add(string);
        }
        List<ApplicationComponents> list2 = ideaPlugin.getApplicationComponents();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"ideaPlugin.applicationComponents");
        Iterable $this$flatMap$iv2 = list2;
        boolean $i$f$flatMap3 = false;
        Iterable $i$f$flatMap2 = $this$flatMap$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (ApplicationComponents)element$iv$iv;
            boolean bl = false;
            ApplicationComponents applicationComponents = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)applicationComponents, (String)"it");
            list$iv$iv = applicationComponents.getComponents();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        int n = ((List)destination$iv$iv2).size();
        List<ProjectComponents> list3 = ideaPlugin.getProjectComponents();
        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"ideaPlugin.projectComponents");
        $this$flatMap$iv2 = list3;
        int n2 = n;
        $i$f$flatMap3 = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv2;
        destination$iv$iv2 = new ArrayList();
        $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (ProjectComponents)element$iv$iv;
            boolean bl = false;
            Object object = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it");
            list$iv$iv = object.getComponents();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        List list4 = (List)destination$iv$iv2;
        int n3 = n2 + list4.size();
        List<ModuleComponents> list5 = ideaPlugin.getModuleComponents();
        Intrinsics.checkExpressionValueIsNotNull(list5, (String)"ideaPlugin.moduleComponents");
        $this$flatMap$iv2 = list5;
        n2 = n3;
        $i$f$flatMap3 = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv2;
        destination$iv$iv2 = new ArrayList();
        $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (ModuleComponents)element$iv$iv;
            boolean bl = false;
            Object object = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it");
            list$iv$iv = object.getComponents();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        list4 = (List)destination$iv$iv2;
        int componentCount = n2 + list4.size();
        return componentCount;
    }

    public static final /* synthetic */ PluginUnloadabilityStatus access$analyzeUnloadable(AnalyzeUnloadablePluginsAction $this, IdeaPlugin ideaPlugin, ExtensionPointOwners extensionPointOwners) {
        return $this.analyzeUnloadable(ideaPlugin, extensionPointOwners);
    }
}

