/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.references;

import com.intellij.codeInspection.unused.ImplicitPropertyUsageProvider;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.VirtualFilePattern;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomTarget;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.ActionOrGroup;
import org.jetbrains.idea.devkit.dom.index.IdeaPluginRegistrationIndex;
import org.jetbrains.idea.devkit.util.PsiUtil;

public class DevKitActionOrGroupIdReferenceContributor
extends PsiReferenceContributor {
    @NonNls
    private static final String ACTION = "action.";
    @NonNls
    private static final String GROUP = "group.";
    @NonNls
    private static final String TEXT = ".text";
    @NonNls
    private static final String DESC = ".description";
    @NonNls
    private static final String BUNDLE_PROPERTIES = "Bundle.properties";
    public static final PsiElementResolveResult[] EMPTY_RESOLVE_RESULT = new PsiElementResolveResult[0];

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            DevKitActionOrGroupIdReferenceContributor.$$$reportNull$$$0(0);
        }
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(PropertyKeyImpl.class).inVirtualFile((ElementPattern)DevKitActionOrGroupIdReferenceContributor.bundleFile()), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!(element instanceof PropertyKeyImpl)) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                if (!PsiUtil.isPluginProject(element.getProject())) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                String text = ((PropertyKeyImpl)element).getText();
                PsiReference[] psiReferenceArray = (PsiReference[])JBIterable.of((Object[])new PsiReference[]{this.createRef(element, text, DevKitActionOrGroupIdReferenceContributor.ACTION, DevKitActionOrGroupIdReferenceContributor.TEXT), this.createRef(element, text, DevKitActionOrGroupIdReferenceContributor.ACTION, DevKitActionOrGroupIdReferenceContributor.DESC), this.createRef(element, text, DevKitActionOrGroupIdReferenceContributor.GROUP, DevKitActionOrGroupIdReferenceContributor.TEXT), this.createRef(element, text, DevKitActionOrGroupIdReferenceContributor.GROUP, DevKitActionOrGroupIdReferenceContributor.DESC)}).filter(Objects::nonNull).toArray((Object[])PsiReference.EMPTY_ARRAY);
                if (psiReferenceArray == null) {
                    1.$$$reportNull$$$0(4);
                }
                return psiReferenceArray;
            }

            @Nullable
            private PsiReference createRef(@NotNull PsiElement element, String text, String prefix, String suffix) {
                if (element == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (!text.startsWith(prefix) || !text.endsWith(suffix)) {
                    return null;
                }
                String id = text.replace(prefix, "").replace(suffix, "");
                return new DevKitActionReference(id, prefix, element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/idea/devkit/references/DevKitActionOrGroupIdReferenceContributor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/idea/devkit/references/DevKitActionOrGroupIdReferenceContributor$1";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "createRef";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    private static VirtualFilePattern bundleFile() {
        return PlatformPatterns.virtualFile().ofType((FileType)PropertiesFileType.INSTANCE).withName((ElementPattern)StandardPatterns.string().endsWith(BUNDLE_PROPERTIES));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "org/jetbrains/idea/devkit/references/DevKitActionOrGroupIdReferenceContributor", "registerReferenceProviders"));
    }

    public static class ImplicitUsageProvider
    extends ImplicitPropertyUsageProvider {
        protected boolean isUsed(@NotNull Property property) {
            PsiFile file;
            String fileName;
            if (property == null) {
                ImplicitUsageProvider.$$$reportNull$$$0(0);
            }
            if (!(fileName = (file = property.getContainingFile()).getName()).endsWith(DevKitActionOrGroupIdReferenceContributor.BUNDLE_PROPERTIES)) {
                return false;
            }
            String name = property.getName();
            if (name == null) {
                return false;
            }
            if ((name.startsWith(DevKitActionOrGroupIdReferenceContributor.ACTION) || name.startsWith(DevKitActionOrGroupIdReferenceContributor.GROUP)) && (name.endsWith(DevKitActionOrGroupIdReferenceContributor.TEXT) || name.endsWith(DevKitActionOrGroupIdReferenceContributor.DESC))) {
                PsiElement key = property.getFirstChild();
                PsiReference[] references = key == null ? PsiReference.EMPTY_ARRAY : key.getReferences();
                return Arrays.stream(references).anyMatch(reference -> reference.resolve() != null);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/idea/devkit/references/DevKitActionOrGroupIdReferenceContributor$ImplicitUsageProvider", "isUsed"));
        }
    }

    private static class DevKitActionReference
    extends PsiPolyVariantReferenceBase<PsiElement> {
        private final String myId;
        private final boolean myIsAction;

        private DevKitActionReference(String id, String prefix, @NotNull PsiElement element) {
            if (element == null) {
                DevKitActionReference.$$$reportNull$$$0(0);
            }
            super(element, TextRange.allOf((String)id).shiftRight(prefix.length()));
            this.myIsAction = prefix.equals(DevKitActionOrGroupIdReferenceContributor.ACTION);
            this.myId = id;
        }

        @NotNull
        public @NotNull ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
            Project project = this.getElement().getProject();
            CommonProcessors.CollectUniquesProcessor processor = new CommonProcessors.CollectUniquesProcessor();
            if (this.myIsAction) {
                IdeaPluginRegistrationIndex.processAction(project, this.myId, ProjectScope.getContentScope((Project)project), (Processor<? super ActionOrGroup>)processor);
            } else {
                IdeaPluginRegistrationIndex.processGroup(project, this.myId, ProjectScope.getContentScope((Project)project), (Processor<? super ActionOrGroup>)processor);
            }
            ResolveResult[] resolveResultArray = (ResolveResult[])JBIterable.from((Iterable)processor.getResults()).map(actionOrGroup -> {
                DomTarget target = DomTarget.getTarget((DomElement)actionOrGroup);
                return target == null ? null : new PsiElementResolveResult(PomService.convertToPsi((Project)project, (PomTarget)target));
            }).filter(Objects::nonNull).toArray((Object[])EMPTY_RESOLVE_RESULT);
            if (resolveResultArray == null) {
                DevKitActionReference.$$$reportNull$$$0(1);
            }
            return resolveResultArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/devkit/references/DevKitActionOrGroupIdReferenceContributor$DevKitActionReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/devkit/references/DevKitActionOrGroupIdReferenceContributor$DevKitActionReference";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "multiResolve";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

