/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.references;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.find.FindModel;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.ide.presentation.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.patterns.uast.UExpressionPattern;
import com.intellij.patterns.uast.UastPatterns;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.UastReferenceProvider;
import com.intellij.psi.UastReferenceRegistrar;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceUtil;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.util.PsiUtil;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastLiteralUtils;

public class IconsReferencesContributor
extends PsiReferenceContributor
implements QueryExecutor<PsiReference, ReferencesSearch.SearchParameters> {
    public boolean execute(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer) {
        PsiElement file;
        if (queryParameters == null) {
            IconsReferencesContributor.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            IconsReferencesContributor.$$$reportNull$$$0(1);
        }
        if ((file = queryParameters.getElementToSearch()) instanceof PsiBinaryFile) {
            Module module = (Module)ReadAction.compute(() -> ModuleUtilCore.findModuleForPsiElement((PsiElement)file));
            VirtualFile image = ((PsiBinaryFile)file).getVirtualFile();
            if (IconsReferencesContributor.isImage(image) && IconsReferencesContributor.isIconsModule(module)) {
                Project project = file.getProject();
                FindModel model = new FindModel();
                String path = IconsReferencesContributor.getPathToImage(image, module);
                model.setStringToFind(path);
                model.setCaseSensitive(true);
                model.setFindAll(true);
                model.setWholeWordsOnly(true);
                FindInProjectUtil.findUsages((FindModel)model, (Project)project, usage -> {
                    ApplicationManager.getApplication().runReadAction(() -> {
                        PsiElement element = usage.getElement();
                        ProperTextRange textRange = usage.getRangeInElement();
                        if (element != null && textRange != null) {
                            PsiElement start = element.findElementAt(textRange.getStartOffset());
                            PsiElement end = element.findElementAt(textRange.getEndOffset());
                            if (start != null && end != null) {
                                PsiFileReference reference;
                                PsiElement value = PsiTreeUtil.findCommonParent((PsiElement)start, (PsiElement)end);
                                if (value instanceof PsiJavaToken) {
                                    value = value.getParent();
                                }
                                if (value != null && (reference = FileReferenceUtil.findFileReference((PsiElement)value)) != null) {
                                    consumer.process((Object)reference);
                                }
                            }
                        }
                    });
                    return true;
                }, (FindUsagesProcessPresentation)new FindUsagesProcessPresentation(new UsageViewPresentation()));
            }
        }
        return true;
    }

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            IconsReferencesContributor.$$$reportNull$$$0(2);
        }
        IconsReferencesContributor.registerForPresentationAnnotation(registrar);
        IconsReferencesContributor.registerForIconLoaderMethods(registrar);
        IconsReferencesContributor.registerForIconXmlAttribute(registrar);
    }

    private static void registerForIconXmlAttribute(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            IconsReferencesContributor.$$$reportNull$$$0(3);
        }
        registrar.registerReferenceProvider((ElementPattern)XmlPatterns.xmlAttributeValue().withLocalName(new String[]{"icon"}), new PsiReferenceProvider(){

            public PsiReference @NotNull [] getReferencesByElement(final @NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!PsiUtil.isPluginXmlPsiElement(element)) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                PsiReference[] psiReferenceArray = new PsiReference[]{new IconPsiReferenceBase(element){

                    public PsiElement resolve() {
                        String value = ((XmlAttributeValue)element).getValue();
                        if (value.startsWith("/")) {
                            FileReference lastRef = new FileReferenceSet(element).getLastReference();
                            return lastRef != null ? lastRef.resolve() : null;
                        }
                        return IconsReferencesContributor.resolveIconPath(value, element);
                    }

                    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
                        PsiElement element2;
                        PsiElement resultForFile;
                        if (newElementName == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if ((resultForFile = this.handleFile(element2 = this.resolve(), lastRef -> lastRef.handleElementRename(newElementName))) != null) {
                            return resultForFile;
                        }
                        PsiElement resultForField = this.handleField(element2, newElementName);
                        if (resultForField != null) {
                            return resultForField;
                        }
                        return super.handleElementRename(newElementName);
                    }

                    public PsiElement bindToElement(@NotNull PsiElement element2) throws IncorrectOperationException {
                        PsiElement resultForFile;
                        if (element2 == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if ((resultForFile = this.handleFile(element2, lastRef -> lastRef.bindToElement(element2))) != null) {
                            return resultForFile;
                        }
                        PsiElement resultForField = this.handleField(element2, null);
                        if (resultForField != null) {
                            return resultForField;
                        }
                        return super.bindToElement(element2);
                    }

                    private PsiElement handleFile(PsiElement element2, Function<FileReference, PsiElement> callback) {
                        FileReference lastRef;
                        if (element2 instanceof PsiFile && (lastRef = new FileReferenceSet(element2).getLastReference()) != null) {
                            return callback.apply(lastRef);
                        }
                        return null;
                    }

                    @Nullable
                    private PsiElement handleField(PsiElement element2, @Nullable String newElementName) {
                        String classQualifiedName;
                        PsiClass containingClass;
                        if (element2 instanceof PsiField && (containingClass = ((PsiField)element2).getContainingClass()) != null && (classQualifiedName = containingClass.getQualifiedName()) != null) {
                            if (newElementName == null) {
                                newElementName = ((PsiField)element2).getName();
                            }
                            if (classQualifiedName.startsWith("com.intellij.icons.")) {
                                return this.replace(classQualifiedName, newElementName, "com.intellij.icons.");
                            }
                            if (classQualifiedName.startsWith("icons.")) {
                                return this.replace(classQualifiedName, newElementName, "icons.");
                            }
                        }
                        return null;
                    }

                    private PsiElement replace(String fqn, String newName, String pckg) {
                        XmlAttribute parent = (XmlAttribute)this.getElement().getParent();
                        parent.setValue(fqn.substring(pckg.length()) + "." + newName);
                        return parent.getValueElement();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "newElementName";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "element";
                                break;
                            }
                        }
                        objectArray2[1] = "org/jetbrains/idea/devkit/references/IconsReferencesContributor$1$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "handleElementRename";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "bindToElement";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }};
                if (psiReferenceArray == null) {
                    1.$$$reportNull$$$0(3);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/idea/devkit/references/IconsReferencesContributor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/idea/devkit/references/IconsReferencesContributor$1";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    private static void registerForIconLoaderMethods(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            IconsReferencesContributor.$$$reportNull$$$0(4);
        }
        PsiMethodPattern method = ((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName(new String[]{"findIcon", "getIcon"})).definedInClass(IconLoader.class.getName());
        PsiJavaElementPattern.Capture findGetIconPattern = (PsiJavaElementPattern.Capture)PsiJavaPatterns.literalExpression().and((ElementPattern)PsiJavaPatterns.psiExpression().methodCallParameter(0, (ElementPattern)method));
        registrar.registerReferenceProvider((ElementPattern)findGetIconPattern, new PsiReferenceProvider(){

            public PsiReference @NotNull [] getReferencesByElement(final @NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (!PsiUtil.isIdeaProject(element.getProject())) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                FileReference[] fileReferenceArray = new FileReferenceSet(element){

                    protected Collection<PsiFileSystemItem> getExtraContexts() {
                        Module iconsModule = ModuleManager.getInstance((Project)element.getProject()).findModuleByName("intellij.platform.icons");
                        if (iconsModule == null) {
                            iconsModule = ModuleManager.getInstance((Project)element.getProject()).findModuleByName("icons");
                        }
                        if (iconsModule == null) {
                            return super.getExtraContexts();
                        }
                        SmartList result = new SmartList();
                        VirtualFile[] roots = ModuleRootManager.getInstance((Module)iconsModule).getSourceRoots();
                        PsiManager psiManager = element.getManager();
                        for (VirtualFile root : roots) {
                            PsiDirectory directory = psiManager.findDirectory(root);
                            ContainerUtil.addIfNotNull((Collection)result, (Object)directory);
                        }
                        return result;
                    }
                }.getAllReferences();
                if (fileReferenceArray == null) {
                    2.$$$reportNull$$$0(3);
                }
                return fileReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/idea/devkit/references/IconsReferencesContributor$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/idea/devkit/references/IconsReferencesContributor$2";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, 100.0);
    }

    private static void registerForPresentationAnnotation(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            IconsReferencesContributor.$$$reportNull$$$0(5);
        }
        UastReferenceRegistrar.registerUastReferenceProvider((PsiReferenceRegistrar)registrar, (ElementPattern)((UExpressionPattern)UastPatterns.injectionHostUExpression().sourcePsiFilter(psi -> PsiUtil.isPluginProject(psi.getProject()))).annotationParam(Presentation.class.getName(), "icon"), (UastReferenceProvider)UastReferenceRegistrar.uastInjectionHostReferenceProvider((uElement, referencePsiElement) -> new PsiReference[]{new IconPsiReferenceBase((PsiElement)referencePsiElement){

            private UElement getUElement() {
                return UastContextKt.toUElement((PsiElement)this.getElement());
            }

            public PsiElement resolve() {
                UElement uElement = this.getUElement();
                if (uElement == null) {
                    return null;
                }
                String value = UastLiteralUtils.getValueIfStringLiteral((UElement)uElement);
                return IconsReferencesContributor.resolveIconPath(value, this.getElement());
            }

            public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
                PsiElement field;
                PsiElement result;
                if (newElementName == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((result = this.handleElement(field = this.resolve(), newElementName)) != null) {
                    return result;
                }
                return super.handleElementRename(newElementName);
            }

            @Nullable
            private PsiElement handleElement(PsiElement element, @Nullable String newElementName) {
                String classQualifiedName;
                PsiClass containingClass;
                if (element instanceof PsiField && (containingClass = ((PsiField)element).getContainingClass()) != null && (classQualifiedName = containingClass.getQualifiedName()) != null) {
                    if (newElementName == null) {
                        newElementName = ((PsiField)element).getName();
                    }
                    if (classQualifiedName.startsWith("com.intellij.icons.")) {
                        return this.replace(newElementName, classQualifiedName, "com.intellij.icons.");
                    }
                    if (classQualifiedName.startsWith("icons.")) {
                        return this.replace(newElementName, classQualifiedName, "icons.");
                    }
                }
                return null;
            }

            private PsiElement replace(String newElementName, String fqn, String packageName) {
                String newValue = fqn.substring(packageName.length()) + "." + newElementName;
                return ElementManipulators.handleContentChange((PsiElement)this.getElement(), (String)newValue);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElementName", "org/jetbrains/idea/devkit/references/IconsReferencesContributor$3", "handleElementRename"));
            }
        }}), (double)100.0);
    }

    @NotNull
    private static String getPathToImage(VirtualFile image, Module module) {
        String path = ModuleRootManager.getInstance((Module)module).getSourceRoots()[0].getPath();
        String string = "/" + FileUtil.getRelativePath((String)path, (String)image.getPath(), (char)'/');
        if (string == null) {
            IconsReferencesContributor.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static boolean isIconsModule(Module module) {
        return module != null && ("icons".equals(module.getName()) || "intellij.platform.icons".equals(module.getName())) && ModuleRootManager.getInstance((Module)module).getSourceRoots().length == 1;
    }

    private static boolean isImage(VirtualFile image) {
        FileTypeManager mgr = FileTypeManager.getInstance();
        return image != null && mgr.getFileTypeByFile(image) == mgr.getFileTypeByExtension("png");
    }

    @Nullable
    private static PsiField resolveIconPath(String pathStr, PsiElement element) {
        if (pathStr == null) {
            return null;
        }
        List path = StringUtil.split((String)pathStr, (String)".");
        if (path.size() > 1 && ((String)path.get(0)).endsWith("Icons")) {
            Project project = element.getProject();
            PsiClass cur = IconsReferencesContributor.findIconClass(project, (String)path.get(0));
            if (cur == null) {
                return null;
            }
            for (int i = 1; i < path.size() - 1; ++i) {
                if ((cur = cur.findInnerClassByName((String)path.get(i), false)) != null) continue;
                return null;
            }
            return cur.findFieldByName((String)path.get(path.size() - 1), false);
        }
        return null;
    }

    @Nullable
    private static PsiClass findIconClass(Project project, String className) {
        boolean isAllIcons = "AllIcons".equals(className);
        String fqnClassName = isAllIcons ? "com.intellij.icons.AllIcons" : "icons." + className;
        return JavaPsiFacade.getInstance((Project)project).findClass(fqnClassName, isAllIcons ? GlobalSearchScope.allScope((Project)project) : GlobalSearchScope.projectScope((Project)project));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryParameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/references/IconsReferencesContributor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/references/IconsReferencesContributor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathToImage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerReferenceProviders";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerForIconXmlAttribute";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerForIconLoaderMethods";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerForPresentationAnnotation";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class IconPsiReferenceBase
    extends PsiReferenceBase<PsiElement>
    implements EmptyResolveMessageProvider {
        IconPsiReferenceBase(@NotNull PsiElement element) {
            if (element == null) {
                IconPsiReferenceBase.$$$reportNull$$$0(0);
            }
            super(element, true);
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string = DevKitBundle.message("inspections.presentation.cannot.resolve.icon", new Object[0]);
            if (string == null) {
                IconPsiReferenceBase.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/devkit/references/IconsReferencesContributor$IconPsiReferenceBase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/devkit/references/IconsReferencesContributor$IconPsiReferenceBase";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnresolvedMessagePattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

