/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.testAssistant.TestDataFile;
import org.jetbrains.idea.devkit.testAssistant.vfs.TestDataGroupVirtualFile;

public class TestDataUtil {
    private static final String TESTDATA_FILE_AFTER_MARKER = "after";
    private static final String TESTDATA_FILE_BEFORE_MARKER = "before";
    public static final String BEFORE_AFTER_DISPLAY_NAME_PART = "before/after";

    private TestDataUtil() {
    }

    @NotNull
    public static String getGroupDisplayName(@NotNull String beforeName, @NotNull String afterName) {
        String beforeNameExt;
        String beforeNameWithoutExt;
        String beforeNameWithoutCommonPrefixAndExt;
        String beforeNameWithoutCommonPrefixAndExtAndBefore;
        if (beforeName == null) {
            TestDataUtil.$$$reportNull$$$0(0);
        }
        if (afterName == null) {
            TestDataUtil.$$$reportNull$$$0(1);
        }
        if (TestDataUtil.isBeforeAfterPrefixedPair(beforeName, afterName)) {
            String string = BEFORE_AFTER_DISPLAY_NAME_PART + StringUtil.trimStart((String)beforeName, (String)TESTDATA_FILE_BEFORE_MARKER);
            if (string == null) {
                TestDataUtil.$$$reportNull$$$0(2);
            }
            return string;
        }
        String commonPrefix = StringUtil.commonPrefix((String)beforeName, (String)afterName);
        if (!commonPrefix.isEmpty() && !StringUtil.containsAlphaCharacters((String)(beforeNameWithoutCommonPrefixAndExtAndBefore = StringUtil.trimEnd((String)(beforeNameWithoutCommonPrefixAndExt = StringUtil.trimStart((String)(beforeNameWithoutExt = (beforeNameExt = PathUtil.getFileExtension((String)beforeName)) == null ? beforeName : StringUtil.substringBeforeLast((String)beforeName, (String)("." + beforeNameExt))), (String)(commonPrefix.endsWith(".") ? StringUtil.trimEnd((String)commonPrefix, (String)".") : commonPrefix))), (String)TESTDATA_FILE_BEFORE_MARKER)))) {
            String result = commonPrefix;
            char lastChar = commonPrefix.charAt(commonPrefix.length() - 1);
            if (Character.isDigit(lastChar) || Character.isLetter(lastChar)) {
                result = result + "_";
            }
            result = result + BEFORE_AFTER_DISPLAY_NAME_PART;
            if (beforeNameExt != null) {
                result = result + "." + beforeNameExt;
            }
            String string = result;
            if (string == null) {
                TestDataUtil.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = beforeName + " | " + afterName;
        if (string == null) {
            TestDataUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    static TestDataGroupVirtualFile getTestDataGroup(@NotNull String fileName1, @NotNull String fileName2) {
        if (fileName1 == null) {
            TestDataUtil.$$$reportNull$$$0(5);
        }
        if (fileName2 == null) {
            TestDataUtil.$$$reportNull$$$0(6);
        }
        return TestDataUtil.getTestDataGroup(new TestDataFile.LazyResolved(fileName1), new TestDataFile.LazyResolved(fileName2));
    }

    @Nullable
    static TestDataGroupVirtualFile getTestDataGroup(@NotNull TestDataFile testDataFile1, @NotNull TestDataFile testDataFile2) {
        String file2Name;
        if (testDataFile1 == null) {
            TestDataUtil.$$$reportNull$$$0(7);
        }
        if (testDataFile2 == null) {
            TestDataUtil.$$$reportNull$$$0(8);
        }
        VirtualFile file1 = testDataFile1.getVirtualFile();
        VirtualFile file2 = testDataFile2.getVirtualFile();
        if (file1 == null || file2 == null) {
            return null;
        }
        if (!Objects.equals(file1.getParent(), file2.getParent())) {
            return null;
        }
        String file1Name = file1.getName();
        int commonPrefixLength = StringUtil.commonPrefixLength((CharSequence)file1Name, (CharSequence)(file2Name = file2.getName()));
        if (commonPrefixLength == 0) {
            if (TestDataUtil.isBeforeAfterPrefixedPair(file1Name, file2Name)) {
                return new TestDataGroupVirtualFile(file1, file2);
            }
            if (TestDataUtil.isBeforeAfterPrefixedPair(file2Name, file1Name)) {
                return new TestDataGroupVirtualFile(file2, file1);
            }
        }
        if (TestDataUtil.isAfterSuffixed(file1Name, file2Name, commonPrefixLength)) {
            return new TestDataGroupVirtualFile(file2, file1);
        }
        if (TestDataUtil.isAfterSuffixed(file2Name, file1Name, commonPrefixLength)) {
            return new TestDataGroupVirtualFile(file1, file2);
        }
        return null;
    }

    private static boolean isBeforeAfterPrefixedPair(@NotNull @NonNls String name1, @NotNull @NonNls String name2) {
        String lcName1MainPart;
        if (name1 == null) {
            TestDataUtil.$$$reportNull$$$0(9);
        }
        if (name2 == null) {
            TestDataUtil.$$$reportNull$$$0(10);
        }
        String lcName1 = StringUtil.toLowerCase((String)name1);
        String lcName2 = StringUtil.toLowerCase((String)name2);
        return lcName1.startsWith(TESTDATA_FILE_BEFORE_MARKER) && lcName2.startsWith(TESTDATA_FILE_AFTER_MARKER) && (lcName1MainPart = StringUtil.substringAfter((String)lcName1, (String)TESTDATA_FILE_BEFORE_MARKER)) != null && lcName1MainPart.equals(StringUtil.substringAfter((String)lcName2, (String)TESTDATA_FILE_AFTER_MARKER));
    }

    private static boolean isAfterSuffixed(@NonNls String nameToCheck, @NonNls String secondName, int commonPrefixLength) {
        String nameToCheckLastPart = StringUtil.toLowerCase((String)nameToCheck.substring(commonPrefixLength));
        if (!nameToCheckLastPart.contains(TESTDATA_FILE_AFTER_MARKER)) {
            return false;
        }
        String nameToCheckWithoutAfter = nameToCheckLastPart.replace(TESTDATA_FILE_AFTER_MARKER, "");
        String nameToCheckExt = StringUtil.substringAfterLast((String)nameToCheck, (String)".");
        String nameToCheckWithoutAfterAndExt = StringUtil.substringBeforeLast((String)nameToCheckWithoutAfter, (String)".");
        String secondNameLastPart = StringUtil.toLowerCase((String)secondName.substring(commonPrefixLength));
        String secondNameExt = nameToCheckExt == null ? secondNameLastPart : secondNameLastPart.replace(nameToCheckExt, "");
        return !StringUtil.containsAlphaCharacters((String)nameToCheckWithoutAfterAndExt) && !StringUtil.containsAlphaCharacters((String)secondNameExt.replace(TESTDATA_FILE_BEFORE_MARKER, ""));
    }

    static void createFileAndNavigate(final Project project, final String path) {
        VirtualFile file = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                try {
                    File file = new File(path);
                    VirtualFile parent = VfsUtil.createDirectories((String)file.getParent());
                    return parent.createChildData((Object)this, file.getName());
                }
                catch (IOException e) {
                    Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)DevKitBundle.message("testdata.create.dialog.title", new Object[0]));
                    return null;
                }
            }
        });
        if (file != null) {
            PsiNavigationSupport.getInstance().createNavigatable(project, file, -1).navigate(true);
        }
    }

    static void openOrAskToCreateFile(@NotNull Project project, @NotNull TestDataFile testDataFile) {
        VirtualFile file;
        if (project == null) {
            TestDataUtil.$$$reportNull$$$0(11);
        }
        if (testDataFile == null) {
            TestDataUtil.$$$reportNull$$$0(12);
        }
        if ((file = testDataFile.getVirtualFile()) != null) {
            PsiNavigationSupport.getInstance().createNavigatable(project, file, -1).navigate(true);
        } else {
            String displayPath = TestDataUtil.getHtmlDisplayPathForMissingFile(project, testDataFile.getPath());
            int rc = Messages.showYesNoDialog((Project)project, (String)DevKitBundle.message("testdata.file.doesn.not.exist", displayPath), (String)DevKitBundle.message("testdata.create.dialog.title", new Object[0]), (Icon)Messages.getQuestionIcon());
            if (rc == 0) {
                TestDataUtil.createFileAndNavigate(project, testDataFile.getPath());
            }
        }
    }

    @Nullable
    private static Pair<String, String> getModuleOrProjectRelativePath(Project project, String filePath) {
        VirtualFile dir;
        String currentPath = PathUtil.getParentPath((String)filePath);
        if (currentPath.isEmpty()) {
            return null;
        }
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        while ((dir = fileSystem.refreshAndFindFileByPath(currentPath)) == null && !(currentPath = PathUtil.getParentPath((String)currentPath)).isEmpty()) {
        }
        if (dir == null) {
            return null;
        }
        Pair<String, String> relativeParentPath = TestDataUtil.getModuleOrProjectRelativePath(project, dir);
        if (relativeParentPath != null) {
            String dirPath = dir.getPath();
            if (!filePath.startsWith(dirPath)) {
                return null;
            }
            return new Pair(relativeParentPath.first, (Object)((String)relativeParentPath.second + filePath.substring(dirPath.length())));
        }
        return null;
    }

    @Nullable
    static Pair<String, String> getModuleOrProjectRelativeParentPath(Project project, VirtualFile file) {
        VirtualFile parent = file.getParent();
        if (parent == null) {
            return null;
        }
        return TestDataUtil.getModuleOrProjectRelativePath(project, parent);
    }

    @Nullable
    private static Pair<String, String> getModuleOrProjectRelativePath(Project project, VirtualFile file) {
        String projectRelativePath;
        String moduleRelativePath;
        VirtualFile moduleFileDir;
        VirtualFile moduleFile;
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        if (module != null && (moduleFile = module.getModuleFile()) != null && (moduleFileDir = moduleFile.getParent()) != null && (moduleRelativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)moduleFileDir)) != null) {
            return new Pair((Object)module.getName(), (Object)moduleRelativePath);
        }
        VirtualFile projectDir = project.getBaseDir();
        if (projectDir != null && (projectRelativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)projectDir)) != null) {
            return new Pair((Object)project.getName(), (Object)projectRelativePath);
        }
        return null;
    }

    @NotNull
    static String getHtmlDisplayPathForMissingFile(Project project, String path) {
        return TestDataUtil.getHtmlDisplayPathForRelativePathPair(TestDataUtil.getRelativePathPairForMissingFile(project, path));
    }

    @NotNull
    static Pair<String, String> getRelativePathPairForMissingFile(Project project, String path) {
        Pair<String, String> relativePath = TestDataUtil.getModuleOrProjectRelativePath(project, path);
        if (relativePath == null) {
            return new Pair(null, (Object)path);
        }
        Pair<String, String> pair = relativePath;
        if (pair == null) {
            TestDataUtil.$$$reportNull$$$0(13);
        }
        return pair;
    }

    @NotNull
    static String getHtmlDisplayPathForRelativePathPair(Pair<String, String> relativePathPair) {
        String base = (String)relativePathPair.getFirst();
        if (base == null) {
            String string = (String)relativePathPair.getSecond();
            if (string == null) {
                TestDataUtil.$$$reportNull$$$0(14);
            }
            return string;
        }
        String string = "<b>" + base + "</b>/" + (String)relativePathPair.getSecond();
        if (string == null) {
            TestDataUtil.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/testAssistant/TestDataUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName1";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName2";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testDataFile1";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testDataFile2";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name1";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name2";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testDataFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/testAssistant/TestDataUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativePathPairForMissingFile";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getHtmlDisplayPathForRelativePathPair";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getGroupDisplayName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTestDataGroup";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isBeforeAfterPrefixedPair";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "openOrAskToCreateFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

