/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.uiDesigner.compiler;

import com.intellij.compiler.instrumentation.FailSafeClassReader;
import com.intellij.compiler.instrumentation.InstrumentationClassFinder;
import com.intellij.compiler.instrumentation.InstrumenterClassWriter;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.uiDesigner.compiler.AlienFormFileException;
import com.intellij.uiDesigner.compiler.AsmCodeGenerator;
import com.intellij.uiDesigner.compiler.FormErrorInfo;
import com.intellij.uiDesigner.compiler.NestedFormLoader;
import com.intellij.uiDesigner.compiler.UIDesignerException;
import com.intellij.uiDesigner.compiler.UnexpectedFormElementException;
import com.intellij.uiDesigner.compiler.Utils;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.lw.CompiledClassPropertiesProvider;
import com.intellij.uiDesigner.lw.LwRootContainer;
import com.intellij.uiDesigner.lw.PropertiesProvider;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.ProjectPaths;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.logging.ProjectBuilderLogger;
import org.jetbrains.jps.incremental.BinaryContent;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.CompiledClass;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.instrumentation.ClassProcessingBuilder;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.incremental.storage.OneToManyPathsMapping;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.uiDesigner.compiler.FormsBuilder;
import org.jetbrains.jps.uiDesigner.model.JpsUiDesignerConfiguration;
import org.jetbrains.jps.uiDesigner.model.JpsUiDesignerExtensionService;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassWriter;

public class FormsInstrumenter
extends FormsBuilder {
    public static final String BUILDER_NAME = "forms";

    public FormsInstrumenter() {
        super(BuilderCategory.CLASS_INSTRUMENTER, BUILDER_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleLevelBuilder.ExitCode build(CompileContext context, ModuleChunk chunk, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, ModuleLevelBuilder.OutputConsumer outputConsumer) throws ProjectBuildException, IOException {
        ProjectBuilderLogger logger;
        JpsProject project = context.getProjectDescriptor().getProject();
        JpsUiDesignerConfiguration config = JpsUiDesignerExtensionService.getInstance().getOrCreateUiDesignerConfiguration(project);
        if (!config.isInstrumentClasses()) {
            return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
        }
        Map srcToForms = (Map)FORMS_TO_COMPILE.get((UserDataHolder)context);
        FORMS_TO_COMPILE.set((UserDataHolder)context, null);
        if (srcToForms == null || srcToForms.isEmpty()) {
            return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
        }
        THashSet formsToCompile = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
        for (Collection files : srcToForms.values()) {
            formsToCompile.addAll(files);
        }
        if (JavaBuilderUtil.isCompileJavaIncrementally((CompileContext)context) && (logger = context.getLoggingManager().getProjectBuilderLogger()).isEnabled()) {
            logger.logCompiledFiles((Collection)formsToCompile, this.getPresentableName(), "Compiling forms:");
        }
        try {
            Collection platformCp = ProjectPaths.getPlatformCompilationClasspath((ModuleChunk)chunk, (boolean)false);
            ArrayList<File> classpath = new ArrayList<File>(ProjectPaths.getCompilationClasspath((ModuleChunk)chunk, (boolean)false));
            classpath.add(FormsInstrumenter.getResourcePath(GridConstraints.class));
            Map chunkSourcePath = ProjectPaths.getSourceRootsWithDependents((ModuleChunk)chunk);
            classpath.addAll(chunkSourcePath.keySet());
            JpsSdk sdk = chunk.representativeTarget().getModule().getSdk((JpsSdkType)JpsJavaSdkType.INSTANCE);
            InstrumentationClassFinder finder = ClassProcessingBuilder.createInstrumentationClassFinder((JpsSdk)sdk, (Collection)platformCp, classpath, (ModuleLevelBuilder.OutputConsumer)outputConsumer);
            try {
                Map<File, Collection<File>> processed = this.instrumentForms(context, chunk, chunkSourcePath, finder, (Collection<File>)formsToCompile, outputConsumer, config.isUseDynamicBundles());
                OneToManyPathsMapping sourceToFormMap = context.getProjectDescriptor().dataManager.getSourceToFormMap();
                for (Map.Entry<File, Collection<File>> entry : processed.entrySet()) {
                    File src = entry.getKey();
                    Collection<File> forms = entry.getValue();
                    ArrayList<String> formPaths = new ArrayList<String>(forms.size());
                    for (File form : forms) {
                        formPaths.add(form.getPath());
                    }
                    sourceToFormMap.update(src.getPath(), formPaths);
                    srcToForms.remove(src);
                }
                for (File srcFile : srcToForms.keySet()) {
                    sourceToFormMap.remove(srcFile.getPath());
                }
            }
            finally {
                finder.releaseResources();
            }
        }
        finally {
            context.processMessage((BuildMessage)new ProgressMessage("Finished instrumenting forms [" + chunk.getPresentableShortName() + "]"));
        }
        return ModuleLevelBuilder.ExitCode.OK;
    }

    @NotNull
    public List<String> getCompilableFileExtensions() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            FormsInstrumenter.$$$reportNull$$$0(0);
        }
        return list;
    }

    private Map<File, Collection<File>> instrumentForms(CompileContext context, ModuleChunk chunk, Map<File, String> chunkSourcePath, InstrumentationClassFinder finder, Collection<File> forms, ModuleLevelBuilder.OutputConsumer outConsumer, boolean useDynamicBundles) throws ProjectBuildException {
        THashMap instrumented = new THashMap(FileUtil.FILE_HASHING_STRATEGY);
        HashMap<String, File> class2form = new HashMap<String, File>();
        MyNestedFormLoader nestedFormsLoader = new MyNestedFormLoader(chunkSourcePath, ProjectPaths.getOutputPathsWithDependents((ModuleChunk)chunk), finder);
        for (File formFile : forms) {
            LwRootContainer rootContainer;
            try {
                rootContainer = Utils.getRootContainer((URL)formFile.toURI().toURL(), (PropertiesProvider)new CompiledClassPropertiesProvider(finder.getLoader()));
            }
            catch (AlienFormFileException e) {
                continue;
            }
            catch (UnexpectedFormElementException e) {
                context.processMessage((BuildMessage)new CompilerMessage(this.getPresentableName(), BuildMessage.Kind.ERROR, e.getMessage(), formFile.getPath()));
                LOG.info((Throwable)e);
                continue;
            }
            catch (UIDesignerException e) {
                context.processMessage((BuildMessage)new CompilerMessage(this.getPresentableName(), BuildMessage.Kind.ERROR, e.getMessage(), formFile.getPath()));
                LOG.info((Throwable)e);
                continue;
            }
            catch (Exception e) {
                throw new ProjectBuildException("Cannot process form file " + formFile.getAbsolutePath(), (Throwable)e);
            }
            String classToBind = rootContainer.getClassToBind();
            if (classToBind == null) continue;
            CompiledClass compiled = FormsInstrumenter.findClassFile(outConsumer, classToBind);
            if (compiled == null) {
                context.processMessage((BuildMessage)new CompilerMessage(this.getPresentableName(), BuildMessage.Kind.WARNING, "Class to bind does not exist: " + classToBind, formFile.getAbsolutePath()));
                continue;
            }
            File alreadyProcessedForm = (File)class2form.get(classToBind);
            if (alreadyProcessedForm != null) {
                context.processMessage((BuildMessage)new CompilerMessage(this.getPresentableName(), BuildMessage.Kind.WARNING, formFile.getAbsolutePath() + ": The form is bound to the class " + classToBind + ".\nAnother form " + alreadyProcessedForm.getAbsolutePath() + " is also bound to this class", formFile.getAbsolutePath()));
                continue;
            }
            class2form.put(classToBind, formFile);
            for (File file : compiled.getSourceFiles()) {
                FormsInstrumenter.addBinding(file, formFile, (Map<File, Collection<File>>)instrumented);
            }
            try {
                FormErrorInfo[] warnings;
                context.processMessage((BuildMessage)new ProgressMessage("Instrumenting forms... [" + chunk.getPresentableShortName() + "]"));
                BinaryContent originalContent = compiled.getContent();
                FailSafeClassReader classReader = new FailSafeClassReader(originalContent.getBuffer(), originalContent.getOffset(), originalContent.getLength());
                int flags = InstrumenterClassWriter.getAsmClassWriterFlags((int)InstrumenterClassWriter.getClassFileVersion((ClassReader)classReader));
                InstrumenterClassWriter classWriter = new InstrumenterClassWriter((ClassReader)classReader, flags, finder);
                AsmCodeGenerator codeGenerator = new AsmCodeGenerator(rootContainer, finder, (NestedFormLoader)nestedFormsLoader, false, useDynamicBundles, (ClassWriter)classWriter);
                byte[] patchedBytes = codeGenerator.patchClass((ClassReader)classReader);
                if (patchedBytes != null) {
                    compiled.setContent(new BinaryContent(patchedBytes));
                }
                for (FormErrorInfo warning : warnings = codeGenerator.getWarnings()) {
                    context.processMessage((BuildMessage)new CompilerMessage(this.getPresentableName(), BuildMessage.Kind.WARNING, warning.getErrorMessage(), formFile.getAbsolutePath()));
                }
                FormErrorInfo[] errors = codeGenerator.getErrors();
                if (errors.length <= 0) continue;
                StringBuilder message = new StringBuilder();
                for (FormErrorInfo error : errors) {
                    if (message.length() > 0) {
                        message.append("\n");
                    }
                    message.append(formFile.getAbsolutePath()).append(": ").append(error.getErrorMessage());
                }
                context.processMessage((BuildMessage)new CompilerMessage(this.getPresentableName(), BuildMessage.Kind.ERROR, message.toString()));
            }
            catch (Exception e) {
                context.processMessage((BuildMessage)new CompilerMessage(this.getPresentableName(), BuildMessage.Kind.ERROR, "Forms instrumentation failed" + e.getMessage(), formFile.getAbsolutePath()));
            }
        }
        return instrumented;
    }

    private static CompiledClass findClassFile(ModuleLevelBuilder.OutputConsumer outputConsumer, String classToBind) {
        Map compiled = outputConsumer.getCompiledClasses();
        CompiledClass fo;
        while ((fo = (CompiledClass)compiled.get(classToBind)) == null) {
            int dotIndex = classToBind.lastIndexOf(46);
            if (dotIndex <= 0) {
                return null;
            }
            classToBind = classToBind.substring(0, dotIndex) + "$" + classToBind.substring(dotIndex + 1);
        }
        return fo;
    }

    private static File getResourcePath(Class aClass) {
        return new File(PathManager.getResourceRoot((Class)aClass, (String)("/" + aClass.getName().replace('.', '/') + ".class")));
    }

    @Nullable
    private static String getJVMClassName(File outputRoot, String className) {
        File candidateClass;
        while (!(candidateClass = new File(outputRoot, className + ".class")).exists()) {
            int position = className.lastIndexOf(47);
            if (position < 0) {
                return null;
            }
            className = className.substring(0, position) + '$' + className.substring(position + 1);
        }
        return className;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/uiDesigner/compiler/FormsInstrumenter", "getCompilableFileExtensions"));
    }

    private static class MyNestedFormLoader
    implements NestedFormLoader {
        private final Map<File, String> mySourceRoots;
        private final Collection<File> myOutputRoots;
        private final InstrumentationClassFinder myClassFinder;
        private final HashMap<String, LwRootContainer> myCache = new HashMap();

        MyNestedFormLoader(Map<File, String> sourceRoots, Collection<File> outputRoots, InstrumentationClassFinder classFinder) {
            this.mySourceRoots = sourceRoots;
            this.myOutputRoots = outputRoots;
            this.myClassFinder = classFinder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LwRootContainer loadForm(String formFileName) throws Exception {
            if (this.myCache.containsKey(formFileName)) {
                return this.myCache.get(formFileName);
            }
            String relPath = FileUtil.toSystemIndependentName((String)formFileName);
            for (Map.Entry<File, String> entry : this.mySourceRoots.entrySet()) {
                File formFile;
                File sourceRoot = entry.getKey();
                String prefix = entry.getValue();
                String path = relPath;
                if (prefix != null && FileUtil.startsWith((String)path, (String)prefix)) {
                    path = path.substring(prefix.length());
                }
                if (!(formFile = new File(sourceRoot, path)).exists()) continue;
                try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(formFile));){
                    LwRootContainer lwRootContainer = this.loadForm(formFileName, stream);
                    return lwRootContainer;
                }
            }
            InputStream fromLibraries = null;
            try {
                fromLibraries = this.myClassFinder.getResourceAsStream(relPath);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (fromLibraries != null) {
                return this.loadForm(formFileName, fromLibraries);
            }
            throw new Exception("Cannot find nested form file " + formFileName);
        }

        private LwRootContainer loadForm(String formFileName, InputStream resourceStream) throws Exception {
            LwRootContainer container = Utils.getRootContainer((InputStream)resourceStream, null);
            this.myCache.put(formFileName, container);
            return container;
        }

        public String getClassToBindName(LwRootContainer container) {
            String className = container.getClassToBind();
            for (File outputRoot : this.myOutputRoots) {
                String result = FormsInstrumenter.getJVMClassName(outputRoot, className.replace('.', '/'));
                if (result == null) continue;
                return result.replace('/', '.');
            }
            return className;
        }
    }
}

